# Guidelines

This is a beginner friendly repository that is dedicated to learning the Ionic SDK while using the Angular Framework.

Before creating a Pull Request, please make sure that your suggestion is not already added to the project. You can submit an update if you believe it improves an existing idea.
Make sure you check your spelling and grammar.
Create individual PR for each suggestion.

- Fork this repo
- Run `npm install` 
- Run `ionic serve` 
- Create a branch with your new feature
- Please [open an issue](https://github.com/JavaVista/-photo-gallery-completed/issues/new) with a description of your contribution and link the PR #
- Create a Pull Request
- Now, just wait for the merge!

# PR Title

Make sure the title starts with a semantic prefix:

- **feat**: A new feature
- **fix**: A bug fix
- **docs**: Documentation only changes
- **style**: Changes that do not affect the meaning of the code (white-space, formatting, missing semi-colons, etc)
- **refactor**: A code change that neither fixes a bug nor adds a feature
- **perf**: A code change that improves performance
- **test**: Adding missing tests or correcting existing tests
- **build**: Changes that affect the build system or external dependencies (example scopes: gulp, broccoli, npm)
- **ci**: Changes to our CI configuration files and scripts (example scopes: Travis, Circle, BrowserStack, SauceLabs)
- **chore**: Other changes that don't modify src or test files
- **revert**: Reverts a previous commit

## HacktoberFest 🎃

By contributing a PR to this project it will take you a step closer to earning your Hacktoberfest T-shirt 👕. If you are a beginner, and looking for your first contribution, I am are here to help.

## License

By contributing, you agree that your contributions will be licensed under its [MIT license](./LICENSE.md).
