# Moodify My Wish: AI Magic for Messages ✨🎉💌

![Code Quality](https://img.shields.io/badge/dynamic/json?label=Code%20Quality&query=%24.code_quality&url=https%3A%2F%2Fraw.githubusercontent.com%2FJasmin25%2FMoodifyMyWish%2Fmain%2Fbadges%2Fbadge_values.json&color=success)
![Test Coverage](https://img.shields.io/badge/dynamic/json?label=Test%20Coverage&query=%24.test_coverage&url=https%3A%2F%2Fraw.githubusercontent.com%2FJasmin25%2FMoodifyMyWish%2Fmain%2Fbadges%2Fbadge_values.json&color=success)
![PEP8 Compliance](https://img.shields.io/badge/dynamic/json?label=PEP8%20Compliance&query=%24.pep8_compliance&url=https%3A%2F%2Fraw.githubusercontent.com%2FJasmin25%2FMoodifyMyWish%2Fmain%2Fbadges%2Fbadge_values.json&color=success)

Discover Moodify My Wish, an innovative web application that harnesses the power of OpenAI's GPT-3.5-turbo language model to generate tailor-made messages based on occasion, relationship, and other crucial details. Explore this GitHub repository and dive into the code behind the scenes, creating personalized and heartfelt wishes with a touch of AI brilliance! 💡

## Features

- Generate personalized messages for different occasions (e.g. Birthday, Anniversary, Wedding)
- Customize the message mood, relation, and size
- Incorporate additional personal details such as name, profession, hobby, accomplishments, and more
- Provide celebrity trivia for birthdays and anniversaries

## Live Demo

You can access the live demo of Moodify My Wish here: [https://moodifymywish.herokuapp.com/](https://moodifymywish.herokuapp.com/)

## Installation

1. Clone the repository: ```git clone https://github.com/Jasmin25/MoodifyMyWish.git```

2. Navigate to the project directory: ```cd MoodifyMyWish```

3. Create a virtual environment: ```python3 -m venv wish_env```

4. Activate the virtual environment:

    - On Linux and macOS: ```source wish_env/bin/activate```
    - On Windows: ```wish_env\Scripts\activate```

5. Install the required packages: ```pip install -r requirements.txt```

6. Set up the environment variables:

    - Copy the `.env.example` file and rename it to `.env`
    - Fill in the required information (e.g. OpenAI API key)

7. Run the Streamlit app: ```streamlit run app.py```

The application will be available at http://localhost:8501

## Contributing

Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update the tests as appropriate.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## Author

Jasmin Shah - [Github](https://github.com/Jasmin25)
