using System;
using Mono.Cecil;
using Mono.Cecil.Cil;

namespace Mirage.Weaver.Serialization
{
    internal class FunctionSerializer : ValueSerializer
    {
        public override bool IsIntType => false;

        private readonly MethodReference writeFunction;
        private readonly MethodReference readFunction;

        public FunctionSerializer(MethodReference writeFunction, MethodReference readFunction)
        {
            if (writeFunction == null && readFunction == null) throw new ArgumentNullException(nameof(writeFunction), "Atleast one of Writer or Reader should be set");

            this.writeFunction = writeFunction;
            this.readFunction = readFunction;
        }

        public override void AppendWriteField(ModuleDefinition module, ILProcessor worker, ParameterDefinition writerParameter, ParameterDefinition typeParameter, FieldReference fieldReference)
        {
            // make generic and import field

            // if param is null then load arg0 instead
            worker.Append(LoadParamOrArg0(worker, writerParameter));
            worker.Append(LoadParamOrArg0(worker, typeParameter));
            worker.Append(worker.Create(OpCodes.Ldfld, fieldReference));
            worker.Append(worker.Create(OpCodes.Call, writeFunction));

        }

        public override void AppendWriteParameter(ModuleDefinition module, ILProcessor worker, VariableDefinition writer, ParameterDefinition valueParameter)
        {
            // use built-in writer func on writer object
            // NetworkWriter object
            worker.Append(worker.Create(OpCodes.Ldloc, writer));
            // add argument to call
            worker.Append(worker.Create(OpCodes.Ldarg, valueParameter));
            // call writer extension method
            worker.Append(worker.Create(OpCodes.Call, writeFunction));
        }

        public override void AppendRead(ModuleDefinition module, ILProcessor worker, ParameterDefinition readerParameter, TypeReference fieldType)
        {
            // add `reader` to stack
            worker.Append(worker.Create(OpCodes.Ldarg, readerParameter));
            // call read function
            worker.Append(worker.Create(OpCodes.Call, readFunction));
        }
    }
}
