# 移动端之开启和禁止页面滚动

在做移动端页面是，有个操作需要禁止页面的滚动，故学习了原生 js 的操作

```javascript
function handler(ev) {
  ev.preventDefault()
}
// 禁止页面滚动
document.body.addEventListener('touchmove', handler, { passive: false })
```

- passive：false。 设置该属性的目的主要是为了在阻止事件默认行为导致的卡顿。等待监听器的执行是耗时的，有些甚至耗时很明显，这样就会导致页面卡顿。即便监听器是个空函数，也会产生一定的卡顿，毕竟空函数的执行也会耗时。加上{ passive: false }能防止页面卡顿。

```javascript
// 开启页面滚动
document.body.removeEventListener('touchmove', handler, { passive: false })
```

- 注意点，不能这样写

```javascript
// 开启页面滚动
document.body.addEventListener(
  'touchmove',
  function (ev) {
    ev.preventDefault()
  },
  { passive: false }
)
```

- 添加和移除的函数对象应该是同一个,否则移除不起作用,即 listener 不能直接用匿名函数 function(ev){
  ev.preventDefault();
  }
