<a href="https://github.com/IsaacAlves7/web"><img src="https://www.webinfonex.com/data/assets/uploads/service/ser_5.jpg"></a>

# It's a repository of Web Development 🌐
> 🌐 **Preparação**: Para este conteúdo, o aluno deverá dispor de um computador com acesso à internet, um web browser com suporte a HTML 5 (Google Chrome, Mozilla Firefox, Microsoft Edge, Safari, Opera etc.), um editor de texto (VSCode etc.) e uma plataforma de hospedagem (gratuita ou paga).

<div align="center"><img src="https://images.fineartamerica.com/images/artworkimages/medium/3/keep-calm-and-let-the-web-developer-handle-it-funny-gift-ideas-transparent.png" height="177"></div>

- https://www.frontendmentor.io/
- https://daily.dev/
- https://getcssscan.com/css-box-shadow-examples
- https://whirl.netlify.app/
- https://flexboxfroggy.com/
- https://courses.cs.washington.edu/courses/cse154/flexboxducky/
- http://www.flexboxdefense.com/
- https://cssgridgarden.com/
- https://gridcritters.com/
- https://caniuse.com/
- https://www.magicpattern.design/tools/blob-generator
- https://meyerweb.com/eric/tools/css/reset/
- https://html5boilerplate.com/
- https://www.color-hex.com/color-palette/22942
- https://www.greatfrontend.com/pt-BR
- https://echarts.apache.org/en/index.html

# 🌐 O que é um website?
Quando falamos sobre website, podemos notar que este termo se trata da junção de duas palavras em inglês: “web”, que significa rede e faz referência a rede mundial de computadores, e “site”, que quer dizer lugar. Nesse sentido, um website ou site é um local que pode ser acessado na internet, por meio de uma URL, e possui um conjunto de páginas programadas em alguma linguagem. 

Para entendermos melhor sobre esse assunto, vamos a um exemplo: quando você digita em seu navegador de internet o endereço blog.betrybe.com para acessar o blog da Trybe, o navegador vai buscar onde este site está localizado na internet. Em seguida, será feita uma requisição ao servidor. 

Nesse servidor estão armazenados todos os arquivos de texto, imagem e estilo que compõem a página web. Então, o servidor devolverá este conjunto de documentos ao navegador para que ele possa exibir o conteúdo como você vê em sua tela. 

Os websites podem apresentar variadas formas e conteúdos. Entre algumas das opções, estão: as lojas virtuais, como Mercado Livre e Amazon, onde a compra e venda de produtos pode ser feita; os sites institucionais e portfólios, usados por empresas e pessoas para se apresentarem e serem encontradas por clientes; e os blogs, como este que você lê. 

Além disso, os sites também podem ser classificados em estáticos ou dinâmicos. Os sites estáticos são desenvolvidos utilizando, de modo geral, HTML, CSS e JavaScript. Seu conteúdo é mais simples e não há interação com uma base de dados.   

Já os sites dinâmicos, além de usufruírem do HTML, CSS e JavaScript, também utilizam linguagens de programação mais robustas, como PHP. Estes sites possuem funcionalidades conectadas a um banco de dados. Dessa forma, cada página acessada pode trazer dados específicos.  

# 🎨 Web Design
<a href="https://www.websitebuilderexpert.com/designing-websites/how-to-choose-color-for-your-website/"><img src="https://em-content.zobj.net/source/microsoft-teams/363/artist-palette_1f3a8.png" height="77" align="right"></a>

Com o **Web Design** você precisa observar a importância da interface para o desenvolvimento de websites, evolução das tecnologias utilizadas na construção de páginas web ricas (web 1.0, web 2.0, web 3.0 e web 4.0), evolução das interfaces (mudanças estéticas, funcionais e estruturais).

Portanto, você necessita compreender a importância da elaboração de interfaces ricas para a construção de um website, visando a melhor experiência de navegação e usabilidade para o usuário final, conhecendo algumas tecnologias utilizadas no passado para a construção de sites online. A partir dessa visão, observar antigas tendências de mercado, assim como enxergar novas tendências na elaboração de interfaces.

Paleta de cores:

- https://paletadecolores.online/pt/magenta/
- https://simpleicons.org/
- https://colorhunt.co/
- https://coolors.co/
- https://colors.muz.li/
- https://www.toptal.com/designers/colourcode/
- https://lospec.com/palette-list
- https://mycolor.space/
- https://www.pantone.com/articles/color-palettes
- https://atmos.style/color-generator
- https://github.com/EmilHvitfeldt/r-color-palettes
- https://www.color-hex.com/color-palettes/
- https://visme.co/blog/website-color-schemes/
- https://colorpalettes.com/
- https://colorpalettes.net/

Gradientes:

- https://www.grabient.com/
- http://gradientsguru.com/
- https://www.eggradients.com/
- https://uigradients.com/#Zinc
- https://webgradients.com/
- https://cssgradient.io/

# 🌐 Web Development
<img src="https://em-content.zobj.net/source/microsoft-teams/363/globe-with-meridians_1f310.png" height="77" align="right">

Basicamente, desenvolvimento web significa codificar páginas para a internet. No entanto, essa tarefa vai além da utilização de HTML e CSS, as ferramentas básicas para a criação de uma página estática — que apresenta informações que só podem ser modificadas com a edição do código fonte.

Ao contrário, as páginas em um site podem ser dinâmicas. Isso significa que o conteúdo exibido pode ser alterado sem a interferência no código fonte. Para que isso seja possível, as partes dinâmicas do site ficam armazenadas em um banco de dados, que é acessado sempre que for necessário recuperar esse conteúdo.

Essa característica permite o desenvolvimento de aplicações complexas, que utilizam regras de negócios, APIs — Application Programming Interface — e muito mais. Portanto, existe uma divisão nas atividades voltadas ao desenvolvimento para web, a codificação do lado cliente (front-end) e a do lado do servidor (back-end).

> Exemplo de API com, a estrutura mais usada atualmente para Aplicações Web e Mobile, REST API também chamado de **RESTful API**.

Aplicações Web são o número cada vez maior de sites na Web, isto é, eles imitam aplicações de desktop ao invés dos documentos tradicionais e
estático de links de textos e imagens que compõem a maioria da Web. Como exemplo, temos os processadores onlines de texto, ferramentas de edição de foto, sites de mapeamento etc. Altamente movidos com JavaScript, eles levaram o HTML4 à beira do limite de suas capacidades. O HTML5 especifica novas APIs (Interface de Programação de Aplicações) para DOM (Modelo de Objeto de Documento), que é uma convenção multiplataforma e independente de linguagem para representação e interação com objetos e documentos HTML, XHTML e XML.

Essas novas APIs ajudam a arrastar e soltar objetos enviados pelo servidor, tais como, desenho, vídeos e similares.

Essas novas interfaces que as páginas HTML expõem ao JavaScript via objetos na DOM tornam mais fácil escrever as aplicações,
utilizando padrões altamente especificados, ao invés de apenas artimanhas mal-documentadas.

Ainda mais importante é a necessidade de um padrão aberto livre (para utilizar e para implementar) que possa competir com padrões proprietários como
Adobe Flash ou Microsoft Silverlight. Independentemente do que você acha dessas tecnologias ou empresas, acreditamos que a Web seja uma plataforma vital à sociedade, comércio e comunicações para estar nas mãos de um fabricante.

Há milhões de páginas Web já em uso por aí, e é imperativo que elas continuem a ser reproduzidas. Então, o HTML5 é, em sua maioria, um derivativo do HTML4 que continua a definir como os navegadores devem lidar com marcações antigas como  <code>&lt;font&gt;</code>, <code>&lt;center&gt;</code> e outras novas, pois milhões de páginas web as utilizam.

# 🎨 Interface
O termo **interface** pode dispor de vários significados dependendo da área na qual ela é estudada. Na área da Tecnologia da Informação, interface significa a **possibilidade de comunicação entre dois sistemas que não poderiam se comunicar naturalmente sem alguma ajuda externa**.

O IHC é o estudo da interação entre pessoas e computadores. É uma matéria interdisciplinar que relaciona a ciência da computação, artes, design, ergonomia, psicologia, sociologia, semiótica, linguística, e áreas afins. A interação entre humanos e máquinas acontece através da interface do utilizador, formada por software e hardware.

> A interação humano-computador é uma disciplina preocupada com o design, a avaliação e a implementação de sistemas computacionais interativos para uso humano e com o estudo dos principais fenômenos ao redor deles.

<img src="https://user-images.githubusercontent.com/61624336/194796066-6256d836-86ae-4249-a45b-898e85537a16.jpg" title="Interface gráfica" height="77" align="right">

Por exemplo, um usuário de um site de e-commerce que está à procura de determinado produto, como um sapato, deverá de alguma forma passar a informação do produto que ele está pensando em adquirir para o sistema, como o tamanho do calçado, o tipo de solado, o material utilizado para a sua confecção, entre outros.

A forma pela qual a aplicação recebe essa informação do usuário pode ser considerada como a sua interface. A finalidade de uma interface é facilitar a interação de uma pessoa com um sistema ou até mesmo a comunicação entre diferentes sistemas.

> **Comentário**: Para o caso específico da comunicação entre diferentes sistemas, existem vários recursos que podem ser utilizados. Alguns dos mais empregados atualmente são os **web services**. Para garantir a correta operação na interligação de sistemas, são utilizados outros recursos além do HTTP, como SOAP, REST e XML-RPC. 

Segundo Benyon (2011), A interface para um sistema interativo são todas as peças do sistema com as quais as pessoas têm contato, física, perceptiva ou conceitualmente:

- **Fisicamente**: Fisicamente, podemos interagir com um dispositivo apertando botões ou movimentando alavancas, e o dispositivo interativo pode responder fornecendo retorno através da pressão do botão ou alavanca;
- **Perceptivamente**: Perceptivamente, o dispositivo exibe coisas em uma tela que podemos ver, ou emite sons que podemos ouvir;
- **Conceitualmente**: Conceitualmente, interagimos com um dispositivo tentando concluir o que ele faz e o que deveríamos estar fazendo. O dispositivo fornece mensagens e outros indicadores feitos para nos ajudar nesse sentido.

> Uma interface deve oferecer meios para que um usuário possa passar instruções de forma simples, como também deverá informar ao usuário algum retorno, que pode ser uma informação, uma imagem, um aviso sonoro, uma animação ou até um filme.

<img src="https://user-images.githubusercontent.com/61624336/194799532-9908b16c-6394-47d8-a92e-7c563321bc5f.jpg" title="Interface gráfica nos smartphones" height="177" align="right">

Podemos observar, atualmente, uma enorme variedade de interfaces, nos mais variados dispositivos que utilizamos em nosso cotidiano, tais como smartphones, controles remotos, geladeiras, aparelhos de micro-ondas e joysticks utilizados em videogames.

O projeto de construção de um sistema é muito mais complexo do que apenas a criação de uma interface. Toda a interação entre o homem e o sistema deve ser levada em consideração desde a sua concepção. Na área de Tecnologia da Informação, o design de interfaces refere-se à criação da interface do usuário para softwares, sites ou aplicativos. Trata-se de programar o visual da aplicação, visando sempre a facilitar a usabilidade e melhorar a experiência do usuário final.

# 📙 [HTML5] Hypertext Makup Language 5
<img src="https://upload.wikimedia.org/wikipedia/commons/6/61/HTML5_logo_and_wordmark.svg" height="77" align="right"/>

A linguagem de formatação de documentos com a capacidade de links de hipertexto (termo que remete a um texto ao qual se agregam outros conjuntos de informação na forma de blocos de textos, palavras, imagens ou sons, cujo acesso ocorre através de referências específicas, no meio digital, denominadas hiperlinks, ou simplesmente links) e que tornou-se o formato básico para publicação na web.

In 1990, the <b>HTML</b> (<i>HyperText Markup Language</i>) has been created by Tim Bernes-Lee. A mais nova versão do HTML, chamada de versão 5, representa uma evolução dos "padrões" para definição de páginas para internet, representando uma nova linguagem de marcação, com elementos, atributos e comportamentos, além de um conjunto maior de tecnologias que permitem o desenvolvimento de aplicações quando associadas a outras linguagens.

**HTML Timeline**
1. HTML é tornado público - 1989
2. HTML - 1991
3. Primeira especificação - 1992
4. HTML 2.0 é publicado e é criado o JavaScript (JS)- 1995
5. Inclusão de novos elementos e a apresentação do CSS 1 - 1996
6. HTML 3.2 - 1997
7. HTML 4 é publicado - 1998
8. HTML 4.01 - 1999
9. Norma ISO para o HTML e o XHTML 1 - 2000
10. HTML5 é publicado - 2008
11. 11W3C parou de trabalhar no XHTML e a desviou recursos para HTML5 - 2009
12. HTML5 - 2014
13. HTML5.1 - 2016 e 2017 (2nd ed.)
14. HTML5.2 - 2017/(Atualmente)

Em 1998, a W3C decidiu que não continuaria a evoluir o HTML. O futuro da programação para páginas de internet era o XML. Então o HTML foi congelado na versão 4.01 e uma especificação foi lançada com nome de XHTML, que era uma versão do HTML baseada no XML, exigindo regras de sintaxe como atributos com aspas, algumas tags com fechamento, enquanto outras eram autocontidas.

Um pequeno grupo, dos criadores do navegador Opera, entretanto, não estava convencido que o XML era o futuro para todos os autores web. Este grupo começou a desenvolver um trabalho separado, para criar uma nova forma de utilização dos antigos códigos HTML, principalmente ligado ao uso de formulários, sem deixar de atender às determinações básicas do XML. Aquela especificação eventualmente se tornou Web Forms 2.0 e, subsequentemente, foi incorporado na especificação HTML5.

Em 2006, a W3C percebeu que talvez tivesse sido otimista demais na esperança de que o mundo se mudasse para o XML. Essas ideias foram implementadas e outras rejeitadas independentemente de qual fosse a fonte e quem ela representasse, ou até mesmo onde elas foram inicialmente debatidas.

## [HTML5] TAGs essenciais
É necessário entender o que é <b>TAG</b> (linguagens de marcação), o “comando” do HTML. TAGs são estruturas de linguagem de marcação contendo instruções, tendo uma marca de início e outra de fim para que o navegador possa renderizar uma página. O elemento que compõe a estrutura do documento HTML5 é iniciado com o símbolo menor ( < ) e terminado com o símbolo maior ( > ), como por exemplo: <code>&lt;meta&gt;</code>, <code>&lt;h1&gt;</code>, <code>&lt;img&gt;</code> etc. 

Ou seja, todo elemento HTML é chamado de <b>tag</b> que é definida pelos os sinais de abertura <b>&lt;tag aberta&gt;</b> e de fechamento <b>&lt;/tag fechada&gt;</b>, há exceções de Tags que não precisam de um fechamento somente a Tag de abertura, como é o caso do <code>&lt;meta&gt;</code> e <code>&lt;link&gt;</code>.

Além disso, são divididas em categorias conforme a seguir:

- Metadados
- O elemento root
- Agrupamento de conteúdo
- Seções
- Script
- Edições
- Semânticas de nível de texto
- Conteúdo incorporado
- <a href="https://github.com/IsaacAlves7/web#-html-tags-de-tabelas">Tabelas</a>
- Formulários
- Interativo

Uma TAG pode conter <b>atributos</b>, que são informações que alteram o comportamento da TAG. Os atributos podem ser divididos em atributos específicos para cada TAG e atributos globais que são comuns a todas as tags.

Além das TAGs, existem outros elementos que ajudam na construção de documentos HTML5, que são: o <b>CSS</b>, o <b>Javascript</b>.

## Atributos de uma TAG
<b>Atributos</b> são informações que passamos na Tag para que ela se comporte da maneira esperada. Existem <b>atributos globais</b> (que funcionam em todas as Tags) e <b>específicos</b> (que são direcionados para cada Tag, através de especificação).

Os Atributos possuem <b>nome</b> e um <b>valor</b>. Existem Atributos que você vai usar sempre e existem outros que serão mais raros. Exemplo de atributo da tag <code>&lt;link&gt;</code>:

```html
<link rel="stylesheet" href="/assets/public/styles/css/style.css">
```

Como pode ver o atributo <code>rel=""</code> indica o valor da conexão, que no caso é <code>rel="stylesheet"</code> que significa "folha de estilo" para reconhecer o arquivo CSS externo. O atributo <code>href=""</code> significa o endereço dessa conexão, é importante que o endereço seja bem declarado para a conexão funcionar, caso contrário não irá funcionar.

### Atributos Específicos de uma TAG
<table>
  <tr>
    <td><strong>Atributo</strong></td>
    <td><strong>Função do atributo</strong></td>
  </tr>
  <tr>
    <td><code>rel=""</code></td>
    <td>Especifica o relacionamento entre o documento atual e o documento linkado</td>
  </tr>
  <tr>
    <td><code>src=""</code></td>
    <td>Especifica a URL do arquivo de mídia</td>
  </tr>
  <tr>
    <td><code>type=""</code></td>
    <td>Especifica o tipo do documento</td>
  </tr>
  <tr>
    <td><code>alt=""</code></td>
    <td>Mostra o texto quando a aparência não renderiza</td>
  </tr>
  <tr>
    <td><code>target=""</code></td>
    <td>Especifica o modo de abrir o link em janela</td>
  </tr>
  <tr>
    <td><code>width=""</code></td>
    <td>Especifica a largura do elemento</td>
  </tr>
  <tr>
    <td><code>height=""</code></td>
    <td>Especifica a altura do elemento</td>
  </tr>
  <tr>
    <td><code>name=""</code></td>
    <td>Especifica o nome do elemento</td>
  </tr>
  <tr>
    <td><code>value=""</code></td>
    <td>Especifica o valor do elemento</td>
  </tr>
</table>

### Atributos Globais de uma TAG
<table>
  <tr>
    <td><strong>Atributo</strong></td>
    <td><strong>Função do atributo</strong></td>
  </tr>
  <tr>
    <td><code>title=""</code></td>
    <td>Especifica a informação extra sobre o elemento, como um balãosinho de texto</td>
  </tr>
  <tr>
    <td><code>class=""</code></td>
    <td>Especifica uma ou mais classes para um elemento ou varios elementos (referência de classe para o CSS)</td>
  </tr>
    <tr>
    <td><code>id=""</code></td>
    <td>Especifica uma unica id para um elemento (referência de id para o CSS)</td>
  </tr>
</table>

# 📘 CSS3 - Cascading Style Sheets 3
<img src="https://upload.wikimedia.org/wikipedia/commons/d/d5/CSS3_logo_and_wordmark.svg" height="77" align="right"/>

O **CSS** (Cascading Style Sheets), é um "Stylesheets" (folha de estilo) composta por "camadas" e usado para definir a aparência de páginas da internet que adotam para o seu desenvolvimento linguagens de marcação (como XML, HTML e XHTML), criando assim as interfaces. O CSS define como serão exibidos os elementos contidos no código de uma página da internet e sua maior vantagem é efetuar a separação entre o formato e o conteúdo de um documento.

Há várias formas de inserir modificação no estilo com CSS. Com o CSS você pode especificar muitas propriedades de estilo para qualquer elemento HTML. Cada propriedade tem um nome e um valor, separados por dois pontos `:`. Cada declaração de propriedade é separada por um ponto e vírgula `;`.

Conforme W3C, Cascading Style Sheets (CSS) é um mecanismo simples para adicionar estilo (por exemplo, fontes, cores, espaçamento) nos documentos da Web. O <strong>CSS</strong> é um conjunto de comandos que alteram o comportamento dos elementos HTML 5 e, portanto, existem algumas formas de fazer isso, veja abaixo quais são e as suas sintaxes:

<ul>
<li><b>CSS interno</b>: as formatações são definidas dentro do arquivo HTML.</li>
<br><b>Exemplo de CSS interno:</b><br>
  
```html
<style> * { margin: 0; padding: 0;} </style>
```
  
<li><b>CSS externo</b>: as formatações são definidas um arquivo CSS que é linkado ao arquivo HTML.</li>
<br><b>Exemplo de CSS externo:</b><br>
  
```html
<link rel="stylesheet" href="/assets/public/styles/css/style.css">
```
  
<li><b>CSS inline</b>: a definição do estilo é feita na mesma linha da TAG HTML a ser formatada. Neste método, o CSS é aplicado diretamente no elemento, utilizando o atributo <strong>style</strong>. É caracterizado por possuir uma implementação mais simples, no entanto, este método dificulta a manutenção do código.</li>
<br><b>Exemplo de CSS inline:</b><br>
  
```html
<p style="color:olive;font-size:19px;background-color:black"></p>
```
  
</ul>

## Principais conceitos do CSS3
Os principais conceitos do CSS são divididas em categorias conforme a seguir:

- <a href="">Seletores, Declarações, Propriedades e Valores</a>
- <a href="https://github.com/IsaacAlves7/web#-css-box-model">Box Model, padding e margin</a>
- <a href="">Texto, Background, Foreground e Variáveis</a>
- <a href="">Classes e IDs</a>
- <a href="">Keyframes e Animations</a>
- <a href="">Pseudo-classes</a>
- <a href="">Pseudo-elementos</a>
- <a href="">Transform e Transition</a>
- <a href="">Positions, Dimensions e Displays</a>
- <a href="">Media Queries e Layouts Responsivos</a>

# 📦 [CSS] Box Model
<img src="https://pressupinc.com/wp-content/uploads/2014/01/box-model.png" height="77" align="right">

When we are creating the layout of a website the browser represents each HTML element as a retangular box, this is the <b>box-model</b>. And with the CSS we can alterate the aparence of this box (width, height, background color, etc.). That box is compost for 4 areas: the content, the padding, the border and the margin.

<ol>
  <li><b>margin</b> - São os espaçamentos entre elementos (transparente).</li>
  <li><b>border</b> - A borda, onde circulam o padding e o conteúdo, dá para alterar a largura, cor e forma.</li>
  <li><b>padding</b> - Espaçamento entre a borda e o conteúdo.</li>
  <li><b>content</b> - O conteúdo inserido no elemento HTML.</li>
</ol>

Besides that, the Box model have his positions:

<img src="https://www.csssolid.com/images/box-model/css-box-model.png" height="177" align="right"/>

<ul>
  <li><b>top</b>: Up position</li>
  <li><b>right</b>: Right position</li>
  <li><b>bottom</b>: Down position</li>
  <li><b>left</b>: Left position</li>
</ul>

> 📦 **Box Model**: ` top, right, down, left `

> OBS: Sempre será referenciada por esta ordem: topo, direita, inferior e esquerda (top, right, bottom, left)

Exemplo:

```css
ul {
 margin: 12px;
 padding: 12px;
}
```

Dessa forma, é possível inserir de uma vez os espaçamentos da ordem (top, right, bottom, left) de um modelo padrão de 12px para cada posição, porém não permite diferenciar e alterar uma posição da ordem, pois ambos foram solicitados para 12px. Outra forma, é inserir essa instrução passo a passo para a ordem (top, right, bottom, left) o que permite diferenciar o espaçamento de cada um, como desejado.

```css
ul {
 margin: 12px 12px 12px 12px; /*top, right, bottom, left = 12px*/
 padding: 12px 0px 12px 12px; /*espaçamento direito entre a borda e o conteúdo = 0px; top, left, bottom = 12px*/
}
```

Outra forma é inserir a propriedade do box model de acordo com suas posições, o que não é muito prático.

Exemplo:

```css
ul {
 margin-top: 12px; /*topo da margem = 12px*/
 margin-right: 12px; /*direito da margem = 12px*/
 margin-bottom: 12px; /*abaixo da margem = 12px*/
 margin-left: 12px; /*esquedo da margem = 12px*/
 
 padding-top: 12px; /*espaçamento topo entre a borda e o conteúdo = 12px*/
 padding-right: 0px; /*espaçamento direito entre a borda e o conteúdo = 0px*/
 padding-bottom: 12px; /*espaçamento inferior entre a borda e o conteúdo = 12px*/
 padding-left: 12px; /*espaçamento esquerdo entre a borda e o conteúdo = 12px*/
}
```

> OBS: Perceberam a discrepância entre os dois métodos? E como é mais prático o primeiro.

# 📜 JavaScript (JS)
<a href="https://github.com/IsaacAlves7/js"><img src="https://blog.vandersonguidi.com.br/wp-content/uploads/2016/11/js3.png" height="77" align="right"/></a>

O <b>JavaScript</b> (JS) é uma linguagem de programação do <b>lado cliente</b>, ou seja, é processada pelo próprio navegador (processada pelo cliente).

Com o JavaScript podemos criar efeitos especiais para nossas páginas na Web, além de podermos proporcionar maior interatividade com nossos usuários. O JavaScript é uma linguagem orientada a objetos, ou seja, ela trata todos os elementos da página como objetos distintos, facilitando a tarefa da programação.

Resumindo, o JavaScript é uma poderosa linguagem que deve ser dominada por quem deseja criar páginas Web dinâmicas e interativas.

É uma linguagem de programação baseada em scripts e padronizada pela ECMA Internacional. Foi criada por <b>Brendan Eich</b> (Netscape) e surgiu em 1995 como linguagem de script client-side de páginas web.
  
> Atualmente, o JavaScript compete com outras linguagens de programação em alta no mercado, sendo indispensável o seu aprendizado.

```html
<img src="1.jpg" onclick="functionClick()"/>
```

O HTML tem a habilidade de gerar eventos desencadeando ações para o navegador, como iniciando uma função JavaScript quando o usuário interage em um elemento. Devido a extensão desse conteúdo criei um repositório mais focado no desenvolvimento JavaScript, clique no badge acima para saber mais sobre os Eventos!

Em 1995, o desenvolvimento de páginas web ganha um poderosíssimo aliado, que o acompanha até os dias de hoje: o **Javascript**. Graças a essa nova tecnologia, designers do mundo inteiro puderam superar algumas das limitações do HTML. A navegação na web começa a ficar menos estática e um pouco mais interativa. Com essa inovação, por exemplo, deu-se início às janelas pop-ups.

> **Comentário**: Um dos problemas da utilização dessa até então nova tecnologia é que o Javascript necessitava ser carregado no topo da página, o que aumentava consideravelmente o tempo de carregamento dos sites. É de se salientar que em meados dos anos 1990, a velocidade máxima de conexão com a internet não ultrapassava a velocidade de 56Kpbs. Muitas das funções iniciais do Javascript acabaram sendo incorporadas ao CSS. 

# 💻 [Front-End] A Estrutura do Website

Tudo começa com o diretório, e dentro dele as pastas `/public/` e `/src/` , e lá os arquivos `index.html` e `style.css`.

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
[![CSS3](https://img.shields.io/badge/-style.css-000000?style=social&logo=CSS3&logoColor=1877F2)](#)
[![JS](https://img.shields.io/badge/-main.js-000000?style=social&logo=JavaScript&logoColor=yellow)](#)

O `index.html` é o padrão da Web de ser o primeiro arquivo processado pelo navegador, geralmente é usado para uma áreas de Login ou a Home da página, e o `style.css` é o padrão para editar um ou mais arquivos HTML.

**HTML5 boilerplate**:

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<!DOCTYPE html>
<html lang="pt-br">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="stylesheet" href="">
	<title>HTML5 boilerplate</title>
    </head>
    <body>
	<h1>Hello, World!</h1>
        <script src="" async defer></script>
    </body>
</html>
```

Basicamente, a estrutura do documento html se baseia em `<!Doctype html>`, `<html>`, `<head>`, `<body>`. Observe a tag  muito cuidadosamente. Aqueles acostumados a escrever XHTML perceberam três estranhezas. A primeira é que a tag está muito mais curta do que costumava ser até então - estávamos acostumados a utilizar:

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
```

Isso ainda é possível, mas a versão mais curta é preferível, já que é mais fácil de digitar e funciona em todo lugar.

Você também perceberá que não colocamos aspas no atributo <code>charset=utf-8</code> nem utilizamos o autoencerramento na tag. O HTML5 não é uma linguagem XML, então você não precisa dessas coisas.

Os navegadores nunca se importaram com a sintaxe XHTML, se ela fosse enviada como text/html (apenas um validador XHTML se importaria). Assim, favorecer uma forma em detrimento da outra no HTML5 seria totalmente arbitrário e tornaria inválidas as páginas que não seguissem o formato, apesar delas funcionarem perfeitamente em qualquer navegador. Desse modo, não importa para o HTML5 qual forma você utiliza.</p>

## `<!Doctype html>`
É o tipo do documento, vale ressaltar que não é obrigatório.

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<!Doctype html>
```

## `<html>`
É a tag onde editamos o documento HTML, vale ressaltar que é obrigatória para o documento funcionar. Possui o atributo <code>lang=""</code> que define a língua regional do documento.

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
<pre>&lt;html lang="pt-br"&gt;&lt;/html&gt;</pre>

<h2>&lt;head&gt;</h2>
<p>O <code>&lt;head&gt;</code> representa uma coleção de comandos em que podemos definir as informações do site em si, caracterizadas, como <b>metadados</b>. Nesse elemento, são carregadas as informações referentes ao documento como, por exemplo, comandos <b>CSS</b> e <strong>JavaScript</strong>.

<p>No <b>&lt;head&gt;</b> encontramos:
  <ul>
  <li><code>&lt;title&gt;</code> que representa o título do documento da página HTML:</li><br/>
    
  [![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
  
  <pre><code>&lt;title&gt;Estrutura do HTML&lt;/title&gt;</code></pre>
  <li><code>&lt;link&gt;</code> que representa ligação com os arquivos externos:</li><br/>
  
  ### Chamando uma folha de estilo externa
 
 [![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
 [![CSS3](https://img.shields.io/badge/-style.css-000000?style=social&logo=CSS3&logoColor=1877F2)](#)
 
 <pre>&lt;link rel="stylesheet" href="style.css"&gt;</pre>
 
 ### Chamando uma ícone para a guia do navegador
 
 [![SVG](https://img.shields.io/badge/-icon.svg-000000?style=social&logo=SVG&logoColor=FFB13B)](#)
 
```html
<link rel="shortcut icon" href="icon.svg">
```

- `<meta>` que representa comandos para definições globais da página:
  
  [![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
  
  <pre>
   <code>&lt;meta charset="utf-8"&gt;</code>
   <code>&lt;meta name="description" content="Free Web Tutorials"&gt;</code>
   <code>&lt;meta name="keywords" contents="HTML,CSS,XML,JavaScript"&gt;</code>
   <code>&lt;meta name="author" content="Hege Refsnes"&gt;</code>
   <code>&lt;meta http-equiv="refresh" content="30"&gt;</code>
  </pre>
  
  <b>Atualizar a página depois de 1 segundo sem JavaScript!</b>
  <pre>&lt;meta http-equiv="refresh" content="1;url=index.html"&gt;</pre>
  
  <li><code>&lt;script&gt;</code> comando para chamada de rotinas em JavaScript e ligação com os arquivos js externos:</li><br/>
  
  [![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)
  
  <pre>&lt;script&gt;
     function myFunction {
         document.getElementById("demo").innerHTML = "Hello JavaScript!";
     }
&lt;/script&gt;
&lt;script type="script/javascript" src="main.js"&gt;&lt;/script&gt;
</pre>

<li><code>&lt;style&gt;</code> comando para estilização do CSS do tipo interno:</li><br/>

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

  <pre>&lt;style&gt;
    h1 {
    color: blue;
    font-size: 200px;
    }
&lt;/style&gt;
</pre>
  </p>
</ul>
<h2>&lt;body&gt;</h2>
O <code>&lt;body&gt;</code> localizado no mesmo nível do <code>&lt;head&gt;</code>, este elemento representa o conteúdo principal da página. Aqui estão localizados todos os comandos necessários para a criação do documento HTML.</p>
<ul>
<li><code>&lt;h1&gt;&lt;h2&gt;&lt;h3&gt;&lt;h4&gt;&lt;h5&gt;&lt;h6&gt;</code> tags de títulos que são por ordem de h1-h6 diminuindo a fonte (do maior para o menor). <code>&lt;hgroup&gt;</code> é uma tag para um grupo de tags, não possui valor semântico, apenas serve para deixar o código mais legível.</li>
<pre>
<code>&lt;hgroup&gt;</code>
  <code>&lt;h1&gt;título 1&lt;/h1&gt;</code>
  <code>&lt;h2&gt;título 2&lt;/h2&gt;</code>
  <code>&lt;h3&gt;título 3&lt;/h3&gt;</code>
  <code>&lt;h4&gt;título 4&lt;/h4&gt;</code>
  <code>&lt;h5&gt;título 5&lt;/h5&gt;</code>
  <code>&lt;h6&gt;título 6&lt;/h6&gt;</code>
<code>&lt;/hgroup&gt;</code>
</pre>
<li><p><code>&lt;p&gt;</code> elemento que representa um parágrafo:</p></li>
<pre><code>&lt;p&gt;parágrafo&lt;/p&gt;</code></pre>
<li><p><code>&lt;i&gt;</code> e <code>&lt;em&gt;</code> elementos que representam o texto do estilo do tipo <em>itálico</em>.</p></li>
<pre>&lt;i&gt;itálico&lt;/i&gt;
     &lt;em&gt;itálico&lt;/em&gt;</pre>
<li><p><code>&lt;b&gt;</code> e <code>&lt;strong&gt;</code> elementos que representam o texto do estilo do tipo <b>negrito</b>.</p></li>
<pre>&lt;b&gt;negrito&lt;/b&gt;
     &lt;strong&gt;negrito&lt;/strong&gt;</pre>
<li><p><code>&lt;pre&gt;</code> elemento que apresenta um bloco de texto pré-formatado, preservando seu conteúdo.<b></b>.</p></li>
<pre>&lt;pre&gt;Bloco de texto pré-formatado.&lt;/pre&gt;</pre>
<li><p><code>&lt;br&gt;</code> elemento que serve para quebrar uma linha da página.</p></li>
<code>&lt;br&gt;</code>
<li><p><code>&lt;hr&gt;</code> elemento que possui uma forma linha horizontal com a função para dividir os elementos da página.</p></li>
<code>&lt;hr&gt;</code>
<li><p><code>&lt;wbr&gt;</code> elemento que dá uma oportunidade de quebra de linha, se necessário.<b></b>.</p></li>
<code>&lt;wbr&gt;</code>
<li><p><code>&lt;sub&gt;</code> elemento que representam o texto do estilo do tipo sobscrito.</p></li>
<pre>&lt;sub&gt;texto sobscrito&lt;/sub&gt;</pre>
<li><p><code>&lt;sup&gt;</code> elemento que representam o texto do estilo do tipo sobrescrito.</p></li>
<pre>&lt;sup&gt;texto sobrescrito&lt;/sup&gt;</pre>
<li><p><code>&lt;big&gt;</code> elemento que representa o texto com fonte maior que o padrão.</p></li>
<pre>&lt;big&gt;texto com fonte maior do que o padrão&lt;/big&gt;</pre>
<li><p><code>&lt;small&gt;</code> elemento que representa o texto com fonte menor que o padrão.</p></li>
<pre>&lt;small&gt;texto com fonte menor do que o padrão&lt;/small&gt;</pre>
<li><p><code>&lt;del&gt;</code> elemento que representa o texto com a fonte rabiscada.</p></li>
<pre>&lt;p&gt;texto com a &lt;del&gt;<del>fonte rabiscada</del>&lt;/del&gt;&lt;p&gt;</pre>
<li><p><code>&lt;blockquote&gt;</code> elemento que tem como função exibir o texto indicando de qual referência foi retirado (citação).</p></li>
<pre>&lt;bloquote cite="http://www.quote.com/sample.html"&gt;
    &lt;p&gt;Elemento textual.&lt;/p&gt;
  &lt;/blockquote&gt;</pre>
  
<li><p><code>&lt;figure&gt;</code> elemento que permite definir logicamente as informações de uma imagem. Trabalha com <code>&lt;figcaption&gt;</code>, que permite dar um título a uma imagem, e <code>&lt;img&gt;</code> elemento que exibe a imagem.</p></li>
<pre>&lt;figure&gt;
    &lt;figcaption&gt;Foto de férias&lt;/figcaption&gt;
   &lt;img src="stata.jpg" alt="Fotos das férias no Rio de Janeiro"/&gt;
  &lt;/figure&gt;</pre>
  
<li><p><code>&lt;div&gt;</code> elemento que representa um bloco de texto. As TAGs <code>&lt;body&gt;</code>, <code>&lt;header&gt;</code>, <code>&lt;footer&gt;</code> etc. possuem regras de utilização bem definidas. Caso o desenvolvedor necessite da criação de um bloco de texto que não se encaixe em alguma regra defina de bloco, pode-se utilizar o recurso da <code>&lt;div&gt;</code>. A <code>&lt;div&gt;</code> é um bloco de texto que pode ser usado em qualquer lugar do documento. Geralmente a <code>&lt;div&gt;</code> é usada para diagramar o layout de um site.</p></li>
<pre>&lt;div&gt;teste&lt;/div&gt;</pre>

<li><p><code>&lt;span&gt;</code> elemento que possui uma utilização genérica semelhante ao elemento <code>&lt;div&gt;</code>.</p></li>
<pre>&lt;span&gt;texto de exemplo&lt;/span&gt;</pre>

<li><p><code>&lt;s&gt;</code> elemento que transforma o texto em um conteúdo não relevante.</p></li>
<pre>&lt;p&gt;O texto é &lt;s&gt;irrelevante&lt;/s&gt;&lt;/p&gt;</pre>

<li><p><code>&lt;cite&gt;</code> elemento que transforma o texto em uma citação.</p></li>
<pre>&lt;p&gt;O texto é do &lt;cite&gt;star wars&lt;/cite&gt;&lt;/p&gt;</pre>

<li><p><code>&lt;q&gt;</code> elemento que coloca aspas em um bloco de texto.</p></li>
<pre>&lt;p&gt;O texto é do &lt;q&gt;star wars&lt;/q&gt;&lt;/p&gt;</pre>

<li><p><code>&lt;code&gt;</code> elemento que representa um fragmento de código de computador.</p></li>
<pre>&lt;pre&gt;&lt;code&gt;console.log('Hello, World!');&lt;/code&gt;&lt;/pre&gt;</pre>
</ul>

# 🖼️ TAG de Imagem
<pre>&lt;img src="/assets/public/img/img.svg"&gt;</pre>

# 📋 TAGs de Listas
As listas são importantes para a organização do texto e orientação do usuário.

- `<ul>` define uma lista comum, não-numerada (não-ordenada).

```html
<ul>
   <li>exemplo 1</li>
   <li>exemplo 2</li>
   <li>exemplo 3</li>
   <li>exemplo 4</li>
</ul>
```

 - `<li>` elemento que representa um os itens das listas.

```html
<!-- Lista não ordenada: circle, square, disc -->
<ul type="disc"> <!-- padrão -->
 <li>exemplo 1</li>
 <li>exemplo 2</li>
 <li>exemplo 3</li>
</ul>
```
  
- `<ol>` define uma lista numerada (ordenada).

```html
<!-- Lista ordenada: 1, A, a, 2 -->
<ol type="1"> <!-- padrão -->
  <li>Comida favorita?</li>
  <li>carro favorito?</li>
  <li>Série favorita?</li>
</ol>
```
 
- `<dl>` elemento textual que exibe uma lista de definições, com termos específicos. Trabalha com as tags `<dt>` termo a ser exibido e `<dd>` elementos do termo.

```html
<dl>
  <dt>Carro</dt>
   <dd>Uno</dd>
   <dd>Gol</dd>
  <dt>Moto</dt>
   <dd>Honda</dd>
   <dd>Yamaha</dd>
</dl>
```

# 🔗 [HTML5] TAG de Âncora
<div align="center"><img src="https://www.computerhope.com/jargon/h/html-tag.gif"></div>
<p><code>&lt;a&gt;</code> elemento que representa uma âncora de endereço. Você pode âncorar um endereço de um site e inclusive criar links da sua página html. Com o atributo para renderizar endereços <code>href=""</code>você pode barrar o endereço como <code>href="#"</code> , apenas com o <code>#</code> ou até mesmo seu email com <code><b>href="mailto:webmaster@example.com"</b></code> que irá enviar uma mensagem para seu email.</p>  

<p>Além dos atributos citados, existe o <code>target=""</code> que possui a função de opção da abertura do link. Os valores do <code>target=""</code> podem ser:</p>
<ul>
  <li><code>_blank</code> abre o link em uma nova guia no navegador.</li>
  <li><code>_self</code> abre o documento na mesma janela (esse é o padrão, portanto não é obrigatório!).</li> 
  <li><code>_parent</code> abre o documento na armação parente.</li>
  <li><code>_top</code> abre o documento no corpo todo da janela.</li>
</ul>

### Exemplo 1: Abrindo o link em uma nova guia
<pre>&lt;a href="https://www.google.com/" target="_blank"&gt;Clique no endereço&lt;/a&gt;</pre>

### Exemplo 2: Linkando dentro das imagens
<pre>&lt;a href="https://www.google.com/" target="_self"&gt;&lt;img src="/assets/public/images/img.svg" height="100"&gt;&lt;/a&gt;</pre>

### Exemplo 3: Enviando mensagem para o email
<pre>&lt;a href="mailto:webmaster07@gmail.com"&gt;Enviar email&lt;/a&gt;</pre>

# 🔊 [HTML5] TAGs de Multimedia
<img src="https://jibigit.github.io/cheat-html/images/media.png" align="right" height="77">

O termo mídia digital é oposto de mídia analógica, esta era configurada por uma base material: o som era gravado em pequenos sulcos, sobre uma superfície de vinil e, quando uma agulha passava por esses sulcos o som era reproduzido. Nas mídias digitais o suporte físico praticamente desaparece, e os dados são convertidos em sequências numéricas ou de dígitos - por isso uso do termo digital. Dessa forma, os sons, imagens, textos, são na realidade sequências de números, o que permite o compartilhamento, armazenamento e conversão de dados. No sentido mais amplo, mídia digital pode ser definida como o conjunto de veículos e aparelhos de comunicação baseados em tecnologia digital, permitindo a distribuição ou comunicação digital das obras intelectuais escritas, sonoras ou visuais. Meios de origem eletrônica utilizados nas estratégias de comunicação das marcas com seus consumidores, geralmente chamada de mídia digital.

O <b>Flash</b> sempre foi a alternativa mais viável para quem precisava adicionar vídeos e músicas nas páginas Web. Ele estava e ainda está presente em quase todos os navegadores e tínhamos um formato que podia ser usado sem maiores problemas.

Bastava adicionar uma <b>chamada para o plugin</b> e funcionava.

<pre>
 <code>&lt;object width="426" height="240"&gt;</code>
 <code>&lt;param name="movie" value=" https://youtu.be/S2Vty9srpFw"&gt;</code>
 <code>&lt;/param&gt;</code>
 <code>&lt;param name="allowFullScreen" value="true"&gt;&lt;/param&gt;</code>
 <code>&lt;param name="allowscriptaccess" value="always"&gt;&lt;/param&gt;</code>
 <code>&lt;param name="allowscriptaccess" value="always"&gt;&lt;/param&gt;
&lt;embed src= https://www.youtube.com/embed/S2Vty9srpFw
type="application/x-shockwave-flash"
allowscriptaccess="always"
allowfullscreen="true"
width="426"
height="240"&gt;</code>
<code>&lt;/embed&gt;</code>
<code>&lt;/object&gt;</code>
</pre>

Em virtude das inconsistências dos navegadores, era preciso adicionar tanto o comando <code>&lt;object&gt</code>; quanto o comando <code>&lt;embed&gt</code>;, comandos específicos para utilização do plugin, duplicando muitos atributos. Isso sem falar que plugins como o Flash causam muitas instabilidades, ocasionando erros que levam até ao fechamento do navegador.

Devido a tudo isso, o HTML 5 vem com um novo suporte, nativo na linguagem, para evitar o uso de plugins e comandos desnecessários. Atualmente, basta colocar a chamada simples, como se fosse uma imagem e o arquivo é acionado.</p>
<pre>&lt;video controls src="video.mp4" width="426" height="240"&gt;&lt;/video&gt;</pre>

O problema apresentado pelo novo comando é o uso do atributo <code>src</code> que não funciona bem em alguns navegadores. E se pretendemos que todos possam abrir a página, com qualquer navegador, é necessário usar outro tipo de atributo. Por isso, é comum o uso do atributo <code>&lt;source&gt;</code> na tag <code>&lt;video&gt;</code>.

O elemento <code>&lt;source&gt;</code> pode ser usado múltiplas vezes e permite definir um formato de vídeo para cada navegador, fazendo com que você tenha um alcance maior.

## video
[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<video width="426" height="240" controls>
  <source src="video.mp4" type="video/mp4">
  <source src="video.webm" type="video/webm">
  <source src="video.ogg" type="video/ogg">
</video>
```

## audio
[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<audio controls>
 <source src="audio.mp3" type="audio/mpeg">
 <source src="audio.ogg" type="audio/ogg">
 <source src="audio.wav" type="audio/wav">
</audio>
```

Existem diversos <b>codecs</b>, possíveis e você precisará exportar pelo menos duas versões para ter um alcance maior.

> **Obs**: Codecs são programas utilizados para codificar e decodificar arquivos de mídia. Eles compactam o formato original, favorecendo o armazenamento, e descompactam na hora da reprodução, transformando novamente em imagem ou áudio.

Todos os exemplos de audio e video citados são importados via documento no diretório. E a dúvida é, como faço para importar um vídeo já hospedado em um site como o YouTube ou o Vimeo? E qual das duas soluções (Via documento ou via server) é a mais vantajosa?

### Importando video
Vamos ver como importar videos do YouTube e do Vimeo, passo a passo!

# 🔲 [HTML5] TAGs de Tabelas
Até o aparecimento do HTML5, as <b>tabelas</b> eram utilizadas como recurso para diagramação de layouts para páginas. Os designers usavam tabelas como uma grade para exibir imagens e textos, e foram amplamente utilizadas, tornando-se a forma predominante de projeto de sites, criando assim um visual rico.

Entretanto, hoje, o uso de tabelas está, de fato, interferindo na construção de sites melhores, mais acessíveis, flexíveis e funcionais, principalmente para as novas mídias, como os celulares, tablets etc.

Essas tabelas ainda continuam existindo no HTML 5 como recurso para exibição de dados tabulares, informações vindas de base de dados. Com a nova versão do HTML, podemos criar sites feitos completamente sem tabelas (tableless), criando assim layouts dinâmicos que aparecem em telas grandes como no computador e se adaptam bem para uma tela pequena do smartphone. Mais pra frente você verá como construir layouts e layouts responsivos com HTML5 e CSS3.

O comando tabela não foi retirado da linguagem, mas ficou restrito o seu uso. Em contrapartida, ainda temos vários sites que utilizam esse recurso, portanto, é importante entendermos como funciona até para poder, se for necessário, dar manutenção nesse tipo de página.

O comando para se inserir uma tabela é `<table>`. Para iniciar uma <b>linha</b>, devemos introduzir a tag `<tr>` e para uma <b>célula</b> `<td>`, que divide a linha da tabela. `<th>` divide a linha da tabela colocando o conteúdo em negrito. Todos esses comandos são encerrados como `</table>`, `</tr>` e `</td>` respectivamente.

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<table>
  <tr>
    <td></td>
    <td></td>
  </tr>
</table>
```

O comando <code>&lt;table&gt;</code> tem uma série de atributos que ajudam na formatação da tabela. Os principais são:
<table>
  <tr>
    <td><code>align=""</code></td>
    <td>alinha a tabela nas três posições: <code>center</code>, <code>left</code>, <code>right</code> e <code>justify</code></td>
  </tr>
  <tr>
    <td><code>bgcolor=""</code></td> 
    <td>determina a cor da tabela</td>
  </tr>
  <tr>
    <td><code>border=""</code></td> 
    <td>determina o tamanho da borda, se for zero não mostra a borda</td>
  </tr>
  <tr>
    <td><code>cellspacing=""</code></td>
    <td>determina o espaçamento entre células</td>
  </tr> 
  <tr>
    <td><code>colspan=""</code></td>
    <td>determina o agrupamento entre duas ou mais colunas da tabela (sentido para os lados)</td>
  </tr>
  <tr>
    <td><code>rowspan=""</code></td>
    <td>determina o agrupamento entre duas ou mais linhas da tabela. (sentido para baixo e cima)</td>
  </tr>
  <tr>
    <td><code>cellpadding=""</code></td>
    <td>determina o espaçamento entre o texto e a borda da célula</td>
  </tr>
</table>

`<caption>` exibe um texto centralizado em relação à tabela, como se fosse uma legenda.

### Atributo Rules
Para escolher as linhas internas que serão mostradas dentro da tabela, usamos o atributo <code>RULES</code>, dentro da tag . Os complementos desse atributo são:

<table>
  <tr>
    <td><code>none</code></td>
    <td>nenhuma linha inteira.</td>
  </tr>
  <tr>
    <td><code>all</code></td>
    <td>para mostrar todas as linhas entre cada coluna e linha na tabela (default)</td>
  </tr>
  <tr>
    <td><code>rows</code></td>
    <td>para as linhas horizontais entre cada linha da tabela.</td>
  </tr>
  <tr>
    <td><code>cols</code></td>
    <td>para as linhas verticais entre cada coluna da tabela.</td>
  </tr>
  <tr>
    <td><code>groups</code></td>
    <td>para linhas entre grupos de colunas e seções horizontais, definidas por tags especiais como <code>&lt;colgroup&gt;</code> e <code>&lt;thead&gt;</code></td>
  </tr>  
</table>

Veja alguns exemplos:

```html
<table border rules="all"6>
```

<pre><code>&lt;table border rules="none"6&gt;</code></pre>
<pre><code>&lt;table border rules="cols"6&gt;</code></pre>
<pre><code>&lt;table border rules="groups"6&gt;</code></pre>
<pre><code>&lt;table border rules="rows"6&gt;</code></pre>

# 🆗 TAGs de Formulários
A parte de formulários em HTML é muito importante para o preenchimento de dados que os usuários inserem na página HTML. O recolhimento desses dados é feita pelo back-end com uma linguagem de programação back-end (PHP, JavaScript, Python, Java etc.) que armazena e consulta esses dados em um banco de dados (MySQL, PostgreSQL, MongoDB, OracleDB etc.). Vejamos as tags de formulários:

**Formulário de Login (boilerplate)**:

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#)

```html
<html>
  <body>
     <h2>Login</h2>
     <form>
	Login:<br>
	<input type="email" name="email"><br>
	Senha:<br>
	<input type="password" name="senha"><br>
	<input type="submit" value="Logar">
     </form>
  </body>
</html>
```

Através do atributo `type` podemos definir o tipo do nosso `input` usado, o atributo `name=''` podemos processar os dados enviados através de uma linguagem de programação. 

**Formulário de Login (boilerplate) - Com PHP**:

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#) [![PHP](https://img.shields.io/badge/-processa.php-000000?style=social&logo=PHP&logoColor=indigo)](#) 

```html
<html>
  <body>
     <h2>Login</h2>
     <form action="processa.php">
	Login:<br>
	<input type="email" name="email" required><br>
	Senha:<br>
	<input type="password" name="senha" required><br>
	<input type="submit" value="Logar">
     </form>
  </body>
</html>
```

**Formulário de Cadastro (boilerplate)**:

[![HTML5](https://img.shields.io/badge/-index.html-000000?style=social&logo=HTML5&logoColor=orangered)](#) [![PHP](https://img.shields.io/badge/-processa.php-000000?style=social&logo=PHP&logoColor=indigo)](#) 

```html
<html>
  <head>
    <title>Cadastro</title>
  </head>
  <body>
     <h2>Cadastre-se</h2>
       <form action="processa.php">
	  Nome Completo:<br>
	  <input type="text" name="nome" required><br>
	  <!-- <label for="email">Email:</label> -->
      Email:<br>
	  <input type="email" name="email" required><br>
	  Senha:<br>
	  <input type="password" name="password" required><br>
	  Repita a senha:<br>
	  <input type="password" name="password" required><br>
	  	
	  Sexo:<br>
	  <input type="radio" name="sexo" value="masculino"> Masculino<br>
	  <input type="radio" name="sexo" value="feminino"> Feminino<br>
	  
	  Interesses:<br>
	  <input type="checkbox" name="interesse" value="futebol"> Futebol<br>
	  <input type="checkbox" name="interesse" value="video-games"> Video-games<br>
	  <input type="checkbox" name="interesse" value="academia"> Academia<br>
	  
	  Estado<br>
	  <select name="estado">
	    <option value="RJ">RJ</option>
	    <option value="SP">SP</option>
	    <option value="MG">MG</option>
	    <option value="ES">ES</option>
	  </select><br>
	
	  Comente!<br>
	  <textarea name="comentario"></textarea><br>

	  <input type="submit" value="Cadastrar">
       </form>
   </body>
</html>
```

Só vamos poder conseguir fazer o `input` entre radios se o `name` for o mesmo, dessa forma conseguimos agrupar essas informações e apenas uma dela será marcada.

Com `checkbox` podemos escolher mais de uma opção para marcar.

Com 

Podemos definir os tipos de `<input>` e seus atributos:

- `button`
- `password`
- `text`

<img src="https://davidwalsh.name/demo/html5-buttons.png" height="77" align="right">

Os elementos `<a>`, `<input>` e `<button>` são todos usados para criar botões em uma página HTML, mas cada um tem finalidades ligeiramente diferentes e é usado em diferentes contextos.

`<a>` o âncora é usado para criar links em HTML. Ele é usado principalmente para navegar entre diferentes páginas da web ou ancorar-se em diferentes seções de uma página. Quando um usuário clica em um elemento `<a>`, ele é direcionado para o URL especificado no atributo `href`. Os elementos `<a>` geralmente são estilizados com CSS para se parecerem com botões, mas eles têm comportamento de link padrão.

```html
<a href="pagina.html">Link</a>
```

`<input>` é usado para criar elementos de entrada em um formulário HTML. Embora seja frequentemente usado para criar campos de entrada de texto, também pode ser usado para criar botões. O tipo de botão é especificado pelo atributo `type`. Alguns valores comuns para o atributo `type` são `"button"`, `"submit"` e `"reset"`. Os botões `<input>` são úteis quando você precisa enviar dados de um formulário para um servidor ou executar ações específicas quando um botão é clicado.

```html
<input type="button" value="Clique Aqui">
```

`<button>` é usado para criar botões em HTML. Ele pode conter texto, elementos de imagem ou outros elementos HTML. Assim como os botões `<input>`, os botões `<button>` podem ter um tipo específico especificado pelo atributo `type`, como `"button"`, `"submit"` ou `"reset"`. Os botões `<button>` oferecem mais flexibilidade em termos de conteúdo e comportamento do que os botões `<input>`, especialmente quando se trata de estilização e manipulação de eventos usando JavaScript.

```html
<button type="button">Clique Aqui</button>
```

Em resumo, se você está criando um botão para navegação, use `<a>`. Se está criando um botão para enviar dados de um formulário, use `<input type="submit">` ou `<button type="submit">`. Se está criando um botão para executar uma ação específica na página (como mostrar ou ocultar conteúdo), use `<button type="button">`.

# 📰 [HTML5] HTML Semântico
<img src="https://www.w3schools.com/html/img_sem_elements.gif" align="right" height="177"/>

O <b>HTML Semântico</b> serve para organizar e estruturar os elementos do documento em partes específicas para não correrem soltos pelo body de maneira desorganizado e ilegível.

Até a versão 4 do HTML as divs eram as principais semânticas de estruturamento da página, com a chegada do HTML5 surgiram novas TAGs com funções das divs que eram criadas para estruturar os elementos contidos no documento, o que facilitou muito no estruturamento da página. Nota-se que dá pra comparar a estrutura de uma página web com  layout de uma <b>folha de jornal</b>, pois ambas contém cabeçalhos, rodapés, artigos e seções.

- O elemento <code>&lt;section&gt;</code> (seção) representa uma seção genérica dentro de um documento. Esse elemento pode conter um agrupamento de textos com vários capítulos, seções numeradas etc. No exemplo a seguir, é apresentado um artigo contendo um assunto principal e, dentro desse assunto, várias seções com assuntos distintos.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105736626-c63f8100-5f13-11eb-81b8-f6c3e341ea4b.jpg)

- O elemento <code>&lt;header&gt;</code> (cabeçalho) utilizado também para delimitar o título da seção, trabalha em conjunto com os elementos anteriores, no entanto, não é obrigatório.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105736972-28988180-5f14-11eb-83c6-bbceb25bf757.jpg)

- <code>&lt;nav&gt;</code> (navegação) este elemento é a seção onde ficam as informações de de página. Geralmente nesta seção são colocadas as ligações (links internos) para a própria página ou ligações externas para outras páginas de sites externos.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105737577-defc6680-5f14-11eb-8363-9b10b09089a6.jpg)

- <code>&lt;article&gt;</code> (artigo) este elemento é um artigo independente dentro de um texto, este elemento pode estar ou não dentro de um elemento <code>&lt;section&gt;</code>. Imagine um jornal com as seções de esportes, fofocas, etc. Dentro de cada seção existem vários artigos sobre textos específicos, por exemplo, na seção de esportes pode ter um artigo falando sobre o time A, outro sobre time B e o outro sobre o time C. Um artigo pode conter um elemento <code>&lt;header&gt;</code> que é o título e um elemento <code>&lt;footer&gt;</code> que é o rodapé do elemento.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105737941-461a1b00-5f15-11eb-8528-d9bf452796ab.jpg)

- <code>&lt;footer&gt;</code> (rodapé) este elemento é um que contém basicamente as informações sobre o conteúdo da seção, como, por exemplo, o autor, links relacionados etc.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105738329-add06600-5f15-11eb-8cac-403ab42f3e3a.jpg)

- <code>&lt;aside&gt;</code> (de lado) neste elemento estão contidas as informações que não estão relacionadas diretamente com o texto. Por exemplo: comerciais pagos, links promocionais etc.

![Sem Título-1](https://user-images.githubusercontent.com/61624336/105738607-f720b580-5f15-11eb-9440-76725a31f908.jpg)

### Estilo incorporado ou interno
Caracteriza-se por escrever o código CSS, utilizando o comando <strong>&lt;style&gt;</strong> do HTML. Esse método é superior ao anterior, pois <b>todas as regras CSS</b> estão localizadas no início do código HTML5. No entanto, essas regras só poderão ser utilizadas dentro deste documento, impedindo o compartilhamento e a reutilização das regras.

Exemplo de utilização:

```html
 <head>
  <style>
   * {margin: 0; padding: 0; box-sizing: border-box;}
   body {width: 100%; height: 100vh;}
  </style>
 </head>
```

### Estilo externo
As regras foram escritas em um arquivo com extensão <b>.css</b> e podem ser carregadas ao documento HTML5 de duas formas:

#### Utilizando o elemento &lt;link&gt; no HTML
```html
<head>
  <link rel="stylesheet" href="default.css">
  <link rel="stylesheet" href="green.css" title="Green styles">
  <link rel="alternate stylesheet" href="contrast.css" title="High contrast">
  <link rel="alternate stylesheet" href="big.css" title="Big fonts">
  <link rel="alternate stylesheet" href="wide.css" title="Wide screen">
</head>
```

#### Utilização do elemento `@import` no CSS
Permite <b>importar</b> regras de estilo dentro de outras regras de estilo. Esse método permite aplicar regras comuns a todos os documentos HTML.

**Exemplo de utilização**:

Dentro de um documento `.css` podemos aplicar nas primeiras linhas, a chamada de arquivos externos, para utilizar comandos já existentes.

```css
@import "mystyle.css";
@import url("mystyle.css");
@import url("fineprint.css") print; /* mídia específica para impressão */
@import url("bluish.css") projection, tv; /* mídia específica grandes mídias*/
@import url("narrow.css") handheld and (max-width: 400px); /* mídia específica mídias portáteis*/
```

## Conceito de Módulos
O CSS nível 3 implementou o conceito de módulos, em que cada módulo é desenvolvido de forma independente, seguindo um cronograma próprio. A principal vantagem é independência na construção das novas funcionalidades.

## Seletores e Declarações
Após a criação do HTML a necessidade de formatar as páginas ficou evidente, assim, em 1996, foi criada a linguagem de estilo que conhecemos por <b>CSS</b>.

A sintaxe é bem simples e pode ser explicada com a frase "você cria regras de estilo para elementos ou grupos de elementos".

Vamos usar um elemento HTML que vimos anteriormente, a âncora , para exemplificar.

Uma regra CSS é representada por um <b>seletor</b> ou um <b>grupo de seletores</b>, no nosso caso é o <b>a</b>, então dentro de um par de chaves adicionamos as <strong>declarações</strong>, no exemplo abaixo estamos alterando cor e tamanho da fonte desse título, as <b>declarações</b> são formadas por uma propriedade e um valor.</p>

# Tipos de Seletores, Declarações, Propriedades e Valores
Uma regra CSS é representada por:
<ul>
<li><strong>Propriedade:</strong> Determina a modificação a ser feita.</li>
<li><strong>Seletor:</strong> É o alvo da regra (nome do comando) CSS.</li>
<li><strong>Valor:</strong> A alteração.</li>
<li><strong>Declaração:</strong> É o conjunto de propriedades e valores.</li>
</ul>
<p>Exemplo:</p>

```css
 a { 
    color: #000;
   }
```

<ul>
  <li>a = seletor</li>
  <li>color = propriedade</li>
  <li>#000 = valor</li>
  <li>{color:#000;} = declaração</li>
</ul>

## Seleção de elementos
<p>No CSS, a seleção de elementos pode variar de uma forma simplificada até padrões contextuais ricos.</p>

## Tipos de seleção
<p>Os tipos de seleção são muito importantes, pois a ordem deles alteram no resultado do processamento da página.</p>

### Agrupamento
<p>O CSS permite agrupar declarações repetidas.

Exemplo:</p>
<pre>
h1 { font-family: sans-serif }
h2 { font-family: sans-serif }
h3 { font-family: sans-serif }
</pre>

<p>É equivalente a:</p>
<pre>
h1, h2, h3 {
font-family: sans-serif
}
</pre>
<blockquote>OBS: Todos os h1, todos os h2 e todos os h3</blockquote>

### Seletores descendentes
Um elemento pode estar contido dentro de outro elemento.

Exemplo:
&lt;H1&gt;Este texto é &lt;EM&gt;muito&lt;/EM&gt; importante&lt;/H1&gt;</p>
<pre>
h1 { color: red } /* indica que todos os elementos h1 possuem a cor vermelha */
em { color: red } /* indica que todos os elementos em possuem a cor vermelha */
h1 em { color: blue } /* indica que os elementos em contidos em um elemento h1 possuem a cor azul */
</pre>

### Seletores filhos
Um elemento filho é caraterizado quando os elementos são separados por “>".
<pre>div ol &gt; li p {color: green }</pre>

<p>Este exemplo, todos os elementos <strong>p</strong> serão de cor verde quando estiverem dentro de um elemento item &lt;li&gt;, filho de uma lista &lt;ol&gt; dentro de uma &lt;div&gt;.</p>

### Seletores por prioridade
<p>Um elemento por prioridade é caracterizado quando os elementos são separados por "+". Ou seja, o primeiro parágrafo que vem depois da div.</p>
<pre>
 div + p {
   color: red;
 }
</pre>

### Seletores por atributos
<p>Especifica regras para os elementos que possuem determinado atributo.

Exemplo:</p>
<pre>span[hello="Cleveland"][goodbye="Columbus"] { color: blue; }</pre>

<p>A regra será aplicada a todos os elementos span que possuem o atributo hello="Cleveland" e o atributo goodbye="Columbus".</p>

### Seletores por classes
<p>Uma classe permite atribuir um conjunto de regras a um determinado elemento. É determinado por asterisco ponto (*.) ou simplesmente ponto (.).

Exemplo:</p>
<pre>
.pastoral { color: green } /* todos os elementos com a classe~=pastoral */
/*ou*/
*.pastoral { color: green } /* todos os elementos com a classe~=pastoral */
</pre>

### Seletores por ID
<p>O atributo ID permite identificar um elemento único no documento HTML. Para selecionar este elemento basta utilizar o caracter “#” seguindo pelo nome do elemento.

Exemplo:</p>
<pre>
h1#titulo1 { text-align: center } /* aplica a regra ao elemento h1 com o id=titulo */
*.pastoral { color: green } /* todos os elementos com a classe~=pastoral */
</pre>

## ID x Class
<p>No exemplo anterior criamos uma regra que altera um elemento HTML diretamente, mas isso significa que todos os elementos <a> ficarão com aquela aparência, e normalmente temos sites mais complexos que precisam de várias regras diferentes para elementos iguais.

Para ficar mais tangível vamos relembrar um pouco o site que começamos a fazer no módulo passado, ele tinha vários elementos header, mas não vamos querer que o header principal tenha a mesma formatação que o header de uma postagem, é aí que entram os IDs e Classes.

O seletor que vimos no primeiro exemplo é um seletor de tipo, pois ele representa um elemento HTML, e com IDs e Classes podemos representar qualquer tipo de elemento mas há algumas diferenças entre eles:

<strong>ID</strong>: é representado pelo símbolo # (hash) seguido de um nome para esse ID. Só pode ser utilizado uma única vez!
<pre><code>#id{
  }</code></pre>

<strong>Classe</strong>: a classe é representada de forma parecida do ID, mas é precedida por um ponto em vez do hash. Pode ser utilizado mais de uma vez!
<pre><code>.class{
  }</code></pre>

E a diferença mais importante entre eles é a forma como devem ser usados: o ID só pode ser usado uma vez em uma página HTML enquanto a classe não tem restrições.</p>


## Pseudo-Classes
<p>E há um último detalhe nesse exemplo: a <b>pseudo-classe</b>. Elementos HTML sofrem alterações causadas pela interação do usuário, como mover o mouse por cima ou clicar nesse elemento. As pseudo-classes são bem parecidas com os eventos do JavaScript, porém não possuem o mesmo poder de manipular os elementos.
  
### Syntax
<pre>
 seletor:pseudo-class { 
    property: value;
   }
</pre>

O <code>a:hover</code> do exemplo significa que a âncora também terá essa aparência quando o usuário passar o mouse por cima de um hyperlink.</p>

### Tipos de Pseudo-Classes
<table>
  <tr>
    <td><b>Pseudo-classe</b></td>
    <td><b>Definição</b></td>
  </tr>
  <tr>
    <td><code>:hover</code></td>
    <td>Altera o elemento por passar o mouse por cima.</td>
  </tr>  
  <tr>
    <td><code>:active</code></td>
    <td>Altera o elemento por clica-lo.</td>
  </tr>
   <tr>
    <td><code>:link</code></td>
    <td>Altera todos os links não visitados.</td>
  </tr>
   <tr>
    <td><code>:visited</code></td>
    <td>Altera todos os links visitados.</td>
  </tr>
  <tr>
    <td><code>:focus</code></td>
    <td>Altera o elemento <code>&lt;input&gt;</code> que tem o foco.</td>
  </tr>
  <tr>
    <td><code>:checked</code></td>
    <td>Altera todos os elementos <code>&lt;input&gt;</code> marcados.</td>
  </tr>
  <tr>
    <td><code>:disable</code></td>
    <td>Altera todos os elementos <code>&lt;input&gt;</code> desativados.</td>
  </tr>
   <tr>
    <td><code>:enabled</code></td>
    <td>Altera todos os elementos <code>&lt;input&gt;</code> habilitados.</td>
  </tr>
  <tr>
    <td><code>:empty</code></td>
    <td>Altera todos os elementos <code>&lt;p&gt;</code> que não têm filhos.</td>
  </tr>
  <tr>
    <td><code>:first-child</code></td>
    <td>Altera cada elemento <code>&lt;input&gt;</code> habilitado.</td>
  </tr>
  <tr>
    <td><code>:enabled</code></td>
    <td>Altera cada elemento <code>&lt;input&gt;</code> habilitado.</td>
  </tr>
  <tr>
    <td><code>:first-child</code></td>
    <td>Altera cada elemento <code>&lt;p&gt;</code> que é primeiro filho do elemento pai.</td>
  </tr>
  <tr>
    <td><code>:first-of-type</code></td>
    <td>Altera cada elemento <code>&lt;p&gt;</code> que é o primeiro elemento <code>&lt;p&gt;</code> de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:in-range</code></td>
    <td>Altera elementos <code>&lt;input&gt;</code> com um valor dentro de um intervalo especificado.</td>
  </tr>
  <tr>
    <td><code>:invalid</code></td>
    <td>Altera todos os elementos <code>&lt;input&gt;</code> com um valor inválido.</td>
  </tr>
  <tr>
    <td><code>:lang(language)</code></td>
    <td>Altera cada elemento <code>&lt;p&gt;</code> com um valor de atributo lang começando com "<code>it</code>".</td>
  </tr>
  <tr>
    <td><code>:last-child</code></td>
    <td>Altera todos os elementos <code>&lt;p&gt;</code> que são os últimos filhos de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:last-of-type</code></td>
    <td>Altera todos os elementos <code>&lt;p&gt;</code> que é o último elemento <code>&lt;p&gt;</code> de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:link</code></td>
    <td>Altera todos os links não visitados.</td>
  </tr>
  <tr>
    <td><code>:not(selector)</code></td>
    <td>Altera cada elemento que não é o elemento <code>&lt;p&gt;</code>.</td>
  </tr>
  <tr>
    <td><code>:nth-child(n)</code></td>
    <td>Altera cada elemento &lt;p&gt; que é ordenado do seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:nth-last-child(n)</code></td>
    <td>Altera cada elemento &lt;p&gt; que é ordenado do seu elemento pai, contando a partir do último filho.</td>
  </tr>
  <tr>
    <td><code>:nth-last-of-type(n)</code></td>
    <td>Altera cada elemento &lt;p&gt; que é o segundo elemento &lt;p&gt; de seu pai, contando a partir do último filho.</td>
  </tr>
  <tr>
    <td><code>:nth-of-type(n)</code></td>
    <td>Altera cada elemento &lt;p&gt; que é o segundo elemento &lt;p&gt; de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:only-of-type</code></td>
    <td>Altera o elemento &lt;p&gt; que é o único elemento &lt;p&gt; de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:only-child</code></td>
    <td>Altera cada elemento &lt;p&gt; que é o único filho de seu elemento pai.</td>
  </tr>
  <tr>
    <td><code>:optional</code></td>
    <td>Altera os elementos &lt;input&gt; sem atributo "obrigatório".</td>
  </tr>
  <tr>
    <td><code>:out-of-range</code></td>
    <td>Altera os elementos &lt;input&gt; com um atributo "somente leitura" especificado.</td>
  </tr>
  <tr>
    <td><code>:read-write</code></td>
    <td>Altera os elementos &lt;input&gt; sem o atributo "somente escrita" especificado.</td>
  </tr>
  <tr>
    <td><code>:required</code></td>
    <td>Altera os elementos &lt;input&gt; com um atributo "obrigatório" especificado.</td>
  </tr>
  <tr>
    <td><code>:root</code></td>
    <td>Altera o elemento raiz do documento.</td>
  </tr>
  <tr>
    <td><code>:target</code></td>
    <td>Altera o elemento ativo atual (clicado em um URL contendo o nome da âncora).</td>
  </tr>
  <tr>
    <td><code>:valid</code></td>
    <td>Altera todos os elementos <code>&lt;input&gt;</code> com um valor válido.</td>
  </tr>
</table>

### Aplicações:
![img11](https://user-images.githubusercontent.com/61624336/112897063-8a609d80-90b5-11eb-84a6-977c76e21cf2.jpg)
![img12](https://user-images.githubusercontent.com/61624336/112897068-8b91ca80-90b5-11eb-9683-751146a318d6.jpg)
![img13](https://user-images.githubusercontent.com/61624336/112897072-8d5b8e00-90b5-11eb-9961-9fa0e8dc799a.jpg)
![img14](https://user-images.githubusercontent.com/61624336/112897086-90567e80-90b5-11eb-8d76-541b90de78e5.jpg)
![img15](https://user-images.githubusercontent.com/61624336/112897092-92204200-90b5-11eb-9319-883412d62ee9.jpg)
![img16](https://user-images.githubusercontent.com/61624336/112897098-93ea0580-90b5-11eb-8f98-01cce0f8eb4f.jpg)
![img17](https://user-images.githubusercontent.com/61624336/112897107-964c5f80-90b5-11eb-97f4-eec02f0f0bcd.jpg)


### Exemplo 1:
<pre>
p:first-child {
  color: blue;
}
</pre>
<pre>
p i:first-child {
  color: blue;
}
</pre>
<pre>
p:first-child i {
  color: blue;
}
</pre>

## [CSS3] Pseudo-Elementos
Os <strong>pseudo-elementos</strong> são usados para estilizar partes específicas de um elemento. Como por exemplo: a primeira letra ou linha de um elemento ou talvez inserir um conteúdo antes ou depois do conteúdo de um elemento.

Sintaxe:

<pre>
selector::pseudo-element {
  property: value;
}
</pre>

Tipos de Pseudo-Elementos:

<table>
  <tr>
    <td><b>Pseudo-elemento</b></td>
    <td><b>Definição</b></td>
  </tr>
  <tr>
    <td><code>::after</code></td>
    <td>Insire algo após o conteúdo de cada elemento.</td>
  </tr>
  <tr>
    <td><code>::before</code></td>
    <td>Insire algo antes do conteúdo de cada elemento.</td>
  </tr>
  <tr>
    <td><code>::first-letter</code></td>
    <td>Seleciona a primeira letra de cada elemento.</td>
  </tr>
   <tr>
    <td><code>::first-line</code></td>
    <td>Seleciona a primeira linha de cada elemento.</td>
  </tr>
  <tr>
    <td><code>::selection</code></td>
    <td>Seleciona a parte de um elemento que é selecionado por um usuário (A mancha/ marca da seleção nos contents).</td>
  </tr> 
</table>

Exemplo 1:

```html
<!DOCTYPE html>
<html>
<head>
<style>
p::after { 
  content: " - Remember this";
}
</style>
</head>
<body>
   <p>My name is Donald</p>
   <p>I live in Ducksburg</p>
</body>
</html>
```

```css
::selection {
  color: red;
  background: yellow;
}
```

## [CSS3] Variáveis no CSS
As <strong>variáveis no CSS</strong> servem para definir um padrão para a maioria dos elementos HTML5, poupando assim muitas linhas de código na folha de estilo. É muito comum usar as variáveis para fazer uma paleta de cores para uma página web mais complexa.

Sintaxe:

```css
:root{
    --nome da variável: #141414;
}

.bg{
  background-color: var(--nome da variável);
}
```

Basta utilizarmos a pseudo-classe <code>:root</code> e inserirmos os seletores <code>--nome da variável</code> para podermos atribuir os valores. Para chama-la é simples, basta somente utilizar o seletor desejável e o valor <code>var(--nome da variável)</code>.

## Border (A Borda do elemento)

<p>No entanto, a <strong>border</strong> é diferente da <strong>margin</strong> e do <strong>padding</strong>: 'border-top-width', 'border-right-width', 'border-bottom-width', e 'border-left-width‘.
&nbsp;
Exemplo de utilização:
&nbsp;
<pre>
h1 { border-width: thin } /* thin thin thin thin */
h1 { border-width: thin thick } /* thin thick thin thick */
h1 { border-width: thin thick medium } /* thin thick medium thick */</p>
</pre>

<p><strong>Estilos da borda:</strong> 'border-top-style', 'border-right-style', 'border-bottom-style', 'border-left-style', and 'border-style‘, 'border'.

Exemplo de utilização:</p>
<pre>#xy34 { border-style: solid dotted }</pre>

### Tipos de Borda
![Tipos de bordas](https://user-images.githubusercontent.com/61624336/108574726-eb4ac800-72f6-11eb-9906-b8f8e1ca5d5c.png)

### 🔺 Como fazer Bordas de Triângulos 🔻
![como fazer triângulos com bordas](https://user-images.githubusercontent.com/61624336/107122854-0ccc9e00-6879-11eb-9ec0-9f604afc59c8.gif)

## Content (O Conteúdo do Elemento)

# Foreground e Background
<p>O CSS permite alterar as cores de primeiro plano (<em>foreground</em>) e plano de fundo (<em>background</em>) dos elementos. O W3C recomenda que a regra background seja utilizado no elemento <em>body</em>.

Sempre que pensamos em criar um layout, devemos configurar a cor de fundo (background) para que a página que será aberta apresente a mesma cor em qualquer navegador. Caso não seja definida, corre o risco do usuário ter modificado a cor padrão da máquina e como não está configurada no HTML, a página vai mostrar a cor padrão, alterando, assim, o que foi definido no layout.

O mesmo caso acontece com a cor da fonte (foreground) que deve ser definida da mesma forma. O W3C recomenda sempre que o body contenha essas definições para que todas as páginas apresentem uma formatação.</p>

## Background
<p>Para alterar a cor de fundo de uma página HTML, usando atributos do CSS, devemos usar conforme o exemplo:</p>

### Modificando a cor do plano de fundo (background):
<p>Dentro da Tag &lt;body&gt;, alteramos o atributo <b>background-color</b> com a cor desejada.</p>

<pre>
body {
  background-color: yellow;
}
</pre>

<p>Definindo, assim, uma cor amarela para o fundo da página.</p>

A definição do background pode ser feita também com a utilização de imagens como fundo, para isso devemos pensar da mesma forma e utilizar os comandos específicos para imagens de fundo.

<strong>Exemplo de elemento do plano de fundo (background)</strong>:

```css
body{
  background-image: url("paper.gif");
  background-color: #cccccc;
}
```

Definindo assim uma cor e uma imagem repitida para o fundo da página.

Quando definimos uma imagem de fundo, o atributo url pode conter um endereço completo de onde se encontra a imagem, podendo estar até em outro domínio.

```css
body{
  background-image: url("//www.exodocientifica.com.br/wp-content/uploads/2014/08/fundo-site.jpg");
  backgroud-color: #cccccc;
}
```

A definição da imagem de fundo pode ser configurada com alguns atributos especiais como:

```css
body{
  background-image: url("paper.gif");
  background-repeat: repeat-y;
}
```

Essa regra repete a imagem no eixo especificado. Se usar `background-repeat: no-repeat;` a imagem não será repetida.

Podemos fixar a imagem em um determinado local da tela.

```css
body{
   background-image: url('smiley.gif');
   background-repeat: no-repeat;
   background-attachment: fixed;
   background-position: center;
}
```

`attachment` fixa a imagem e `position` determina a sua localização. O resultado é a imagem totalmente centralizada na página.

## Gradientes 
É muito usado para mesclar duas ou mais cores no background, o que deixa a interface mais moderna e atraente ao usuário.

### Linear-gradient

# [CSS] Trabalhando com textos
<p>Uma das novidades do CSS 3 é o uso de fontes da própria internet, podemos agora usar fontes livres que são disponíveis na internet, sem que tenha a necessidade de estar instalada na máquina do usuário.

O site do Google disponibiliza uma quantidade grande de fontes livres. No endereço https://fonts.google.com/ encontramos as fontes e a forma de como colocar no nosso código.

Para colocar no código da página, escolhemos a fonte e depois copiamos o código que vai ser colocado no <code>&lt;head&gt;</code> da página.</p>
<pre>
 &lt;head&gt;
  &lt;link href="https://fonts.googleapis.com/css?family=Abhaya+Libre|Bungee+Inline" rel="stylesheet"&gt;
 &lt;/head&gt;
</pre>

<p>Depois no CSS colocamos o comando para o seu uso.</p>

<pre>
font-family:'Bungee Inline', cursive;
font-family:'Abhaya Libre', serif;
</pre>

<p>O comando <code>font-family</code> é o que determina a fonte que será usada.

No CSS, temos ainda uma série de definições de comandos para fonte como:</p>
<table>
  <tr>
     <td><strong>Propriedade</strong></td>
     <td><strong>Função da propriedade</strong></td>
  </tr>
  <tr>
    <td><code>font-family</code></td>
    <td>determina a fonte que será usada</td>
  </tr>
  <tr>
     <td><code>font-size</code></td>
     <td>Define o tamanho da fonte</td>
  </tr>
  <tr>
     <td><code>font-style</code></td>
     <td>Define o estilo da fonte</td>
  </tr>
  <tr>
     <td><code>font-variant</code></td>
     <td>Define a caixa da fonte</td>
  </tr>
  <tr>
     <td><code>font-weight</code></td>
     <td>Define o corpo da fonte</td>
  </tr>
  <tr>
     <td><code>letter-spacing</code></td>
     <td>Define o espaçamento das letras da fonte</td>
  </tr>
  <tr>
     <td><code>text-transform</code></td>
     <td>Alterna o texto entre maiúsculas e minúsculas</td>
  </tr>
  <tr>
     <td><code>text-decoration</code></td>
     <td>Adiciona destaque a um texto (linhas)</td>
  </tr>
</table>

### Exemplo:
<pre>
 h1{
   font-size: 250%;
   font-style: normal;
   font-variant: small-caps;
 }
 &nbsp;
 h2{
   font-size: 100px;
   font-style: italic;
   font-weight: normal;
 }
 &nbsp;
 h3{
   font-size: 2cm;
   font-style: italic;
   font-weight: bold;
 }
 &nbsp;
 h4{
   font-size: 10rem;
   font-style: italic;
   font-weight: 900;
 }
 &nbsp;
 p{
   font-size: 100pc;
   font-style: oblique;
   letter-spacing: 2px;
 }
</pre>

## Estilizando listas
<table>
  <tr>
    <td>Propriedade</td>
    <td>Função da propriedade</td>
  </tr>
  <tr>
    <td><code>list-style-type</code></td>
    <td>Altera o marcador da lista</td>
  </tr>
</table>

### Exemplo:
<pre>
ul {
  list-style-type: square;
}

ol {
  list-style-type: upper-roman;
}

ul {
  list-style-type: "\1F44D"; /*Código do Emoji de um joinha*/
}
</pre>

### Exemplo: Estilizando a lista com imagem
<pre>
ul {
  list-style-type: url('rocket.png');
}
</pre>

# [CSS] Positions and dimensions
<p>As propriedades CSS <strong>position</strong> e <strong>float</strong> determinam como um box será posicionado no modelo visual de formatação de um documento. Esse box pode conter imagens, textos, listas, entre outros e, com isso, podemos montar layouts com a mesma qualidade de um programa gráfico feito para este fim.

As recomendações do W3C para as CSS 3 preveem a existência de três esquemas de posicionamento:</p>

### 1. Esquema Normal
<p>Esse esquema segue o fluxo normal em que os elementos são exibidos um após o outro e de cima para baixo. Ele é simples e atualmente a maioria das páginas usam essa forma.

Um exemplo usando textos em sequência:</p>
<pre>
em{
  padding: 2px;
  margin: 2em;
  border-width: medium;
  border-style: dashed;
  line-height: 2.4em;
}
</pre>

### 2. Esquema Float (Flutuante)
<p>Definido pela regra <b>float</b> de posicionamento, juntamente com as regras <strong>left, right, none e inherit (herdado)</strong>.

O box é deslocado para uma nova posição e seu espaço original é preenchido por outro elemento, na medida do possível.

Exemplo de uso: Neste exemplo a imagem está com o float: LEFT o que a coloca ao lado do texto.</p>
<pre>
img {
  float: left;
}
&nbsp;
body, p, img {
      margin: 2em;
}
</pre>

### 4. Esquema Relativo
![EuKdtFOVcAIac3j](https://user-images.githubusercontent.com/61624336/113332439-8de36700-92f7-11eb-9e31-7a356f8d03cf.jpg)

### 3. Esquema Absoluto
<p>Definido pela regra position com valores <b>absolute</b> e <b>fixed</b>. O box é removido do fluxo completamente sem impactar nos elementos posteriores.

No exemplo, seu uso para montar layouts com várias partes:</p>
<pre>
body {
   height: 8.5in;
}
&nbsp;
#header {
     position: fixed;
     width: 100%;
     height: 15%;
     top: 0;
     right: 0;
     bottom: auto;
     left: 0;
     background-color: red;
}
&nbsp;
#sidebar {
     position: fixed;
     width: 10em;
     height: auto;
     top: 15%;
     right: auto;
     bottom: 100px;
     left: 0;
     background-color: blue;
}
&nbsp;
#main {
    position: fixed;
    width: auto;
    height: auto;
    top: 15%;
    right: 0;
    bottom: 100px;
    left: 10em;
    background-color: yellow;
}
&nbsp;
#footer{
     position: fixed;
     width: 100%;
     height: 100px;
     top: auto;
     right: 0;
     bottom: 0;
     left: 0;
     background-color: black;
}
</pre>

# [CSS] Transition e Transform
O <b>CSS3</b> em conjunto com o <b>JavasScript</b> e o <b>HTML5</b> passaram a dar suporte a transformações em tempo real, de objetos HTML.

Podemos modificar posição, rotacionar, aumentar e diminuir, tudo isso dentro de todos os eixos gráficos disponíveis na sua tela.

Vamos começar com um exemplo de como mudar uma div de posição sem precisar chamar novamente a página, isto é, diretamente no navegador.</p>

**Vejamos os códigos**:
[![CodePen](https://img.shields.io/badge/-CodePen-000?style=for-the-badge&logo=CodePen&logoColor=white)](https://codepen.io/isaacalves7/pen/zYKowjP)

```html
<!DOCTYPE html>
<html>
<head>
 <link>
</head>
<body>
  <p>Rotacionar o element DIV</p>
  <div id="div1">Aqui o texto!</div>
  Rotacionar: <br>
  <input type="range" min="-360" max="360" value="7" onchange="rotate(this.value)"/><br>
  transformação: rotacionar(<span id="span1">7deg</span>);
</body>
</html>
```

<pre>
#div1 {
   width: 120px;
   height: 100px;
   background-color: yellow;
   border: 1px solid black;
   transform: rotate(7deg);
   -ms-transform: rotate(7deg); /*IE 9*/
   -webkit-transform: rotate(7deg); /*Opera, Chrome and Safari*/
}
</pre>

<pre>
function rotate(value){
   document.getElementById('div1').style.webkitTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.webkitTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.webkitTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.msTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.MozTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.OTransform="rotate("+value+"deg)";
   document.getElementById('div1').style.tranform="rotate("+value+"deg)";
   document.getElementById('span1').innerHTML=value+"deg";
}
</pre>

<blockquote>Agora veja como ficará a página. Arrastando a barra de rolagem, teremos a modificação da caixa amarela.</blockquote>

### Tipos de transformações possíveis 📘🌱🌳🍃🍂
<table>
  <tr>
    <td>Valor</td>
    <td>Descrição</td>
  </tr>
  <tr>
    <td>none</td>
    <td>Nenhum tipo de transformação.</td>
  </tr>
  <tr>
    <td>matrix(n,n,n,n,n,n)</td>
    <td>Define transformação 2D com seis valores.</td>
  </tr>
  <tr>
    <td>matrix3d(n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n)</td>
    <td>Define transformação 3D com uma matrix de 16 valores.</td>
  </tr>
  <tr>
    <td>translate(x,y)</td>
    <td>Define deslocamento 2D.</td>
  </tr>
    <tr>
    <td>translate3d(x,y,z)</td>
    <td>Define deslocamento 3D.</td>
  </tr>
  <tr>
    <td>translateX(x)</td>
    <td>Deslocamento pelo eixo X.</td>
  </tr>
  <tr>
    <td>translateY(y)</td>
    <td>Deslocamento pelo eixo Y.</td>
  </tr>
  <tr>
    <td>translateZ(z)</td>
    <td>Deslocamento pelo eixo Z.</td>
  </tr>
  <tr>
    <td>scale(x,y)</td>
    <td>Modifica o tamanho em 2D.</td>
  </tr>
  <tr>
    <td>scale3d(x,y,z)</td>
    <td>Modifica o tamanho em 3D.</td>
  </tr>
  <tr>
    <td>scaleX(x)</td>
    <td>Modifica o tamanho pelo eixo X.</td>
  </tr>  
  <tr>
    <td>scaleY(y)</td>
    <td>Modifica o tamanho pelo eixo Y.</td>
  </tr>
  <tr>
    <td>scaleZ(z)</td>
    <td>Modifica o tamanho pelo eixo Z.</td>
  </tr>
  <tr>
    <td>rotate(angle)</td>
    <td>Rotacionar pelo ângulo.</td>
  </tr>
  <tr>
    <td>rotate3d(x,y,z,angle)</td>
    <td>Rotacionar.</td>
  </tr>
  <tr>
    <td>rotateX(angle)</td>
    <td>Rotacionar pelo eixo X.</td>
  </tr>
  <tr>
    <td>rotateY(angle)</td>
    <td>Rotacionar pelo eixo Y.</td>
  </tr>
  <tr>
    <td>rotateZ(angle)</td>
    <td>Rotacionar pelo eixo Z.</td>
  </tr>
  <tr>
    <td>skew(x-angle,y-angle)</td>
    <td>Modifica torcendo o objeto pelo ângulo.</td>
  </tr>
  <tr>
    <td>skewX(angle)</td>
    <td>Modifica torcendo o objeto pelo ângulo.</td>
  </tr>
 <tr>
    <td>skewY(angle)</td>
    <td>Modifica torcendo o objeto pelo ângulo.</td>
  </tr>
  <tr>
    <td>perspective(n)</td>
    <td>Perspectiva.</td>
  </tr>
</table>

### Exemplo de aplicação: Fotos de uma câmera Polaroid
```html
&lt;!DOCTYPE html&gt;
&lt;html&gt;
&lt;head&gt;
 &lt;link&gt;
&lt;/head&gt;
&lt;body&gt;
&lt;div class="polaroid rotate_right"&gt;
  &lt;img src="pulpitrock.jpg" alt="Pulpit rock" width="284" height="213"&gt;
&lt;p class="caption"&gt;O púlpito em Lysefjorden, Noruega.&lt;/p&gt;
&lt;/div&gt;
&nbsp;
&lt;div class="polaroid rotate_left"&gt;
&lt;img src="cinqueterre.jpg" alt="Monterosso al Mare" width="284" height="213"&gt;
&lt;p class="caption"&gt;Monterosso al Mare. Uma das cinco aldeias de Cinque Terre&lt;/p&gt;
&lt;/div&gt;
&lt;/body&gt;
&lt;/html&gt;
```

<pre>
<h4>📘 style.css</h4>
body {
  margin: 30px;
  background-color: #E9E9E9;
}
div.polaroid{
   width: 249px;
   padding: 10px 10px 20px 10px;
   border: 1px solid #BFBFBF;
   background-color: white;
   box-shadow: 10px 10px 5px #aaaaaa;
}
div.rotate_right{
   float: left;
   -ms-transform: rotate(7deg);/*IE 9*/
   -webkit-transform: rotate(7deg);/*Safari*/
   transform: rotate(7deg);
}
div.rotate_left{
    float: left;
    -ms-transform: rotate(-8deg);/*IE 9*/
    -webkit-transform: rotate(-8deg);/*Safari*/
    transform: rotate(-8deg);
}
</pre>

# 📺 [CSS] Displays

## Flexbox Layout
<img src="https://miro.medium.com/max/3200/1*K1TTuVckzyeMdv2qGIT_vA.png" height="177" align="right"/>

## Grid Layout
<img src="https://miro.medium.com/max/840/1*kuzeYL058uQGHPt8_wuoqg.png" height="177" align="right"/>

# 📱 [CSS] Responsive Layout

## Unidades de resolução responsivas
`vh`, `%`, `em`

## Mobile First

## Padrão para tela inteira responsiva (Responsive Landing Page)
```css
section {
   width: 100%; height: 100vh;
}
```

## Viewport 

## Media Queries
<img src="https://user-images.githubusercontent.com/61624336/112909640-3ca16080-90c8-11eb-85a4-d5cc3a6aaa85.gif" align="right" height="177">

Podemos definir **media queries** como a maneira que o navegador define que formatação de página vai apresentar a cada tipo de dispositivo.

Os <strong>media types</strong> são definidos para cada tipo de media recebendo um certo código CSS, fazendo com que o navegador direcione a abertura da página de uma certa forma. O HTML foi gerado para ser portátil, ou seja, lido e interpretado por qualquer tipo de dispositivo. Só que cada dispositivo exibe o HTML de uma maneira, devido a fatores como, por exemplo, as dimensões da tela.

Imagine que visitamos um site em um desktop; ele não terá o mesmo aspecto se visitarmos o mesmo site em um dispositivo móvel. Isso ocorre porque são dispositivos diferentes e formas diferentes de navegação. Por isso, a importância de usar essa nova forma de definição de CSS. Isso facilita a leitura do site em mídias diferentes.

Para que possamos manter nossas páginas sempre adequadas a cada tipo de visualização, utilizamos <b>media types</b> com a seguinte formatação:</p>
<ul>
  <li><strong>all</strong> = para todos os dispositivos.</li>
  <li><strong>braille</strong> = para os dispositivos táteis.</li>
  <li><strong>embossed</strong> = para os dispositivos que imprimem em braille.</li>
  <li><strong>print</strong> = para a impressão em papel.</li>
  <li><strong>projection</strong> = para apresentações como PPS.</li>
  <li><strong>screen</strong> = para monitores ou dispositivos com telas coloridas e resolução adequada.</li>
  <li><strong>speech</strong> = para sintetizadores de voz. O CSS 2 têm uma especificação de CSS chamada <strong>Aural</strong>, onde podemos formatar a voz dos sintetizadores.</li>
  <li><strong>tty</strong> = para dispositivos que possuem uma grade fixa para exibição de caracteres, tais como: Teletypes, Terminais e também dispositivos portáteis com display limitados.</li>
  <li><strong>tv</strong> = para dispositivos como televisores, ou seja, com baixa resolução, quantidade de cores e scroll limitados.</li>
  <li><strong>handheld</strong> = para dispositivos portáteis, geralmente com telas pequenas e banda limitada.</li>
</ul>
<p>Observe, abaixo, um exemplo de utilização:</p>
<pre>&lt;link rel="stylesheet" href="estilo.css" media="screen and (color)"/&gt;</pre>
<b>Onde:</b>
<ul>
  <li><strong>rel</strong> = define o tipo do arquivo.</li>
  <li><strong>href</strong> = define a localização do arquivo.css.</li>
  <li><strong>media</strong> = define o tipo de saída do arquivo.</li>
</ul>

<p>Com esse arquivo definimos que ele será usado quando for acessado pela mídia correspondente. Dessa maneira, o CSS não será aplicado em <strong>dispositivos monocromáticos.</strong></p>

<p>Nas <em>media queries</em> são utilizados três operadores lógicos:</p>

### `not`
<p>Usamos para dispositivos monocromáticos, pois estamos negando o atributo color.</p>
<pre>&lt;link rel="stylesheet" href="estilo.css" media="all and (not color)"/&gt;</pre>

<p>No próximo exemplo, podemos definir a resolução de vídeo que queremos modificar:</p>

<pre>&lt;link rel="stylesheet" href="estilo.css" media="screen and (max-width: 480px)"/&gt;</pre>

<blockquote>As modificações serão feitas em dispositivos de media screen e com resolução máxima de 480px.</blockquote>

### `or
<p>Define a localização do arquivo.css.</p>
<pre>&lt;link rel="stylesheet" href="estilo.css" media="all and (not color)"/&gt;</pre>

### `only`
<p>Define o tipo de saída do arquivo.</p>
</ul>

### A importância do Viewport para layouts responsivos

### Layout multicolunas
<p>Sua principal vantagem é a flexibilidade, pois independe de dispositivo.

Esta especificação permite que o conteúdo da página se adeque de uma coluna para outra e o número de colunas pode variar dependendo do tamanho da janela.

Para facilitar o seu entendimento, vamos direto a um exemplo:

No código CSS definimos em quantas colunas apresentaremos o texto, fazendo distinção de navegador (existem comandos específicos para cada navegador).</p>
<pre>
div {
   -webkit-column-count: 3; /* Chrome, Safari, Opera */
   -moz-column-count: 3; /* Firefox */
    column-count: 3;
    }
&nbsp;
p { 
  margin: 0; padding: 0; 
  }
&nbsp;
img { 
  display: none;
  }
</pre>

<p>No HTML temos um código simples de texto.</p>
<pre>
&lt;html&gt;
&lt;head&gt;&lt;/head&gt;
&lt;body&gt;
&lt;div&gt;
   &lt;p&gt;Lorem Ipsum é simplesmente uma simulação de texto da indústria tipográfica e de impressos, e vem sendo utilizado desde o século XVI, quando um impressor desconhecido pegou uma bandeja de tipos e os embaralhou para fazer um livro de modelos de tipos. Lorem Ipsum sobreviveu não só a cinco séculos, como também ao salto para a editoração eletrônica, permanecendo essencialmente inalterado. Popularizou-se na década de 1960, quando a Letraset lançou decalques contendo passagens de Lorem Ipsum, e mais recentemente quando passou a ser integrado a softwares de editoração eletrônica como Aldus PageMaker.&lt;/p&gt;
&lt;/div&gt;
&lt;/body&gt;
&lt;/html&gt;
</pre>
<blockquote>Se diminuirmos o navegador, o layout irá se ajustar. Podemos ainda dividir as colunas com uma linha. Para isso, utilizaremos o CSS.</blockquote>
<pre>
  div {
  -webkit-column-count: 3; /* Chrome, Safari, Opera */ -moz-column-count: 3; /* Firefox */ column-count: 3;
  /** Define o espaçamento entre as colunas **/ -webkit-column-gap: 30px; /* Chrome, Safari, Opera */ -moz-column-gap: 30px; /* Firefox */ column-gap: 30px;
  /** Define uma linha solida entre as colunas **/
  -webkit-column-rule-style: solid; /* Chrome, Safari, Opera */ -moz-column-rule-style: solid; /* Firefox */ column-rule-style: solid; 
  } 
  p { margin: 0; padding: 0 }
</pre>

### Layout de Box Flexível
<p>É um novo algoritmo para disposição de boxes dentro do HTML. Este modelo permite um controle mais apurado do Box permitindo “dobrar” suas dimensões para preencher espaços não utilizados.

Veja as propriedades a seguir:</p>
<ul>
  <li><strong>display: ;</strong> /*flex, inline-flex*/</li>
  <li><strong>flex-direction: ;</strong> /*row, column, row-reverse, column-reverse*/</li>
  <li><strong>flex-wrap: ;</strong> /*nowrap, wrap, wrap-reverse*/</li>
  <li><strong>flex-flow: ;</strong> /*forma abreviada para declarar flex-direction e flex-wrap*/</li>
</ul>

#### Vamos ao exemplo!
<p>Renderização dos boxes (.box1 e .box2) contidos no div#container renderizados segundo o Box Model CSS 2.1.

Observe agora a estilização padrão da marcação e sua respectiva renderização.</p>
<pre>
&nbsp;
.container {
width: 240px;
height: 240px;
}
&nbsp;
.box-flex {
width: 80px;
height: 80px;
}
&nbsp;
.box-flex p {
color: #fff;
font-weight: bold;
margin: 0 !important;
padding: 0 !important;
}
&nbsp;
.box1 {
background-color: rgba(0, 153, 0, 0.9); /* verde 10% transparente */
}
.box2 {
background-color: rgba(204, 51, 0, 0.9); /* vermelho 10% transparente */
</pre>

<pre>
&lt;div id="container" class="container"&gt;
&nbsp;
  &lt;div class="box-flex box1"&gt;
&lt;p&gt;Box 1&lt;/p&gt;
&lt;/div&gt;
  &lt;div class="box-flex box2"&gt;
&lt;p&gt;Box 2&lt;/p&gt;
</div>
  </div>
</pre>

Agora, iremos criar um identificador container e configurar como queremos colocar as caixas.

### Criar container
```css
#container {
    display: box;
    box-align: stretch;
    box-orient: horizontal;
}
```

### Definir a largura das caixas
```css
.container {
    /*width: 240px;*/
    height: 240px;
}
```

### Tornar o box flexível
```css
.box-flex {
    box-flex: 1;
}
```

### Definir as medias do box
```css
.box-flex {
/* width: 80px; */
height: 80px;
}

.box-flex p {
color: #fff;
font-weight: bold;
margin: 0 !important;
padding: 0 !important;
}

.box1 {
background-color: rgba(0, 153, 0, 0.9); /* verde 10% transparente */
}

.box2 {
background-color: rgba(204, 51, 0, 0.9); /* vermelho 10% transparente */
```

# 👓 Sass
<img src="https://cdn.worldvectorlogo.com/logos/sass-1.svg" height="77" align="right">

Para um desenvolvimento web moderno, o CSS é muitas vezes visto como primitivo e incompleto. Há muitas funcionalidades que nos facilitaria na hora de desenvolver aplicações mais complexas. Um **pré-processador** é um programa que recebe um texto, realiza algumas alterações e nos devolve um novo texto. E isso já nos ajuda com parte do nosso problema! Só conseguimos estilizar nossas páginas com CSS. E se criássemos uma espécie de "CSS com superpoderes", criando novas funcionalidades? Então, nós usaríamos um pré-processador para utilizar esse código e transformar em CSS comum, fazendo com que qualquer navegador possa entender nosso código.

Assim, podemos trabalhar melhor e com mais produtividade, fazendo proveito de funcionalidades que são inexistentes no CSS comum. Há vários pré-processadores, não só para CSS, mas também para JavaScript. Para CSS, os mais famosos são **Sass**, Less e Stylus. 

O HTML5, por si só, não possui pré-processadores, como o CSS tem o Sass ou Less. No entanto, existem ferramentas e linguagens que podem ser usadas em conjunto com HTML5 para facilitar o desenvolvimento web. Alguns exemplos incluem:

1. **Pug (anteriormente conhecido como Jade)**: Pug é uma linguagem de modelagem que compila para HTML. Ele permite que você escreva HTML de maneira mais concisa e legível, usando uma sintaxe simplificada.

2. **Haml**: Assim como o Pug, o Haml é outra linguagem de modelagem que visa simplificar a criação de HTML. Ele usa uma sintaxe mais limpa e minimalista do que o HTML tradicional.

3. **Slim**: Slim é semelhante ao Haml e ao Pug, oferecendo uma sintaxe mais simples para escrever HTML. Ele é projetado para ser mais expressivo e fácil de ler do que o HTML padrão.

Essas linguagens não são tecnicamente pré-processadores de HTML, mas podem ser usadas para gerar HTML de uma maneira mais eficiente e legível. Assim como o CSS tem pré-processadores como Sass e Less, o JavaScript também possui algumas ferramentas que podem ser consideradas pré-processadores ou linguagens que compilam para JavaScript. Alguns exemplos populares incluem:

1. **TypeScript**: TypeScript é um superconjunto tipado de JavaScript que adiciona tipos estáticos opcionais ao JavaScript. Ele compila para JavaScript padrão e é amplamente adotado em projetos grandes e complexos para fornecer verificação de tipo durante o desenvolvimento.

2. **CoffeeScript**: CoffeeScript é uma linguagem que compila para JavaScript. Ela tem uma sintaxe mais sucinta e expressiva do que o JavaScript padrão e é projetada para tornar a escrita de código JavaScript mais rápida e fácil.

3. **Babel**: Embora não seja estritamente um pré-processador, o Babel é uma ferramenta popular para transpilação de código JavaScript. Ele permite que você escreva código usando as últimas características do JavaScript (como as especificadas no ECMAScript 6 e posteriores) e compile esse código para uma versão compatível com navegadores mais antigos.

4. **Elm**: Elm é uma linguagem funcional compilada para JavaScript. Ela é projetada para criar aplicativos web front-end robustos e escaláveis, enfatizando a imutabilidade e a arquitetura de aplicativos orientada a modelos.

Essas ferramentas e linguagens podem ser usadas para escrever JavaScript de maneira mais eficiente, segura e expressiva, facilitando o desenvolvimento de aplicativos web complexos.

Então, o Sass possui uma sintaxe muito parecida com o CSS comum. Isso significa que qualquer código CSS é interpretado pelo Sass! Possui uma grande comunidade e é utilizado por grandes frameworks, como o Bootstrap (que antigamente usava o Less), também possui um código bem maduro, com um desenvolvimento ativo há mais de 9 anos. Segundo uma pesquisa feita pelo ashleynola.co.uk, o Sass é utilizado por pelo menos 66% dos desenvolvedores. No Google Trends, se procurarmos por “Less” e “Sass”, veremos que o Sass é bem mais pesquisado. Ambos são ótimos pré-processadores e normalmente a escolha dependerá do gosto da equipe que estiver desenvolvendo o sistema.

Quando começamos a ler sobre Sass, encontramos também o termo "SCSS". Afinal, qual a diferença? Sass é o nome do pré-processador, originalmente criado em Ruby. No começo, era necessário instalar o Ruby em sua máquina para poder gerar o CSS.

A sintaxe era bem diferente do CSS comum:

[![Sass](https://img.shields.io/badge/-style.sass-000?style=social&logo=Sass&logoColor=pink)](#)

```sass
  #my-div
  color: red
  &:hover
  color: green
```

Veja que, diferente do CSS comum, não há “`;`“ nem “`{ }`”. Pela ausência de “`{ }`“, os espaços da indentação são importantes.

Depois de um tempo, o Sass passou por uma mudança. Sua sintaxe passou a ser mais parecida com o CSS comum:

[![Sass](https://img.shields.io/badge/-style.scss-000?style=social&logo=Sass&logoColor=safira)](#)

```scss
  #my-div{
    color: red;
    &:hover{
     color: green;
    }
  }
```

Similar ao:

[![CSS3](https://img.shields.io/badge/-style.css-000000?style=social&logo=CSS3&logoColor=1877F2)](#)

```css
  #my-div{
    color: red;
  }
  #my-div:hover{
    color: green;
  }
```

A nova sintaxe do Sass utiliza a extensão `.scss`, diferente da antiga que utilizava a extensão `.sass`.

<blockquote><b>Resumindo:</b> “sass” e “scss” são as duas sintaxes do Sass. Você ainda pode utilizar a sintaxe .sass, mas o mais recomendado é usar a sintaxe <b>.scss</b>, por ser mais parecido com o CSS comum.</blockquote>

Além disso, pela popularização do Sass, hoje em dia não somos mais obrigados a ter o Ruby em nossa máquina para usá-lo. Podemos compilar o Sass a partir de C, Go, Java, Node.js, PHP, Python, etc.

Para uma lista completa, acesse: http://sass-lang.com/libsass

<img src="https://cdn.worldvectorlogo.com/logos/node-sass.svg" height="77" align="right"/>

Como foi dito, não é mais preciso obter o Ruby em nossa máquina para poder utilizar o Sass. Podemos compilar o Sass a partir de C, Go, Java, Node.js, PHP, Python, etc. Vamos aprender como configurar e rodar o Sass no ambiente Node.js:

Como a maioria dos desenvolvedores front-end usam o Node.js atualmente, veremos como configurá-lo para compilar nosso Sass para CSS.
Primeiro, obtenha o Node.js em: https://nodejs.org/

Após instalar o Node.js em sua máquina, criaremos um diretório chamado Sass.

# ☂️ Framework Bootstrap
<a href="https://getbootstrap.com/"><img src="https://cdn.worldvectorlogo.com/logos/bootstrap-5-1.svg" height="77" align="right"></a>

Se trata de um framework para desenvolvimento de sites responsivos. Possui uma vasta biblioteca de componentes que facilita a agiliza o desenvolvimento de páginas web. É um dos frameworks mais conhecidos e usados para desenvolvimento front-end.

Para saber mais clique na imagem acima para acessar o repositório do Bootstrap.

<img src="https://user-images.githubusercontent.com/61624336/106330804-a5a05f80-6262-11eb-990b-77961ab5ca76.jpg" align="right" height="177">

O Bootstrap já possui um padrão para containers, divs e entre outras tags, como se fossem uma espécie de caixa, todas elas são chamadas pelos atributos <code>class</code>. Uma desvantagem do Bootstrap é a quantidade de linhas e classes no arquivo html, tornando o código mais longo do que estilizado pelo CSS puro. No entanto, é possível utilizar o Framework Bootstrap junto com a folha de Estilo, basta somente usar outros nomes para os seletores.
