---
sidebar_position: 1
---

# IoTSharp是什么？

IoTSharp是一个基于 **.Net 6.0** 使用C#语言编写的以实现可见与不可见的物理设备**数字孪生**的**物联网平台**， 什么是数字孪生？

## **属性数据(Attributes Data)**  
  显示设备中类似于型号， 性别或者串口、IP地址等设备上固定的信息我们称之为属性数据。  属性数据分三侧如下：
  - **客户侧属性** 型号、性别等固定属性从设备中采集到的称之为客户端侧属性 
  - **服务侧属性** 姓名、用途、归于哪一个资产旗下的标识等这些服务端定义的属性就是服务侧属性。
  -  **任意侧属性** 类似串口配置， IP地址配置等服务端定义需要下发到客户端的数据称之为任意侧属性。


## **遥测数据 (Telemetry Data)**  
  遥测数据类似温度、湿度、气压、电压、年龄 体温 等不停的在变化的我们均称之为遥测数据， 这些数据主要以时序方式存储，你可以将其用于基于时间序列的预测， 也可以统计分析环比，利用大数据工具探索这些数据之前的关系等等。 或者提供图表等可视化展示等等。 

## **远程控制(RPC)**  

比如 灯 ， 我们拥有他的属性瓦数，拥有他的遥测数据亮度和耗电量， 远程控制就是灯的开关功能我们称之为远程控制， 远程控制分服务单向、双向和客户端远程控制。 以下分别介绍：
   - 服务端单向控制  业务层调用IoTSharp提供的统一API，调用后直接返回，不等待设备返回，实际结果一般是通过遥测数据体现， 假设 空调温度， 你控制空调将温度设置为31°， 效果则从遥测反馈的结果来体现。 
   - 服务端双向控制  业务层调用IoTSharp后，需要等待设备响应结果， 比如， 灯泡的开关控制了打开， 我们需要可靠的知道控制灯泡的开关是否确实打开了灯泡，并告诉服务端结果， 结果包括成功、失败、为什么失败， 或者超时。 
   - 客户端远程控制  比如， 一个报警按钮， 按下报警按钮后， 信息发送到IoTSharp ， IoTSharp 通过远程控制的规则链调用了你事先提供的接口后，将结果提供给客户端， 客户端确认无误，这样一个过程就叫 客户端远程控制。 

 ## **规则链** 
  IoTSharp提供的规则链功能具有非常丰富的自定义能力和脚本支持能力， 类似一个流程图， 数据先进入到某个规则链， 这个规则链的起点中IoTSharp将数据转换为一个对象， 然后 你可以连接多个 任务块， 连接线上的动态表达式结果决定了需要将数据转交给后面的那些任务块， 在后面的任务块收到对象数据后， 任务块中你实现指定的脚本开始发挥作用， 这些脚本可以是前端最熟悉的JS，也可以是C#， 也可以是Python， 也可以是 SQL、当然， 你也可以装载C#写动态库，或者是我们预制的功能。 这些任务块有输入， 有输出， 输出依然为一个对象数据， 如果输出上依然连接有连接线， 那么开始计算条件 走向下一个任务块， 否则就算结束。 