﻿/* tslint:disable */
//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v12.0.12.0 (NJsonSchema v9.13.15.0 (Newtonsoft.Json v11.0.0.0)) (http://NSwag.org)
// </auto-generated>
//----------------------
// ReSharper disable InconsistentNaming

export module IoT.Sharp.Sdk.TS {
namespace IoT.Sharp.Sdk.TS {

export class AccountClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl ? baseUrl : "http://localhost:51498";
    }

    login(model: LoginDto): Promise<LoginResult | null> {
        let url_ = this.baseUrl + "/api/Account/Login";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(model);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processLogin(_response);
        });
    }

    protected processLogin(response: Response): Promise<LoginResult | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? LoginResult.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<LoginResult | null>(<any>null);
    }

    register(model: RegisterDto): Promise<LoginResult | null> {
        let url_ = this.baseUrl + "/api/Account/Register";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(model);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processRegister(_response);
        });
    }

    protected processRegister(response: Response): Promise<LoginResult | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? LoginResult.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<LoginResult | null>(<any>null);
    }
}

export class CustomersClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl ? baseUrl : "http://localhost:51498";
    }

    getCustomers(tenantId: string): Promise<Customer[] | null> {
        let url_ = this.baseUrl + "/api/Customers/Tenant/{tenantId}";
        if (tenantId === undefined || tenantId === null)
            throw new Error("The parameter 'tenantId' must be defined.");
        url_ = url_.replace("{tenantId}", encodeURIComponent("" + tenantId)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetCustomers(_response);
        });
    }

    protected processGetCustomers(response: Response): Promise<Customer[] | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(Customer.fromJS(item));
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Customer[] | null>(<any>null);
    }

    getCustomer(id: string): Promise<Customer | null> {
        let url_ = this.baseUrl + "/api/Customers/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetCustomer(_response);
        });
    }

    protected processGetCustomer(response: Response): Promise<Customer | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Customer.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Customer | null>(<any>null);
    }

    putCustomer(id: string, customer: Customer): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/api/Customers/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(customer);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutCustomer(_response);
        });
    }

    protected processPutCustomer(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    deleteCustomer(id: string): Promise<Customer | null> {
        let url_ = this.baseUrl + "/api/Customers/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "DELETE",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteCustomer(_response);
        });
    }

    protected processDeleteCustomer(response: Response): Promise<Customer | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Customer.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Customer | null>(<any>null);
    }

    postCustomer(customer: Customer): Promise<Customer | null> {
        let url_ = this.baseUrl + "/api/Customers";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(customer);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostCustomer(_response);
        });
    }

    protected processPostCustomer(response: Response): Promise<Customer | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Customer.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Customer | null>(<any>null);
    }
}

export class DevicesClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl ? baseUrl : "http://localhost:51498";
    }

    getDevicesAll(customerId: string): Promise<Device[] | null> {
        let url_ = this.baseUrl + "/api/Devices/Customers/{customerId}";
        if (customerId === undefined || customerId === null)
            throw new Error("The parameter 'customerId' must be defined.");
        url_ = url_.replace("{customerId}", encodeURIComponent("" + customerId)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetDevicesAll(_response);
        });
    }

    protected processGetDevicesAll(response: Response): Promise<Device[] | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(Device.fromJS(item));
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Device[] | null>(<any>null);
    }

    getDevices(customerId: string): Promise<Device[] | null> {
        let url_ = this.baseUrl + "/api/Devices";
        if (customerId === undefined || customerId === null)
            throw new Error("The parameter 'customerId' must be defined.");
        url_ = url_.replace("{customerId}", encodeURIComponent("" + customerId)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetDevices(_response);
        });
    }

    protected processGetDevices(response: Response): Promise<Device[] | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(Device.fromJS(item));
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Device[] | null>(<any>null);
    }

    postDevice(device: Device): Promise<Device | null> {
        let url_ = this.baseUrl + "/api/Devices";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(device);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostDevice(_response);
        });
    }

    protected processPostDevice(response: Response): Promise<Device | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Device.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Device | null>(<any>null);
    }

    getDevice(id: string): Promise<Device | null> {
        let url_ = this.baseUrl + "/api/Devices/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetDevice(_response);
        });
    }

    protected processGetDevice(response: Response): Promise<Device | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Device.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Device | null>(<any>null);
    }

    putDevice(id: string, device: Device): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/api/Devices/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(device);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutDevice(_response);
        });
    }

    protected processPutDevice(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    deleteDevice(id: string): Promise<Device | null> {
        let url_ = this.baseUrl + "/api/Devices/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "DELETE",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteDevice(_response);
        });
    }

    protected processDeleteDevice(response: Response): Promise<Device | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Device.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Device | null>(<any>null);
    }
}

export class InstallerClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl ? baseUrl : "http://localhost:51498";
    }

    instance(): Promise<InstanceDto | null> {
        let url_ = this.baseUrl + "/api/Installer/Instance";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processInstance(_response);
        });
    }

    protected processInstance(response: Response): Promise<InstanceDto | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? InstanceDto.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<InstanceDto | null>(<any>null);
    }

    install(model: InstallDto): Promise<InstanceDto | null> {
        let url_ = this.baseUrl + "/api/Installer/Install";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(model);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processInstall(_response);
        });
    }

    protected processInstall(response: Response): Promise<InstanceDto | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? InstanceDto.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<InstanceDto | null>(<any>null);
    }
}

export class TenantsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl ? baseUrl : "http://localhost:51498";
    }

    getTenantAll(): Promise<Tenant[] | null> {
        let url_ = this.baseUrl + "/api/Tenants";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTenantAll(_response);
        });
    }

    protected processGetTenantAll(response: Response): Promise<Tenant[] | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(Tenant.fromJS(item));
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Tenant[] | null>(<any>null);
    }

    postTenant(tenant: Tenant): Promise<Tenant | null> {
        let url_ = this.baseUrl + "/api/Tenants";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(tenant);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTenant(_response);
        });
    }

    protected processPostTenant(response: Response): Promise<Tenant | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Tenant.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Tenant | null>(<any>null);
    }

    getTenant(id: string): Promise<Tenant | null> {
        let url_ = this.baseUrl + "/api/Tenants/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTenant(_response);
        });
    }

    protected processGetTenant(response: Response): Promise<Tenant | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Tenant.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Tenant | null>(<any>null);
    }

    putTenant(id: string, tenant: Tenant): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/api/Tenants/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(tenant);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            headers: {
                "Content-Type": "application/json", 
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTenant(_response);
        });
    }

    protected processPutTenant(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    deleteTenant(id: string): Promise<Tenant | null> {
        let url_ = this.baseUrl + "/api/Tenants/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id)); 
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "DELETE",
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTenant(_response);
        });
    }

    protected processDeleteTenant(response: Response): Promise<Tenant | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = resultData200 ? Tenant.fromJS(resultData200) : <any>null;
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Tenant | null>(<any>null);
    }
}

export class LoginResult implements ILoginResult {
    userName?: string | undefined;
    signIn?: SignInResult | undefined;
    succeeded!: boolean;
    token?: TokenEntity | undefined;

    constructor(data?: ILoginResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.userName = data["userName"];
            this.signIn = data["signIn"] ? SignInResult.fromJS(data["signIn"]) : <any>undefined;
            this.succeeded = data["succeeded"];
            this.token = data["token"] ? TokenEntity.fromJS(data["token"]) : <any>undefined;
        }
    }

    static fromJS(data: any): LoginResult {
        data = typeof data === 'object' ? data : {};
        let result = new LoginResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["userName"] = this.userName;
        data["signIn"] = this.signIn ? this.signIn.toJSON() : <any>undefined;
        data["succeeded"] = this.succeeded;
        data["token"] = this.token ? this.token.toJSON() : <any>undefined;
        return data; 
    }
}

export interface ILoginResult {
    userName?: string | undefined;
    signIn?: SignInResult | undefined;
    succeeded: boolean;
    token?: TokenEntity | undefined;
}

export class SignInResult implements ISignInResult {
    succeeded!: boolean;
    isLockedOut!: boolean;
    isNotAllowed!: boolean;
    requiresTwoFactor!: boolean;

    constructor(data?: ISignInResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.succeeded = data["succeeded"];
            this.isLockedOut = data["isLockedOut"];
            this.isNotAllowed = data["isNotAllowed"];
            this.requiresTwoFactor = data["requiresTwoFactor"];
        }
    }

    static fromJS(data: any): SignInResult {
        data = typeof data === 'object' ? data : {};
        let result = new SignInResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["succeeded"] = this.succeeded;
        data["isLockedOut"] = this.isLockedOut;
        data["isNotAllowed"] = this.isNotAllowed;
        data["requiresTwoFactor"] = this.requiresTwoFactor;
        return data; 
    }
}

export interface ISignInResult {
    succeeded: boolean;
    isLockedOut: boolean;
    isNotAllowed: boolean;
    requiresTwoFactor: boolean;
}

export class TokenEntity implements ITokenEntity {
    access_token?: string | undefined;
    expires_in!: number;

    constructor(data?: ITokenEntity) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.access_token = data["access_token"];
            this.expires_in = data["expires_in"];
        }
    }

    static fromJS(data: any): TokenEntity {
        data = typeof data === 'object' ? data : {};
        let result = new TokenEntity();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["access_token"] = this.access_token;
        data["expires_in"] = this.expires_in;
        return data; 
    }
}

export interface ITokenEntity {
    access_token?: string | undefined;
    expires_in: number;
}

export class LoginDto implements ILoginDto {
    password!: string;
    email!: string;

    constructor(data?: ILoginDto) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.password = data["password"];
            this.email = data["email"];
        }
    }

    static fromJS(data: any): LoginDto {
        data = typeof data === 'object' ? data : {};
        let result = new LoginDto();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["password"] = this.password;
        data["email"] = this.email;
        return data; 
    }
}

export interface ILoginDto {
    password: string;
    email: string;
}

export class RegisterDto implements IRegisterDto {
    email!: string;
    customerName!: string;
    password!: string;

    constructor(data?: IRegisterDto) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.email = data["email"];
            this.customerName = data["customerName"];
            this.password = data["password"];
        }
    }

    static fromJS(data: any): RegisterDto {
        data = typeof data === 'object' ? data : {};
        let result = new RegisterDto();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["email"] = this.email;
        data["customerName"] = this.customerName;
        data["password"] = this.password;
        return data; 
    }
}

export interface IRegisterDto {
    email: string;
    customerName: string;
    password: string;
}

export class Customer implements ICustomer {
    id!: string;
    name?: string | undefined;
    email?: string | undefined;
    phone?: string | undefined;
    country?: string | undefined;
    province?: string | undefined;
    city?: string | undefined;
    street?: string | undefined;
    address?: string | undefined;
    zipCode!: number;
    tenant?: Tenant | undefined;

    constructor(data?: ICustomer) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.id = data["id"];
            this.name = data["name"];
            this.email = data["email"];
            this.phone = data["phone"];
            this.country = data["country"];
            this.province = data["province"];
            this.city = data["city"];
            this.street = data["street"];
            this.address = data["address"];
            this.zipCode = data["zipCode"];
            this.tenant = data["tenant"] ? Tenant.fromJS(data["tenant"]) : <any>undefined;
        }
    }

    static fromJS(data: any): Customer {
        data = typeof data === 'object' ? data : {};
        let result = new Customer();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["name"] = this.name;
        data["email"] = this.email;
        data["phone"] = this.phone;
        data["country"] = this.country;
        data["province"] = this.province;
        data["city"] = this.city;
        data["street"] = this.street;
        data["address"] = this.address;
        data["zipCode"] = this.zipCode;
        data["tenant"] = this.tenant ? this.tenant.toJSON() : <any>undefined;
        return data; 
    }
}

export interface ICustomer {
    id: string;
    name?: string | undefined;
    email?: string | undefined;
    phone?: string | undefined;
    country?: string | undefined;
    province?: string | undefined;
    city?: string | undefined;
    street?: string | undefined;
    address?: string | undefined;
    zipCode: number;
    tenant?: Tenant | undefined;
}

export class Tenant implements ITenant {
    id!: string;
    name?: string | undefined;
    eMail?: string | undefined;
    phone?: string | undefined;
    country?: string | undefined;
    province?: string | undefined;
    city?: string | undefined;
    street?: string | undefined;
    address?: string | undefined;
    zipCode!: number;

    constructor(data?: ITenant) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.id = data["id"];
            this.name = data["name"];
            this.eMail = data["eMail"];
            this.phone = data["phone"];
            this.country = data["country"];
            this.province = data["province"];
            this.city = data["city"];
            this.street = data["street"];
            this.address = data["address"];
            this.zipCode = data["zipCode"];
        }
    }

    static fromJS(data: any): Tenant {
        data = typeof data === 'object' ? data : {};
        let result = new Tenant();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["name"] = this.name;
        data["eMail"] = this.eMail;
        data["phone"] = this.phone;
        data["country"] = this.country;
        data["province"] = this.province;
        data["city"] = this.city;
        data["street"] = this.street;
        data["address"] = this.address;
        data["zipCode"] = this.zipCode;
        return data; 
    }
}

export interface ITenant {
    id: string;
    name?: string | undefined;
    eMail?: string | undefined;
    phone?: string | undefined;
    country?: string | undefined;
    province?: string | undefined;
    city?: string | undefined;
    street?: string | undefined;
    address?: string | undefined;
    zipCode: number;
}

export class Device implements IDevice {
    id!: string;
    name?: string | undefined;
    type?: string | undefined;
    tenant?: Tenant | undefined;
    customer?: Customer | undefined;
    attributeData?: AttributeData[] | undefined;
    attributeLatest?: AttributeLatest[] | undefined;
    telemetryData?: TelemetryData[] | undefined;
    telemetryLatest?: TelemetryLatest[] | undefined;

    constructor(data?: IDevice) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.id = data["id"];
            this.name = data["name"];
            this.type = data["type"];
            this.tenant = data["tenant"] ? Tenant.fromJS(data["tenant"]) : <any>undefined;
            this.customer = data["customer"] ? Customer.fromJS(data["customer"]) : <any>undefined;
            if (data["attributeData"] && data["attributeData"].constructor === Array) {
                this.attributeData = [] as any;
                for (let item of data["attributeData"])
                    this.attributeData!.push(AttributeData.fromJS(item));
            }
            if (data["attributeLatest"] && data["attributeLatest"].constructor === Array) {
                this.attributeLatest = [] as any;
                for (let item of data["attributeLatest"])
                    this.attributeLatest!.push(AttributeLatest.fromJS(item));
            }
            if (data["telemetryData"] && data["telemetryData"].constructor === Array) {
                this.telemetryData = [] as any;
                for (let item of data["telemetryData"])
                    this.telemetryData!.push(TelemetryData.fromJS(item));
            }
            if (data["telemetryLatest"] && data["telemetryLatest"].constructor === Array) {
                this.telemetryLatest = [] as any;
                for (let item of data["telemetryLatest"])
                    this.telemetryLatest!.push(TelemetryLatest.fromJS(item));
            }
        }
    }

    static fromJS(data: any): Device {
        data = typeof data === 'object' ? data : {};
        let result = new Device();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["name"] = this.name;
        data["type"] = this.type;
        data["tenant"] = this.tenant ? this.tenant.toJSON() : <any>undefined;
        data["customer"] = this.customer ? this.customer.toJSON() : <any>undefined;
        if (this.attributeData && this.attributeData.constructor === Array) {
            data["attributeData"] = [];
            for (let item of this.attributeData)
                data["attributeData"].push(item.toJSON());
        }
        if (this.attributeLatest && this.attributeLatest.constructor === Array) {
            data["attributeLatest"] = [];
            for (let item of this.attributeLatest)
                data["attributeLatest"].push(item.toJSON());
        }
        if (this.telemetryData && this.telemetryData.constructor === Array) {
            data["telemetryData"] = [];
            for (let item of this.telemetryData)
                data["telemetryData"].push(item.toJSON());
        }
        if (this.telemetryLatest && this.telemetryLatest.constructor === Array) {
            data["telemetryLatest"] = [];
            for (let item of this.telemetryLatest)
                data["telemetryLatest"].push(item.toJSON());
        }
        return data; 
    }
}

export interface IDevice {
    id: string;
    name?: string | undefined;
    type?: string | undefined;
    tenant?: Tenant | undefined;
    customer?: Customer | undefined;
    attributeData?: AttributeData[] | undefined;
    attributeLatest?: AttributeLatest[] | undefined;
    telemetryData?: TelemetryData[] | undefined;
    telemetryLatest?: TelemetryLatest[] | undefined;
}

export class DataStorage implements IDataStorage {
    id!: string;
    keyName!: string;
    device!: Device;
    catalog!: DataCatalog;
    type!: DataType;
    dateTime!: Date;
    value_Boolean!: boolean;
    value_String?: string | undefined;
    value_Long!: number;
    value_Double!: number;
    value_Json?: string | undefined;
    value_XML?: string | undefined;
    value_Binary?: string | undefined;

    constructor(data?: IDataStorage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.device = new Device();
        }
    }

    init(data?: any) {
        if (data) {
            this.id = data["id"];
            this.keyName = data["keyName"];
            this.device = data["device"] ? Device.fromJS(data["device"]) : new Device();
            this.catalog = data["catalog"];
            this.type = data["type"];
            this.dateTime = data["dateTime"] ? new Date(data["dateTime"].toString()) : <any>undefined;
            this.value_Boolean = data["value_Boolean"];
            this.value_String = data["value_String"];
            this.value_Long = data["value_Long"];
            this.value_Double = data["value_Double"];
            this.value_Json = data["value_Json"];
            this.value_XML = data["value_XML"];
            this.value_Binary = data["value_Binary"];
        }
    }

    static fromJS(data: any): DataStorage {
        data = typeof data === 'object' ? data : {};
        let result = new DataStorage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["keyName"] = this.keyName;
        data["device"] = this.device ? this.device.toJSON() : <any>undefined;
        data["catalog"] = this.catalog;
        data["type"] = this.type;
        data["dateTime"] = this.dateTime ? this.dateTime.toISOString() : <any>undefined;
        data["value_Boolean"] = this.value_Boolean;
        data["value_String"] = this.value_String;
        data["value_Long"] = this.value_Long;
        data["value_Double"] = this.value_Double;
        data["value_Json"] = this.value_Json;
        data["value_XML"] = this.value_XML;
        data["value_Binary"] = this.value_Binary;
        return data; 
    }
}

export interface IDataStorage {
    id: string;
    keyName: string;
    device: Device;
    catalog: DataCatalog;
    type: DataType;
    dateTime: Date;
    value_Boolean: boolean;
    value_String?: string | undefined;
    value_Long: number;
    value_Double: number;
    value_Json?: string | undefined;
    value_XML?: string | undefined;
    value_Binary?: string | undefined;
}

export class AttributeData extends DataStorage implements IAttributeData {

    constructor(data?: IAttributeData) {
        super(data);
    }

    init(data?: any) {
        super.init(data);
    }

    static fromJS(data: any): AttributeData {
        data = typeof data === 'object' ? data : {};
        let result = new AttributeData();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data; 
    }
}

export interface IAttributeData extends IDataStorage {
}

export enum DataCatalog {
    None = 0, 
    AttributeData = 1, 
    AttributeLatest = 2, 
    TelemetryData = 3, 
    TelemetryLatest = 4, 
}

export enum DataType {
    Boolean = 0, 
    String = 1, 
    Long = 2, 
    Double = 3, 
    Json = 4, 
    XML = 5, 
    Binary = 6, 
}

export class AttributeLatest extends DataStorage implements IAttributeLatest {

    constructor(data?: IAttributeLatest) {
        super(data);
    }

    init(data?: any) {
        super.init(data);
    }

    static fromJS(data: any): AttributeLatest {
        data = typeof data === 'object' ? data : {};
        let result = new AttributeLatest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data; 
    }
}

export interface IAttributeLatest extends IDataStorage {
}

export class TelemetryData extends DataStorage implements ITelemetryData {

    constructor(data?: ITelemetryData) {
        super(data);
    }

    init(data?: any) {
        super.init(data);
    }

    static fromJS(data: any): TelemetryData {
        data = typeof data === 'object' ? data : {};
        let result = new TelemetryData();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data; 
    }
}

export interface ITelemetryData extends IDataStorage {
}

export class TelemetryLatest extends DataStorage implements ITelemetryLatest {

    constructor(data?: ITelemetryLatest) {
        super(data);
    }

    init(data?: any) {
        super.init(data);
    }

    static fromJS(data: any): TelemetryLatest {
        data = typeof data === 'object' ? data : {};
        let result = new TelemetryLatest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data; 
    }
}

export interface ITelemetryLatest extends IDataStorage {
}

export class InstanceDto implements IInstanceDto {
    version?: string | undefined;
    installed!: boolean;

    constructor(data?: IInstanceDto) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.version = data["version"];
            this.installed = data["installed"];
        }
    }

    static fromJS(data: any): InstanceDto {
        data = typeof data === 'object' ? data : {};
        let result = new InstanceDto();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["version"] = this.version;
        data["installed"] = this.installed;
        return data; 
    }
}

export interface IInstanceDto {
    version?: string | undefined;
    installed: boolean;
}

export class InstallDto implements IInstallDto {
    email!: string;
    customerName!: string;
    password!: string;
    tenantName?: string | undefined;
    tenantEMail?: string | undefined;
    customerEMail?: string | undefined;
    phoneNumber?: string | undefined;

    constructor(data?: IInstallDto) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(data?: any) {
        if (data) {
            this.email = data["email"];
            this.customerName = data["customerName"];
            this.password = data["password"];
            this.tenantName = data["tenantName"];
            this.tenantEMail = data["tenantEMail"];
            this.customerEMail = data["customerEMail"];
            this.phoneNumber = data["phoneNumber"];
        }
    }

    static fromJS(data: any): InstallDto {
        data = typeof data === 'object' ? data : {};
        let result = new InstallDto();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["email"] = this.email;
        data["customerName"] = this.customerName;
        data["password"] = this.password;
        data["tenantName"] = this.tenantName;
        data["tenantEMail"] = this.tenantEMail;
        data["customerEMail"] = this.customerEMail;
        data["phoneNumber"] = this.phoneNumber;
        return data; 
    }
}

export interface IInstallDto {
    email: string;
    customerName: string;
    password: string;
    tenantName?: string | undefined;
    tenantEMail?: string | undefined;
    customerEMail?: string | undefined;
    phoneNumber?: string | undefined;
}

export interface FileResponse {
    data: Blob;
    status: number;
    fileName?: string;
    headers?: { [name: string]: any };
}

export class SwaggerException extends Error {
    message: string;
    status: number; 
    response: string; 
    headers: { [key: string]: any; };
    result: any; 

    constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
        super();

        this.message = message;
        this.status = status;
        this.response = response;
        this.headers = headers;
        this.result = result;
    }

    protected isSwaggerException = true;

    static isSwaggerException(obj: any): obj is SwaggerException {
        return obj.isSwaggerException === true;
    }
}

function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
    if(result !== null && result !== undefined)
        throw result;
    else
        throw new SwaggerException(message, status, response, headers, null);
}

}
}