//
//  NoiseComponent.swift
//  OctopusKit
//
//  Created by ShinryakuTako@invadingoctopus.io on 2018/03/15.
//  Copyright © 2020 Invading Octopus. Licensed under Apache License v2.0 (see LICENSE.txt)
//

import SpriteKit
import GameplayKit

/// Encapsulates a `GKNoise` object and provides the foundation for a `NoiseMapComponent`.
open class NoiseComponent: OKComponent {

    // ℹ️ Hierarchy: Noise Source » Noise » Noise Map
    // https://developer.apple.com/documentation/gameplaykit/gknoisesource
    // https://developer.apple.com/documentation/gameplaykit/gknoise
    // https://developer.apple.com/documentation/gameplaykit/gknoisemap
    
    open var noise: GKNoise
    
    /// - Parameter noise: A representation of procedural noise, generated by a noise source, that you can use to process, transform, or combine noise. Default: A single `GKPerlinNoiseSource`.
    public init(noise: GKNoise = GKNoise(GKPerlinNoiseSource())) {
        self.noise = noise
        super.init()
    }
    
    public required init?(coder aDecoder: NSCoder) { fatalError("init(coder:) has not been implemented") }
}

