### Полезные ссылки по теме (и около):

#### Общая информация:
- [ARM (архитектура)](https://ru.wikipedia.org/wiki/ARM_(%D0%B0%D1%80%D1%85%D0%B8%D1%82%D0%B5%D0%BA%D1%82%D1%83%D1%80%D0%B0))
- [ARM Introduction](https://www.electronicshub.org/arm-introduction/#Introduction)
- [ARM vs x86 - Explained](https://www.section.io/engineering-education/arm-x86/)
- [ARM против x86: В чем разница между двумя архитектурами процессоров?](https://habr.com/ru/company/droider/blog/519732/)
- [Процессоры ARM](https://you-2-you.ru/articles/interesnoe/protsessoryi-arm-chto-eto-takoe-i-s-chem-ih-edyat)
- [STM32](https://ru.wikipedia.org/wiki/STM32#STM32_F7)
- [STMicroelectronics: перспективы](https://www.compel.ru/lib/123541)
- [STM32: эпоха 32-битных микроконтроллеров наступила](https://www.compel.ru/lib/53953)

#### Подробнее про ARM:
- [Arm Cortex-M7 Processor Datasheet](https://developer.arm.com/documentation/102838/0100)
- [ARM developer documentation](https://developer.arm.com/documentation)

#### Сравнение регистровой архитектуры ARM и x86:
- [ARM registers](https://developer.arm.com/documentation/dui0473/m/overview-of-the-arm-architecture/arm-registers)
- [Intel 64 and IA-32 Architectures Software Developer Manuals](https://www.intel.com/content/www/us/en/developer/articles/technical/intel-sdm.html)

#### Статьи на Habr про STM32:
- [Отладочная плата STM32](https://habr.com/ru/post/497056/)
- [Обзор платформы для разработчиков ST Nucleo на примере Nucleo-F401RE](https://habr.com/ru/post/230651/)
- [ARM-микроконтроллеры STM32F. Быстрый старт c STM32-Discovery](https://habr.com/ru/post/128734/)
- [Клоны STM32: хороший, плохой, злой](https://habr.com/ru/company/ruvds/blog/525842/)
- [Микроконтроллеры семейств AVR, MSP430, STM32 и мои субъективные впечатления](https://habr.com/ru/post/219803/)
- [Игровая консоль stm32](https://habr.com/ru/post/501600/)

#### Обсуждения на форумах:
- [Аналог STM32](https://electronix.ru/forum/index.php?app=forums&module=forums&controller=topic&id=147725)
- [Китайские аналоги STM32](https://www.linux.org.ru/forum/development/13992289)

#### Популярные графические библиотеки, софт которых не предназначен для STM32 ( ¯\\_(ツ)_/¯ ):
- [OpenGL](https://www.khronos.org/opengl/wiki/Related_toolkits_and_APIs)
- [Direct3D](https://docs.microsoft.com/en-us/windows/win32/direct3d11/atoc-dx-graphics-direct3d-11)
- [Vulkan](https://www.vulkan.org)

#### Готовые решения, близкие к моей теме (ну или мне просто так показалось на первый взгляд):
- [Cтранная и с ходу непонятная 3D-графика на STM32](https://github.com/LedKast/STM32_3D_TEST)
- [CG_3D_Scene](https://github.com/LedKast/CG_3D_Scene)
- [obj loader (C++)](https://github.com/Bly7/OBJ-Loader)
- [obj loader and writer (Java)](https://github.com/javagl/Obj)
- [An Arduino IDE compatible graphics and fonts library for AVR processors with a driver for the ILI9341 based TFT displays](https://github.com/javagl/Obj)

#### Общие материалы по компьютерной графике:
- Курс лекций А. В. Курова
- Д. Роджерс - "Алгоритмические основы машинной графики"
- [Материал с экзамена по компьютерной графике](https://github.com/chrislvt/CG/wiki)
- [Краткий курс компьютерной графики: пишем упрощённый OpenGL своими руками (6 частей)](https://habr.com/ru/post/248153/)
- [OpenGL Course - Create 3D and 2D Graphics With C++](https://www.youtube.com/watch?v=45MIykWJ-C4)

#### Материалы по использованным алгоритмам:
- [Удаление невидимых линий и поверхностей (algolist)](http://algolist.manual.ru/graphics/delinvis.php)
- [Удаление невидимых линий и поверхностей (studfile)](https://studfile.net/preview/9467170/page:8/)
- [Алгоритм Варнока](http://compgraph.tpu.ru/warnock.htm)
- [Warnock Subdivision for Deferred Lighting](http://www.codersnotes.com/notes/warnock-subdivision-for-deferred-lighting/)
- [Освещение и закраска](http://www.mari-el.ru/mmlab/home/kg/Lection11/index.html)
- [Построение теней](http://www.mari-el.ru/mmlab/home/kg/Lection12/index.html)

#### Про платы и дисплеи:
- [STM32 + современный TFT-дисплей: варианты на любой вкус](https://www.compel.ru/lib/88474)
- [Разрабатываем устройство с графикой на STM32. Основные возможности периферии](https://www.compel.ru/lib/90626)

#### Официальная документация к моему железу:
- [STM32F767ZI Nucleo-144 (st.com)](https://www.st.com/en/evaluation-tools/nucleo-f767zi.html)
- [NUCLEO-F767ZI (os.mbed.com)](https://os.mbed.com/platforms/ST-Nucleo-F767ZI/)
- [Processor description (st.com)](https://www.st.com/en/microcontrollers-microprocessors/stm32f767zi.html)
- [Arm Cortex-M7](https://developer.arm.com/Processors/Cortex-M7)
- [Managing memory protection unit in STM32 MCUs](https://www.st.com/resource/en/application_note/dm00272912-managing-memory-protection-unit-in-stm32-mcus-stmicroelectronics.pdf)
- [ILI9341 Datasheet](https://datasheetspdf.com/datasheet/ILI9341.html)
- [ILI9341 User Manual](https://usermanual.wiki/Manual/ILI9341.2019494355)
- [TFT User Manual](http://web.mit.edu/6.115/www/document/TFT_User_Manual.pdf)

#### Практические гайды по моему железу (или похожему):
- [STM32 Nucleo. Подключаем TFT LCD на базе чипа ILI9341](https://habr.com/ru/post/241409/)
- [STM32 SPI и DMA. Конфигурация и пример использования.](https://microtechnics.ru/stm32-spi-i-dma-konfiguracziya-i-primer-ispolzovaniya/)
- [Быстрый старт ST Nucleo-F401 + краткое руководство](https://habr.com/ru/post/230931/)
- [STM Урок 40. Знакомство с платой NUCLEO STM32F767ZI](https://narodstream.ru/stm-urok-40-znakomstvo-s-platoj-nucleo-stm32f767zi/)
- [STM Урок 179. HAL. Дисплей TFT 240×320. SPI (несколько частей)](https://narodstream.ru/stm-urok-179-displej-tft-240x320-spi-chast-1/)

#### Софт для взаимодействия с железом:
- [Arm GNU Toolchain](https://developer.arm.com/Tools%20and%20Software/GNU%20Toolchain)
- [Visual Studio Code для C / C ++ с ARM Cortex-M](https://cmitavia.ru/technology/hardware/idearm/vscforcortexm.html)
- [Настройка VSCODE под разработку для ARM на примере отладочной платы stm32f429i-disco](https://habr.com/ru/post/437760/)
- [Работаем с микроконтроллерами STM32F7 (4 части)](https://www.compel.ru/lib/115978)

#### Как писать код:
- [IDE от MBED](https://ide.mbed.com/compiler)
- [Arm Compiler optimization options](https://developer.arm.com/documentation/100748/0612/using-common-compiler-options/selecting-optimization-options)
- [Arm inline assembly code](https://developer.arm.com/documentation/100748/0616/Using-Assembly-and-Intrinsics-in-C-or-C---Code/Writing-inline-assembly-code)
- [Простейшее профилирование памяти на STM32 и других микроконтроллерах](https://habr.com/ru/post/443030/)
- [Про профилирование памяти на STM32 более подробно](https://electronics.stackexchange.com/questions/363931/how-do-i-find-out-at-compile-time-how-much-of-an-stm32s-flash-memory-and-dynami)
- [Определение размера использованного стека с помощью "красок" (Ужас!)](https://habr.com/ru/post/443030/)
- [Счётчик тактов процессора STM32](https://stackoverflow.com/questions/36378280/stm32-how-to-enable-dwt-cycle-counter)
- [Data Watchpoint and Trace Unit (DWT)](https://developer.arm.com/documentation/ddi0489/f/data-watchpoint-and-trace-unit)

#### Про obj файлы:
- [3D ML. Часть 1: формы представления 3D-данных](https://habr.com/ru/company/itmai/blog/503358/)
- [Википедия](https://ru.wikipedia.org/wiki/Obj#%D0%A4%D0%BE%D1%80%D0%BC%D0%B0%D1%82_%D1%84%D0%B0%D0%B9%D0%BB%D0%B0)
- [Описание формата obj](https://www.fileformat.info/format/wavefrontobj/egff.htm)
- [Какое-то очень длинное описание формата obj](http://fegemo.github.io/cefet-cg/attachments/obj-spec.pdf)
- [Описание формата mtl](https://www.fileformat.info/format/material/)
- [Загрузка формата obj](https://sites.google.com/site/raznyeurokipoinformatiki/home/opengl-s/zagruzka-formata-obj?tmpl=%2Fsystem%2Fapp%2Ftemplates%2Fprint%2F)

#### Откуда я брал 3D-модели:
- [Библиотека полигональных моделей](https://free3d.com/ru/3d-models/), откуда я брал [такие модели](https://free3d.com/ru/3d-models/obj-%D0%BD%D0%B8%D0%B7%D0%BA%D0%BE%D0%BF%D0%BE%D0%BB%D0%B8%D0%B3%D0%BE%D0%BD%D0%B0%D0%BB%D1%8C%D0%BD%D0%BE%D0%B5)

#### Другие курсовые работы по компьютерной графике на ИУ7 (их, в отличие от моей, можно брать (◕‿◕)):
- [Трёхмерная визуализация городской среды и погодных условий](https://github.com/Winterpuma/bmstu_CG_CP)
- [Квантовые вычисления в алгоритме трассировки лучей](https://github.com/mRrvz/quantum-ray-tracer)
- [Моделирование поверхностей на основе конструктивной сплошной геометрии с использованием технологии RayMarching.](https://github.com/Flash1ee/cg-course-work)
- [Разработка алгоритма и программного обеспечения для трехмерной визуализации маятника Ньютона](https://github.com/Sunshine-ki/BMSTU5_CG_CP)
- [Трехмерный планировщик городского пространства](https://github.com/kovkir/bmstu_cg_course_project)
- [Построение реалистичного изображения с учётом оптических свойств поверхностей объектов методом трассировки лучей](https://github.com/ivaaahn/bmstu-cg-coursework)
- [Моделирование реалистичных изображений облаков](https://github.com/ansushina/sem5/tree/master/course)
- [Моделирование раскачивания объекта на водной поверхности и ещё несколько интересных курсачей](https://github.com/medva1997/bmstu_sem5/tree/master/CG_course)
- [Моделирование волн](https://github.com/hamzreg/cg-course)
- [Моделирование огня, исходящего от свечи](https://github.com/BMSTU-ICS7-Lab-Works/CG_CP_CANDLE)
- [Моделирование игры в бильярд](https://github.com/fairay/CourseComputerGraphics)
