/*=========================================================================
 *
 *  Copyright NumFOCUS
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/

#include "itkImageRegionSplitterDirection.h"
#include "itkImageRegion.h"
#include "itkTestingMacros.h"
#include <iostream>

int
itkImageRegionSplitterDirectionTest(int, char *[])
{

  const itk::ImageRegionSplitterDirection::Pointer splitter = itk::ImageRegionSplitterDirection::New();

  ITK_EXERCISE_BASIC_OBJECT_METHODS(splitter, ImageRegionSplitterDirection, ImageRegionSplitterBase);

  itk::ImageRegion<2> region;
  region.SetSize(0, 10);
  region.SetSize(1, 11);

  region.SetIndex(0, 1);
  region.SetIndex(1, 10);

  const itk::ImageRegion<2> lpRegion = region;

  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 0), 1);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 1), 1);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 2), 2);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 3), 3);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 4), 4);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 7), 6);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 11), 11);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 12), 11);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 99), 11);

  splitter->SetDirection(1);
  ITK_TEST_EXPECT_EQUAL(splitter->GetDirection(), 1);

  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 1), 1);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 4), 4);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 7), 5);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 11), 10);
  ITK_TEST_EXPECT_EQUAL(splitter->GetNumberOfSplits(lpRegion, 99), 10);

  region = lpRegion;
  splitter->GetSplit(0, 2, region);
  ITK_TEST_EXPECT_EQUAL(region.GetSize(0), 5);
  ITK_TEST_EXPECT_EQUAL(region.GetSize(1), 11);

  region = lpRegion;
  splitter->GetSplit(1, 2, region);
  ITK_TEST_EXPECT_EQUAL(region.GetSize(0), 5);
  ITK_TEST_EXPECT_EQUAL(region.GetSize(1), 11);

  const itk::ImageRegion<2> lpRegion2{}; // default zero sized
  region = lpRegion2;
  ITK_TEST_EXPECT_EQUAL(1, splitter->GetNumberOfSplits(lpRegion2, 1));
  ITK_TEST_EXPECT_EQUAL(1, splitter->GetSplit(1, 1, region));
  ITK_TEST_EXPECT_EQUAL(region.GetSize(0), 0);
  ITK_TEST_EXPECT_EQUAL(region.GetSize(1), 0);


  return EXIT_SUCCESS;
}
