# ITK ecosystem

Together with the core ITK code base, a number of other projects and
frameworks are maintained allowing to leverage the power of ITK beyond
its natural boundaries:

- [ITK/VTK Viewer](https://kitware.github.io/itk-vtk-viewer/docs/index.html)
  is a web-based image, mesh, and point set viewer.
- [itk-viewer](https://itk-viewer.on.fleek.co/) is a multi-dimensional
  web-based image, mesh, and point set viewer.
- [ITK-Wasm](https://wasm.itk.org/en/latest/) combines ITK and
  [WebAssembly](https://webassembly.org/) to enable high-performance
  spatial analysis in a web browser or system-level environments and
  reproducible execution across programming languages and hardware
  architectures.
- [itkwidgets](https://itkwidgets.readthedocs.io/en/latest/) is an
  elegant Python interface for visualization on the web platform to
  interactively generate insights into multidimensional images, point
  sets, and geometry.
- [SimpleITK](https://simpleitk.org/) is a simplified programming interface
  to ITK. It supports interfaces for multiple programming languages including
  C++, Python, R, Java, C#, Lua, Ruby and TCL.
- [scikit-build](https://scikit-build.org) is a Python build system for
  CPython C/C++/Fortran/Cython extensions using [CMake](https://cmake.org).

## Legacy tools

Other legacy projects that offered ITK's power through other interfaces
or sets of pipelines were:

- [Praxix](https://code.google.com/archive/p/praxix/) was a collection
  of command line programs for image processing using ITK.
- [ITK One Shot](https://github.com/daviddoria/ITK_OneShot) was a
  collecion of short programs to perform specific operations on images.
- [ITKApps](https://github.com/InsightSoftwareConsortium/ITKApps) were
  a variety of applications written with ITK, ranging from simple uses
  of the toolkit to complex and GUI-based applications.
