- ### [The Ultimate Question: Why should I start Competitive Programming?](https://codeforces.com/blog/entry/79449#comment-651688)
  Well, I believe that the ultimate goal of my existence is to be happy. And I have learned from many well-established people that getting a great job or being famous or other   common stereotypical goals won't make you happy as when you get used to those they become meaningless.

  I think happiness is living your present with excitement.

  That being said, now your main goal is to find something that will make you happy. There are lots of things you can do like being a musician or an artist etc. For me it was CP. I can lose myself into CP for hours and hours and still hold my excitement. A good contest is enough to make my day.

  Man, I am not saying that you have to choose CP too. Find anything that suits you well, delve into that and maybe you will find peace.

  Because I wanna spend my precious time on something so that in the end I can say with Heisenberg, "I did it for me. I liked it, I was good at it, and I was really... I was alive".

  Let's discuss something if you think CP is the thing that you wanna do.

  May you find that something that you have been looking for throughout your life!

- ### [Getting into Competitive Programming](https://github.com/the-hyp0cr1t3/CC)

- ### [Warm-Up: Solve at least 200 Problems](https://codeforces.com/problemset?order=BY_SOLVED_DESC)

- ### [FAQ](https://codeforces.com/blog/entry/47516)

- ### [[Tutorial] A way to Practice Competitive Programming : From Rating 1000 to 2400+](https://drive.google.com/file/d/1J2x8pIYQ3MXANgvzOgBciWd3d79j_Exa/view)

- ### How should I Practice?

  1. Create a topic list(every possible category, from easy to advanced).
  2. Select a topic.
  3. Learn the topic.
  4. Solve lots of problems about that topic.
  5. Go to ii.

  And of course, participate in every possible contests in every online judge.
  
 - ### How to Practice a Problem?
    - First of all, you should try to solve it  by yourself.
    - At the first glance, it may look like you have no idea what that random alien-made problem is asking you to do. But take your time. Always try to solve the problem using brute force. After that try to make your solution more efficient. 
    - Ok, so still you have no idea on how to solve the problem? Try to look at it from a whole new angle.
    - "Keep trying while you have new ideas, then look up the editorial after **15+ minutes of being completely stuck**." - [Errichto](https://codeforces.com/profile/Errichto)
    - To be more precise, if you think you are getting into the solution, then take more time and try to solve it. But if you have no clue on how to solve it, then what is the point of wasting your valuable time? It will only slow down your improvement process.
    - Time to implement the problem. Try not to use any unnecessary macros. Try to make it more readable. It will help you debugging the solution.
    - After that read implementations of some skilled users (searching for some useful tricks or really nice implementations). **This part is really important which will significantly improve your skill.**
    - If the problem uses a new idea/trick/algorithm which is a classic one i.e. it might be helpful in future then try to write that down so that in future you can easily access it.
 
 - ### The Art of Debugging
    - Run with n=1.
    - Check overflow(long long vs int).
    - Check all array bounds.
    - Check if m, n aren’t misused.
    - Printed enough new lines or extra new lines?
    - Make sure output format is right(including YES/NO vs Yes/No or
    newline vs spaces).
    - Have you cleared the vectors ?
    - Make sure two ints aren’t multiplied to get a long long.
    - Output enough digits after decimal point.
    - Check the constraints again.
    - When using multiple dfs recursions check if inside one dfs another dfs
    is called or not.
    - Shouldn't you print the case number?
    - Are you using the correct mod value?
    - "I spent a lot of my time debugging my solution without any success,
    after the contest I discovered that the obstacles in the input is 'x'
    (small one) while I was thinking it was 'X' (capital), I lost a bronze
    medal because of it :(" - kingofnumbers
    - Set or multiset?
    - Different Variables with the same name?
    - Inside 2d loop are you using i++ instead of j++?
    - Are you using ceil function? Then remove it!
    - Is inf large enough?
    - For multiple queries are you returning 0 inside the queries?
    - For max and min have you initialized the values by a good enough
    value?
    - Are you using the local variable of the same name when global variable was
    required to be used?
    - "Declared a counter of type char instead of int , resulted in passing of
    pretests and failing of system test. :)" - A random CF user
    - "I subtracted 1 in a for loop from v.size(). Guess what happened when
    the input vector is empty?" - A random CF user
    - "for (int i = n - 1; i--; i >= 0)
    instead of:
    for (int i = n - 1; i >= 0; i--)
    It passed pretests and failed systests" - A random CF user
    - Are you using memset correctly?
    - Use bool operators using brackets. Beware!!! E.g. ans = ans + k == 0 vs ans = ans + (k == 0).
    - Have you deleted debug(x) lines? It might get you TLE!
    - It may be scanf("%d" , x). where &x is missing.
    - Instead of printing NO printed N0. (with a zero).
    - Are you erasing values from a set or an stl while parallelly traversing
    the elements of the stl? Please don’t. This is not nice!
    - Don't use scanf or printf while using ios_base.
    - Still have no idea? Try to recode from scratch or see others solutions.
                                                                 
  
 - ### Topic List (As you are feeling lazy to collect them by yourself!)
    - [Chronological](https://docs.google.com/spreadsheets/d/1XSP_OsjzhdJfcvuOluUnwkoWKi9XCayEtWMsbh5yoeo/edit?fbclid=IwAR2JDGnBakUhRs-niPR2RdwCp010r18fB0bNhVcAdE32T29ewTK9bi5HaV0#gid=0)
    - [A2 OJ](https://a2oj.com/categories) 
    - [Quora](https://www.quora.com/What-are-the-algorithms-required-to-solve-all-problems-using-C++-in-any-competitive-coding-contest)
    - [Programming Camp Syllabus](https://docs.google.com/document/d/1_dc3Ifg7Gg1LxhiqMMmE9UbTsXpdRiYh4pKILYG2eA4/edit)
    - [E-Maxx](https://cp-algorithms.com/)
    - [Geometry](https://vlecomte.github.io/cp-geo.pdf)
    - [GeeksForGeeks](https://www.geeksforgeeks.org/fundamentals-of-algorithms/)
    - [PEG Wiki](http://wcipeg.com/wiki/Special:AllPages)
    - [Topcoder](https://www.topcoder.com/community/competitive-programming/tutorials/)
    - [The Hitchhiker’s Guide to the Programming Contests](http://comscigate.com/Books/contests/icpc.pdf)
    - [Competitive Programming Resources](https://halexv.blogspot.com/2015/10/competitive-programming-resources.html)
    - [All the good tutorials found for Competitive Programming](https://codeforces.com/blog/entry/57282)
    - [Good Blog Post Resources about Algorithm and Data Structures](https://codeforces.com/blog/entry/13529)
    - [Topic Specific Problems by Morass](https://codeforces.com/blog/entry/55274)
    - [LightOJ](http://www.lightoj.com/volume_problemcategory.php)
    
- ### [Code Library](https://github.com/kth-competitive-programming/kactl/tree/master/content)

- ### [Library Checker](https://judge.yosupo.jp/)

- ### [I know every topic that you have thrown at me. Am I a Good Programmer now?](https://codeforces.com/blog/entry/53341?#comment-373965)

- ### [CF Bingo DIV2](https://drive.google.com/file/d/0Bw3r2b-mo3r4SE11QmdzX2dpOG8/view)
