<?php $__env->startSection('style'); ?>

 <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <?php echo $__env->make('backend.pages._partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="col-9">

                        <form method="GET" action="<?php echo e(route('penilaian.monthly')); ?>" accept-charset="UTF-8" class="form-inline mt-3">
                            <table>
                                <tr>
                                    <td align="left"><label for="month" class="control-label text-left">Lihat Bulanan / </label></td>
                                    <td align="right">
                                        <select class="form-control form-control-sm" id="user_id" name="user_id">
                                        <option selected disabled>Pilihan</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($u->id); ?>"><?php echo e($u->username); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <select class="form-control form-control-sm" id="month" name="month">
                                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"><?php echo e($m); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <input class="btn btn-info btn-sm" type="submit" value="Lihat Laporan">
                                            <a href="<?php echo e(route('penilaian.monthly')); ?>" class="btn btn-default btn-sm">Bulan Ini</a>
                                            <a href="<?php echo e(route('penilaian.yearly', ['year' => $year])); ?>" class="btn btn-default btn-sm">Lihat Tahunan</a>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </form>

                        <div class="card card-primary">
                            <div class="card-body">
                                <h6 class="card-title text-right">Grafik Penilaian Bulan <?php echo e($months[$month]); ?></h6>
                                <strong>Nilai</strong>
                                <div id="monthly-chart" style="height: 250px;"></div>
                                <div class="text-right mr-4"><strong><small>Tanggal</small></strong></div>
                            </div>
                        </div>

                        <div class="card card-success table-responsive">
                            <div class="card-heading"><h6 class="card-title ml-4">Detail Laporan</h6></div>
                            <div class="card-body">
                                <table class="table-sm table datatable">
                                    <thead>
                                        <th class="text-center">Tanggal</th>
                                        <th class="text-center">Nilai</th>
                                        <th class="text-right">Pegawai</th>
                                        <th class="text-center">Aksi</th>
                                    </thead>
                                    <tbody>
                                        <?php $chartData = []; ?>
                                        <?php $__currentLoopData = monthDateArray($year, $month); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dateNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $any = isset($reports[$dateNumber]);
                                            $id = $any ? $reports[$dateNumber]->id_user : 0;
                                            $nilai = $any ? $reports[$dateNumber]->nilai_pg : 0;
                                        ?>
                                        <?php if($any): ?>
                                            <tr>
                                                <td class="text-center"><?php echo e(dateId($date = $year.'-'.$month.'-'.$dateNumber)); ?></td>
                                                <?php
                                                $pegawai = App\Pegawai::where('user_id', $id)->first();
                                                ?>
                                                <td class="text-center"><?php echo e($pegawai->name); ?></td>
                                                <td class="text-right"><?php echo e(number_format($nilai, 2)); ?> %</td>
                                                <td class="text-center">
                                                    <a href="<?php echo e(route('penilaian.daily', ['date' => $date])); ?>" class="btn btn-info btn-xs" title="Laponan Harian: 03 Mei 2019">Lihat Harian</a>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                        <?php
                                            $chartData[] = ['date' => $dateNumber, 'value' => ($nilai) ];
                                        ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('js/vendor/raphael.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/vendor/morris.min.js')); ?>"></script>
<script>
(function() {
    new Morris.Line({
        element: 'monthly-chart',
        data: <?php echo collect($chartData)->toJson(); ?>,
        xkey: 'date',
        ykeys: ['value'],
        labels: ["<?php echo e(__('Penilaian')); ?>"],
        parseTime:false,
        xLabelAngle: 30,
        goals: [0],
        goalLineColors : ['red'],
        lineWidth: 2,
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\WEBDEV\laragon\www\_p_karyawan_rscale\resources\views/backend/pages/penilaian/reports/monthly.blade.php ENDPATH**/ ?>