<?php $__env->startSection('style'); ?>

 <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <?php echo $__env->make('backend.pages._partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="col-9">

                        <form method="GET" action="<?php echo e(route('penilaian.yearly')); ?>" accept-charset="UTF-8" class="form-inline mt-3">
                            <table>
                                <tr>
                                    <td align="left"><label for="month" class="control-label text-left">Lihat Tahunan / </label></td>
                                    <td align="right">
                                        <select class="form-control form-control-sm" id="user_id" name="user_id">
                                        <option selected disabled>Pilihan</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($u->id); ?>"><?php echo e($u->username); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <select class="form-control form-control-sm" id="year" name="year">
                                        <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <input class="btn btn-info btn-sm" type="submit" value="Lihat Laporan">
                                            <a href="<?php echo e(route('penilaian.yearly')); ?>" class="btn btn-default btn-sm">Tahun Ini</a>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </form>

                        <div class="card card-primary">
                            <div class="card-body">
                                <h6 class="card-title text-right">Grafik Penilaian Tahun <?php echo e($year); ?></h6>
                                <strong>Nilai</strong>
                                <div id="yearly-chart" style="height: 250px;"></div>
                                <div class="text-right mr-4"><strong><small>Bulan</small></strong></div>
                            </div>
                        </div>

                        <div class="card card-success table-responsive">
                            <div class="card-heading"><h6 class="card-title ml-4">Detail Laporan</h6></div>
                            <div class="card-body table-responsive">
                                <table class="table-sm table datatable">
                                    <thead>
                                        <th class="text-center">Bulan</th>
                                        <th class="text-center">Jumlah Pegawai</th>
                                        <th class="text-right">Nilai</th>
                                        <th class="text-center">Aksi</th>
                                    </thead>
                                    <tbody>
                                        <?php $chartData = []; ?>
                                        <?php $__currentLoopData = getMonths(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthNumber => $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $any = isset($reports[$monthNumber]);
                                            $total = $any ? $reports[$monthNumber]->total : 0
                                        ?>
                                        <tr>
                                            <td class="text-center"><?php echo e(monthId($monthNumber)); ?></td>
                                            <td class="text-center"><?php echo e($any ? $reports[$monthNumber]->count : 0); ?></td>
                                            <td class="text-right"><?php echo e(number_format($total, 2)); ?> %</td>
                                            <td class="text-center">
                                                <a href="<?php echo e(route('penilaian.monthly', ['month' => $monthNumber, 'year' => $year])); ?>" class="btn btn-default btn-sm">Lihat Bulanan</a>
                                            </td>
                                        </tr>
                                        <?php
                                            $chartData[] = ['month' => monthId($monthNumber), 'value' => $total];
                                        ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('js/vendor/raphael.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/vendor/morris.min.js')); ?>"></script>
<script>
(function() {
    new Morris.Line({
        element: 'yearly-chart',
        data: <?php echo collect($chartData)->toJson(); ?>,
        xkey: 'month',
        ykeys: ['value'],
        labels: ["<?php echo e(__('Pembelian')); ?> Rp"],
        parseTime:false,
        goals: [0],
        goalLineColors : ['red'],
        smooth: true,
        lineWidth: 2,
    });
})();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\WEBDEV\laragon\www\_p_karyawan_rscale\resources\views/backend/pages/penilaian/reports/yearly.blade.php ENDPATH**/ ?>