# Action pull request another repository 
This GitHub Action modifies a package dependency version from the current version to a version in another repository and create a pull request

## Example Workflow
    name: Push File

    on: push

    jobs:
      pull-request:
        runs-on: ubuntu-latest
        steps:
        - name: Checkout
          uses: actions/checkout@v2

        - name: create pull request
          uses: ./.github/actions/update-dep-version
          env:
            API_TOKEN_GITHUB: ${{ secrets.GH_AUTH_TOKEN }}
          with:
            package_name: package-name
            destination_repo: user-name/repository-name
            destination_base_branch: master

## Variables
* package_name: The name of package
* destination_repo: The repository to place the file or directory in.
* user_email: The GitHub user email associated with the API token secret.
* user_name: The GitHub username associated with the API token secret.
* destination_head_branch: The branch to create to push the changes. Cannot be `master` or `main`.
* pull_request_reviewers: [optional] The pull request reviewers. It can be only one (just like 'reviewer') or many (just like 'reviewer1,reviewer2,...')

## ENV
* API_TOKEN_GITHUB: You must create a personal access token in you account. Follow the link:
- [Personal access token](https://docs.github.com/en/free-pro-team@latest/github/authenticating-to-github/creating-a-personal-access-token)

> You must select the scopes: 'repo = Full control of private repositories', 'admin:org = read:org' and 'write:discussion = Read:discussion'; 
