Contributing
============
<img alt="GitHub forks" src="https://img.shields.io/github/forks/IODevBlue/NetworkValidator?label=Forks&color=2CCCE4&style=for-the-badge&labelColor=0109B6"> <img alt="Number of issues" src="https://img.shields.io/github/issues-raw/IODevBlue/NetworkValidator?color=2CCCE4&style=for-the-badge&labelColor=0109B6"> <img alt="Closed issues" src="https://img.shields.io/github/issues-closed-raw/IODevBlue/NetworkValidator?color=2CCCE4&style=for-the-badge&labelColor=0109B6">

<img alt="Number of pull requests" src="https://img.shields.io/github/issues-pr-raw/IODevBlue/NetworkValidator?color=2CCCE4&style=for-the-badge&labelColor=0109B6"> <img alt="Closed pull requests" src="https://img.shields.io/github/issues-pr-closed-raw/IODevBlue/NetworkValidator?color=2CCCE4&style=for-the-badge&labelColor=0109B6">

<img alt="GitHub contributors" src="https://img.shields.io/github/contributors/IODevBlue/NetworkValidator?color=2CCCE4&style=for-the-badge&labelColor=0109B6">

<img alt="Last commit for development" src="https://img.shields.io/github/last-commit/IODevBlue/NetworkValidator/development?color=2CCCE4&style=for-the-badge&labelColor=0109B6">

Current tasks to be completed
-----------------------------
- [ ] NetworkValidator for LiveData
- [ ] NetworkValidator for ReactiveX
- [x] Airplane mode listener

- Have a new feature in mind?
- Want to make changes and improvements to documentations and code?
- Noticed an error?
- Found a bug?

Contributions are welcome and encouraged!!

Make a [fork](https://github.com/IODevBlue/NetworkValidator/fork) of the repository and send a pull request.

Discussions about your code, logical decisions and proposed changes would be made before pushing to the [main](https://github.com/IODevBlue/NetworkValidator/tree/main) repository branch.

Concerning Issues
-----------------
- Before creating an issue, please verify if a pre-existing and similar issue already exists.
- If an issue is closed and problem persists, you can reopen that same issue or create an entirely new issue.
- Persistent bugs can be better illustrated using a unit/integrated test, demo project, JPG/JPEG file, GIF animation, stack traces and logs.

**NOTE:** When posting code blocks, logs or stack traces etc, please use Github flavoured markdown syntax to improve readability.

For Kotlin code blocks, KDoc comments with KDoc syntax are preferable.

Concerning Code Style
---------------------
Consistent indentation plays an important role in readability and maintainability of code.
The indentation currently used in this project is as follows:
```KOTLIN
fun correctIndent() {
	doSomethingHere {
		val x = "some string var"
	}
}
```
Wrong indentation:
```KOTLIN
fun inCorrectIndent() 
{
	doSomethingHere 
	{
		val x = "some string var"
	}
}
```
Please follow the correct indentation style.