// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: peer/transaction.proto

package peer

import (
	common "github.com/hyperledger/fabric-protos-go-apiv2/common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TxValidationCode int32

const (
	TxValidationCode_VALID                        TxValidationCode = 0
	TxValidationCode_NIL_ENVELOPE                 TxValidationCode = 1
	TxValidationCode_BAD_PAYLOAD                  TxValidationCode = 2
	TxValidationCode_BAD_COMMON_HEADER            TxValidationCode = 3
	TxValidationCode_BAD_CREATOR_SIGNATURE        TxValidationCode = 4
	TxValidationCode_INVALID_ENDORSER_TRANSACTION TxValidationCode = 5
	TxValidationCode_INVALID_CONFIG_TRANSACTION   TxValidationCode = 6
	TxValidationCode_UNSUPPORTED_TX_PAYLOAD       TxValidationCode = 7
	TxValidationCode_BAD_PROPOSAL_TXID            TxValidationCode = 8
	TxValidationCode_DUPLICATE_TXID               TxValidationCode = 9
	TxValidationCode_ENDORSEMENT_POLICY_FAILURE   TxValidationCode = 10
	TxValidationCode_MVCC_READ_CONFLICT           TxValidationCode = 11
	TxValidationCode_PHANTOM_READ_CONFLICT        TxValidationCode = 12
	TxValidationCode_UNKNOWN_TX_TYPE              TxValidationCode = 13
	TxValidationCode_TARGET_CHAIN_NOT_FOUND       TxValidationCode = 14
	TxValidationCode_MARSHAL_TX_ERROR             TxValidationCode = 15
	TxValidationCode_NIL_TXACTION                 TxValidationCode = 16
	TxValidationCode_EXPIRED_CHAINCODE            TxValidationCode = 17
	TxValidationCode_CHAINCODE_VERSION_CONFLICT   TxValidationCode = 18
	TxValidationCode_BAD_HEADER_EXTENSION         TxValidationCode = 19
	TxValidationCode_BAD_CHANNEL_HEADER           TxValidationCode = 20
	TxValidationCode_BAD_RESPONSE_PAYLOAD         TxValidationCode = 21
	TxValidationCode_BAD_RWSET                    TxValidationCode = 22
	TxValidationCode_ILLEGAL_WRITESET             TxValidationCode = 23
	TxValidationCode_INVALID_WRITESET             TxValidationCode = 24
	TxValidationCode_INVALID_CHAINCODE            TxValidationCode = 25
	TxValidationCode_NOT_VALIDATED                TxValidationCode = 254
	TxValidationCode_INVALID_OTHER_REASON         TxValidationCode = 255
)

// Enum value maps for TxValidationCode.
var (
	TxValidationCode_name = map[int32]string{
		0:   "VALID",
		1:   "NIL_ENVELOPE",
		2:   "BAD_PAYLOAD",
		3:   "BAD_COMMON_HEADER",
		4:   "BAD_CREATOR_SIGNATURE",
		5:   "INVALID_ENDORSER_TRANSACTION",
		6:   "INVALID_CONFIG_TRANSACTION",
		7:   "UNSUPPORTED_TX_PAYLOAD",
		8:   "BAD_PROPOSAL_TXID",
		9:   "DUPLICATE_TXID",
		10:  "ENDORSEMENT_POLICY_FAILURE",
		11:  "MVCC_READ_CONFLICT",
		12:  "PHANTOM_READ_CONFLICT",
		13:  "UNKNOWN_TX_TYPE",
		14:  "TARGET_CHAIN_NOT_FOUND",
		15:  "MARSHAL_TX_ERROR",
		16:  "NIL_TXACTION",
		17:  "EXPIRED_CHAINCODE",
		18:  "CHAINCODE_VERSION_CONFLICT",
		19:  "BAD_HEADER_EXTENSION",
		20:  "BAD_CHANNEL_HEADER",
		21:  "BAD_RESPONSE_PAYLOAD",
		22:  "BAD_RWSET",
		23:  "ILLEGAL_WRITESET",
		24:  "INVALID_WRITESET",
		25:  "INVALID_CHAINCODE",
		254: "NOT_VALIDATED",
		255: "INVALID_OTHER_REASON",
	}
	TxValidationCode_value = map[string]int32{
		"VALID":                        0,
		"NIL_ENVELOPE":                 1,
		"BAD_PAYLOAD":                  2,
		"BAD_COMMON_HEADER":            3,
		"BAD_CREATOR_SIGNATURE":        4,
		"INVALID_ENDORSER_TRANSACTION": 5,
		"INVALID_CONFIG_TRANSACTION":   6,
		"UNSUPPORTED_TX_PAYLOAD":       7,
		"BAD_PROPOSAL_TXID":            8,
		"DUPLICATE_TXID":               9,
		"ENDORSEMENT_POLICY_FAILURE":   10,
		"MVCC_READ_CONFLICT":           11,
		"PHANTOM_READ_CONFLICT":        12,
		"UNKNOWN_TX_TYPE":              13,
		"TARGET_CHAIN_NOT_FOUND":       14,
		"MARSHAL_TX_ERROR":             15,
		"NIL_TXACTION":                 16,
		"EXPIRED_CHAINCODE":            17,
		"CHAINCODE_VERSION_CONFLICT":   18,
		"BAD_HEADER_EXTENSION":         19,
		"BAD_CHANNEL_HEADER":           20,
		"BAD_RESPONSE_PAYLOAD":         21,
		"BAD_RWSET":                    22,
		"ILLEGAL_WRITESET":             23,
		"INVALID_WRITESET":             24,
		"INVALID_CHAINCODE":            25,
		"NOT_VALIDATED":                254,
		"INVALID_OTHER_REASON":         255,
	}
)

func (x TxValidationCode) Enum() *TxValidationCode {
	p := new(TxValidationCode)
	*p = x
	return p
}

func (x TxValidationCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TxValidationCode) Descriptor() protoreflect.EnumDescriptor {
	return file_peer_transaction_proto_enumTypes[0].Descriptor()
}

func (TxValidationCode) Type() protoreflect.EnumType {
	return &file_peer_transaction_proto_enumTypes[0]
}

func (x TxValidationCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TxValidationCode.Descriptor instead.
func (TxValidationCode) EnumDescriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{0}
}

// Reserved entries in the key-level metadata map
type MetaDataKeys int32

const (
	MetaDataKeys_VALIDATION_PARAMETER    MetaDataKeys = 0
	MetaDataKeys_VALIDATION_PARAMETER_V2 MetaDataKeys = 1
)

// Enum value maps for MetaDataKeys.
var (
	MetaDataKeys_name = map[int32]string{
		0: "VALIDATION_PARAMETER",
		1: "VALIDATION_PARAMETER_V2",
	}
	MetaDataKeys_value = map[string]int32{
		"VALIDATION_PARAMETER":    0,
		"VALIDATION_PARAMETER_V2": 1,
	}
)

func (x MetaDataKeys) Enum() *MetaDataKeys {
	p := new(MetaDataKeys)
	*p = x
	return p
}

func (x MetaDataKeys) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetaDataKeys) Descriptor() protoreflect.EnumDescriptor {
	return file_peer_transaction_proto_enumTypes[1].Descriptor()
}

func (MetaDataKeys) Type() protoreflect.EnumType {
	return &file_peer_transaction_proto_enumTypes[1]
}

func (x MetaDataKeys) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetaDataKeys.Descriptor instead.
func (MetaDataKeys) EnumDescriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{1}
}

// ProcessedTransaction wraps an Envelope that includes a transaction along with an indication
// of whether the transaction was validated or invalidated by committing peer.
// The use case is that GetTransactionByID API needs to retrieve the transaction Envelope
// from block storage, and return it to a client, and indicate whether the transaction
// was validated or invalidated by committing peer. So that the originally submitted
// transaction Envelope is not modified, the ProcessedTransaction wrapper is returned.
type ProcessedTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An Envelope which includes a processed transaction
	TransactionEnvelope *common.Envelope `protobuf:"bytes,1,opt,name=transactionEnvelope,proto3" json:"transactionEnvelope,omitempty"`
	// An indication of whether the transaction was validated or invalidated by committing peer
	ValidationCode int32 `protobuf:"varint,2,opt,name=validationCode,proto3" json:"validationCode,omitempty"`
}

func (x *ProcessedTransaction) Reset() {
	*x = ProcessedTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_transaction_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessedTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessedTransaction) ProtoMessage() {}

func (x *ProcessedTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_transaction_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessedTransaction.ProtoReflect.Descriptor instead.
func (*ProcessedTransaction) Descriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{0}
}

func (x *ProcessedTransaction) GetTransactionEnvelope() *common.Envelope {
	if x != nil {
		return x.TransactionEnvelope
	}
	return nil
}

func (x *ProcessedTransaction) GetValidationCode() int32 {
	if x != nil {
		return x.ValidationCode
	}
	return 0
}

// The transaction to be sent to the ordering service. A transaction contains
// one or more TransactionAction. Each TransactionAction binds a proposal to
// potentially multiple actions. The transaction is atomic meaning that either
// all actions in the transaction will be committed or none will.  Note that
// while a Transaction might include more than one Header, the Header.creator
// field must be the same in each.
// A single client is free to issue a number of independent Proposal, each with
// their header (Header) and request payload (ChaincodeProposalPayload).  Each
// proposal is independently endorsed generating an action
// (ProposalResponsePayload) with one signature per Endorser. Any number of
// independent proposals (and their action) might be included in a transaction
// to ensure that they are treated atomically.
type Transaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The payload is an array of TransactionAction. An array is necessary to
	// accommodate multiple actions per transaction
	Actions []*TransactionAction `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Transaction) Reset() {
	*x = Transaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_transaction_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transaction) ProtoMessage() {}

func (x *Transaction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_transaction_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transaction.ProtoReflect.Descriptor instead.
func (*Transaction) Descriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{1}
}

func (x *Transaction) GetActions() []*TransactionAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

// TransactionAction binds a proposal to its action.  The type field in the
// header dictates the type of action to be applied to the ledger.
type TransactionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header of the proposal action, which is the proposal header
	Header []byte `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The payload of the action as defined by the type in the header For
	// chaincode, it's the bytes of ChaincodeActionPayload
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *TransactionAction) Reset() {
	*x = TransactionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_transaction_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionAction) ProtoMessage() {}

func (x *TransactionAction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_transaction_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionAction.ProtoReflect.Descriptor instead.
func (*TransactionAction) Descriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{2}
}

func (x *TransactionAction) GetHeader() []byte {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *TransactionAction) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// ChaincodeActionPayload is the message to be used for the TransactionAction's
// payload when the Header's type is set to CHAINCODE.  It carries the
// chaincodeProposalPayload and an endorsed action to apply to the ledger.
type ChaincodeActionPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field contains the bytes of the ChaincodeProposalPayload message from
	// the original invocation (essentially the arguments) after the application
	// of the visibility function. The main visibility modes are "full" (the
	// entire ChaincodeProposalPayload message is included here), "hash" (only
	// the hash of the ChaincodeProposalPayload message is included) or
	// "nothing".  This field will be used to check the consistency of
	// ProposalResponsePayload.proposalHash.  For the CHAINCODE type,
	// ProposalResponsePayload.proposalHash is supposed to be H(ProposalHeader ||
	// f(ChaincodeProposalPayload)) where f is the visibility function.
	ChaincodeProposalPayload []byte `protobuf:"bytes,1,opt,name=chaincode_proposal_payload,json=chaincodeProposalPayload,proto3" json:"chaincode_proposal_payload,omitempty"`
	// The list of actions to apply to the ledger
	Action *ChaincodeEndorsedAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *ChaincodeActionPayload) Reset() {
	*x = ChaincodeActionPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_transaction_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeActionPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeActionPayload) ProtoMessage() {}

func (x *ChaincodeActionPayload) ProtoReflect() protoreflect.Message {
	mi := &file_peer_transaction_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeActionPayload.ProtoReflect.Descriptor instead.
func (*ChaincodeActionPayload) Descriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{3}
}

func (x *ChaincodeActionPayload) GetChaincodeProposalPayload() []byte {
	if x != nil {
		return x.ChaincodeProposalPayload
	}
	return nil
}

func (x *ChaincodeActionPayload) GetAction() *ChaincodeEndorsedAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// ChaincodeEndorsedAction carries information about the endorsement of a
// specific proposal
type ChaincodeEndorsedAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the bytes of the ProposalResponsePayload message signed by the
	// endorsers.  Recall that for the CHAINCODE type, the
	// ProposalResponsePayload's extenstion field carries a ChaincodeAction
	ProposalResponsePayload []byte `protobuf:"bytes,1,opt,name=proposal_response_payload,json=proposalResponsePayload,proto3" json:"proposal_response_payload,omitempty"`
	// The endorsement of the proposal, basically the endorser's signature over
	// proposalResponsePayload
	Endorsements []*Endorsement `protobuf:"bytes,2,rep,name=endorsements,proto3" json:"endorsements,omitempty"`
}

func (x *ChaincodeEndorsedAction) Reset() {
	*x = ChaincodeEndorsedAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_transaction_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeEndorsedAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeEndorsedAction) ProtoMessage() {}

func (x *ChaincodeEndorsedAction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_transaction_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeEndorsedAction.ProtoReflect.Descriptor instead.
func (*ChaincodeEndorsedAction) Descriptor() ([]byte, []int) {
	return file_peer_transaction_proto_rawDescGZIP(), []int{4}
}

func (x *ChaincodeEndorsedAction) GetProposalResponsePayload() []byte {
	if x != nil {
		return x.ProposalResponsePayload
	}
	return nil
}

func (x *ChaincodeEndorsedAction) GetEndorsements() []*Endorsement {
	if x != nil {
		return x.Endorsements
	}
	return nil
}

var File_peer_transaction_proto protoreflect.FileDescriptor

var file_peer_transaction_proto_rawDesc = []byte{
	0x0a, 0x16, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x1a, 0x1c, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x13,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x82, 0x01, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x13,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x13, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x12, 0x26, 0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x42, 0x0a, 0x0b, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x45, 0x0a, 0x11,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x22, 0x8f, 0x01, 0x0a, 0x16, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3c,
	0x0a, 0x1a, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x18, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x45,
	0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x17, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x45, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x0a,
	0x0c, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x45, 0x6e, 0x64,
	0x6f, 0x72, 0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x73,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2a, 0xab, 0x05, 0x0a, 0x10, 0x54, 0x78, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x49, 0x4c, 0x5f, 0x45, 0x4e,
	0x56, 0x45, 0x4c, 0x4f, 0x50, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x41, 0x44, 0x5f,
	0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x41, 0x44,
	0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x03,
	0x12, 0x19, 0x0a, 0x15, 0x42, 0x41, 0x44, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x4f, 0x52, 0x5f,
	0x53, 0x49, 0x47, 0x4e, 0x41, 0x54, 0x55, 0x52, 0x45, 0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x45, 0x4e, 0x44, 0x4f, 0x52, 0x53, 0x45, 0x52, 0x5f,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1e, 0x0a,
	0x1a, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x1a, 0x0a,
	0x16, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x58, 0x5f,
	0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x41, 0x44,
	0x5f, 0x50, 0x52, 0x4f, 0x50, 0x4f, 0x53, 0x41, 0x4c, 0x5f, 0x54, 0x58, 0x49, 0x44, 0x10, 0x08,
	0x12, 0x12, 0x0a, 0x0e, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x58,
	0x49, 0x44, 0x10, 0x09, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x4e, 0x44, 0x4f, 0x52, 0x53, 0x45, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55,
	0x52, 0x45, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x56, 0x43, 0x43, 0x5f, 0x52, 0x45, 0x41,
	0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x10, 0x0b, 0x12, 0x19, 0x0a, 0x15,
	0x50, 0x48, 0x41, 0x4e, 0x54, 0x4f, 0x4d, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x4c, 0x49, 0x43, 0x54, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x5f, 0x54, 0x58, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16,
	0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x49, 0x4e, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x41, 0x52, 0x53,
	0x48, 0x41, 0x4c, 0x5f, 0x54, 0x58, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x0f, 0x12, 0x10,
	0x0a, 0x0c, 0x4e, 0x49, 0x4c, 0x5f, 0x54, 0x58, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x10,
	0x12, 0x15, 0x0a, 0x11, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x49,
	0x4e, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x48, 0x41, 0x49, 0x4e,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x4c, 0x49, 0x43, 0x54, 0x10, 0x12, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x41, 0x44, 0x5f, 0x48,
	0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x13, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x41, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x14, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x41, 0x44,
	0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41,
	0x44, 0x10, 0x15, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x41, 0x44, 0x5f, 0x52, 0x57, 0x53, 0x45, 0x54,
	0x10, 0x16, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x57, 0x52,
	0x49, 0x54, 0x45, 0x53, 0x45, 0x54, 0x10, 0x17, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x53, 0x45, 0x54, 0x10, 0x18, 0x12, 0x15,
	0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x49, 0x4e, 0x43,
	0x4f, 0x44, 0x45, 0x10, 0x19, 0x12, 0x12, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0xfe, 0x01, 0x12, 0x19, 0x0a, 0x14, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f,
	0x4e, 0x10, 0xff, 0x01, 0x2a, 0x45, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x10, 0x00, 0x12, 0x1b,
	0x0a, 0x17, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x52,
	0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x56, 0x32, 0x10, 0x01, 0x42, 0xa2, 0x01, 0x0a, 0x22,
	0x6f, 0x72, 0x67, 0x2e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e,
	0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x70, 0x65,
	0x65, 0x72, 0x42, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66,
	0x61, 0x62, 0x72, 0x69, 0x63, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x70, 0x65, 0x65, 0x72, 0xa2, 0x02, 0x03, 0x50, 0x58, 0x58,
	0xaa, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0xca, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0xe2, 0x02, 0x12, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_peer_transaction_proto_rawDescOnce sync.Once
	file_peer_transaction_proto_rawDescData = file_peer_transaction_proto_rawDesc
)

func file_peer_transaction_proto_rawDescGZIP() []byte {
	file_peer_transaction_proto_rawDescOnce.Do(func() {
		file_peer_transaction_proto_rawDescData = protoimpl.X.CompressGZIP(file_peer_transaction_proto_rawDescData)
	})
	return file_peer_transaction_proto_rawDescData
}

var file_peer_transaction_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_peer_transaction_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_peer_transaction_proto_goTypes = []interface{}{
	(TxValidationCode)(0),           // 0: protos.TxValidationCode
	(MetaDataKeys)(0),               // 1: protos.MetaDataKeys
	(*ProcessedTransaction)(nil),    // 2: protos.ProcessedTransaction
	(*Transaction)(nil),             // 3: protos.Transaction
	(*TransactionAction)(nil),       // 4: protos.TransactionAction
	(*ChaincodeActionPayload)(nil),  // 5: protos.ChaincodeActionPayload
	(*ChaincodeEndorsedAction)(nil), // 6: protos.ChaincodeEndorsedAction
	(*common.Envelope)(nil),         // 7: common.Envelope
	(*Endorsement)(nil),             // 8: protos.Endorsement
}
var file_peer_transaction_proto_depIdxs = []int32{
	7, // 0: protos.ProcessedTransaction.transactionEnvelope:type_name -> common.Envelope
	4, // 1: protos.Transaction.actions:type_name -> protos.TransactionAction
	6, // 2: protos.ChaincodeActionPayload.action:type_name -> protos.ChaincodeEndorsedAction
	8, // 3: protos.ChaincodeEndorsedAction.endorsements:type_name -> protos.Endorsement
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_peer_transaction_proto_init() }
func file_peer_transaction_proto_init() {
	if File_peer_transaction_proto != nil {
		return
	}
	file_peer_proposal_response_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_peer_transaction_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessedTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_transaction_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_transaction_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_transaction_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeActionPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_transaction_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeEndorsedAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_peer_transaction_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_peer_transaction_proto_goTypes,
		DependencyIndexes: file_peer_transaction_proto_depIdxs,
		EnumInfos:         file_peer_transaction_proto_enumTypes,
		MessageInfos:      file_peer_transaction_proto_msgTypes,
	}.Build()
	File_peer_transaction_proto = out.File
	file_peer_transaction_proto_rawDesc = nil
	file_peer_transaction_proto_goTypes = nil
	file_peer_transaction_proto_depIdxs = nil
}
