// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: peer/query.proto

package peer

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ChaincodeQueryResponse returns information about each chaincode that pertains
// to a query in lscc.go, such as GetChaincodes (returns all chaincodes
// instantiated on a channel), and GetInstalledChaincodes (returns all chaincodes
// installed on a peer)
type ChaincodeQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Chaincodes []*ChaincodeInfo `protobuf:"bytes,1,rep,name=chaincodes,proto3" json:"chaincodes,omitempty"`
}

func (x *ChaincodeQueryResponse) Reset() {
	*x = ChaincodeQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_query_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeQueryResponse) ProtoMessage() {}

func (x *ChaincodeQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_peer_query_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeQueryResponse.ProtoReflect.Descriptor instead.
func (*ChaincodeQueryResponse) Descriptor() ([]byte, []int) {
	return file_peer_query_proto_rawDescGZIP(), []int{0}
}

func (x *ChaincodeQueryResponse) GetChaincodes() []*ChaincodeInfo {
	if x != nil {
		return x.Chaincodes
	}
	return nil
}

// ChaincodeInfo contains general information about an installed/instantiated
// chaincode
type ChaincodeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// the path as specified by the install/instantiate transaction
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// the chaincode function upon instantiation and its arguments. This will be
	// blank if the query is returning information about installed chaincodes.
	Input string `protobuf:"bytes,4,opt,name=input,proto3" json:"input,omitempty"`
	// the name of the ESCC for this chaincode. This will be
	// blank if the query is returning information about installed chaincodes.
	Escc string `protobuf:"bytes,5,opt,name=escc,proto3" json:"escc,omitempty"`
	// the name of the VSCC for this chaincode. This will be
	// blank if the query is returning information about installed chaincodes.
	Vscc string `protobuf:"bytes,6,opt,name=vscc,proto3" json:"vscc,omitempty"`
	// the chaincode unique id.
	// computed as: H(
	//
	//	  H(name || version) ||
	//	  H(CodePackage)
	//	)
	Id []byte `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ChaincodeInfo) Reset() {
	*x = ChaincodeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_query_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeInfo) ProtoMessage() {}

func (x *ChaincodeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_peer_query_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeInfo.ProtoReflect.Descriptor instead.
func (*ChaincodeInfo) Descriptor() ([]byte, []int) {
	return file_peer_query_proto_rawDescGZIP(), []int{1}
}

func (x *ChaincodeInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChaincodeInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ChaincodeInfo) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ChaincodeInfo) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

func (x *ChaincodeInfo) GetEscc() string {
	if x != nil {
		return x.Escc
	}
	return ""
}

func (x *ChaincodeInfo) GetVscc() string {
	if x != nil {
		return x.Vscc
	}
	return ""
}

func (x *ChaincodeInfo) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

// ChannelQueryResponse returns information about each channel that pertains
// to a query in lscc.go, such as GetChannels (returns all channels for a
// given peer)
type ChannelQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Channels []*ChannelInfo `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *ChannelQueryResponse) Reset() {
	*x = ChannelQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_query_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelQueryResponse) ProtoMessage() {}

func (x *ChannelQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_peer_query_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelQueryResponse.ProtoReflect.Descriptor instead.
func (*ChannelQueryResponse) Descriptor() ([]byte, []int) {
	return file_peer_query_proto_rawDescGZIP(), []int{2}
}

func (x *ChannelQueryResponse) GetChannels() []*ChannelInfo {
	if x != nil {
		return x.Channels
	}
	return nil
}

// ChannelInfo contains general information about channels
type ChannelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
}

func (x *ChannelInfo) Reset() {
	*x = ChannelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_query_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelInfo) ProtoMessage() {}

func (x *ChannelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_peer_query_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelInfo.ProtoReflect.Descriptor instead.
func (*ChannelInfo) Descriptor() ([]byte, []int) {
	return file_peer_query_proto_rawDescGZIP(), []int{3}
}

func (x *ChannelInfo) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

// JoinBySnapshotStatus contains information about whether or a JoinBySnapshot operation
// is in progress and the related bootstrap dir if it is running.
type JoinBySnapshotStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InProgress               bool   `protobuf:"varint,1,opt,name=in_progress,json=inProgress,proto3" json:"in_progress,omitempty"`
	BootstrappingSnapshotDir string `protobuf:"bytes,2,opt,name=bootstrapping_snapshot_dir,json=bootstrappingSnapshotDir,proto3" json:"bootstrapping_snapshot_dir,omitempty"`
}

func (x *JoinBySnapshotStatus) Reset() {
	*x = JoinBySnapshotStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_query_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JoinBySnapshotStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinBySnapshotStatus) ProtoMessage() {}

func (x *JoinBySnapshotStatus) ProtoReflect() protoreflect.Message {
	mi := &file_peer_query_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinBySnapshotStatus.ProtoReflect.Descriptor instead.
func (*JoinBySnapshotStatus) Descriptor() ([]byte, []int) {
	return file_peer_query_proto_rawDescGZIP(), []int{4}
}

func (x *JoinBySnapshotStatus) GetInProgress() bool {
	if x != nil {
		return x.InProgress
	}
	return false
}

func (x *JoinBySnapshotStatus) GetBootstrappingSnapshotDir() string {
	if x != nil {
		return x.BootstrappingSnapshotDir
	}
	return ""
}

var File_peer_query_proto protoreflect.FileDescriptor

var file_peer_query_proto_rawDesc = []byte{
	0x0a, 0x10, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x22, 0x4f, 0x0a, 0x16, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x9f, 0x01, 0x0a, 0x0d,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x14, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x73, 0x63, 0x63, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x73, 0x63, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x73, 0x63,
	0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x73, 0x63, 0x63, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x64, 0x22, 0x47, 0x0a,
	0x14, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x22, 0x2c, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x49, 0x64, 0x22, 0x75, 0x0a, 0x14, 0x4a, 0x6f, 0x69, 0x6e, 0x42, 0x79, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3c, 0x0a,
	0x1a, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x18, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x42, 0x9c, 0x01, 0x0a, 0x22,
	0x6f, 0x72, 0x67, 0x2e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e,
	0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x70, 0x65,
	0x65, 0x72, 0x42, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70,
	0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2d,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x70, 0x65, 0x65, 0x72, 0xa2, 0x02, 0x03, 0x50, 0x58, 0x58, 0xaa, 0x02, 0x06, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0xca, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0xe2, 0x02, 0x12, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xea, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_peer_query_proto_rawDescOnce sync.Once
	file_peer_query_proto_rawDescData = file_peer_query_proto_rawDesc
)

func file_peer_query_proto_rawDescGZIP() []byte {
	file_peer_query_proto_rawDescOnce.Do(func() {
		file_peer_query_proto_rawDescData = protoimpl.X.CompressGZIP(file_peer_query_proto_rawDescData)
	})
	return file_peer_query_proto_rawDescData
}

var file_peer_query_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_peer_query_proto_goTypes = []interface{}{
	(*ChaincodeQueryResponse)(nil), // 0: protos.ChaincodeQueryResponse
	(*ChaincodeInfo)(nil),          // 1: protos.ChaincodeInfo
	(*ChannelQueryResponse)(nil),   // 2: protos.ChannelQueryResponse
	(*ChannelInfo)(nil),            // 3: protos.ChannelInfo
	(*JoinBySnapshotStatus)(nil),   // 4: protos.JoinBySnapshotStatus
}
var file_peer_query_proto_depIdxs = []int32{
	1, // 0: protos.ChaincodeQueryResponse.chaincodes:type_name -> protos.ChaincodeInfo
	3, // 1: protos.ChannelQueryResponse.channels:type_name -> protos.ChannelInfo
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_peer_query_proto_init() }
func file_peer_query_proto_init() {
	if File_peer_query_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_peer_query_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_query_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_query_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_query_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_query_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JoinBySnapshotStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_peer_query_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_peer_query_proto_goTypes,
		DependencyIndexes: file_peer_query_proto_depIdxs,
		MessageInfos:      file_peer_query_proto_msgTypes,
	}.Build()
	File_peer_query_proto = out.File
	file_peer_query_proto_rawDesc = nil
	file_peer_query_proto_goTypes = nil
	file_peer_query_proto_depIdxs = nil
}
