// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: peer/events.proto

package peer

import (
	common "github.com/hyperledger/fabric-protos-go-apiv2/common"
	rwset "github.com/hyperledger/fabric-protos-go-apiv2/ledger/rwset"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// FilteredBlock is a minimal set of information about a block
type FilteredBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChannelId            string                 `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	Number               uint64                 `protobuf:"varint,2,opt,name=number,proto3" json:"number,omitempty"` // The position in the blockchain
	FilteredTransactions []*FilteredTransaction `protobuf:"bytes,4,rep,name=filtered_transactions,json=filteredTransactions,proto3" json:"filtered_transactions,omitempty"`
}

func (x *FilteredBlock) Reset() {
	*x = FilteredBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilteredBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilteredBlock) ProtoMessage() {}

func (x *FilteredBlock) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilteredBlock.ProtoReflect.Descriptor instead.
func (*FilteredBlock) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{0}
}

func (x *FilteredBlock) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *FilteredBlock) GetNumber() uint64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *FilteredBlock) GetFilteredTransactions() []*FilteredTransaction {
	if x != nil {
		return x.FilteredTransactions
	}
	return nil
}

// FilteredTransaction is a minimal set of information about a transaction
// within a block
type FilteredTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Txid             string            `protobuf:"bytes,1,opt,name=txid,proto3" json:"txid,omitempty"`
	Type             common.HeaderType `protobuf:"varint,2,opt,name=type,proto3,enum=common.HeaderType" json:"type,omitempty"`
	TxValidationCode TxValidationCode  `protobuf:"varint,3,opt,name=tx_validation_code,json=txValidationCode,proto3,enum=protos.TxValidationCode" json:"tx_validation_code,omitempty"`
	// Types that are assignable to Data:
	//
	//	*FilteredTransaction_TransactionActions
	Data isFilteredTransaction_Data `protobuf_oneof:"Data"`
}

func (x *FilteredTransaction) Reset() {
	*x = FilteredTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilteredTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilteredTransaction) ProtoMessage() {}

func (x *FilteredTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilteredTransaction.ProtoReflect.Descriptor instead.
func (*FilteredTransaction) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{1}
}

func (x *FilteredTransaction) GetTxid() string {
	if x != nil {
		return x.Txid
	}
	return ""
}

func (x *FilteredTransaction) GetType() common.HeaderType {
	if x != nil {
		return x.Type
	}
	return common.HeaderType(0)
}

func (x *FilteredTransaction) GetTxValidationCode() TxValidationCode {
	if x != nil {
		return x.TxValidationCode
	}
	return TxValidationCode_VALID
}

func (m *FilteredTransaction) GetData() isFilteredTransaction_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *FilteredTransaction) GetTransactionActions() *FilteredTransactionActions {
	if x, ok := x.GetData().(*FilteredTransaction_TransactionActions); ok {
		return x.TransactionActions
	}
	return nil
}

type isFilteredTransaction_Data interface {
	isFilteredTransaction_Data()
}

type FilteredTransaction_TransactionActions struct {
	TransactionActions *FilteredTransactionActions `protobuf:"bytes,4,opt,name=transaction_actions,json=transactionActions,proto3,oneof"`
}

func (*FilteredTransaction_TransactionActions) isFilteredTransaction_Data() {}

// FilteredTransactionActions is a wrapper for array of TransactionAction
// message from regular block
type FilteredTransactionActions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChaincodeActions []*FilteredChaincodeAction `protobuf:"bytes,1,rep,name=chaincode_actions,json=chaincodeActions,proto3" json:"chaincode_actions,omitempty"`
}

func (x *FilteredTransactionActions) Reset() {
	*x = FilteredTransactionActions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilteredTransactionActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilteredTransactionActions) ProtoMessage() {}

func (x *FilteredTransactionActions) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilteredTransactionActions.ProtoReflect.Descriptor instead.
func (*FilteredTransactionActions) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{2}
}

func (x *FilteredTransactionActions) GetChaincodeActions() []*FilteredChaincodeAction {
	if x != nil {
		return x.ChaincodeActions
	}
	return nil
}

// FilteredChaincodeAction is a minimal set of information about an action
// within a transaction
type FilteredChaincodeAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChaincodeEvent *ChaincodeEvent `protobuf:"bytes,1,opt,name=chaincode_event,json=chaincodeEvent,proto3" json:"chaincode_event,omitempty"`
}

func (x *FilteredChaincodeAction) Reset() {
	*x = FilteredChaincodeAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilteredChaincodeAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilteredChaincodeAction) ProtoMessage() {}

func (x *FilteredChaincodeAction) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilteredChaincodeAction.ProtoReflect.Descriptor instead.
func (*FilteredChaincodeAction) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{3}
}

func (x *FilteredChaincodeAction) GetChaincodeEvent() *ChaincodeEvent {
	if x != nil {
		return x.ChaincodeEvent
	}
	return nil
}

// BlockAndPrivateData contains Block and a map from tx_seq_in_block to rwset.TxPvtReadWriteSet
type BlockAndPrivateData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *common.Block `protobuf:"bytes,1,opt,name=block,proto3" json:"block,omitempty"`
	// map from tx_seq_in_block to rwset.TxPvtReadWriteSet
	PrivateDataMap map[uint64]*rwset.TxPvtReadWriteSet `protobuf:"bytes,2,rep,name=private_data_map,json=privateDataMap,proto3" json:"private_data_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BlockAndPrivateData) Reset() {
	*x = BlockAndPrivateData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockAndPrivateData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockAndPrivateData) ProtoMessage() {}

func (x *BlockAndPrivateData) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockAndPrivateData.ProtoReflect.Descriptor instead.
func (*BlockAndPrivateData) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{4}
}

func (x *BlockAndPrivateData) GetBlock() *common.Block {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *BlockAndPrivateData) GetPrivateDataMap() map[uint64]*rwset.TxPvtReadWriteSet {
	if x != nil {
		return x.PrivateDataMap
	}
	return nil
}

// DeliverResponse
type DeliverResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*DeliverResponse_Status
	//	*DeliverResponse_Block
	//	*DeliverResponse_FilteredBlock
	//	*DeliverResponse_BlockAndPrivateData
	Type isDeliverResponse_Type `protobuf_oneof:"Type"`
}

func (x *DeliverResponse) Reset() {
	*x = DeliverResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_events_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeliverResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliverResponse) ProtoMessage() {}

func (x *DeliverResponse) ProtoReflect() protoreflect.Message {
	mi := &file_peer_events_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliverResponse.ProtoReflect.Descriptor instead.
func (*DeliverResponse) Descriptor() ([]byte, []int) {
	return file_peer_events_proto_rawDescGZIP(), []int{5}
}

func (m *DeliverResponse) GetType() isDeliverResponse_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *DeliverResponse) GetStatus() common.Status {
	if x, ok := x.GetType().(*DeliverResponse_Status); ok {
		return x.Status
	}
	return common.Status(0)
}

func (x *DeliverResponse) GetBlock() *common.Block {
	if x, ok := x.GetType().(*DeliverResponse_Block); ok {
		return x.Block
	}
	return nil
}

func (x *DeliverResponse) GetFilteredBlock() *FilteredBlock {
	if x, ok := x.GetType().(*DeliverResponse_FilteredBlock); ok {
		return x.FilteredBlock
	}
	return nil
}

func (x *DeliverResponse) GetBlockAndPrivateData() *BlockAndPrivateData {
	if x, ok := x.GetType().(*DeliverResponse_BlockAndPrivateData); ok {
		return x.BlockAndPrivateData
	}
	return nil
}

type isDeliverResponse_Type interface {
	isDeliverResponse_Type()
}

type DeliverResponse_Status struct {
	Status common.Status `protobuf:"varint,1,opt,name=status,proto3,enum=common.Status,oneof"`
}

type DeliverResponse_Block struct {
	Block *common.Block `protobuf:"bytes,2,opt,name=block,proto3,oneof"`
}

type DeliverResponse_FilteredBlock struct {
	FilteredBlock *FilteredBlock `protobuf:"bytes,3,opt,name=filtered_block,json=filteredBlock,proto3,oneof"`
}

type DeliverResponse_BlockAndPrivateData struct {
	BlockAndPrivateData *BlockAndPrivateData `protobuf:"bytes,4,opt,name=block_and_private_data,json=blockAndPrivateData,proto3,oneof"`
}

func (*DeliverResponse_Status) isDeliverResponse_Type() {}

func (*DeliverResponse_Block) isDeliverResponse_Type() {}

func (*DeliverResponse_FilteredBlock) isDeliverResponse_Type() {}

func (*DeliverResponse_BlockAndPrivateData) isDeliverResponse_Type() {}

var File_peer_events_proto protoreflect.FileDescriptor

var file_peer_events_proto_rawDesc = []byte{
	0x0a, 0x11, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x1a, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x18, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2f, 0x72,
	0x77, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x70, 0x65, 0x65, 0x72,
	0x2f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x98,
	0x01, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x50, 0x0a, 0x15, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf8, 0x01, 0x0a, 0x13, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x78, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a,
	0x12, 0x74, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x54, 0x78, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x10, 0x74, 0x78, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x55, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x06, 0x0a, 0x04,
	0x44, 0x61, 0x74, 0x61, 0x22, 0x6a, 0x0a, 0x1a, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x11, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x43,
	0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x5a, 0x0a, 0x17, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0f, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xf2, 0x01, 0x0a,
	0x13, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x59, 0x0a, 0x10, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x4d, 0x61, 0x70, 0x1a, 0x5b, 0x0a, 0x13, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x72,
	0x77, 0x73, 0x65, 0x74, 0x2e, 0x54, 0x78, 0x50, 0x76, 0x74, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xfe, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x25, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x48, 0x00, 0x52,
	0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3e, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x65, 0x64, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65,
	0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x52, 0x0a, 0x16, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x61, 0x6e, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x13, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x42, 0x06, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x32, 0xd4, 0x01, 0x0a, 0x07, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x12, 0x3a,
	0x0a, 0x07, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x12, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x1a, 0x17, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x42, 0x0a, 0x0f, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x12, 0x10, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x1a,
	0x17, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x49,
	0x0a, 0x16, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x57, 0x69, 0x74, 0x68, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x1a, 0x17, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x9d, 0x01, 0x0a, 0x22, 0x6f, 0x72,
	0x67, 0x2e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66, 0x61,
	0x62, 0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x42, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70, 0x65,
	0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2d, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x70,
	0x65, 0x65, 0x72, 0xa2, 0x02, 0x03, 0x50, 0x58, 0x58, 0xaa, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0xca, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0xe2, 0x02, 0x12, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xea, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_peer_events_proto_rawDescOnce sync.Once
	file_peer_events_proto_rawDescData = file_peer_events_proto_rawDesc
)

func file_peer_events_proto_rawDescGZIP() []byte {
	file_peer_events_proto_rawDescOnce.Do(func() {
		file_peer_events_proto_rawDescData = protoimpl.X.CompressGZIP(file_peer_events_proto_rawDescData)
	})
	return file_peer_events_proto_rawDescData
}

var file_peer_events_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_peer_events_proto_goTypes = []interface{}{
	(*FilteredBlock)(nil),              // 0: protos.FilteredBlock
	(*FilteredTransaction)(nil),        // 1: protos.FilteredTransaction
	(*FilteredTransactionActions)(nil), // 2: protos.FilteredTransactionActions
	(*FilteredChaincodeAction)(nil),    // 3: protos.FilteredChaincodeAction
	(*BlockAndPrivateData)(nil),        // 4: protos.BlockAndPrivateData
	(*DeliverResponse)(nil),            // 5: protos.DeliverResponse
	nil,                                // 6: protos.BlockAndPrivateData.PrivateDataMapEntry
	(common.HeaderType)(0),             // 7: common.HeaderType
	(TxValidationCode)(0),              // 8: protos.TxValidationCode
	(*ChaincodeEvent)(nil),             // 9: protos.ChaincodeEvent
	(*common.Block)(nil),               // 10: common.Block
	(common.Status)(0),                 // 11: common.Status
	(*rwset.TxPvtReadWriteSet)(nil),    // 12: rwset.TxPvtReadWriteSet
	(*common.Envelope)(nil),            // 13: common.Envelope
}
var file_peer_events_proto_depIdxs = []int32{
	1,  // 0: protos.FilteredBlock.filtered_transactions:type_name -> protos.FilteredTransaction
	7,  // 1: protos.FilteredTransaction.type:type_name -> common.HeaderType
	8,  // 2: protos.FilteredTransaction.tx_validation_code:type_name -> protos.TxValidationCode
	2,  // 3: protos.FilteredTransaction.transaction_actions:type_name -> protos.FilteredTransactionActions
	3,  // 4: protos.FilteredTransactionActions.chaincode_actions:type_name -> protos.FilteredChaincodeAction
	9,  // 5: protos.FilteredChaincodeAction.chaincode_event:type_name -> protos.ChaincodeEvent
	10, // 6: protos.BlockAndPrivateData.block:type_name -> common.Block
	6,  // 7: protos.BlockAndPrivateData.private_data_map:type_name -> protos.BlockAndPrivateData.PrivateDataMapEntry
	11, // 8: protos.DeliverResponse.status:type_name -> common.Status
	10, // 9: protos.DeliverResponse.block:type_name -> common.Block
	0,  // 10: protos.DeliverResponse.filtered_block:type_name -> protos.FilteredBlock
	4,  // 11: protos.DeliverResponse.block_and_private_data:type_name -> protos.BlockAndPrivateData
	12, // 12: protos.BlockAndPrivateData.PrivateDataMapEntry.value:type_name -> rwset.TxPvtReadWriteSet
	13, // 13: protos.Deliver.Deliver:input_type -> common.Envelope
	13, // 14: protos.Deliver.DeliverFiltered:input_type -> common.Envelope
	13, // 15: protos.Deliver.DeliverWithPrivateData:input_type -> common.Envelope
	5,  // 16: protos.Deliver.Deliver:output_type -> protos.DeliverResponse
	5,  // 17: protos.Deliver.DeliverFiltered:output_type -> protos.DeliverResponse
	5,  // 18: protos.Deliver.DeliverWithPrivateData:output_type -> protos.DeliverResponse
	16, // [16:19] is the sub-list for method output_type
	13, // [13:16] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_peer_events_proto_init() }
func file_peer_events_proto_init() {
	if File_peer_events_proto != nil {
		return
	}
	file_peer_chaincode_event_proto_init()
	file_peer_transaction_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_peer_events_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilteredBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_events_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilteredTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_events_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilteredTransactionActions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_events_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilteredChaincodeAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_events_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockAndPrivateData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_events_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeliverResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_peer_events_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*FilteredTransaction_TransactionActions)(nil),
	}
	file_peer_events_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*DeliverResponse_Status)(nil),
		(*DeliverResponse_Block)(nil),
		(*DeliverResponse_FilteredBlock)(nil),
		(*DeliverResponse_BlockAndPrivateData)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_peer_events_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_peer_events_proto_goTypes,
		DependencyIndexes: file_peer_events_proto_depIdxs,
		MessageInfos:      file_peer_events_proto_msgTypes,
	}.Build()
	File_peer_events_proto = out.File
	file_peer_events_proto_rawDesc = nil
	file_peer_events_proto_goTypes = nil
	file_peer_events_proto_depIdxs = nil
}
