// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: peer/chaincode_shim.proto

package peer

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ChaincodeMessage_Type int32

const (
	ChaincodeMessage_UNDEFINED             ChaincodeMessage_Type = 0
	ChaincodeMessage_REGISTER              ChaincodeMessage_Type = 1
	ChaincodeMessage_REGISTERED            ChaincodeMessage_Type = 2
	ChaincodeMessage_INIT                  ChaincodeMessage_Type = 3
	ChaincodeMessage_READY                 ChaincodeMessage_Type = 4
	ChaincodeMessage_TRANSACTION           ChaincodeMessage_Type = 5
	ChaincodeMessage_COMPLETED             ChaincodeMessage_Type = 6
	ChaincodeMessage_ERROR                 ChaincodeMessage_Type = 7
	ChaincodeMessage_GET_STATE             ChaincodeMessage_Type = 8
	ChaincodeMessage_PUT_STATE             ChaincodeMessage_Type = 9
	ChaincodeMessage_DEL_STATE             ChaincodeMessage_Type = 10
	ChaincodeMessage_INVOKE_CHAINCODE      ChaincodeMessage_Type = 11
	ChaincodeMessage_RESPONSE              ChaincodeMessage_Type = 13
	ChaincodeMessage_GET_STATE_BY_RANGE    ChaincodeMessage_Type = 14
	ChaincodeMessage_GET_QUERY_RESULT      ChaincodeMessage_Type = 15
	ChaincodeMessage_QUERY_STATE_NEXT      ChaincodeMessage_Type = 16
	ChaincodeMessage_QUERY_STATE_CLOSE     ChaincodeMessage_Type = 17
	ChaincodeMessage_KEEPALIVE             ChaincodeMessage_Type = 18
	ChaincodeMessage_GET_HISTORY_FOR_KEY   ChaincodeMessage_Type = 19
	ChaincodeMessage_GET_STATE_METADATA    ChaincodeMessage_Type = 20
	ChaincodeMessage_PUT_STATE_METADATA    ChaincodeMessage_Type = 21
	ChaincodeMessage_GET_PRIVATE_DATA_HASH ChaincodeMessage_Type = 22
	ChaincodeMessage_PURGE_PRIVATE_DATA    ChaincodeMessage_Type = 23
)

// Enum value maps for ChaincodeMessage_Type.
var (
	ChaincodeMessage_Type_name = map[int32]string{
		0:  "UNDEFINED",
		1:  "REGISTER",
		2:  "REGISTERED",
		3:  "INIT",
		4:  "READY",
		5:  "TRANSACTION",
		6:  "COMPLETED",
		7:  "ERROR",
		8:  "GET_STATE",
		9:  "PUT_STATE",
		10: "DEL_STATE",
		11: "INVOKE_CHAINCODE",
		13: "RESPONSE",
		14: "GET_STATE_BY_RANGE",
		15: "GET_QUERY_RESULT",
		16: "QUERY_STATE_NEXT",
		17: "QUERY_STATE_CLOSE",
		18: "KEEPALIVE",
		19: "GET_HISTORY_FOR_KEY",
		20: "GET_STATE_METADATA",
		21: "PUT_STATE_METADATA",
		22: "GET_PRIVATE_DATA_HASH",
		23: "PURGE_PRIVATE_DATA",
	}
	ChaincodeMessage_Type_value = map[string]int32{
		"UNDEFINED":             0,
		"REGISTER":              1,
		"REGISTERED":            2,
		"INIT":                  3,
		"READY":                 4,
		"TRANSACTION":           5,
		"COMPLETED":             6,
		"ERROR":                 7,
		"GET_STATE":             8,
		"PUT_STATE":             9,
		"DEL_STATE":             10,
		"INVOKE_CHAINCODE":      11,
		"RESPONSE":              13,
		"GET_STATE_BY_RANGE":    14,
		"GET_QUERY_RESULT":      15,
		"QUERY_STATE_NEXT":      16,
		"QUERY_STATE_CLOSE":     17,
		"KEEPALIVE":             18,
		"GET_HISTORY_FOR_KEY":   19,
		"GET_STATE_METADATA":    20,
		"PUT_STATE_METADATA":    21,
		"GET_PRIVATE_DATA_HASH": 22,
		"PURGE_PRIVATE_DATA":    23,
	}
)

func (x ChaincodeMessage_Type) Enum() *ChaincodeMessage_Type {
	p := new(ChaincodeMessage_Type)
	*p = x
	return p
}

func (x ChaincodeMessage_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChaincodeMessage_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_peer_chaincode_shim_proto_enumTypes[0].Descriptor()
}

func (ChaincodeMessage_Type) Type() protoreflect.EnumType {
	return &file_peer_chaincode_shim_proto_enumTypes[0]
}

func (x ChaincodeMessage_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChaincodeMessage_Type.Descriptor instead.
func (ChaincodeMessage_Type) EnumDescriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{0, 0}
}

type ChaincodeMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type      ChaincodeMessage_Type  `protobuf:"varint,1,opt,name=type,proto3,enum=protos.ChaincodeMessage_Type" json:"type,omitempty"`
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Payload   []byte                 `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	Txid      string                 `protobuf:"bytes,4,opt,name=txid,proto3" json:"txid,omitempty"`
	Proposal  *SignedProposal        `protobuf:"bytes,5,opt,name=proposal,proto3" json:"proposal,omitempty"`
	// event emitted by chaincode. Used only with Init or Invoke.
	// This event is then stored (currently)
	// with Block.NonHashData.TransactionResult
	ChaincodeEvent *ChaincodeEvent `protobuf:"bytes,6,opt,name=chaincode_event,json=chaincodeEvent,proto3" json:"chaincode_event,omitempty"`
	// channel id
	ChannelId string `protobuf:"bytes,7,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
}

func (x *ChaincodeMessage) Reset() {
	*x = ChaincodeMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeMessage) ProtoMessage() {}

func (x *ChaincodeMessage) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeMessage.ProtoReflect.Descriptor instead.
func (*ChaincodeMessage) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{0}
}

func (x *ChaincodeMessage) GetType() ChaincodeMessage_Type {
	if x != nil {
		return x.Type
	}
	return ChaincodeMessage_UNDEFINED
}

func (x *ChaincodeMessage) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *ChaincodeMessage) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *ChaincodeMessage) GetTxid() string {
	if x != nil {
		return x.Txid
	}
	return ""
}

func (x *ChaincodeMessage) GetProposal() *SignedProposal {
	if x != nil {
		return x.Proposal
	}
	return nil
}

func (x *ChaincodeMessage) GetChaincodeEvent() *ChaincodeEvent {
	if x != nil {
		return x.ChaincodeEvent
	}
	return nil
}

func (x *ChaincodeMessage) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

// GetState is the payload of a ChaincodeMessage. It contains a key which
// is to be fetched from the ledger. If the collection is specified, the key
// would be fetched from the collection (i.e., private state)
type GetState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *GetState) Reset() {
	*x = GetState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetState) ProtoMessage() {}

func (x *GetState) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetState.ProtoReflect.Descriptor instead.
func (*GetState) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{1}
}

func (x *GetState) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *GetState) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

type GetStateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *GetStateMetadata) Reset() {
	*x = GetStateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStateMetadata) ProtoMessage() {}

func (x *GetStateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStateMetadata.ProtoReflect.Descriptor instead.
func (*GetStateMetadata) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{2}
}

func (x *GetStateMetadata) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *GetStateMetadata) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

// PutState is the payload of a ChaincodeMessage. It contains a key and value
// which needs to be written to the transaction's write set. If the collection is
// specified, the key and value would be written to the transaction's private
// write set.
type PutState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value      []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Collection string `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *PutState) Reset() {
	*x = PutState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutState) ProtoMessage() {}

func (x *PutState) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutState.ProtoReflect.Descriptor instead.
func (*PutState) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{3}
}

func (x *PutState) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PutState) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PutState) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

type PutStateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string         `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection string         `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata   *StateMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PutStateMetadata) Reset() {
	*x = PutStateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutStateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutStateMetadata) ProtoMessage() {}

func (x *PutStateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutStateMetadata.ProtoReflect.Descriptor instead.
func (*PutStateMetadata) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{4}
}

func (x *PutStateMetadata) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PutStateMetadata) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *PutStateMetadata) GetMetadata() *StateMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// DelState is the payload of a ChaincodeMessage. It contains a key which
// needs to be recorded in the transaction's write set as a delete operation.
// If the collection is specified, the key needs to be recorded in the
// transaction's private write set as a delete operation.
type DelState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *DelState) Reset() {
	*x = DelState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelState) ProtoMessage() {}

func (x *DelState) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelState.ProtoReflect.Descriptor instead.
func (*DelState) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{5}
}

func (x *DelState) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DelState) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

type PurgePrivateState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key        string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
}

func (x *PurgePrivateState) Reset() {
	*x = PurgePrivateState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgePrivateState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgePrivateState) ProtoMessage() {}

func (x *PurgePrivateState) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgePrivateState.ProtoReflect.Descriptor instead.
func (*PurgePrivateState) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{6}
}

func (x *PurgePrivateState) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PurgePrivateState) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

// GetStateByRange is the payload of a ChaincodeMessage. It contains a start key and
// a end key required to execute range query. If the collection is specified,
// the range query needs to be executed on the private data. The metadata hold
// the byte representation of QueryMetadata.
type GetStateByRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartKey   string `protobuf:"bytes,1,opt,name=startKey,proto3" json:"startKey,omitempty"`
	EndKey     string `protobuf:"bytes,2,opt,name=endKey,proto3" json:"endKey,omitempty"`
	Collection string `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata   []byte `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *GetStateByRange) Reset() {
	*x = GetStateByRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStateByRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStateByRange) ProtoMessage() {}

func (x *GetStateByRange) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStateByRange.ProtoReflect.Descriptor instead.
func (*GetStateByRange) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{7}
}

func (x *GetStateByRange) GetStartKey() string {
	if x != nil {
		return x.StartKey
	}
	return ""
}

func (x *GetStateByRange) GetEndKey() string {
	if x != nil {
		return x.EndKey
	}
	return ""
}

func (x *GetStateByRange) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *GetStateByRange) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// GetQueryResult is the payload of a ChaincodeMessage. It contains a query
// string in the form that is supported by the underlying state database.
// If the collection is specified, the query needs to be executed on the
// private data.  The metadata hold the byte representation of QueryMetadata.
type GetQueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Query      string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata   []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *GetQueryResult) Reset() {
	*x = GetQueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetQueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQueryResult) ProtoMessage() {}

func (x *GetQueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQueryResult.ProtoReflect.Descriptor instead.
func (*GetQueryResult) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{8}
}

func (x *GetQueryResult) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *GetQueryResult) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *GetQueryResult) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// QueryMetadata is the metadata of a GetStateByRange and GetQueryResult.
// It contains a pageSize which denotes the number of records to be fetched
// and a bookmark.
type QueryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PageSize int32  `protobuf:"varint,1,opt,name=pageSize,proto3" json:"pageSize,omitempty"`
	Bookmark string `protobuf:"bytes,2,opt,name=bookmark,proto3" json:"bookmark,omitempty"`
}

func (x *QueryMetadata) Reset() {
	*x = QueryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetadata) ProtoMessage() {}

func (x *QueryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetadata.ProtoReflect.Descriptor instead.
func (*QueryMetadata) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{9}
}

func (x *QueryMetadata) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryMetadata) GetBookmark() string {
	if x != nil {
		return x.Bookmark
	}
	return ""
}

// GetHistoryForKey is the payload of a ChaincodeMessage. It contains a key
// for which the historical values need to be retrieved.
type GetHistoryForKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *GetHistoryForKey) Reset() {
	*x = GetHistoryForKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetHistoryForKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHistoryForKey) ProtoMessage() {}

func (x *GetHistoryForKey) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHistoryForKey.ProtoReflect.Descriptor instead.
func (*GetHistoryForKey) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{10}
}

func (x *GetHistoryForKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type QueryStateNext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *QueryStateNext) Reset() {
	*x = QueryStateNext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryStateNext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStateNext) ProtoMessage() {}

func (x *QueryStateNext) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStateNext.ProtoReflect.Descriptor instead.
func (*QueryStateNext) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{11}
}

func (x *QueryStateNext) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type QueryStateClose struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *QueryStateClose) Reset() {
	*x = QueryStateClose{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryStateClose) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStateClose) ProtoMessage() {}

func (x *QueryStateClose) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStateClose.ProtoReflect.Descriptor instead.
func (*QueryStateClose) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{12}
}

func (x *QueryStateClose) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// QueryResultBytes hold the byte representation of a record returned by the peer.
type QueryResultBytes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResultBytes []byte `protobuf:"bytes,1,opt,name=resultBytes,proto3" json:"resultBytes,omitempty"`
}

func (x *QueryResultBytes) Reset() {
	*x = QueryResultBytes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResultBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResultBytes) ProtoMessage() {}

func (x *QueryResultBytes) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResultBytes.ProtoReflect.Descriptor instead.
func (*QueryResultBytes) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{13}
}

func (x *QueryResultBytes) GetResultBytes() []byte {
	if x != nil {
		return x.ResultBytes
	}
	return nil
}

// QueryResponse is returned by the peer as a result of a GetStateByRange,
// GetQueryResult, and GetHistoryForKey. It holds a bunch of records in
// results field, a flag to denote whether more results need to be fetched from
// the peer in has_more field, transaction id in id field, and a QueryResponseMetadata
// in metadata field.
type QueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Results  []*QueryResultBytes `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	HasMore  bool                `protobuf:"varint,2,opt,name=has_more,json=hasMore,proto3" json:"has_more,omitempty"`
	Id       string              `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	Metadata []byte              `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *QueryResponse) Reset() {
	*x = QueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResponse) ProtoMessage() {}

func (x *QueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResponse.ProtoReflect.Descriptor instead.
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{14}
}

func (x *QueryResponse) GetResults() []*QueryResultBytes {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *QueryResponse) GetHasMore() bool {
	if x != nil {
		return x.HasMore
	}
	return false
}

func (x *QueryResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *QueryResponse) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// QueryResponseMetadata is the metadata of a QueryResponse. It contains a count
// which denotes the number of records fetched from the ledger and a bookmark.
type QueryResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FetchedRecordsCount int32  `protobuf:"varint,1,opt,name=fetched_records_count,json=fetchedRecordsCount,proto3" json:"fetched_records_count,omitempty"`
	Bookmark            string `protobuf:"bytes,2,opt,name=bookmark,proto3" json:"bookmark,omitempty"`
}

func (x *QueryResponseMetadata) Reset() {
	*x = QueryResponseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResponseMetadata) ProtoMessage() {}

func (x *QueryResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResponseMetadata.ProtoReflect.Descriptor instead.
func (*QueryResponseMetadata) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{15}
}

func (x *QueryResponseMetadata) GetFetchedRecordsCount() int32 {
	if x != nil {
		return x.FetchedRecordsCount
	}
	return 0
}

func (x *QueryResponseMetadata) GetBookmark() string {
	if x != nil {
		return x.Bookmark
	}
	return ""
}

type StateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metakey string `protobuf:"bytes,1,opt,name=metakey,proto3" json:"metakey,omitempty"`
	Value   []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StateMetadata) Reset() {
	*x = StateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMetadata) ProtoMessage() {}

func (x *StateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMetadata.ProtoReflect.Descriptor instead.
func (*StateMetadata) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{16}
}

func (x *StateMetadata) GetMetakey() string {
	if x != nil {
		return x.Metakey
	}
	return ""
}

func (x *StateMetadata) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type StateMetadataResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entries []*StateMetadata `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *StateMetadataResult) Reset() {
	*x = StateMetadataResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_peer_chaincode_shim_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateMetadataResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMetadataResult) ProtoMessage() {}

func (x *StateMetadataResult) ProtoReflect() protoreflect.Message {
	mi := &file_peer_chaincode_shim_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMetadataResult.ProtoReflect.Descriptor instead.
func (*StateMetadataResult) Descriptor() ([]byte, []int) {
	return file_peer_chaincode_shim_proto_rawDescGZIP(), []int{17}
}

func (x *StateMetadataResult) GetEntries() []*StateMetadata {
	if x != nil {
		return x.Entries
	}
	return nil
}

var File_peer_chaincode_shim_proto protoreflect.FileDescriptor

var file_peer_chaincode_shim_proto_rawDesc = []byte{
	0x0a, 0x19, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x5f, 0x73, 0x68, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x1a, 0x1a, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x13, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x05, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x78, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x3f, 0x0a, 0x0f, 0x63, 0x68, 0x61,
	0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xaa, 0x03, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x49, 0x4e, 0x49, 0x54, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41,
	0x44, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x12,
	0x0d, 0x0a, 0x09, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x08, 0x12, 0x0d,
	0x0a, 0x09, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x09, 0x12, 0x0d, 0x0a,
	0x09, 0x44, 0x45, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x0a, 0x12, 0x14, 0x0a, 0x10,
	0x49, 0x4e, 0x56, 0x4f, 0x4b, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x49, 0x4e, 0x43, 0x4f, 0x44, 0x45,
	0x10, 0x0b, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x0d,
	0x12, 0x16, 0x0a, 0x12, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x42, 0x59,
	0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x45, 0x54, 0x5f,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x10, 0x0f, 0x12, 0x14,
	0x0a, 0x10, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x45,
	0x58, 0x54, 0x10, 0x10, 0x12, 0x15, 0x0a, 0x11, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x10, 0x11, 0x12, 0x0d, 0x0a, 0x09, 0x4b,
	0x45, 0x45, 0x50, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x12, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45,
	0x54, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x4b, 0x45,
	0x59, 0x10, 0x13, 0x12, 0x16, 0x0a, 0x12, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x14, 0x12, 0x16, 0x0a, 0x12, 0x50,
	0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54,
	0x41, 0x10, 0x15, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41,
	0x54, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x10, 0x16, 0x12, 0x16,
	0x0a, 0x12, 0x50, 0x55, 0x52, 0x47, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x10, 0x17, 0x22, 0x3c, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0x0a, 0x08, 0x50, 0x75,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77,
	0x0a, 0x10, 0x50, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x3c, 0x0a, 0x08, 0x44, 0x65, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0x0a, 0x11, 0x50, 0x75, 0x72, 0x67, 0x65, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06,
	0x65, 0x6e, 0x64, 0x4b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e,
	0x64, 0x4b, 0x65, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x62, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x47, 0x0a, 0x0d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x6f, 0x6f, 0x6b, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x6b, 0x6d, 0x61, 0x72, 0x6b, 0x22, 0x24, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x6f, 0x72, 0x4b, 0x65,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x22, 0x20, 0x0a, 0x0e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x4e, 0x65, 0x78, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x21, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x34, 0x0a, 0x10, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x8a,
	0x01, 0x0a, 0x0d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x32, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x61, 0x73, 0x5f, 0x6d, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x68, 0x61, 0x73, 0x4d, 0x6f, 0x72, 0x65, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x67, 0x0a, 0x15, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x13, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x6f, 0x6f, 0x6b,
	0x6d, 0x61, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x6b,
	0x6d, 0x61, 0x72, 0x6b, 0x22, 0x3f, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x61, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x61, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x46, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2f, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x32, 0x56, 0x0a,
	0x10, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x42, 0x0a, 0x08, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0x18, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x28, 0x01, 0x30, 0x01, 0x32, 0x4e, 0x0a, 0x09, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x18, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x28, 0x01, 0x30, 0x01, 0x42, 0xa4, 0x01, 0x0a, 0x22, 0x6f, 0x72, 0x67, 0x2e, 0x68, 0x79,
	0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x42, 0x12, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x69, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68,
	0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69,
	0x63, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2f, 0x70, 0x65, 0x65, 0x72, 0xa2, 0x02, 0x03, 0x50, 0x58, 0x58, 0xaa, 0x02, 0x06, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0xca, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0xe2, 0x02,
	0x12, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xea, 0x02, 0x06, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_peer_chaincode_shim_proto_rawDescOnce sync.Once
	file_peer_chaincode_shim_proto_rawDescData = file_peer_chaincode_shim_proto_rawDesc
)

func file_peer_chaincode_shim_proto_rawDescGZIP() []byte {
	file_peer_chaincode_shim_proto_rawDescOnce.Do(func() {
		file_peer_chaincode_shim_proto_rawDescData = protoimpl.X.CompressGZIP(file_peer_chaincode_shim_proto_rawDescData)
	})
	return file_peer_chaincode_shim_proto_rawDescData
}

var file_peer_chaincode_shim_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_peer_chaincode_shim_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_peer_chaincode_shim_proto_goTypes = []interface{}{
	(ChaincodeMessage_Type)(0),    // 0: protos.ChaincodeMessage.Type
	(*ChaincodeMessage)(nil),      // 1: protos.ChaincodeMessage
	(*GetState)(nil),              // 2: protos.GetState
	(*GetStateMetadata)(nil),      // 3: protos.GetStateMetadata
	(*PutState)(nil),              // 4: protos.PutState
	(*PutStateMetadata)(nil),      // 5: protos.PutStateMetadata
	(*DelState)(nil),              // 6: protos.DelState
	(*PurgePrivateState)(nil),     // 7: protos.PurgePrivateState
	(*GetStateByRange)(nil),       // 8: protos.GetStateByRange
	(*GetQueryResult)(nil),        // 9: protos.GetQueryResult
	(*QueryMetadata)(nil),         // 10: protos.QueryMetadata
	(*GetHistoryForKey)(nil),      // 11: protos.GetHistoryForKey
	(*QueryStateNext)(nil),        // 12: protos.QueryStateNext
	(*QueryStateClose)(nil),       // 13: protos.QueryStateClose
	(*QueryResultBytes)(nil),      // 14: protos.QueryResultBytes
	(*QueryResponse)(nil),         // 15: protos.QueryResponse
	(*QueryResponseMetadata)(nil), // 16: protos.QueryResponseMetadata
	(*StateMetadata)(nil),         // 17: protos.StateMetadata
	(*StateMetadataResult)(nil),   // 18: protos.StateMetadataResult
	(*timestamppb.Timestamp)(nil), // 19: google.protobuf.Timestamp
	(*SignedProposal)(nil),        // 20: protos.SignedProposal
	(*ChaincodeEvent)(nil),        // 21: protos.ChaincodeEvent
}
var file_peer_chaincode_shim_proto_depIdxs = []int32{
	0,  // 0: protos.ChaincodeMessage.type:type_name -> protos.ChaincodeMessage.Type
	19, // 1: protos.ChaincodeMessage.timestamp:type_name -> google.protobuf.Timestamp
	20, // 2: protos.ChaincodeMessage.proposal:type_name -> protos.SignedProposal
	21, // 3: protos.ChaincodeMessage.chaincode_event:type_name -> protos.ChaincodeEvent
	17, // 4: protos.PutStateMetadata.metadata:type_name -> protos.StateMetadata
	14, // 5: protos.QueryResponse.results:type_name -> protos.QueryResultBytes
	17, // 6: protos.StateMetadataResult.entries:type_name -> protos.StateMetadata
	1,  // 7: protos.ChaincodeSupport.Register:input_type -> protos.ChaincodeMessage
	1,  // 8: protos.Chaincode.Connect:input_type -> protos.ChaincodeMessage
	1,  // 9: protos.ChaincodeSupport.Register:output_type -> protos.ChaincodeMessage
	1,  // 10: protos.Chaincode.Connect:output_type -> protos.ChaincodeMessage
	9,  // [9:11] is the sub-list for method output_type
	7,  // [7:9] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_peer_chaincode_shim_proto_init() }
func file_peer_chaincode_shim_proto_init() {
	if File_peer_chaincode_shim_proto != nil {
		return
	}
	file_peer_chaincode_event_proto_init()
	file_peer_proposal_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_peer_chaincode_shim_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutStateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgePrivateState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStateByRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetQueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetHistoryForKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryStateNext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryStateClose); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResultBytes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResponseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_peer_chaincode_shim_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateMetadataResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_peer_chaincode_shim_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_peer_chaincode_shim_proto_goTypes,
		DependencyIndexes: file_peer_chaincode_shim_proto_depIdxs,
		EnumInfos:         file_peer_chaincode_shim_proto_enumTypes,
		MessageInfos:      file_peer_chaincode_shim_proto_msgTypes,
	}.Build()
	File_peer_chaincode_shim_proto = out.File
	file_peer_chaincode_shim_proto_rawDesc = nil
	file_peer_chaincode_shim_proto_goTypes = nil
	file_peer_chaincode_shim_proto_depIdxs = nil
}
