// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: orderer/blockattestation.proto

package orderer

import (
	context "context"
	common "github.com/hyperledger/fabric-protos-go-apiv2/common"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BlockAttestations_BlockAttestations_FullMethodName = "/orderer.BlockAttestations/BlockAttestations"
)

// BlockAttestationsClient is the client API for BlockAttestations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BlockAttestationsClient interface {
	// BlockAttestations receives an Envelope of type DELIVER_SEEK_INFO , then sends back a stream of BlockAttestations.
	BlockAttestations(ctx context.Context, in *common.Envelope, opts ...grpc.CallOption) (BlockAttestations_BlockAttestationsClient, error)
}

type blockAttestationsClient struct {
	cc grpc.ClientConnInterface
}

func NewBlockAttestationsClient(cc grpc.ClientConnInterface) BlockAttestationsClient {
	return &blockAttestationsClient{cc}
}

func (c *blockAttestationsClient) BlockAttestations(ctx context.Context, in *common.Envelope, opts ...grpc.CallOption) (BlockAttestations_BlockAttestationsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlockAttestations_ServiceDesc.Streams[0], BlockAttestations_BlockAttestations_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &blockAttestationsBlockAttestationsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlockAttestations_BlockAttestationsClient interface {
	Recv() (*BlockAttestationResponse, error)
	grpc.ClientStream
}

type blockAttestationsBlockAttestationsClient struct {
	grpc.ClientStream
}

func (x *blockAttestationsBlockAttestationsClient) Recv() (*BlockAttestationResponse, error) {
	m := new(BlockAttestationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BlockAttestationsServer is the server API for BlockAttestations service.
// All implementations should embed UnimplementedBlockAttestationsServer
// for forward compatibility
type BlockAttestationsServer interface {
	// BlockAttestations receives an Envelope of type DELIVER_SEEK_INFO , then sends back a stream of BlockAttestations.
	BlockAttestations(*common.Envelope, BlockAttestations_BlockAttestationsServer) error
}

// UnimplementedBlockAttestationsServer should be embedded to have forward compatible implementations.
type UnimplementedBlockAttestationsServer struct {
}

func (UnimplementedBlockAttestationsServer) BlockAttestations(*common.Envelope, BlockAttestations_BlockAttestationsServer) error {
	return status.Errorf(codes.Unimplemented, "method BlockAttestations not implemented")
}

// UnsafeBlockAttestationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BlockAttestationsServer will
// result in compilation errors.
type UnsafeBlockAttestationsServer interface {
	mustEmbedUnimplementedBlockAttestationsServer()
}

func RegisterBlockAttestationsServer(s grpc.ServiceRegistrar, srv BlockAttestationsServer) {
	s.RegisterService(&BlockAttestations_ServiceDesc, srv)
}

func _BlockAttestations_BlockAttestations_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(common.Envelope)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlockAttestationsServer).BlockAttestations(m, &blockAttestationsBlockAttestationsServer{stream})
}

type BlockAttestations_BlockAttestationsServer interface {
	Send(*BlockAttestationResponse) error
	grpc.ServerStream
}

type blockAttestationsBlockAttestationsServer struct {
	grpc.ServerStream
}

func (x *blockAttestationsBlockAttestationsServer) Send(m *BlockAttestationResponse) error {
	return x.ServerStream.SendMsg(m)
}

// BlockAttestations_ServiceDesc is the grpc.ServiceDesc for BlockAttestations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BlockAttestations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "orderer.BlockAttestations",
	HandlerType: (*BlockAttestationsServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "BlockAttestations",
			Handler:       _BlockAttestations_BlockAttestations_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "orderer/blockattestation.proto",
}
