// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: msp/msp_config.proto

package msp

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// MSPConfig collects all the configuration information for
// an MSP. The Config field should be unmarshalled in a way
// that depends on the Type
type MSPConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type holds the type of the MSP; the default one would
	// be of type FABRIC implementing an X.509 based provider
	Type int32 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	// Config is MSP dependent configuration info
	Config []byte `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *MSPConfig) Reset() {
	*x = MSPConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MSPConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MSPConfig) ProtoMessage() {}

func (x *MSPConfig) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MSPConfig.ProtoReflect.Descriptor instead.
func (*MSPConfig) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{0}
}

func (x *MSPConfig) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *MSPConfig) GetConfig() []byte {
	if x != nil {
		return x.Config
	}
	return nil
}

// FabricMSPConfig collects all the configuration information for
// a Fabric MSP.
// Here we assume a default certificate validation policy, where
// any certificate signed by any of the listed rootCA certs would
// be considered as valid under this MSP.
// This MSP may or may not come with a signing identity. If it does,
// it can also issue signing identities. If it does not, it can only
// be used to validate and verify certificates.
type FabricMSPConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name holds the identifier of the MSP; MSP identifier
	// is chosen by the application that governs this MSP.
	// For example, and assuming the default implementation of MSP,
	// that is X.509-based and considers a single Issuer,
	// this can refer to the Subject OU field or the Issuer OU field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// List of root certificates trusted by this MSP
	// they are used upon certificate validation (see
	// comment for IntermediateCerts below)
	RootCerts [][]byte `protobuf:"bytes,2,rep,name=root_certs,json=rootCerts,proto3" json:"root_certs,omitempty"`
	// List of intermediate certificates trusted by this MSP;
	// they are used upon certificate validation as follows:
	// validation attempts to build a path from the certificate
	// to be validated (which is at one end of the path) and
	// one of the certs in the RootCerts field (which is at
	// the other end of the path). If the path is longer than
	// 2, certificates in the middle are searched within the
	// IntermediateCerts pool
	IntermediateCerts [][]byte `protobuf:"bytes,3,rep,name=intermediate_certs,json=intermediateCerts,proto3" json:"intermediate_certs,omitempty"`
	// Identity denoting the administrator of this MSP
	Admins [][]byte `protobuf:"bytes,4,rep,name=admins,proto3" json:"admins,omitempty"`
	// Identity revocation list
	RevocationList [][]byte `protobuf:"bytes,5,rep,name=revocation_list,json=revocationList,proto3" json:"revocation_list,omitempty"`
	// SigningIdentity holds information on the signing identity
	// this peer is to use, and which is to be imported by the
	// MSP defined before
	SigningIdentity *SigningIdentityInfo `protobuf:"bytes,6,opt,name=signing_identity,json=signingIdentity,proto3" json:"signing_identity,omitempty"`
	// OrganizationalUnitIdentifiers holds one or more
	// fabric organizational unit identifiers that belong to
	// this MSP configuration
	OrganizationalUnitIdentifiers []*FabricOUIdentifier `protobuf:"bytes,7,rep,name=organizational_unit_identifiers,json=organizationalUnitIdentifiers,proto3" json:"organizational_unit_identifiers,omitempty"`
	// FabricCryptoConfig contains the configuration parameters
	// for the cryptographic algorithms used by this MSP
	CryptoConfig *FabricCryptoConfig `protobuf:"bytes,8,opt,name=crypto_config,json=cryptoConfig,proto3" json:"crypto_config,omitempty"`
	// List of TLS root certificates trusted by this MSP.
	// They are returned by GetTLSRootCerts.
	TlsRootCerts [][]byte `protobuf:"bytes,9,rep,name=tls_root_certs,json=tlsRootCerts,proto3" json:"tls_root_certs,omitempty"`
	// List of TLS intermediate certificates trusted by this MSP;
	// They are returned by GetTLSIntermediateCerts.
	TlsIntermediateCerts [][]byte `protobuf:"bytes,10,rep,name=tls_intermediate_certs,json=tlsIntermediateCerts,proto3" json:"tls_intermediate_certs,omitempty"`
	// fabric_node_ous contains the configuration to distinguish clients from peers from orderers
	// based on the OUs.
	FabricNodeOus *FabricNodeOUs `protobuf:"bytes,11,opt,name=fabric_node_ous,json=fabricNodeOus,proto3" json:"fabric_node_ous,omitempty"`
}

func (x *FabricMSPConfig) Reset() {
	*x = FabricMSPConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FabricMSPConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FabricMSPConfig) ProtoMessage() {}

func (x *FabricMSPConfig) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FabricMSPConfig.ProtoReflect.Descriptor instead.
func (*FabricMSPConfig) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{1}
}

func (x *FabricMSPConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FabricMSPConfig) GetRootCerts() [][]byte {
	if x != nil {
		return x.RootCerts
	}
	return nil
}

func (x *FabricMSPConfig) GetIntermediateCerts() [][]byte {
	if x != nil {
		return x.IntermediateCerts
	}
	return nil
}

func (x *FabricMSPConfig) GetAdmins() [][]byte {
	if x != nil {
		return x.Admins
	}
	return nil
}

func (x *FabricMSPConfig) GetRevocationList() [][]byte {
	if x != nil {
		return x.RevocationList
	}
	return nil
}

func (x *FabricMSPConfig) GetSigningIdentity() *SigningIdentityInfo {
	if x != nil {
		return x.SigningIdentity
	}
	return nil
}

func (x *FabricMSPConfig) GetOrganizationalUnitIdentifiers() []*FabricOUIdentifier {
	if x != nil {
		return x.OrganizationalUnitIdentifiers
	}
	return nil
}

func (x *FabricMSPConfig) GetCryptoConfig() *FabricCryptoConfig {
	if x != nil {
		return x.CryptoConfig
	}
	return nil
}

func (x *FabricMSPConfig) GetTlsRootCerts() [][]byte {
	if x != nil {
		return x.TlsRootCerts
	}
	return nil
}

func (x *FabricMSPConfig) GetTlsIntermediateCerts() [][]byte {
	if x != nil {
		return x.TlsIntermediateCerts
	}
	return nil
}

func (x *FabricMSPConfig) GetFabricNodeOus() *FabricNodeOUs {
	if x != nil {
		return x.FabricNodeOus
	}
	return nil
}

// FabricCryptoConfig contains configuration parameters
// for the cryptographic algorithms used by the MSP
// this configuration refers to
type FabricCryptoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SignatureHashFamily is a string representing the hash family to be used
	// during sign and verify operations.
	// Allowed values are "SHA2" and "SHA3".
	SignatureHashFamily string `protobuf:"bytes,1,opt,name=signature_hash_family,json=signatureHashFamily,proto3" json:"signature_hash_family,omitempty"`
	// IdentityIdentifierHashFunction is a string representing the hash function
	// to be used during the computation of the identity identifier of an MSP identity.
	// Allowed values are "SHA256", "SHA384" and "SHA3_256", "SHA3_384".
	IdentityIdentifierHashFunction string `protobuf:"bytes,2,opt,name=identity_identifier_hash_function,json=identityIdentifierHashFunction,proto3" json:"identity_identifier_hash_function,omitempty"`
}

func (x *FabricCryptoConfig) Reset() {
	*x = FabricCryptoConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FabricCryptoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FabricCryptoConfig) ProtoMessage() {}

func (x *FabricCryptoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FabricCryptoConfig.ProtoReflect.Descriptor instead.
func (*FabricCryptoConfig) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{2}
}

func (x *FabricCryptoConfig) GetSignatureHashFamily() string {
	if x != nil {
		return x.SignatureHashFamily
	}
	return ""
}

func (x *FabricCryptoConfig) GetIdentityIdentifierHashFunction() string {
	if x != nil {
		return x.IdentityIdentifierHashFunction
	}
	return ""
}

// IdemixMSPConfig collects all the configuration information for
// an Idemix MSP.
type IdemixMSPConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name holds the identifier of the MSP
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ipk represents the (serialized) issuer public key
	Ipk []byte `protobuf:"bytes,2,opt,name=ipk,proto3" json:"ipk,omitempty"`
	// signer may contain crypto material to configure a default signer
	Signer *IdemixMSPSignerConfig `protobuf:"bytes,3,opt,name=signer,proto3" json:"signer,omitempty"`
	// revocation_pk is the public key used for revocation of credentials
	RevocationPk []byte `protobuf:"bytes,4,opt,name=revocation_pk,json=revocationPk,proto3" json:"revocation_pk,omitempty"`
	// epoch represents the current epoch (time interval) used for revocation
	Epoch int64 `protobuf:"varint,5,opt,name=epoch,proto3" json:"epoch,omitempty"`
}

func (x *IdemixMSPConfig) Reset() {
	*x = IdemixMSPConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdemixMSPConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdemixMSPConfig) ProtoMessage() {}

func (x *IdemixMSPConfig) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdemixMSPConfig.ProtoReflect.Descriptor instead.
func (*IdemixMSPConfig) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{3}
}

func (x *IdemixMSPConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IdemixMSPConfig) GetIpk() []byte {
	if x != nil {
		return x.Ipk
	}
	return nil
}

func (x *IdemixMSPConfig) GetSigner() *IdemixMSPSignerConfig {
	if x != nil {
		return x.Signer
	}
	return nil
}

func (x *IdemixMSPConfig) GetRevocationPk() []byte {
	if x != nil {
		return x.RevocationPk
	}
	return nil
}

func (x *IdemixMSPConfig) GetEpoch() int64 {
	if x != nil {
		return x.Epoch
	}
	return 0
}

// IdemixMSPSIgnerConfig contains the crypto material to set up an idemix signing identity
type IdemixMSPSignerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// cred represents the serialized idemix credential of the default signer
	Cred []byte `protobuf:"bytes,1,opt,name=cred,proto3" json:"cred,omitempty"`
	// sk is the secret key of the default signer, corresponding to credential Cred
	Sk []byte `protobuf:"bytes,2,opt,name=sk,proto3" json:"sk,omitempty"`
	// organizational_unit_identifier defines the organizational unit the default signer is in
	OrganizationalUnitIdentifier string `protobuf:"bytes,3,opt,name=organizational_unit_identifier,json=organizationalUnitIdentifier,proto3" json:"organizational_unit_identifier,omitempty"`
	// role defines whether the default signer is admin, peer, member or client
	Role int32 `protobuf:"varint,4,opt,name=role,proto3" json:"role,omitempty"`
	// enrollment_id contains the enrollment id of this signer
	EnrollmentId string `protobuf:"bytes,5,opt,name=enrollment_id,json=enrollmentId,proto3" json:"enrollment_id,omitempty"`
	// credential_revocation_information contains a serialized CredentialRevocationInformation
	CredentialRevocationInformation []byte `protobuf:"bytes,6,opt,name=credential_revocation_information,json=credentialRevocationInformation,proto3" json:"credential_revocation_information,omitempty"`
}

func (x *IdemixMSPSignerConfig) Reset() {
	*x = IdemixMSPSignerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdemixMSPSignerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdemixMSPSignerConfig) ProtoMessage() {}

func (x *IdemixMSPSignerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdemixMSPSignerConfig.ProtoReflect.Descriptor instead.
func (*IdemixMSPSignerConfig) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{4}
}

func (x *IdemixMSPSignerConfig) GetCred() []byte {
	if x != nil {
		return x.Cred
	}
	return nil
}

func (x *IdemixMSPSignerConfig) GetSk() []byte {
	if x != nil {
		return x.Sk
	}
	return nil
}

func (x *IdemixMSPSignerConfig) GetOrganizationalUnitIdentifier() string {
	if x != nil {
		return x.OrganizationalUnitIdentifier
	}
	return ""
}

func (x *IdemixMSPSignerConfig) GetRole() int32 {
	if x != nil {
		return x.Role
	}
	return 0
}

func (x *IdemixMSPSignerConfig) GetEnrollmentId() string {
	if x != nil {
		return x.EnrollmentId
	}
	return ""
}

func (x *IdemixMSPSignerConfig) GetCredentialRevocationInformation() []byte {
	if x != nil {
		return x.CredentialRevocationInformation
	}
	return nil
}

// SigningIdentityInfo represents the configuration information
// related to the signing identity the peer is to use for generating
// endorsements
type SigningIdentityInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PublicSigner carries the public information of the signing
	// identity. For an X.509 provider this would be represented by
	// an X.509 certificate
	PublicSigner []byte `protobuf:"bytes,1,opt,name=public_signer,json=publicSigner,proto3" json:"public_signer,omitempty"`
	// PrivateSigner denotes a reference to the private key of the
	// peer's signing identity
	PrivateSigner *KeyInfo `protobuf:"bytes,2,opt,name=private_signer,json=privateSigner,proto3" json:"private_signer,omitempty"`
}

func (x *SigningIdentityInfo) Reset() {
	*x = SigningIdentityInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningIdentityInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningIdentityInfo) ProtoMessage() {}

func (x *SigningIdentityInfo) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningIdentityInfo.ProtoReflect.Descriptor instead.
func (*SigningIdentityInfo) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{5}
}

func (x *SigningIdentityInfo) GetPublicSigner() []byte {
	if x != nil {
		return x.PublicSigner
	}
	return nil
}

func (x *SigningIdentityInfo) GetPrivateSigner() *KeyInfo {
	if x != nil {
		return x.PrivateSigner
	}
	return nil
}

// KeyInfo represents a (secret) key that is either already stored
// in the bccsp/keystore or key material to be imported to the
// bccsp key-store. In later versions it may contain also a
// keystore identifier
type KeyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the key inside the default keystore; this for
	// the case of Software BCCSP as well as the HSM BCCSP would be
	// the SKI of the key
	KeyIdentifier string `protobuf:"bytes,1,opt,name=key_identifier,json=keyIdentifier,proto3" json:"key_identifier,omitempty"`
	// KeyMaterial (optional) for the key to be imported; this is
	// properly encoded key bytes, prefixed by the type of the key
	KeyMaterial []byte `protobuf:"bytes,2,opt,name=key_material,json=keyMaterial,proto3" json:"key_material,omitempty"`
}

func (x *KeyInfo) Reset() {
	*x = KeyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyInfo) ProtoMessage() {}

func (x *KeyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyInfo.ProtoReflect.Descriptor instead.
func (*KeyInfo) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{6}
}

func (x *KeyInfo) GetKeyIdentifier() string {
	if x != nil {
		return x.KeyIdentifier
	}
	return ""
}

func (x *KeyInfo) GetKeyMaterial() []byte {
	if x != nil {
		return x.KeyMaterial
	}
	return nil
}

// FabricOUIdentifier represents an organizational unit and
// its related chain of trust identifier.
type FabricOUIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Certificate represents the second certificate in a certification chain.
	// (Notice that the first certificate in a certification chain is supposed
	// to be the certificate of an identity).
	// It must correspond to the certificate of root or intermediate CA
	// recognized by the MSP this message belongs to.
	// Starting from this certificate, a certification chain is computed
	// and bound to the OrganizationUnitIdentifier specified
	Certificate []byte `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// OrganizationUnitIdentifier defines the organizational unit under the
	// MSP identified with MSPIdentifier
	OrganizationalUnitIdentifier string `protobuf:"bytes,2,opt,name=organizational_unit_identifier,json=organizationalUnitIdentifier,proto3" json:"organizational_unit_identifier,omitempty"`
}

func (x *FabricOUIdentifier) Reset() {
	*x = FabricOUIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FabricOUIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FabricOUIdentifier) ProtoMessage() {}

func (x *FabricOUIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FabricOUIdentifier.ProtoReflect.Descriptor instead.
func (*FabricOUIdentifier) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{7}
}

func (x *FabricOUIdentifier) GetCertificate() []byte {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *FabricOUIdentifier) GetOrganizationalUnitIdentifier() string {
	if x != nil {
		return x.OrganizationalUnitIdentifier
	}
	return ""
}

// FabricNodeOUs contains configuration to tell apart clients from peers from orderers
// based on OUs. If NodeOUs recognition is enabled then an msp identity
// that does not contain any of the specified OU will be considered invalid.
type FabricNodeOUs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true then an msp identity that does not contain any of the specified OU will be considered invalid.
	Enable bool `protobuf:"varint,1,opt,name=enable,proto3" json:"enable,omitempty"`
	// OU Identifier of the clients
	ClientOuIdentifier *FabricOUIdentifier `protobuf:"bytes,2,opt,name=client_ou_identifier,json=clientOuIdentifier,proto3" json:"client_ou_identifier,omitempty"`
	// OU Identifier of the peers
	PeerOuIdentifier *FabricOUIdentifier `protobuf:"bytes,3,opt,name=peer_ou_identifier,json=peerOuIdentifier,proto3" json:"peer_ou_identifier,omitempty"`
	// OU Identifier of the admins
	AdminOuIdentifier *FabricOUIdentifier `protobuf:"bytes,4,opt,name=admin_ou_identifier,json=adminOuIdentifier,proto3" json:"admin_ou_identifier,omitempty"`
	// OU Identifier of the orderers
	OrdererOuIdentifier *FabricOUIdentifier `protobuf:"bytes,5,opt,name=orderer_ou_identifier,json=ordererOuIdentifier,proto3" json:"orderer_ou_identifier,omitempty"`
}

func (x *FabricNodeOUs) Reset() {
	*x = FabricNodeOUs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_msp_msp_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FabricNodeOUs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FabricNodeOUs) ProtoMessage() {}

func (x *FabricNodeOUs) ProtoReflect() protoreflect.Message {
	mi := &file_msp_msp_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FabricNodeOUs.ProtoReflect.Descriptor instead.
func (*FabricNodeOUs) Descriptor() ([]byte, []int) {
	return file_msp_msp_config_proto_rawDescGZIP(), []int{8}
}

func (x *FabricNodeOUs) GetEnable() bool {
	if x != nil {
		return x.Enable
	}
	return false
}

func (x *FabricNodeOUs) GetClientOuIdentifier() *FabricOUIdentifier {
	if x != nil {
		return x.ClientOuIdentifier
	}
	return nil
}

func (x *FabricNodeOUs) GetPeerOuIdentifier() *FabricOUIdentifier {
	if x != nil {
		return x.PeerOuIdentifier
	}
	return nil
}

func (x *FabricNodeOUs) GetAdminOuIdentifier() *FabricOUIdentifier {
	if x != nil {
		return x.AdminOuIdentifier
	}
	return nil
}

func (x *FabricNodeOUs) GetOrdererOuIdentifier() *FabricOUIdentifier {
	if x != nil {
		return x.OrdererOuIdentifier
	}
	return nil
}

var File_msp_msp_config_proto protoreflect.FileDescriptor

var file_msp_msp_config_proto_rawDesc = []byte{
	0x0a, 0x14, 0x6d, 0x73, 0x70, 0x2f, 0x6d, 0x73, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x6d, 0x73, 0x70, 0x22, 0x37, 0x0a, 0x09, 0x4d,
	0x53, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xb0, 0x04, 0x0a, 0x0f, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4d,
	0x53, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c,
	0x52, 0x09, 0x72, 0x6f, 0x6f, 0x74, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x06, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0e, 0x72, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x10, 0x73,
	0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x53, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x5f, 0x0a, 0x1f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x73, 0x70, 0x2e,
	0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4f, 0x55, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x1d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x46,
	0x61, 0x62, 0x72, 0x69, 0x63, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0c, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x24, 0x0a, 0x0e, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0c, 0x74, 0x6c, 0x73, 0x52, 0x6f, 0x6f, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x6c, 0x73, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x14, 0x74, 0x6c, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x0f, 0x66,
	0x61, 0x62, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6f, 0x75, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x46, 0x61, 0x62, 0x72, 0x69,
	0x63, 0x4e, 0x6f, 0x64, 0x65, 0x4f, 0x55, 0x73, 0x52, 0x0d, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63,
	0x4e, 0x6f, 0x64, 0x65, 0x4f, 0x75, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x12, 0x46, 0x61, 0x62, 0x72,
	0x69, 0x63, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32,
	0x0a, 0x15, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x48, 0x61, 0x73, 0x68, 0x46, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x12, 0x49, 0x0a, 0x21, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x48, 0x61, 0x73, 0x68, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa6, 0x01,
	0x0a, 0x0f, 0x49, 0x64, 0x65, 0x6d, 0x69, 0x78, 0x4d, 0x53, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x70, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x03, 0x69, 0x70, 0x6b, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x49, 0x64,
	0x65, 0x6d, 0x69, 0x78, 0x4d, 0x53, 0x50, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6b,
	0x12, 0x14, 0x0a, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x86, 0x02, 0x0a, 0x15, 0x49, 0x64, 0x65, 0x6d, 0x69,
	0x78, 0x4d, 0x53, 0x50, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x63, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04,
	0x63, 0x72, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x02, 0x73, 0x6b, 0x12, 0x44, 0x0a, 0x1e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1c, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x21, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x1f,
	0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6f, 0x0a, 0x13, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x0e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72,
	0x22, 0x53, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x6b,
	0x65, 0x79, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x5f, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x4d, 0x61, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x7c, 0x0a, 0x12, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4f,
	0x55, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x44, 0x0a,
	0x1e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x22, 0xcf, 0x02, 0x0a, 0x0d, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4e, 0x6f,
	0x64, 0x65, 0x4f, 0x55, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x49, 0x0a,
	0x14, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x73,
	0x70, 0x2e, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4f, 0x55, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x12, 0x70, 0x65, 0x65, 0x72,
	0x5f, 0x6f, 0x75, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x46, 0x61, 0x62, 0x72, 0x69,
	0x63, 0x4f, 0x55, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x10, 0x70,
	0x65, 0x65, 0x72, 0x4f, 0x75, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x47, 0x0a, 0x13, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x6f, 0x75, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d,
	0x73, 0x70, 0x2e, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4f, 0x55, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x11, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x4f, 0x75, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x15, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x65, 0x72, 0x5f, 0x6f, 0x75, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x46, 0x61,
	0x62, 0x72, 0x69, 0x63, 0x4f, 0x55, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x52, 0x13, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x72, 0x4f, 0x75, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x42, 0x92, 0x01, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x68, 0x79,
	0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x6d, 0x73, 0x70, 0x42, 0x0e, 0x4d, 0x53, 0x50,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2d, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6d, 0x73, 0x70,
	0xa2, 0x02, 0x03, 0x4d, 0x58, 0x58, 0xaa, 0x02, 0x03, 0x4d, 0x73, 0x70, 0xca, 0x02, 0x03, 0x4d,
	0x73, 0x70, 0xe2, 0x02, 0x0f, 0x4d, 0x73, 0x70, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x03, 0x4d, 0x73, 0x70, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_msp_msp_config_proto_rawDescOnce sync.Once
	file_msp_msp_config_proto_rawDescData = file_msp_msp_config_proto_rawDesc
)

func file_msp_msp_config_proto_rawDescGZIP() []byte {
	file_msp_msp_config_proto_rawDescOnce.Do(func() {
		file_msp_msp_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_msp_msp_config_proto_rawDescData)
	})
	return file_msp_msp_config_proto_rawDescData
}

var file_msp_msp_config_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_msp_msp_config_proto_goTypes = []interface{}{
	(*MSPConfig)(nil),             // 0: msp.MSPConfig
	(*FabricMSPConfig)(nil),       // 1: msp.FabricMSPConfig
	(*FabricCryptoConfig)(nil),    // 2: msp.FabricCryptoConfig
	(*IdemixMSPConfig)(nil),       // 3: msp.IdemixMSPConfig
	(*IdemixMSPSignerConfig)(nil), // 4: msp.IdemixMSPSignerConfig
	(*SigningIdentityInfo)(nil),   // 5: msp.SigningIdentityInfo
	(*KeyInfo)(nil),               // 6: msp.KeyInfo
	(*FabricOUIdentifier)(nil),    // 7: msp.FabricOUIdentifier
	(*FabricNodeOUs)(nil),         // 8: msp.FabricNodeOUs
}
var file_msp_msp_config_proto_depIdxs = []int32{
	5,  // 0: msp.FabricMSPConfig.signing_identity:type_name -> msp.SigningIdentityInfo
	7,  // 1: msp.FabricMSPConfig.organizational_unit_identifiers:type_name -> msp.FabricOUIdentifier
	2,  // 2: msp.FabricMSPConfig.crypto_config:type_name -> msp.FabricCryptoConfig
	8,  // 3: msp.FabricMSPConfig.fabric_node_ous:type_name -> msp.FabricNodeOUs
	4,  // 4: msp.IdemixMSPConfig.signer:type_name -> msp.IdemixMSPSignerConfig
	6,  // 5: msp.SigningIdentityInfo.private_signer:type_name -> msp.KeyInfo
	7,  // 6: msp.FabricNodeOUs.client_ou_identifier:type_name -> msp.FabricOUIdentifier
	7,  // 7: msp.FabricNodeOUs.peer_ou_identifier:type_name -> msp.FabricOUIdentifier
	7,  // 8: msp.FabricNodeOUs.admin_ou_identifier:type_name -> msp.FabricOUIdentifier
	7,  // 9: msp.FabricNodeOUs.orderer_ou_identifier:type_name -> msp.FabricOUIdentifier
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_msp_msp_config_proto_init() }
func file_msp_msp_config_proto_init() {
	if File_msp_msp_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_msp_msp_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MSPConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FabricMSPConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FabricCryptoConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdemixMSPConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdemixMSPSignerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigningIdentityInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FabricOUIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_msp_msp_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FabricNodeOUs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_msp_msp_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_msp_msp_config_proto_goTypes,
		DependencyIndexes: file_msp_msp_config_proto_depIdxs,
		MessageInfos:      file_msp_msp_config_proto_msgTypes,
	}.Build()
	File_msp_msp_config_proto = out.File
	file_msp_msp_config_proto_rawDesc = nil
	file_msp_msp_config_proto_goTypes = nil
	file_msp_msp_config_proto_depIdxs = nil
}
