// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: ledger/rwset/kvrwset/kv_rwset.proto

package kvrwset

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// KVRWSet encapsulates the read-write set for a chaincode that operates upon a KV or Document data model
// This structure is used for both the public data and the private data
type KVRWSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Reads            []*KVRead          `protobuf:"bytes,1,rep,name=reads,proto3" json:"reads,omitempty"`
	RangeQueriesInfo []*RangeQueryInfo  `protobuf:"bytes,2,rep,name=range_queries_info,json=rangeQueriesInfo,proto3" json:"range_queries_info,omitempty"`
	Writes           []*KVWrite         `protobuf:"bytes,3,rep,name=writes,proto3" json:"writes,omitempty"`
	MetadataWrites   []*KVMetadataWrite `protobuf:"bytes,4,rep,name=metadata_writes,json=metadataWrites,proto3" json:"metadata_writes,omitempty"`
}

func (x *KVRWSet) Reset() {
	*x = KVRWSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVRWSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVRWSet) ProtoMessage() {}

func (x *KVRWSet) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVRWSet.ProtoReflect.Descriptor instead.
func (*KVRWSet) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{0}
}

func (x *KVRWSet) GetReads() []*KVRead {
	if x != nil {
		return x.Reads
	}
	return nil
}

func (x *KVRWSet) GetRangeQueriesInfo() []*RangeQueryInfo {
	if x != nil {
		return x.RangeQueriesInfo
	}
	return nil
}

func (x *KVRWSet) GetWrites() []*KVWrite {
	if x != nil {
		return x.Writes
	}
	return nil
}

func (x *KVRWSet) GetMetadataWrites() []*KVMetadataWrite {
	if x != nil {
		return x.MetadataWrites
	}
	return nil
}

// HashedRWSet encapsulates hashed representation of a private read-write set for KV or Document data model
type HashedRWSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HashedReads    []*KVReadHash          `protobuf:"bytes,1,rep,name=hashed_reads,json=hashedReads,proto3" json:"hashed_reads,omitempty"`
	HashedWrites   []*KVWriteHash         `protobuf:"bytes,2,rep,name=hashed_writes,json=hashedWrites,proto3" json:"hashed_writes,omitempty"`
	MetadataWrites []*KVMetadataWriteHash `protobuf:"bytes,3,rep,name=metadata_writes,json=metadataWrites,proto3" json:"metadata_writes,omitempty"`
}

func (x *HashedRWSet) Reset() {
	*x = HashedRWSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashedRWSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashedRWSet) ProtoMessage() {}

func (x *HashedRWSet) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashedRWSet.ProtoReflect.Descriptor instead.
func (*HashedRWSet) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{1}
}

func (x *HashedRWSet) GetHashedReads() []*KVReadHash {
	if x != nil {
		return x.HashedReads
	}
	return nil
}

func (x *HashedRWSet) GetHashedWrites() []*KVWriteHash {
	if x != nil {
		return x.HashedWrites
	}
	return nil
}

func (x *HashedRWSet) GetMetadataWrites() []*KVMetadataWriteHash {
	if x != nil {
		return x.MetadataWrites
	}
	return nil
}

// KVRead captures a read operation performed during transaction simulation
// A 'nil' version indicates a non-existing key read by the transaction
type KVRead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key     string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Version *Version `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *KVRead) Reset() {
	*x = KVRead{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVRead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVRead) ProtoMessage() {}

func (x *KVRead) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVRead.ProtoReflect.Descriptor instead.
func (*KVRead) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{2}
}

func (x *KVRead) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KVRead) GetVersion() *Version {
	if x != nil {
		return x.Version
	}
	return nil
}

// KVWrite captures a write (update/delete) operation performed during transaction simulation
type KVWrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key      string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	IsDelete bool   `protobuf:"varint,2,opt,name=is_delete,json=isDelete,proto3" json:"is_delete,omitempty"`
	Value    []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *KVWrite) Reset() {
	*x = KVWrite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVWrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVWrite) ProtoMessage() {}

func (x *KVWrite) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVWrite.ProtoReflect.Descriptor instead.
func (*KVWrite) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{3}
}

func (x *KVWrite) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KVWrite) GetIsDelete() bool {
	if x != nil {
		return x.IsDelete
	}
	return false
}

func (x *KVWrite) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// KVMetadataWrite captures all the entries in the metadata associated with a key
type KVMetadataWrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key     string             `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Entries []*KVMetadataEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *KVMetadataWrite) Reset() {
	*x = KVMetadataWrite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVMetadataWrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVMetadataWrite) ProtoMessage() {}

func (x *KVMetadataWrite) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVMetadataWrite.ProtoReflect.Descriptor instead.
func (*KVMetadataWrite) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{4}
}

func (x *KVMetadataWrite) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KVMetadataWrite) GetEntries() []*KVMetadataEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// KVReadHash is similar to the KVRead in spirit. However, it captures the hash of the key instead of the key itself
// version is kept as is for now. However, if the version also needs to be privacy-protected, it would need to be the
// hash of the version and hence of 'bytes' type
type KVReadHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyHash []byte   `protobuf:"bytes,1,opt,name=key_hash,json=keyHash,proto3" json:"key_hash,omitempty"`
	Version *Version `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *KVReadHash) Reset() {
	*x = KVReadHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVReadHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVReadHash) ProtoMessage() {}

func (x *KVReadHash) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVReadHash.ProtoReflect.Descriptor instead.
func (*KVReadHash) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{5}
}

func (x *KVReadHash) GetKeyHash() []byte {
	if x != nil {
		return x.KeyHash
	}
	return nil
}

func (x *KVReadHash) GetVersion() *Version {
	if x != nil {
		return x.Version
	}
	return nil
}

// KVWriteHash is similar to the KVWrite. It captures a write (update/delete) operation performed during transaction simulation
type KVWriteHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyHash   []byte `protobuf:"bytes,1,opt,name=key_hash,json=keyHash,proto3" json:"key_hash,omitempty"`
	IsDelete  bool   `protobuf:"varint,2,opt,name=is_delete,json=isDelete,proto3" json:"is_delete,omitempty"`
	ValueHash []byte `protobuf:"bytes,3,opt,name=value_hash,json=valueHash,proto3" json:"value_hash,omitempty"`
	IsPurge   bool   `protobuf:"varint,4,opt,name=is_purge,json=isPurge,proto3" json:"is_purge,omitempty"`
}

func (x *KVWriteHash) Reset() {
	*x = KVWriteHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVWriteHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVWriteHash) ProtoMessage() {}

func (x *KVWriteHash) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVWriteHash.ProtoReflect.Descriptor instead.
func (*KVWriteHash) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{6}
}

func (x *KVWriteHash) GetKeyHash() []byte {
	if x != nil {
		return x.KeyHash
	}
	return nil
}

func (x *KVWriteHash) GetIsDelete() bool {
	if x != nil {
		return x.IsDelete
	}
	return false
}

func (x *KVWriteHash) GetValueHash() []byte {
	if x != nil {
		return x.ValueHash
	}
	return nil
}

func (x *KVWriteHash) GetIsPurge() bool {
	if x != nil {
		return x.IsPurge
	}
	return false
}

// KVMetadataWriteHash captures all the upserts to the metadata associated with a key hash
type KVMetadataWriteHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyHash []byte             `protobuf:"bytes,1,opt,name=key_hash,json=keyHash,proto3" json:"key_hash,omitempty"`
	Entries []*KVMetadataEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *KVMetadataWriteHash) Reset() {
	*x = KVMetadataWriteHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVMetadataWriteHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVMetadataWriteHash) ProtoMessage() {}

func (x *KVMetadataWriteHash) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVMetadataWriteHash.ProtoReflect.Descriptor instead.
func (*KVMetadataWriteHash) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{7}
}

func (x *KVMetadataWriteHash) GetKeyHash() []byte {
	if x != nil {
		return x.KeyHash
	}
	return nil
}

func (x *KVMetadataWriteHash) GetEntries() []*KVMetadataEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// KVMetadataEntry captures a 'name'ed entry in the metadata of a key/key-hash.
type KVMetadataEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *KVMetadataEntry) Reset() {
	*x = KVMetadataEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KVMetadataEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KVMetadataEntry) ProtoMessage() {}

func (x *KVMetadataEntry) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KVMetadataEntry.ProtoReflect.Descriptor instead.
func (*KVMetadataEntry) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{8}
}

func (x *KVMetadataEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KVMetadataEntry) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Version encapsulates the version of a Key
// A version of a committed key is maintained as the height of the transaction that committed the key.
// The height is represenetd as a tuple <blockNum, txNum> where the txNum is the position of the transaction
// (starting with 0) within block
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockNum uint64 `protobuf:"varint,1,opt,name=block_num,json=blockNum,proto3" json:"block_num,omitempty"`
	TxNum    uint64 `protobuf:"varint,2,opt,name=tx_num,json=txNum,proto3" json:"tx_num,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{9}
}

func (x *Version) GetBlockNum() uint64 {
	if x != nil {
		return x.BlockNum
	}
	return 0
}

func (x *Version) GetTxNum() uint64 {
	if x != nil {
		return x.TxNum
	}
	return 0
}

// RangeQueryInfo encapsulates the details of a range query performed by a transaction during simulation.
// This helps protect transactions from phantom reads by varifying during validation whether any new items
// got committed within the given range between transaction simuation and validation
// (in addition to regular checks for updates/deletes of the existing items).
// readInfo field contains either the KVReads (for the items read by the range query) or a merkle-tree hash
// if the KVReads exceeds a pre-configured numbers
type RangeQueryInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartKey     string `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey       string `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	ItrExhausted bool   `protobuf:"varint,3,opt,name=itr_exhausted,json=itrExhausted,proto3" json:"itr_exhausted,omitempty"`
	// Types that are assignable to ReadsInfo:
	//
	//	*RangeQueryInfo_RawReads
	//	*RangeQueryInfo_ReadsMerkleHashes
	ReadsInfo isRangeQueryInfo_ReadsInfo `protobuf_oneof:"reads_info"`
}

func (x *RangeQueryInfo) Reset() {
	*x = RangeQueryInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RangeQueryInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RangeQueryInfo) ProtoMessage() {}

func (x *RangeQueryInfo) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RangeQueryInfo.ProtoReflect.Descriptor instead.
func (*RangeQueryInfo) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{10}
}

func (x *RangeQueryInfo) GetStartKey() string {
	if x != nil {
		return x.StartKey
	}
	return ""
}

func (x *RangeQueryInfo) GetEndKey() string {
	if x != nil {
		return x.EndKey
	}
	return ""
}

func (x *RangeQueryInfo) GetItrExhausted() bool {
	if x != nil {
		return x.ItrExhausted
	}
	return false
}

func (m *RangeQueryInfo) GetReadsInfo() isRangeQueryInfo_ReadsInfo {
	if m != nil {
		return m.ReadsInfo
	}
	return nil
}

func (x *RangeQueryInfo) GetRawReads() *QueryReads {
	if x, ok := x.GetReadsInfo().(*RangeQueryInfo_RawReads); ok {
		return x.RawReads
	}
	return nil
}

func (x *RangeQueryInfo) GetReadsMerkleHashes() *QueryReadsMerkleSummary {
	if x, ok := x.GetReadsInfo().(*RangeQueryInfo_ReadsMerkleHashes); ok {
		return x.ReadsMerkleHashes
	}
	return nil
}

type isRangeQueryInfo_ReadsInfo interface {
	isRangeQueryInfo_ReadsInfo()
}

type RangeQueryInfo_RawReads struct {
	RawReads *QueryReads `protobuf:"bytes,4,opt,name=raw_reads,json=rawReads,proto3,oneof"`
}

type RangeQueryInfo_ReadsMerkleHashes struct {
	ReadsMerkleHashes *QueryReadsMerkleSummary `protobuf:"bytes,5,opt,name=reads_merkle_hashes,json=readsMerkleHashes,proto3,oneof"`
}

func (*RangeQueryInfo_RawReads) isRangeQueryInfo_ReadsInfo() {}

func (*RangeQueryInfo_ReadsMerkleHashes) isRangeQueryInfo_ReadsInfo() {}

// QueryReads encapsulates the KVReads for the items read by a transaction as a result of a query execution
type QueryReads struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KvReads []*KVRead `protobuf:"bytes,1,rep,name=kv_reads,json=kvReads,proto3" json:"kv_reads,omitempty"`
}

func (x *QueryReads) Reset() {
	*x = QueryReads{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryReads) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryReads) ProtoMessage() {}

func (x *QueryReads) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryReads.ProtoReflect.Descriptor instead.
func (*QueryReads) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{11}
}

func (x *QueryReads) GetKvReads() []*KVRead {
	if x != nil {
		return x.KvReads
	}
	return nil
}

// QueryReadsMerkleSummary encapsulates the Merkle-tree hashes for the QueryReads
// This allows to reduce the size of RWSet in the presence of query results
// by storing certain hashes instead of actual results.
// maxDegree field refers to the maximum number of children in the tree at any level
// maxLevel field contains the lowest level which has lesser nodes than maxDegree (starting from leaf level)
type QueryReadsMerkleSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxDegree      uint32   `protobuf:"varint,1,opt,name=max_degree,json=maxDegree,proto3" json:"max_degree,omitempty"`
	MaxLevel       uint32   `protobuf:"varint,2,opt,name=max_level,json=maxLevel,proto3" json:"max_level,omitempty"`
	MaxLevelHashes [][]byte `protobuf:"bytes,3,rep,name=max_level_hashes,json=maxLevelHashes,proto3" json:"max_level_hashes,omitempty"`
}

func (x *QueryReadsMerkleSummary) Reset() {
	*x = QueryReadsMerkleSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryReadsMerkleSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryReadsMerkleSummary) ProtoMessage() {}

func (x *QueryReadsMerkleSummary) ProtoReflect() protoreflect.Message {
	mi := &file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryReadsMerkleSummary.ProtoReflect.Descriptor instead.
func (*QueryReadsMerkleSummary) Descriptor() ([]byte, []int) {
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP(), []int{12}
}

func (x *QueryReadsMerkleSummary) GetMaxDegree() uint32 {
	if x != nil {
		return x.MaxDegree
	}
	return 0
}

func (x *QueryReadsMerkleSummary) GetMaxLevel() uint32 {
	if x != nil {
		return x.MaxLevel
	}
	return 0
}

func (x *QueryReadsMerkleSummary) GetMaxLevelHashes() [][]byte {
	if x != nil {
		return x.MaxLevelHashes
	}
	return nil
}

var File_ledger_rwset_kvrwset_kv_rwset_proto protoreflect.FileDescriptor

var file_ledger_rwset_kvrwset_kv_rwset_proto_rawDesc = []byte{
	0x0a, 0x23, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2f, 0x6b,
	0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2f, 0x6b, 0x76, 0x5f, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x22, 0xe4,
	0x01, 0x0a, 0x07, 0x4b, 0x56, 0x52, 0x57, 0x53, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x05, 0x72, 0x65,
	0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6b, 0x76, 0x72, 0x77,
	0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x52, 0x65, 0x61, 0x64, 0x52, 0x05, 0x72, 0x65, 0x61, 0x64,
	0x73, 0x12, 0x45, 0x0a, 0x12, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x06, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x6b, 0x76, 0x72, 0x77, 0x73,
	0x65, 0x74, 0x2e, 0x4b, 0x56, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x06, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x73, 0x12, 0x41, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6b, 0x76,
	0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x73, 0x22, 0xc7, 0x01, 0x0a, 0x0b, 0x48, 0x61, 0x73, 0x68, 0x65, 0x64,
	0x52, 0x57, 0x53, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x0c, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6b, 0x76,
	0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x52, 0x65, 0x61, 0x64, 0x48, 0x61, 0x73, 0x68,
	0x52, 0x0b, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x52, 0x65, 0x61, 0x64, 0x73, 0x12, 0x39, 0x0a,
	0x0d, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b,
	0x56, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x61, 0x73, 0x68, 0x52, 0x0c, 0x68, 0x61, 0x73, 0x68,
	0x65, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x61, 0x73, 0x68, 0x52,
	0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x22,
	0x46, 0x0a, 0x06, 0x4b, 0x56, 0x52, 0x65, 0x61, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x6b,
	0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x07, 0x4b, 0x56, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x57, 0x0a, 0x0f, 0x4b, 0x56, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x22, 0x53, 0x0a, 0x0a, 0x4b, 0x56, 0x52, 0x65, 0x61, 0x64, 0x48, 0x61, 0x73, 0x68, 0x12, 0x19,
	0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x6b, 0x65, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x2a, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x6b, 0x76, 0x72,
	0x77, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x0b, 0x4b, 0x56, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x48, 0x61, 0x73, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12,
	0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x61, 0x73, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x69,
	0x73, 0x5f, 0x70, 0x75, 0x72, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69,
	0x73, 0x50, 0x75, 0x72, 0x67, 0x65, 0x22, 0x64, 0x0a, 0x13, 0x4b, 0x56, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x61, 0x73, 0x68, 0x12, 0x19, 0x0a,
	0x08, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x6b, 0x65, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x32, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6b, 0x76, 0x72, 0x77,
	0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x3b, 0x0a, 0x0f,
	0x4b, 0x56, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x3d, 0x0a, 0x07, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6e, 0x75,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x4e, 0x75,
	0x6d, 0x12, 0x15, 0x0a, 0x06, 0x74, 0x78, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x05, 0x74, 0x78, 0x4e, 0x75, 0x6d, 0x22, 0x81, 0x02, 0x0a, 0x0e, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x6e, 0x64, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x4b, 0x65,
	0x79, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x74, 0x72, 0x5f, 0x65, 0x78, 0x68, 0x61, 0x75, 0x73, 0x74,
	0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x74, 0x72, 0x45, 0x78, 0x68,
	0x61, 0x75, 0x73, 0x74, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x09, 0x72, 0x61, 0x77, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6b, 0x76, 0x72, 0x77,
	0x73, 0x65, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x64, 0x73, 0x48, 0x00,
	0x52, 0x08, 0x72, 0x61, 0x77, 0x52, 0x65, 0x61, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x13, 0x72, 0x65,
	0x61, 0x64, 0x73, 0x5f, 0x6d, 0x65, 0x72, 0x6b, 0x6c, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6b, 0x76, 0x72, 0x77, 0x73, 0x65,
	0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x64, 0x73, 0x4d, 0x65, 0x72, 0x6b,
	0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x4d, 0x65, 0x72, 0x6b, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x42, 0x0c,
	0x0a, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x38, 0x0a, 0x0a,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x64, 0x73, 0x12, 0x2a, 0x0a, 0x08, 0x6b, 0x76,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6b,
	0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x4b, 0x56, 0x52, 0x65, 0x61, 0x64, 0x52, 0x07, 0x6b,
	0x76, 0x52, 0x65, 0x61, 0x64, 0x73, 0x22, 0x7f, 0x0a, 0x17, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x61, 0x64, 0x73, 0x4d, 0x65, 0x72, 0x6b, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x28, 0x0a,
	0x10, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x42, 0xc2, 0x01, 0x0a, 0x32, 0x6f, 0x72, 0x67, 0x2e,
	0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66, 0x61, 0x62, 0x72,
	0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72,
	0x2e, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2e, 0x6b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x42, 0x0c,
	0x4b, 0x56, 0x52, 0x57, 0x53, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70, 0x65, 0x72,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2d, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x72, 0x2f, 0x72, 0x77, 0x73, 0x65, 0x74, 0x2f, 0x6b, 0x76, 0x72, 0x77, 0x73,
	0x65, 0x74, 0xa2, 0x02, 0x03, 0x4b, 0x58, 0x58, 0xaa, 0x02, 0x07, 0x4b, 0x76, 0x72, 0x77, 0x73,
	0x65, 0x74, 0xca, 0x02, 0x07, 0x4b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0xe2, 0x02, 0x13, 0x4b,
	0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xea, 0x02, 0x07, 0x4b, 0x76, 0x72, 0x77, 0x73, 0x65, 0x74, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescOnce sync.Once
	file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescData = file_ledger_rwset_kvrwset_kv_rwset_proto_rawDesc
)

func file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescGZIP() []byte {
	file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescOnce.Do(func() {
		file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescData = protoimpl.X.CompressGZIP(file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescData)
	})
	return file_ledger_rwset_kvrwset_kv_rwset_proto_rawDescData
}

var file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_ledger_rwset_kvrwset_kv_rwset_proto_goTypes = []interface{}{
	(*KVRWSet)(nil),                 // 0: kvrwset.KVRWSet
	(*HashedRWSet)(nil),             // 1: kvrwset.HashedRWSet
	(*KVRead)(nil),                  // 2: kvrwset.KVRead
	(*KVWrite)(nil),                 // 3: kvrwset.KVWrite
	(*KVMetadataWrite)(nil),         // 4: kvrwset.KVMetadataWrite
	(*KVReadHash)(nil),              // 5: kvrwset.KVReadHash
	(*KVWriteHash)(nil),             // 6: kvrwset.KVWriteHash
	(*KVMetadataWriteHash)(nil),     // 7: kvrwset.KVMetadataWriteHash
	(*KVMetadataEntry)(nil),         // 8: kvrwset.KVMetadataEntry
	(*Version)(nil),                 // 9: kvrwset.Version
	(*RangeQueryInfo)(nil),          // 10: kvrwset.RangeQueryInfo
	(*QueryReads)(nil),              // 11: kvrwset.QueryReads
	(*QueryReadsMerkleSummary)(nil), // 12: kvrwset.QueryReadsMerkleSummary
}
var file_ledger_rwset_kvrwset_kv_rwset_proto_depIdxs = []int32{
	2,  // 0: kvrwset.KVRWSet.reads:type_name -> kvrwset.KVRead
	10, // 1: kvrwset.KVRWSet.range_queries_info:type_name -> kvrwset.RangeQueryInfo
	3,  // 2: kvrwset.KVRWSet.writes:type_name -> kvrwset.KVWrite
	4,  // 3: kvrwset.KVRWSet.metadata_writes:type_name -> kvrwset.KVMetadataWrite
	5,  // 4: kvrwset.HashedRWSet.hashed_reads:type_name -> kvrwset.KVReadHash
	6,  // 5: kvrwset.HashedRWSet.hashed_writes:type_name -> kvrwset.KVWriteHash
	7,  // 6: kvrwset.HashedRWSet.metadata_writes:type_name -> kvrwset.KVMetadataWriteHash
	9,  // 7: kvrwset.KVRead.version:type_name -> kvrwset.Version
	8,  // 8: kvrwset.KVMetadataWrite.entries:type_name -> kvrwset.KVMetadataEntry
	9,  // 9: kvrwset.KVReadHash.version:type_name -> kvrwset.Version
	8,  // 10: kvrwset.KVMetadataWriteHash.entries:type_name -> kvrwset.KVMetadataEntry
	11, // 11: kvrwset.RangeQueryInfo.raw_reads:type_name -> kvrwset.QueryReads
	12, // 12: kvrwset.RangeQueryInfo.reads_merkle_hashes:type_name -> kvrwset.QueryReadsMerkleSummary
	2,  // 13: kvrwset.QueryReads.kv_reads:type_name -> kvrwset.KVRead
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_ledger_rwset_kvrwset_kv_rwset_proto_init() }
func file_ledger_rwset_kvrwset_kv_rwset_proto_init() {
	if File_ledger_rwset_kvrwset_kv_rwset_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVRWSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashedRWSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVRead); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVWrite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVMetadataWrite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVReadHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVWriteHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVMetadataWriteHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KVMetadataEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RangeQueryInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryReads); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryReadsMerkleSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*RangeQueryInfo_RawReads)(nil),
		(*RangeQueryInfo_ReadsMerkleHashes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ledger_rwset_kvrwset_kv_rwset_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ledger_rwset_kvrwset_kv_rwset_proto_goTypes,
		DependencyIndexes: file_ledger_rwset_kvrwset_kv_rwset_proto_depIdxs,
		MessageInfos:      file_ledger_rwset_kvrwset_kv_rwset_proto_msgTypes,
	}.Build()
	File_ledger_rwset_kvrwset_kv_rwset_proto = out.File
	file_ledger_rwset_kvrwset_kv_rwset_proto_rawDesc = nil
	file_ledger_rwset_kvrwset_kv_rwset_proto_goTypes = nil
	file_ledger_rwset_kvrwset_kv_rwset_proto_depIdxs = nil
}
