// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: gossip/message.proto

package gossip

import (
	peer "github.com/hyperledger/fabric-protos-go-apiv2/peer"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type PullMsgType int32

const (
	PullMsgType_UNDEFINED    PullMsgType = 0
	PullMsgType_BLOCK_MSG    PullMsgType = 1
	PullMsgType_IDENTITY_MSG PullMsgType = 2
)

// Enum value maps for PullMsgType.
var (
	PullMsgType_name = map[int32]string{
		0: "UNDEFINED",
		1: "BLOCK_MSG",
		2: "IDENTITY_MSG",
	}
	PullMsgType_value = map[string]int32{
		"UNDEFINED":    0,
		"BLOCK_MSG":    1,
		"IDENTITY_MSG": 2,
	}
)

func (x PullMsgType) Enum() *PullMsgType {
	p := new(PullMsgType)
	*p = x
	return p
}

func (x PullMsgType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PullMsgType) Descriptor() protoreflect.EnumDescriptor {
	return file_gossip_message_proto_enumTypes[0].Descriptor()
}

func (PullMsgType) Type() protoreflect.EnumType {
	return &file_gossip_message_proto_enumTypes[0]
}

func (x PullMsgType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PullMsgType.Descriptor instead.
func (PullMsgType) EnumDescriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{0}
}

type GossipMessage_Tag int32

const (
	GossipMessage_UNDEFINED    GossipMessage_Tag = 0
	GossipMessage_EMPTY        GossipMessage_Tag = 1
	GossipMessage_ORG_ONLY     GossipMessage_Tag = 2
	GossipMessage_CHAN_ONLY    GossipMessage_Tag = 3
	GossipMessage_CHAN_AND_ORG GossipMessage_Tag = 4
	GossipMessage_CHAN_OR_ORG  GossipMessage_Tag = 5
)

// Enum value maps for GossipMessage_Tag.
var (
	GossipMessage_Tag_name = map[int32]string{
		0: "UNDEFINED",
		1: "EMPTY",
		2: "ORG_ONLY",
		3: "CHAN_ONLY",
		4: "CHAN_AND_ORG",
		5: "CHAN_OR_ORG",
	}
	GossipMessage_Tag_value = map[string]int32{
		"UNDEFINED":    0,
		"EMPTY":        1,
		"ORG_ONLY":     2,
		"CHAN_ONLY":    3,
		"CHAN_AND_ORG": 4,
		"CHAN_OR_ORG":  5,
	}
)

func (x GossipMessage_Tag) Enum() *GossipMessage_Tag {
	p := new(GossipMessage_Tag)
	*p = x
	return p
}

func (x GossipMessage_Tag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GossipMessage_Tag) Descriptor() protoreflect.EnumDescriptor {
	return file_gossip_message_proto_enumTypes[1].Descriptor()
}

func (GossipMessage_Tag) Type() protoreflect.EnumType {
	return &file_gossip_message_proto_enumTypes[1]
}

func (x GossipMessage_Tag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GossipMessage_Tag.Descriptor instead.
func (GossipMessage_Tag) EnumDescriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{3, 0}
}

// Envelope contains a marshalled
// GossipMessage and a signature over it.
// It may also contain a SecretEnvelope
// which is a marshalled Secret
type Envelope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload        []byte          `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature      []byte          `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	SecretEnvelope *SecretEnvelope `protobuf:"bytes,3,opt,name=secret_envelope,json=secretEnvelope,proto3" json:"secret_envelope,omitempty"`
}

func (x *Envelope) Reset() {
	*x = Envelope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Envelope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Envelope) ProtoMessage() {}

func (x *Envelope) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Envelope.ProtoReflect.Descriptor instead.
func (*Envelope) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{0}
}

func (x *Envelope) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *Envelope) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *Envelope) GetSecretEnvelope() *SecretEnvelope {
	if x != nil {
		return x.SecretEnvelope
	}
	return nil
}

// SecretEnvelope is a marshalled Secret
// and a signature over it.
// The signature should be validated by the peer
// that signed the Envelope the SecretEnvelope
// came with
type SecretEnvelope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload   []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SecretEnvelope) Reset() {
	*x = SecretEnvelope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretEnvelope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretEnvelope) ProtoMessage() {}

func (x *SecretEnvelope) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretEnvelope.ProtoReflect.Descriptor instead.
func (*SecretEnvelope) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{1}
}

func (x *SecretEnvelope) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *SecretEnvelope) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

// Secret is an entity that might be omitted
// from an Envelope when the remote peer that is receiving
// the Envelope shouldn't know the secret's content.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Content:
	//
	//	*Secret_InternalEndpoint
	Content isSecret_Content `protobuf_oneof:"content"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{2}
}

func (m *Secret) GetContent() isSecret_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *Secret) GetInternalEndpoint() string {
	if x, ok := x.GetContent().(*Secret_InternalEndpoint); ok {
		return x.InternalEndpoint
	}
	return ""
}

type isSecret_Content interface {
	isSecret_Content()
}

type Secret_InternalEndpoint struct {
	InternalEndpoint string `protobuf:"bytes,1,opt,name=internalEndpoint,proto3,oneof"`
}

func (*Secret_InternalEndpoint) isSecret_Content() {}

// GossipMessage defines the message sent in a gossip network
type GossipMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// used mainly for testing, but will might be used in the future
	// for ensuring message delivery by acking
	Nonce uint64 `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// The channel of the message.
	// Some GossipMessages may set this to nil, because
	// they are cross-channels but some may not
	Channel []byte `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	// determines to which peers it is allowed
	// to forward the message
	Tag GossipMessage_Tag `protobuf:"varint,3,opt,name=tag,proto3,enum=gossip.GossipMessage_Tag" json:"tag,omitempty"`
	// Types that are assignable to Content:
	//
	//	*GossipMessage_AliveMsg
	//	*GossipMessage_MemReq
	//	*GossipMessage_MemRes
	//	*GossipMessage_DataMsg
	//	*GossipMessage_Hello
	//	*GossipMessage_DataDig
	//	*GossipMessage_DataReq
	//	*GossipMessage_DataUpdate
	//	*GossipMessage_Empty
	//	*GossipMessage_Conn
	//	*GossipMessage_StateInfo
	//	*GossipMessage_StateSnapshot
	//	*GossipMessage_StateInfoPullReq
	//	*GossipMessage_StateRequest
	//	*GossipMessage_StateResponse
	//	*GossipMessage_LeadershipMsg
	//	*GossipMessage_PeerIdentity
	//	*GossipMessage_Ack
	//	*GossipMessage_PrivateReq
	//	*GossipMessage_PrivateRes
	//	*GossipMessage_PrivateData
	Content isGossipMessage_Content `protobuf_oneof:"content"`
}

func (x *GossipMessage) Reset() {
	*x = GossipMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GossipMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GossipMessage) ProtoMessage() {}

func (x *GossipMessage) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GossipMessage.ProtoReflect.Descriptor instead.
func (*GossipMessage) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{3}
}

func (x *GossipMessage) GetNonce() uint64 {
	if x != nil {
		return x.Nonce
	}
	return 0
}

func (x *GossipMessage) GetChannel() []byte {
	if x != nil {
		return x.Channel
	}
	return nil
}

func (x *GossipMessage) GetTag() GossipMessage_Tag {
	if x != nil {
		return x.Tag
	}
	return GossipMessage_UNDEFINED
}

func (m *GossipMessage) GetContent() isGossipMessage_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *GossipMessage) GetAliveMsg() *AliveMessage {
	if x, ok := x.GetContent().(*GossipMessage_AliveMsg); ok {
		return x.AliveMsg
	}
	return nil
}

func (x *GossipMessage) GetMemReq() *MembershipRequest {
	if x, ok := x.GetContent().(*GossipMessage_MemReq); ok {
		return x.MemReq
	}
	return nil
}

func (x *GossipMessage) GetMemRes() *MembershipResponse {
	if x, ok := x.GetContent().(*GossipMessage_MemRes); ok {
		return x.MemRes
	}
	return nil
}

func (x *GossipMessage) GetDataMsg() *DataMessage {
	if x, ok := x.GetContent().(*GossipMessage_DataMsg); ok {
		return x.DataMsg
	}
	return nil
}

func (x *GossipMessage) GetHello() *GossipHello {
	if x, ok := x.GetContent().(*GossipMessage_Hello); ok {
		return x.Hello
	}
	return nil
}

func (x *GossipMessage) GetDataDig() *DataDigest {
	if x, ok := x.GetContent().(*GossipMessage_DataDig); ok {
		return x.DataDig
	}
	return nil
}

func (x *GossipMessage) GetDataReq() *DataRequest {
	if x, ok := x.GetContent().(*GossipMessage_DataReq); ok {
		return x.DataReq
	}
	return nil
}

func (x *GossipMessage) GetDataUpdate() *DataUpdate {
	if x, ok := x.GetContent().(*GossipMessage_DataUpdate); ok {
		return x.DataUpdate
	}
	return nil
}

func (x *GossipMessage) GetEmpty() *Empty {
	if x, ok := x.GetContent().(*GossipMessage_Empty); ok {
		return x.Empty
	}
	return nil
}

func (x *GossipMessage) GetConn() *ConnEstablish {
	if x, ok := x.GetContent().(*GossipMessage_Conn); ok {
		return x.Conn
	}
	return nil
}

func (x *GossipMessage) GetStateInfo() *StateInfo {
	if x, ok := x.GetContent().(*GossipMessage_StateInfo); ok {
		return x.StateInfo
	}
	return nil
}

func (x *GossipMessage) GetStateSnapshot() *StateInfoSnapshot {
	if x, ok := x.GetContent().(*GossipMessage_StateSnapshot); ok {
		return x.StateSnapshot
	}
	return nil
}

func (x *GossipMessage) GetStateInfoPullReq() *StateInfoPullRequest {
	if x, ok := x.GetContent().(*GossipMessage_StateInfoPullReq); ok {
		return x.StateInfoPullReq
	}
	return nil
}

func (x *GossipMessage) GetStateRequest() *RemoteStateRequest {
	if x, ok := x.GetContent().(*GossipMessage_StateRequest); ok {
		return x.StateRequest
	}
	return nil
}

func (x *GossipMessage) GetStateResponse() *RemoteStateResponse {
	if x, ok := x.GetContent().(*GossipMessage_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

func (x *GossipMessage) GetLeadershipMsg() *LeadershipMessage {
	if x, ok := x.GetContent().(*GossipMessage_LeadershipMsg); ok {
		return x.LeadershipMsg
	}
	return nil
}

func (x *GossipMessage) GetPeerIdentity() *PeerIdentity {
	if x, ok := x.GetContent().(*GossipMessage_PeerIdentity); ok {
		return x.PeerIdentity
	}
	return nil
}

func (x *GossipMessage) GetAck() *Acknowledgement {
	if x, ok := x.GetContent().(*GossipMessage_Ack); ok {
		return x.Ack
	}
	return nil
}

func (x *GossipMessage) GetPrivateReq() *RemotePvtDataRequest {
	if x, ok := x.GetContent().(*GossipMessage_PrivateReq); ok {
		return x.PrivateReq
	}
	return nil
}

func (x *GossipMessage) GetPrivateRes() *RemotePvtDataResponse {
	if x, ok := x.GetContent().(*GossipMessage_PrivateRes); ok {
		return x.PrivateRes
	}
	return nil
}

func (x *GossipMessage) GetPrivateData() *PrivateDataMessage {
	if x, ok := x.GetContent().(*GossipMessage_PrivateData); ok {
		return x.PrivateData
	}
	return nil
}

type isGossipMessage_Content interface {
	isGossipMessage_Content()
}

type GossipMessage_AliveMsg struct {
	// Membership
	AliveMsg *AliveMessage `protobuf:"bytes,5,opt,name=alive_msg,json=aliveMsg,proto3,oneof"`
}

type GossipMessage_MemReq struct {
	MemReq *MembershipRequest `protobuf:"bytes,6,opt,name=mem_req,json=memReq,proto3,oneof"`
}

type GossipMessage_MemRes struct {
	MemRes *MembershipResponse `protobuf:"bytes,7,opt,name=mem_res,json=memRes,proto3,oneof"`
}

type GossipMessage_DataMsg struct {
	// Contains a ledger block
	DataMsg *DataMessage `protobuf:"bytes,8,opt,name=data_msg,json=dataMsg,proto3,oneof"`
}

type GossipMessage_Hello struct {
	// Used for push&pull
	Hello *GossipHello `protobuf:"bytes,9,opt,name=hello,proto3,oneof"`
}

type GossipMessage_DataDig struct {
	DataDig *DataDigest `protobuf:"bytes,10,opt,name=data_dig,json=dataDig,proto3,oneof"`
}

type GossipMessage_DataReq struct {
	DataReq *DataRequest `protobuf:"bytes,11,opt,name=data_req,json=dataReq,proto3,oneof"`
}

type GossipMessage_DataUpdate struct {
	DataUpdate *DataUpdate `protobuf:"bytes,12,opt,name=data_update,json=dataUpdate,proto3,oneof"`
}

type GossipMessage_Empty struct {
	// Empty message, used for pinging
	Empty *Empty `protobuf:"bytes,13,opt,name=empty,proto3,oneof"`
}

type GossipMessage_Conn struct {
	// ConnEstablish, used for establishing a connection
	Conn *ConnEstablish `protobuf:"bytes,14,opt,name=conn,proto3,oneof"`
}

type GossipMessage_StateInfo struct {
	// Used for relaying information
	// about state
	StateInfo *StateInfo `protobuf:"bytes,15,opt,name=state_info,json=stateInfo,proto3,oneof"`
}

type GossipMessage_StateSnapshot struct {
	// Used for sending sets of StateInfo messages
	StateSnapshot *StateInfoSnapshot `protobuf:"bytes,16,opt,name=state_snapshot,json=stateSnapshot,proto3,oneof"`
}

type GossipMessage_StateInfoPullReq struct {
	// Used for asking for StateInfoSnapshots
	StateInfoPullReq *StateInfoPullRequest `protobuf:"bytes,17,opt,name=state_info_pull_req,json=stateInfoPullReq,proto3,oneof"`
}

type GossipMessage_StateRequest struct {
	// Used to ask from a remote peer a set of blocks
	StateRequest *RemoteStateRequest `protobuf:"bytes,18,opt,name=state_request,json=stateRequest,proto3,oneof"`
}

type GossipMessage_StateResponse struct {
	// Used to send a set of blocks to a remote peer
	StateResponse *RemoteStateResponse `protobuf:"bytes,19,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

type GossipMessage_LeadershipMsg struct {
	// Used to indicate intent of peer to become leader
	LeadershipMsg *LeadershipMessage `protobuf:"bytes,20,opt,name=leadership_msg,json=leadershipMsg,proto3,oneof"`
}

type GossipMessage_PeerIdentity struct {
	// Used to learn of a peer's certificate
	PeerIdentity *PeerIdentity `protobuf:"bytes,21,opt,name=peer_identity,json=peerIdentity,proto3,oneof"`
}

type GossipMessage_Ack struct {
	Ack *Acknowledgement `protobuf:"bytes,22,opt,name=ack,proto3,oneof"`
}

type GossipMessage_PrivateReq struct {
	// Used to request private data
	PrivateReq *RemotePvtDataRequest `protobuf:"bytes,23,opt,name=privateReq,proto3,oneof"`
}

type GossipMessage_PrivateRes struct {
	// Used to respond to private data requests
	PrivateRes *RemotePvtDataResponse `protobuf:"bytes,24,opt,name=privateRes,proto3,oneof"`
}

type GossipMessage_PrivateData struct {
	// Encapsulates private data used to distribute
	// private rwset after the endorsement
	PrivateData *PrivateDataMessage `protobuf:"bytes,25,opt,name=private_data,json=privateData,proto3,oneof"`
}

func (*GossipMessage_AliveMsg) isGossipMessage_Content() {}

func (*GossipMessage_MemReq) isGossipMessage_Content() {}

func (*GossipMessage_MemRes) isGossipMessage_Content() {}

func (*GossipMessage_DataMsg) isGossipMessage_Content() {}

func (*GossipMessage_Hello) isGossipMessage_Content() {}

func (*GossipMessage_DataDig) isGossipMessage_Content() {}

func (*GossipMessage_DataReq) isGossipMessage_Content() {}

func (*GossipMessage_DataUpdate) isGossipMessage_Content() {}

func (*GossipMessage_Empty) isGossipMessage_Content() {}

func (*GossipMessage_Conn) isGossipMessage_Content() {}

func (*GossipMessage_StateInfo) isGossipMessage_Content() {}

func (*GossipMessage_StateSnapshot) isGossipMessage_Content() {}

func (*GossipMessage_StateInfoPullReq) isGossipMessage_Content() {}

func (*GossipMessage_StateRequest) isGossipMessage_Content() {}

func (*GossipMessage_StateResponse) isGossipMessage_Content() {}

func (*GossipMessage_LeadershipMsg) isGossipMessage_Content() {}

func (*GossipMessage_PeerIdentity) isGossipMessage_Content() {}

func (*GossipMessage_Ack) isGossipMessage_Content() {}

func (*GossipMessage_PrivateReq) isGossipMessage_Content() {}

func (*GossipMessage_PrivateRes) isGossipMessage_Content() {}

func (*GossipMessage_PrivateData) isGossipMessage_Content() {}

// StateInfo is used for a peer to relay its state information
// to other peers
type StateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Timestamp *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	PkiId     []byte    `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC []byte      `protobuf:"bytes,4,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
	Properties  *Properties `protobuf:"bytes,5,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *StateInfo) Reset() {
	*x = StateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateInfo) ProtoMessage() {}

func (x *StateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateInfo.ProtoReflect.Descriptor instead.
func (*StateInfo) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{4}
}

func (x *StateInfo) GetTimestamp() *PeerTime {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *StateInfo) GetPkiId() []byte {
	if x != nil {
		return x.PkiId
	}
	return nil
}

func (x *StateInfo) GetChannel_MAC() []byte {
	if x != nil {
		return x.Channel_MAC
	}
	return nil
}

func (x *StateInfo) GetProperties() *Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

type Properties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LedgerHeight uint64       `protobuf:"varint,1,opt,name=ledger_height,json=ledgerHeight,proto3" json:"ledger_height,omitempty"`
	LeftChannel  bool         `protobuf:"varint,2,opt,name=left_channel,json=leftChannel,proto3" json:"left_channel,omitempty"`
	Chaincodes   []*Chaincode `protobuf:"bytes,3,rep,name=chaincodes,proto3" json:"chaincodes,omitempty"`
}

func (x *Properties) Reset() {
	*x = Properties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Properties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Properties) ProtoMessage() {}

func (x *Properties) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Properties.ProtoReflect.Descriptor instead.
func (*Properties) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{5}
}

func (x *Properties) GetLedgerHeight() uint64 {
	if x != nil {
		return x.LedgerHeight
	}
	return 0
}

func (x *Properties) GetLeftChannel() bool {
	if x != nil {
		return x.LeftChannel
	}
	return false
}

func (x *Properties) GetChaincodes() []*Chaincode {
	if x != nil {
		return x.Chaincodes
	}
	return nil
}

// StateInfoSnapshot is an aggregation of StateInfo messages
type StateInfoSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Elements []*Envelope `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
}

func (x *StateInfoSnapshot) Reset() {
	*x = StateInfoSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateInfoSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateInfoSnapshot) ProtoMessage() {}

func (x *StateInfoSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateInfoSnapshot.ProtoReflect.Descriptor instead.
func (*StateInfoSnapshot) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{6}
}

func (x *StateInfoSnapshot) GetElements() []*Envelope {
	if x != nil {
		return x.Elements
	}
	return nil
}

// StateInfoPullRequest is used to fetch a StateInfoSnapshot
// from a remote peer
type StateInfoPullRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC []byte `protobuf:"bytes,1,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
}

func (x *StateInfoPullRequest) Reset() {
	*x = StateInfoPullRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateInfoPullRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateInfoPullRequest) ProtoMessage() {}

func (x *StateInfoPullRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateInfoPullRequest.ProtoReflect.Descriptor instead.
func (*StateInfoPullRequest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{7}
}

func (x *StateInfoPullRequest) GetChannel_MAC() []byte {
	if x != nil {
		return x.Channel_MAC
	}
	return nil
}

// ConnEstablish is the message used for the gossip handshake
// Whenever a peer connects to another peer, it handshakes
// with it by sending this message that proves its identity
type ConnEstablish struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PkiId       []byte `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Identity    []byte `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	TlsCertHash []byte `protobuf:"bytes,3,opt,name=tls_cert_hash,json=tlsCertHash,proto3" json:"tls_cert_hash,omitempty"`
	Probe       bool   `protobuf:"varint,4,opt,name=probe,proto3" json:"probe,omitempty"`
}

func (x *ConnEstablish) Reset() {
	*x = ConnEstablish{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnEstablish) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnEstablish) ProtoMessage() {}

func (x *ConnEstablish) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnEstablish.ProtoReflect.Descriptor instead.
func (*ConnEstablish) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{8}
}

func (x *ConnEstablish) GetPkiId() []byte {
	if x != nil {
		return x.PkiId
	}
	return nil
}

func (x *ConnEstablish) GetIdentity() []byte {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (x *ConnEstablish) GetTlsCertHash() []byte {
	if x != nil {
		return x.TlsCertHash
	}
	return nil
}

func (x *ConnEstablish) GetProbe() bool {
	if x != nil {
		return x.Probe
	}
	return false
}

// PeerIdentity defines the identity of the peer
// Used to make other peers learn of the identity
// of a certain peer
type PeerIdentity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PkiId    []byte `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Cert     []byte `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
	Metadata []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PeerIdentity) Reset() {
	*x = PeerIdentity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeerIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerIdentity) ProtoMessage() {}

func (x *PeerIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerIdentity.ProtoReflect.Descriptor instead.
func (*PeerIdentity) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{9}
}

func (x *PeerIdentity) GetPkiId() []byte {
	if x != nil {
		return x.PkiId
	}
	return nil
}

func (x *PeerIdentity) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

func (x *PeerIdentity) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// DataRequest is a message used for a peer to request
// certain data blocks from a remote peer
type DataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Digests [][]byte    `protobuf:"bytes,2,rep,name=digests,proto3" json:"digests,omitempty"`
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (x *DataRequest) Reset() {
	*x = DataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRequest) ProtoMessage() {}

func (x *DataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRequest.ProtoReflect.Descriptor instead.
func (*DataRequest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{10}
}

func (x *DataRequest) GetNonce() uint64 {
	if x != nil {
		return x.Nonce
	}
	return 0
}

func (x *DataRequest) GetDigests() [][]byte {
	if x != nil {
		return x.Digests
	}
	return nil
}

func (x *DataRequest) GetMsgType() PullMsgType {
	if x != nil {
		return x.MsgType
	}
	return PullMsgType_UNDEFINED
}

// GossipHello is the message that is used for the peer to initiate
// a pull round with another peer
type GossipHello struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce    uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Metadata []byte      `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	MsgType  PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (x *GossipHello) Reset() {
	*x = GossipHello{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GossipHello) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GossipHello) ProtoMessage() {}

func (x *GossipHello) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GossipHello.ProtoReflect.Descriptor instead.
func (*GossipHello) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{11}
}

func (x *GossipHello) GetNonce() uint64 {
	if x != nil {
		return x.Nonce
	}
	return 0
}

func (x *GossipHello) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GossipHello) GetMsgType() PullMsgType {
	if x != nil {
		return x.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataUpdate is the final message in the pull phase
// sent from the receiver to the initiator
type DataUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Data    []*Envelope `protobuf:"bytes,2,rep,name=data,proto3" json:"data,omitempty"`
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (x *DataUpdate) Reset() {
	*x = DataUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataUpdate) ProtoMessage() {}

func (x *DataUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataUpdate.ProtoReflect.Descriptor instead.
func (*DataUpdate) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{12}
}

func (x *DataUpdate) GetNonce() uint64 {
	if x != nil {
		return x.Nonce
	}
	return 0
}

func (x *DataUpdate) GetData() []*Envelope {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DataUpdate) GetMsgType() PullMsgType {
	if x != nil {
		return x.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataDigest is the message sent from the receiver peer
// to the initator peer and contains the data items it has
type DataDigest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Digests [][]byte    `protobuf:"bytes,2,rep,name=digests,proto3" json:"digests,omitempty"` // Maybe change this to bitmap later on
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (x *DataDigest) Reset() {
	*x = DataDigest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataDigest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDigest) ProtoMessage() {}

func (x *DataDigest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDigest.ProtoReflect.Descriptor instead.
func (*DataDigest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{13}
}

func (x *DataDigest) GetNonce() uint64 {
	if x != nil {
		return x.Nonce
	}
	return 0
}

func (x *DataDigest) GetDigests() [][]byte {
	if x != nil {
		return x.Digests
	}
	return nil
}

func (x *DataDigest) GetMsgType() PullMsgType {
	if x != nil {
		return x.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataMessage is the message that contains a block
type DataMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *DataMessage) Reset() {
	*x = DataMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataMessage) ProtoMessage() {}

func (x *DataMessage) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataMessage.ProtoReflect.Descriptor instead.
func (*DataMessage) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{14}
}

func (x *DataMessage) GetPayload() *Payload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// PrivateDataMessage message which includes private
// data information to distributed once transaction
// has been endorsed
type PrivateDataMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload *PrivatePayload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *PrivateDataMessage) Reset() {
	*x = PrivateDataMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateDataMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateDataMessage) ProtoMessage() {}

func (x *PrivateDataMessage) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateDataMessage.ProtoReflect.Descriptor instead.
func (*PrivateDataMessage) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{15}
}

func (x *PrivateDataMessage) GetPayload() *PrivatePayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Payload contains a block
type Payload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SeqNum      uint64   `protobuf:"varint,1,opt,name=seq_num,json=seqNum,proto3" json:"seq_num,omitempty"`
	Data        []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	PrivateData [][]byte `protobuf:"bytes,3,rep,name=private_data,json=privateData,proto3" json:"private_data,omitempty"`
}

func (x *Payload) Reset() {
	*x = Payload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Payload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Payload) ProtoMessage() {}

func (x *Payload) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Payload.ProtoReflect.Descriptor instead.
func (*Payload) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{16}
}

func (x *Payload) GetSeqNum() uint64 {
	if x != nil {
		return x.SeqNum
	}
	return 0
}

func (x *Payload) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Payload) GetPrivateData() [][]byte {
	if x != nil {
		return x.PrivateData
	}
	return nil
}

// PrivatePayload payload to encapsulate private
// data with collection name to enable routing
// based on collection partitioning
type PrivatePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CollectionName    string                        `protobuf:"bytes,1,opt,name=collection_name,json=collectionName,proto3" json:"collection_name,omitempty"`
	Namespace         string                        `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	TxId              string                        `protobuf:"bytes,3,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	PrivateRwset      []byte                        `protobuf:"bytes,4,opt,name=private_rwset,json=privateRwset,proto3" json:"private_rwset,omitempty"`
	PrivateSimHeight  uint64                        `protobuf:"varint,5,opt,name=private_sim_height,json=privateSimHeight,proto3" json:"private_sim_height,omitempty"`
	CollectionConfigs *peer.CollectionConfigPackage `protobuf:"bytes,6,opt,name=collection_configs,json=collectionConfigs,proto3" json:"collection_configs,omitempty"`
}

func (x *PrivatePayload) Reset() {
	*x = PrivatePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivatePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivatePayload) ProtoMessage() {}

func (x *PrivatePayload) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivatePayload.ProtoReflect.Descriptor instead.
func (*PrivatePayload) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{17}
}

func (x *PrivatePayload) GetCollectionName() string {
	if x != nil {
		return x.CollectionName
	}
	return ""
}

func (x *PrivatePayload) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *PrivatePayload) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

func (x *PrivatePayload) GetPrivateRwset() []byte {
	if x != nil {
		return x.PrivateRwset
	}
	return nil
}

func (x *PrivatePayload) GetPrivateSimHeight() uint64 {
	if x != nil {
		return x.PrivateSimHeight
	}
	return 0
}

func (x *PrivatePayload) GetCollectionConfigs() *peer.CollectionConfigPackage {
	if x != nil {
		return x.CollectionConfigs
	}
	return nil
}

// AliveMessage is sent to inform remote peers
// of a peer's existence and activity
type AliveMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Membership *Member   `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
	Timestamp  *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Identity   []byte    `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *AliveMessage) Reset() {
	*x = AliveMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AliveMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AliveMessage) ProtoMessage() {}

func (x *AliveMessage) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AliveMessage.ProtoReflect.Descriptor instead.
func (*AliveMessage) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{18}
}

func (x *AliveMessage) GetMembership() *Member {
	if x != nil {
		return x.Membership
	}
	return nil
}

func (x *AliveMessage) GetTimestamp() *PeerTime {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *AliveMessage) GetIdentity() []byte {
	if x != nil {
		return x.Identity
	}
	return nil
}

// Leadership Message is sent during leader election to inform
// remote peers about intent of peer to proclaim itself as leader
type LeadershipMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PkiId         []byte    `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Timestamp     *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	IsDeclaration bool      `protobuf:"varint,3,opt,name=is_declaration,json=isDeclaration,proto3" json:"is_declaration,omitempty"`
}

func (x *LeadershipMessage) Reset() {
	*x = LeadershipMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeadershipMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeadershipMessage) ProtoMessage() {}

func (x *LeadershipMessage) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeadershipMessage.ProtoReflect.Descriptor instead.
func (*LeadershipMessage) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{19}
}

func (x *LeadershipMessage) GetPkiId() []byte {
	if x != nil {
		return x.PkiId
	}
	return nil
}

func (x *LeadershipMessage) GetTimestamp() *PeerTime {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *LeadershipMessage) GetIsDeclaration() bool {
	if x != nil {
		return x.IsDeclaration
	}
	return false
}

// PeerTime defines the logical time of a peer's life
type PeerTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IncNum uint64 `protobuf:"varint,1,opt,name=inc_num,json=incNum,proto3" json:"inc_num,omitempty"`
	SeqNum uint64 `protobuf:"varint,2,opt,name=seq_num,json=seqNum,proto3" json:"seq_num,omitempty"`
}

func (x *PeerTime) Reset() {
	*x = PeerTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeerTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerTime) ProtoMessage() {}

func (x *PeerTime) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerTime.ProtoReflect.Descriptor instead.
func (*PeerTime) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{20}
}

func (x *PeerTime) GetIncNum() uint64 {
	if x != nil {
		return x.IncNum
	}
	return 0
}

func (x *PeerTime) GetSeqNum() uint64 {
	if x != nil {
		return x.SeqNum
	}
	return 0
}

// MembershipRequest is used to ask membership information
// from a remote peer
type MembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SelfInformation *Envelope `protobuf:"bytes,1,opt,name=self_information,json=selfInformation,proto3" json:"self_information,omitempty"`
	Known           [][]byte  `protobuf:"bytes,2,rep,name=known,proto3" json:"known,omitempty"`
}

func (x *MembershipRequest) Reset() {
	*x = MembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipRequest) ProtoMessage() {}

func (x *MembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipRequest.ProtoReflect.Descriptor instead.
func (*MembershipRequest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{21}
}

func (x *MembershipRequest) GetSelfInformation() *Envelope {
	if x != nil {
		return x.SelfInformation
	}
	return nil
}

func (x *MembershipRequest) GetKnown() [][]byte {
	if x != nil {
		return x.Known
	}
	return nil
}

// MembershipResponse is used for replying to MembershipRequests
type MembershipResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Alive []*Envelope `protobuf:"bytes,1,rep,name=alive,proto3" json:"alive,omitempty"`
	Dead  []*Envelope `protobuf:"bytes,2,rep,name=dead,proto3" json:"dead,omitempty"`
}

func (x *MembershipResponse) Reset() {
	*x = MembershipResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipResponse) ProtoMessage() {}

func (x *MembershipResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipResponse.ProtoReflect.Descriptor instead.
func (*MembershipResponse) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{22}
}

func (x *MembershipResponse) GetAlive() []*Envelope {
	if x != nil {
		return x.Alive
	}
	return nil
}

func (x *MembershipResponse) GetDead() []*Envelope {
	if x != nil {
		return x.Dead
	}
	return nil
}

// Member holds membership-related information
// about a peer
type Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Metadata []byte `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	PkiId    []byte `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
}

func (x *Member) Reset() {
	*x = Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Member) ProtoMessage() {}

func (x *Member) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Member.ProtoReflect.Descriptor instead.
func (*Member) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{23}
}

func (x *Member) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *Member) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Member) GetPkiId() []byte {
	if x != nil {
		return x.PkiId
	}
	return nil
}

// Empty is used for pinging and in tests
type Empty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Empty) Reset() {
	*x = Empty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{24}
}

// RemoteStateRequest is used to ask a set of blocks
// from a remote peer
type RemoteStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartSeqNum uint64 `protobuf:"varint,1,opt,name=start_seq_num,json=startSeqNum,proto3" json:"start_seq_num,omitempty"`
	EndSeqNum   uint64 `protobuf:"varint,2,opt,name=end_seq_num,json=endSeqNum,proto3" json:"end_seq_num,omitempty"`
}

func (x *RemoteStateRequest) Reset() {
	*x = RemoteStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteStateRequest) ProtoMessage() {}

func (x *RemoteStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteStateRequest.ProtoReflect.Descriptor instead.
func (*RemoteStateRequest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{25}
}

func (x *RemoteStateRequest) GetStartSeqNum() uint64 {
	if x != nil {
		return x.StartSeqNum
	}
	return 0
}

func (x *RemoteStateRequest) GetEndSeqNum() uint64 {
	if x != nil {
		return x.EndSeqNum
	}
	return 0
}

// RemoteStateResponse is used to send a set of blocks
// to a remote peer
type RemoteStateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payloads []*Payload `protobuf:"bytes,1,rep,name=payloads,proto3" json:"payloads,omitempty"`
}

func (x *RemoteStateResponse) Reset() {
	*x = RemoteStateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteStateResponse) ProtoMessage() {}

func (x *RemoteStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteStateResponse.ProtoReflect.Descriptor instead.
func (*RemoteStateResponse) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{26}
}

func (x *RemoteStateResponse) GetPayloads() []*Payload {
	if x != nil {
		return x.Payloads
	}
	return nil
}

// RemotePrivateDataRequest message used to request
// missing private rwset
type RemotePvtDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Digests []*PvtDataDigest `protobuf:"bytes,1,rep,name=digests,proto3" json:"digests,omitempty"`
}

func (x *RemotePvtDataRequest) Reset() {
	*x = RemotePvtDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemotePvtDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemotePvtDataRequest) ProtoMessage() {}

func (x *RemotePvtDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemotePvtDataRequest.ProtoReflect.Descriptor instead.
func (*RemotePvtDataRequest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{27}
}

func (x *RemotePvtDataRequest) GetDigests() []*PvtDataDigest {
	if x != nil {
		return x.Digests
	}
	return nil
}

// PvtDataDigest defines a digest of private data
type PvtDataDigest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TxId       string `protobuf:"bytes,1,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	Namespace  string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Collection string `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	BlockSeq   uint64 `protobuf:"varint,4,opt,name=block_seq,json=blockSeq,proto3" json:"block_seq,omitempty"`
	SeqInBlock uint64 `protobuf:"varint,5,opt,name=seq_in_block,json=seqInBlock,proto3" json:"seq_in_block,omitempty"`
}

func (x *PvtDataDigest) Reset() {
	*x = PvtDataDigest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PvtDataDigest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PvtDataDigest) ProtoMessage() {}

func (x *PvtDataDigest) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PvtDataDigest.ProtoReflect.Descriptor instead.
func (*PvtDataDigest) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{28}
}

func (x *PvtDataDigest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

func (x *PvtDataDigest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *PvtDataDigest) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *PvtDataDigest) GetBlockSeq() uint64 {
	if x != nil {
		return x.BlockSeq
	}
	return 0
}

func (x *PvtDataDigest) GetSeqInBlock() uint64 {
	if x != nil {
		return x.SeqInBlock
	}
	return 0
}

// RemotePrivateData message to response on private
// data replication request
type RemotePvtDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Elements []*PvtDataElement `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
}

func (x *RemotePvtDataResponse) Reset() {
	*x = RemotePvtDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemotePvtDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemotePvtDataResponse) ProtoMessage() {}

func (x *RemotePvtDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemotePvtDataResponse.ProtoReflect.Descriptor instead.
func (*RemotePvtDataResponse) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{29}
}

func (x *RemotePvtDataResponse) GetElements() []*PvtDataElement {
	if x != nil {
		return x.Elements
	}
	return nil
}

type PvtDataElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Digest *PvtDataDigest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// the payload is a marshaled kvrwset.KVRWSet
	Payload [][]byte `protobuf:"bytes,2,rep,name=payload,proto3" json:"payload,omitempty"`
}

func (x *PvtDataElement) Reset() {
	*x = PvtDataElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PvtDataElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PvtDataElement) ProtoMessage() {}

func (x *PvtDataElement) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PvtDataElement.ProtoReflect.Descriptor instead.
func (*PvtDataElement) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{30}
}

func (x *PvtDataElement) GetDigest() *PvtDataDigest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *PvtDataElement) GetPayload() [][]byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// PvtPayload augments private rwset data and tx index
// inside the block
type PvtDataPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TxSeqInBlock uint64 `protobuf:"varint,1,opt,name=tx_seq_in_block,json=txSeqInBlock,proto3" json:"tx_seq_in_block,omitempty"`
	// Encodes marhslaed bytes of rwset.TxPvtReadWriteSet
	// defined in rwset.proto
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *PvtDataPayload) Reset() {
	*x = PvtDataPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PvtDataPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PvtDataPayload) ProtoMessage() {}

func (x *PvtDataPayload) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PvtDataPayload.ProtoReflect.Descriptor instead.
func (*PvtDataPayload) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{31}
}

func (x *PvtDataPayload) GetTxSeqInBlock() uint64 {
	if x != nil {
		return x.TxSeqInBlock
	}
	return 0
}

func (x *PvtDataPayload) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

type Acknowledgement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Acknowledgement) Reset() {
	*x = Acknowledgement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Acknowledgement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Acknowledgement) ProtoMessage() {}

func (x *Acknowledgement) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Acknowledgement.ProtoReflect.Descriptor instead.
func (*Acknowledgement) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{32}
}

func (x *Acknowledgement) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Chaincode represents a Chaincode that is installed
// on a peer
type Chaincode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version  string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Metadata []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *Chaincode) Reset() {
	*x = Chaincode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gossip_message_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Chaincode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Chaincode) ProtoMessage() {}

func (x *Chaincode) ProtoReflect() protoreflect.Message {
	mi := &file_gossip_message_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Chaincode.ProtoReflect.Descriptor instead.
func (*Chaincode) Descriptor() ([]byte, []int) {
	return file_gossip_message_proto_rawDescGZIP(), []int{33}
}

func (x *Chaincode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Chaincode) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Chaincode) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

var File_gossip_message_proto protoreflect.FileDescriptor

var file_gossip_message_proto_rawDesc = []byte{
	0x0a, 0x14, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x1a, 0x15,
	0x70, 0x65, 0x65, 0x72, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x01, 0x0a, 0x08, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x0e, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x22, 0x48, 0x0a, 0x0e, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x41, 0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x2c, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x09, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x87, 0x0b, 0x0a, 0x0d, 0x47, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x61,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70,
	0x2e, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54,
	0x61, 0x67, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x33, 0x0a, 0x09, 0x61, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x6d, 0x73, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x08, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x4d, 0x73, 0x67, 0x12, 0x34, 0x0a, 0x07,
	0x6d, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x52,
	0x65, 0x71, 0x12, 0x35, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48,
	0x00, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6d, 0x73, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x4d, 0x73, 0x67, 0x12, 0x2b, 0x0a, 0x05, 0x68,
	0x65, 0x6c, 0x6c, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x48,
	0x00, 0x52, 0x05, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x12, 0x2f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x64, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x12, 0x35, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0d, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x48, 0x00, 0x52, 0x05, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2b, 0x0a, 0x04, 0x63, 0x6f, 0x6e,
	0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x48, 0x00,
	0x52, 0x04, 0x63, 0x6f, 0x6e, 0x6e, 0x12, 0x32, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x42, 0x0a, 0x0e, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x48, 0x00, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x4d,
	0x0a, 0x13, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x70, 0x75, 0x6c,
	0x6c, 0x5f, 0x72, 0x65, 0x71, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x75,
	0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x41, 0x0a,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69,
	0x70, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x6d, 0x73, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x6c, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x4d, 0x73, 0x67, 0x12, 0x3b, 0x0a, 0x0d, 0x70, 0x65,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x2b, 0x0a, 0x03, 0x61, 0x63, 0x6b, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x41, 0x63,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x03, 0x61, 0x63, 0x6b, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69,
	0x70, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69,
	0x70, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22, 0x5f, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x0d, 0x0a,
	0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x52, 0x47, 0x5f, 0x4f,
	0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x48, 0x41, 0x4e, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x4f, 0x52, 0x47, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x48, 0x41, 0x4e, 0x5f, 0x4f,
	0x52, 0x5f, 0x4f, 0x52, 0x47, 0x10, 0x05, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0xa7, 0x01, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x2e, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x65, 0x65,
	0x72, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x15, 0x0a, 0x06, 0x70, 0x6b, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x05, 0x70, 0x6b, 0x69, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x4d, 0x41, 0x43, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x41, 0x43, 0x12, 0x32, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x87, 0x01, 0x0a,
	0x0a, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x72, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0c, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6c, 0x65, 0x66, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70,
	0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x41, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x2c, 0x0a, 0x08, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52,
	0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x37, 0x0a, 0x14, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x4d, 0x41, 0x43,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d,
	0x41, 0x43, 0x22, 0x7c, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x6e, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x6b, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x70, 0x6b, 0x69, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74,
	0x6c, 0x73, 0x43, 0x65, 0x72, 0x74, 0x48, 0x61, 0x73, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x72,
	0x6f, 0x62, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x22, 0x55, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x15, 0x0a, 0x06, 0x70, 0x6b, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x05, 0x70, 0x6b, 0x69, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x6d, 0x0a, 0x0b, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x07, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12, 0x2e, 0x0a, 0x08, 0x6d, 0x73, 0x67, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69,
	0x70, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6d,
	0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x6f, 0x0a, 0x0b, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70,
	0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2e, 0x0a, 0x08, 0x6d, 0x73, 0x67, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x73, 0x73,
	0x69, 0x70, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07,
	0x6d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x78, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73,
	0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x2e, 0x0a, 0x08, 0x6d, 0x73, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x75, 0x6c,
	0x6c, 0x4d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x6c, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05,
	0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x12,
	0x2e, 0x0a, 0x08, 0x6d, 0x73, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d,
	0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x38, 0x0a, 0x0b, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x29,
	0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x46, 0x0a, 0x12, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x30, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x22, 0x59, 0x0a, 0x07, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x17, 0x0a, 0x07,
	0x73, 0x65, 0x71, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x73,
	0x65, 0x71, 0x4e, 0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22, 0x8f, 0x02, 0x0a,
	0x0e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x77, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52, 0x77, 0x73, 0x65, 0x74,
	0x12, 0x2c, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x6d, 0x5f,
	0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6d, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x4e,
	0x0a, 0x12, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x11, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0x8a,
	0x01, 0x0a, 0x0c, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x2e, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12,
	0x2e, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x65, 0x65, 0x72,
	0x54, 0x69, 0x6d, 0x65, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x81, 0x01, 0x0a, 0x11,
	0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x6b, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x05, 0x70, 0x6b, 0x69, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x64,
	0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x69, 0x73, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x3c, 0x0a, 0x08, 0x50, 0x65, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x69,
	0x6e, 0x63, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x69, 0x6e,
	0x63, 0x4e, 0x75, 0x6d, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x65, 0x71, 0x5f, 0x6e, 0x75, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x73, 0x65, 0x71, 0x4e, 0x75, 0x6d, 0x22, 0x66, 0x0a,
	0x11, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3b, 0x0a, 0x10, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67,
	0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x0f,
	0x73, 0x65, 0x6c, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x14, 0x0a, 0x05, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x05,
	0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x22, 0x62, 0x0a, 0x12, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x05, 0x61,
	0x6c, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x61, 0x6c,
	0x69, 0x76, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x64, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x52, 0x04, 0x64, 0x65, 0x61, 0x64, 0x22, 0x57, 0x0a, 0x06, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x15, 0x0a, 0x06, 0x70,
	0x6b, 0x69, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x70, 0x6b, 0x69,
	0x49, 0x64, 0x22, 0x07, 0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x58, 0x0a, 0x12, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x22, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x73, 0x65, 0x71, 0x5f, 0x6e,
	0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x53,
	0x65, 0x71, 0x4e, 0x75, 0x6d, 0x12, 0x1e, 0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x73, 0x65, 0x71,
	0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x53,
	0x65, 0x71, 0x4e, 0x75, 0x6d, 0x22, 0x42, 0x0a, 0x13, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x08,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f,
	0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x08, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x22, 0x47, 0x0a, 0x14, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x2f, 0x0a, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x76, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x07, 0x64, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x0d, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x73, 0x65, 0x71, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x53, 0x65, 0x71, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x65, 0x71, 0x5f, 0x69, 0x6e, 0x5f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x65, 0x71, 0x49,
	0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x4b, 0x0a, 0x15, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x32, 0x0a, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50, 0x76, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0x59, 0x0a, 0x0e, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x50,
	0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x51,
	0x0a, 0x0e, 0x50, 0x76, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x25, 0x0a, 0x0f, 0x74, 0x78, 0x5f, 0x73, 0x65, 0x71, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x74, 0x78, 0x53, 0x65, 0x71,
	0x49, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x22, 0x27, 0x0a, 0x0f, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x55, 0x0a, 0x09, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2a, 0x3d, 0x0a, 0x0b, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x53, 0x47, 0x10, 0x01, 0x12, 0x10,
	0x0a, 0x0c, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x53, 0x47, 0x10, 0x02,
	0x32, 0x66, 0x0a, 0x06, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x12, 0x36, 0x0a, 0x0c, 0x47, 0x6f,
	0x73, 0x73, 0x69, 0x70, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x1a, 0x10, 0x2e, 0x67,
	0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x28, 0x01,
	0x30, 0x01, 0x12, 0x24, 0x0a, 0x04, 0x50, 0x69, 0x6e, 0x67, 0x12, 0x0d, 0x2e, 0x67, 0x6f, 0x73,
	0x73, 0x69, 0x70, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x0d, 0x2e, 0x67, 0x6f, 0x73, 0x73,
	0x69, 0x70, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42, 0xa2, 0x01, 0x0a, 0x24, 0x6f, 0x72, 0x67,
	0x2e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66, 0x61, 0x62,
	0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69,
	0x70, 0x42, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79,
	0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f, 0x66, 0x61, 0x62, 0x72, 0x69, 0x63,
	0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f, 0x2d, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0xa2, 0x02, 0x03, 0x47, 0x58, 0x58, 0xaa, 0x02, 0x06,
	0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0xca, 0x02, 0x06, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0xe2,
	0x02, 0x12, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x06, 0x47, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_gossip_message_proto_rawDescOnce sync.Once
	file_gossip_message_proto_rawDescData = file_gossip_message_proto_rawDesc
)

func file_gossip_message_proto_rawDescGZIP() []byte {
	file_gossip_message_proto_rawDescOnce.Do(func() {
		file_gossip_message_proto_rawDescData = protoimpl.X.CompressGZIP(file_gossip_message_proto_rawDescData)
	})
	return file_gossip_message_proto_rawDescData
}

var file_gossip_message_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_gossip_message_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_gossip_message_proto_goTypes = []interface{}{
	(PullMsgType)(0),                     // 0: gossip.PullMsgType
	(GossipMessage_Tag)(0),               // 1: gossip.GossipMessage.Tag
	(*Envelope)(nil),                     // 2: gossip.Envelope
	(*SecretEnvelope)(nil),               // 3: gossip.SecretEnvelope
	(*Secret)(nil),                       // 4: gossip.Secret
	(*GossipMessage)(nil),                // 5: gossip.GossipMessage
	(*StateInfo)(nil),                    // 6: gossip.StateInfo
	(*Properties)(nil),                   // 7: gossip.Properties
	(*StateInfoSnapshot)(nil),            // 8: gossip.StateInfoSnapshot
	(*StateInfoPullRequest)(nil),         // 9: gossip.StateInfoPullRequest
	(*ConnEstablish)(nil),                // 10: gossip.ConnEstablish
	(*PeerIdentity)(nil),                 // 11: gossip.PeerIdentity
	(*DataRequest)(nil),                  // 12: gossip.DataRequest
	(*GossipHello)(nil),                  // 13: gossip.GossipHello
	(*DataUpdate)(nil),                   // 14: gossip.DataUpdate
	(*DataDigest)(nil),                   // 15: gossip.DataDigest
	(*DataMessage)(nil),                  // 16: gossip.DataMessage
	(*PrivateDataMessage)(nil),           // 17: gossip.PrivateDataMessage
	(*Payload)(nil),                      // 18: gossip.Payload
	(*PrivatePayload)(nil),               // 19: gossip.PrivatePayload
	(*AliveMessage)(nil),                 // 20: gossip.AliveMessage
	(*LeadershipMessage)(nil),            // 21: gossip.LeadershipMessage
	(*PeerTime)(nil),                     // 22: gossip.PeerTime
	(*MembershipRequest)(nil),            // 23: gossip.MembershipRequest
	(*MembershipResponse)(nil),           // 24: gossip.MembershipResponse
	(*Member)(nil),                       // 25: gossip.Member
	(*Empty)(nil),                        // 26: gossip.Empty
	(*RemoteStateRequest)(nil),           // 27: gossip.RemoteStateRequest
	(*RemoteStateResponse)(nil),          // 28: gossip.RemoteStateResponse
	(*RemotePvtDataRequest)(nil),         // 29: gossip.RemotePvtDataRequest
	(*PvtDataDigest)(nil),                // 30: gossip.PvtDataDigest
	(*RemotePvtDataResponse)(nil),        // 31: gossip.RemotePvtDataResponse
	(*PvtDataElement)(nil),               // 32: gossip.PvtDataElement
	(*PvtDataPayload)(nil),               // 33: gossip.PvtDataPayload
	(*Acknowledgement)(nil),              // 34: gossip.Acknowledgement
	(*Chaincode)(nil),                    // 35: gossip.Chaincode
	(*peer.CollectionConfigPackage)(nil), // 36: protos.CollectionConfigPackage
}
var file_gossip_message_proto_depIdxs = []int32{
	3,  // 0: gossip.Envelope.secret_envelope:type_name -> gossip.SecretEnvelope
	1,  // 1: gossip.GossipMessage.tag:type_name -> gossip.GossipMessage.Tag
	20, // 2: gossip.GossipMessage.alive_msg:type_name -> gossip.AliveMessage
	23, // 3: gossip.GossipMessage.mem_req:type_name -> gossip.MembershipRequest
	24, // 4: gossip.GossipMessage.mem_res:type_name -> gossip.MembershipResponse
	16, // 5: gossip.GossipMessage.data_msg:type_name -> gossip.DataMessage
	13, // 6: gossip.GossipMessage.hello:type_name -> gossip.GossipHello
	15, // 7: gossip.GossipMessage.data_dig:type_name -> gossip.DataDigest
	12, // 8: gossip.GossipMessage.data_req:type_name -> gossip.DataRequest
	14, // 9: gossip.GossipMessage.data_update:type_name -> gossip.DataUpdate
	26, // 10: gossip.GossipMessage.empty:type_name -> gossip.Empty
	10, // 11: gossip.GossipMessage.conn:type_name -> gossip.ConnEstablish
	6,  // 12: gossip.GossipMessage.state_info:type_name -> gossip.StateInfo
	8,  // 13: gossip.GossipMessage.state_snapshot:type_name -> gossip.StateInfoSnapshot
	9,  // 14: gossip.GossipMessage.state_info_pull_req:type_name -> gossip.StateInfoPullRequest
	27, // 15: gossip.GossipMessage.state_request:type_name -> gossip.RemoteStateRequest
	28, // 16: gossip.GossipMessage.state_response:type_name -> gossip.RemoteStateResponse
	21, // 17: gossip.GossipMessage.leadership_msg:type_name -> gossip.LeadershipMessage
	11, // 18: gossip.GossipMessage.peer_identity:type_name -> gossip.PeerIdentity
	34, // 19: gossip.GossipMessage.ack:type_name -> gossip.Acknowledgement
	29, // 20: gossip.GossipMessage.privateReq:type_name -> gossip.RemotePvtDataRequest
	31, // 21: gossip.GossipMessage.privateRes:type_name -> gossip.RemotePvtDataResponse
	17, // 22: gossip.GossipMessage.private_data:type_name -> gossip.PrivateDataMessage
	22, // 23: gossip.StateInfo.timestamp:type_name -> gossip.PeerTime
	7,  // 24: gossip.StateInfo.properties:type_name -> gossip.Properties
	35, // 25: gossip.Properties.chaincodes:type_name -> gossip.Chaincode
	2,  // 26: gossip.StateInfoSnapshot.elements:type_name -> gossip.Envelope
	0,  // 27: gossip.DataRequest.msg_type:type_name -> gossip.PullMsgType
	0,  // 28: gossip.GossipHello.msg_type:type_name -> gossip.PullMsgType
	2,  // 29: gossip.DataUpdate.data:type_name -> gossip.Envelope
	0,  // 30: gossip.DataUpdate.msg_type:type_name -> gossip.PullMsgType
	0,  // 31: gossip.DataDigest.msg_type:type_name -> gossip.PullMsgType
	18, // 32: gossip.DataMessage.payload:type_name -> gossip.Payload
	19, // 33: gossip.PrivateDataMessage.payload:type_name -> gossip.PrivatePayload
	36, // 34: gossip.PrivatePayload.collection_configs:type_name -> protos.CollectionConfigPackage
	25, // 35: gossip.AliveMessage.membership:type_name -> gossip.Member
	22, // 36: gossip.AliveMessage.timestamp:type_name -> gossip.PeerTime
	22, // 37: gossip.LeadershipMessage.timestamp:type_name -> gossip.PeerTime
	2,  // 38: gossip.MembershipRequest.self_information:type_name -> gossip.Envelope
	2,  // 39: gossip.MembershipResponse.alive:type_name -> gossip.Envelope
	2,  // 40: gossip.MembershipResponse.dead:type_name -> gossip.Envelope
	18, // 41: gossip.RemoteStateResponse.payloads:type_name -> gossip.Payload
	30, // 42: gossip.RemotePvtDataRequest.digests:type_name -> gossip.PvtDataDigest
	32, // 43: gossip.RemotePvtDataResponse.elements:type_name -> gossip.PvtDataElement
	30, // 44: gossip.PvtDataElement.digest:type_name -> gossip.PvtDataDigest
	2,  // 45: gossip.Gossip.GossipStream:input_type -> gossip.Envelope
	26, // 46: gossip.Gossip.Ping:input_type -> gossip.Empty
	2,  // 47: gossip.Gossip.GossipStream:output_type -> gossip.Envelope
	26, // 48: gossip.Gossip.Ping:output_type -> gossip.Empty
	47, // [47:49] is the sub-list for method output_type
	45, // [45:47] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_gossip_message_proto_init() }
func file_gossip_message_proto_init() {
	if File_gossip_message_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_gossip_message_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Envelope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretEnvelope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GossipMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Properties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateInfoSnapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateInfoPullRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnEstablish); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeerIdentity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GossipHello); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataDigest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateDataMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Payload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivatePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AliveMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeadershipMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeerTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Empty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteStateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemotePvtDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PvtDataDigest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemotePvtDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PvtDataElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PvtDataPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Acknowledgement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gossip_message_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Chaincode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_gossip_message_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Secret_InternalEndpoint)(nil),
	}
	file_gossip_message_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*GossipMessage_AliveMsg)(nil),
		(*GossipMessage_MemReq)(nil),
		(*GossipMessage_MemRes)(nil),
		(*GossipMessage_DataMsg)(nil),
		(*GossipMessage_Hello)(nil),
		(*GossipMessage_DataDig)(nil),
		(*GossipMessage_DataReq)(nil),
		(*GossipMessage_DataUpdate)(nil),
		(*GossipMessage_Empty)(nil),
		(*GossipMessage_Conn)(nil),
		(*GossipMessage_StateInfo)(nil),
		(*GossipMessage_StateSnapshot)(nil),
		(*GossipMessage_StateInfoPullReq)(nil),
		(*GossipMessage_StateRequest)(nil),
		(*GossipMessage_StateResponse)(nil),
		(*GossipMessage_LeadershipMsg)(nil),
		(*GossipMessage_PeerIdentity)(nil),
		(*GossipMessage_Ack)(nil),
		(*GossipMessage_PrivateReq)(nil),
		(*GossipMessage_PrivateRes)(nil),
		(*GossipMessage_PrivateData)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_gossip_message_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_gossip_message_proto_goTypes,
		DependencyIndexes: file_gossip_message_proto_depIdxs,
		EnumInfos:         file_gossip_message_proto_enumTypes,
		MessageInfos:      file_gossip_message_proto_msgTypes,
	}.Build()
	File_gossip_message_proto = out.File
	file_gossip_message_proto_rawDesc = nil
	file_gossip_message_proto_goTypes = nil
	file_gossip_message_proto_depIdxs = nil
}
