// Copyright the Hyperledger Fabric contributors. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: discovery/protocol.proto

package discovery

import (
	gossip "github.com/hyperledger/fabric-protos-go-apiv2/gossip"
	msp "github.com/hyperledger/fabric-protos-go-apiv2/msp"
	peer "github.com/hyperledger/fabric-protos-go-apiv2/peer"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SignedRequest contains a serialized Request in the payload field
// and a signature.
// The identity that is used to verify the signature
// can be extracted from the authentication field of type AuthInfo
// in the Request itself after deserializing it.
type SignedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload   []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SignedRequest) Reset() {
	*x = SignedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignedRequest) ProtoMessage() {}

func (x *SignedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignedRequest.ProtoReflect.Descriptor instead.
func (*SignedRequest) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{0}
}

func (x *SignedRequest) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *SignedRequest) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

// Request contains authentication info about the client that sent the request
// and the queries it wishes to query the service
type Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// authentication contains information that the service uses to check
	// the client's eligibility for the queries.
	Authentication *AuthInfo `protobuf:"bytes,1,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// queries
	Queries []*Query `protobuf:"bytes,2,rep,name=queries,proto3" json:"queries,omitempty"`
}

func (x *Request) Reset() {
	*x = Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Request) ProtoMessage() {}

func (x *Request) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Request.ProtoReflect.Descriptor instead.
func (*Request) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{1}
}

func (x *Request) GetAuthentication() *AuthInfo {
	if x != nil {
		return x.Authentication
	}
	return nil
}

func (x *Request) GetQueries() []*Query {
	if x != nil {
		return x.Queries
	}
	return nil
}

type Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results are returned in the same order of the queries
	Results []*QueryResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *Response) Reset() {
	*x = Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Response) ProtoMessage() {}

func (x *Response) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Response.ProtoReflect.Descriptor instead.
func (*Response) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{2}
}

func (x *Response) GetResults() []*QueryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// AuthInfo aggregates authentication information that the server uses
// to authenticate the client
type AuthInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the identity of the client that is used to verify the signature
	// on the SignedRequest's payload.
	// It is a msp.SerializedIdentity in bytes form
	ClientIdentity []byte `protobuf:"bytes,1,opt,name=client_identity,json=clientIdentity,proto3" json:"client_identity,omitempty"`
	// This is the hash of the client's TLS cert.
	// When the network is running with TLS, clients that don't include a certificate
	// will be denied access to the service.
	// Since the Request is encapsulated with a SignedRequest (which is signed),
	// this binds the TLS session to the enrollement identity of the client and
	// therefore both authenticates the client to the server,
	// and also prevents the server from relaying the request message to another server.
	ClientTlsCertHash []byte `protobuf:"bytes,2,opt,name=client_tls_cert_hash,json=clientTlsCertHash,proto3" json:"client_tls_cert_hash,omitempty"`
}

func (x *AuthInfo) Reset() {
	*x = AuthInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthInfo) ProtoMessage() {}

func (x *AuthInfo) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthInfo.ProtoReflect.Descriptor instead.
func (*AuthInfo) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{3}
}

func (x *AuthInfo) GetClientIdentity() []byte {
	if x != nil {
		return x.ClientIdentity
	}
	return nil
}

func (x *AuthInfo) GetClientTlsCertHash() []byte {
	if x != nil {
		return x.ClientTlsCertHash
	}
	return nil
}

// Query asks for information in the context of a specific channel
type Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	// Types that are assignable to Query:
	//
	//	*Query_ConfigQuery
	//	*Query_PeerQuery
	//	*Query_CcQuery
	//	*Query_LocalPeers
	Query isQuery_Query `protobuf_oneof:"query"`
}

func (x *Query) Reset() {
	*x = Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Query) ProtoMessage() {}

func (x *Query) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Query.ProtoReflect.Descriptor instead.
func (*Query) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{4}
}

func (x *Query) GetChannel() string {
	if x != nil {
		return x.Channel
	}
	return ""
}

func (m *Query) GetQuery() isQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *Query) GetConfigQuery() *ConfigQuery {
	if x, ok := x.GetQuery().(*Query_ConfigQuery); ok {
		return x.ConfigQuery
	}
	return nil
}

func (x *Query) GetPeerQuery() *PeerMembershipQuery {
	if x, ok := x.GetQuery().(*Query_PeerQuery); ok {
		return x.PeerQuery
	}
	return nil
}

func (x *Query) GetCcQuery() *ChaincodeQuery {
	if x, ok := x.GetQuery().(*Query_CcQuery); ok {
		return x.CcQuery
	}
	return nil
}

func (x *Query) GetLocalPeers() *LocalPeerQuery {
	if x, ok := x.GetQuery().(*Query_LocalPeers); ok {
		return x.LocalPeers
	}
	return nil
}

type isQuery_Query interface {
	isQuery_Query()
}

type Query_ConfigQuery struct {
	// ConfigQuery is used to query for the configuration of the channel,
	// such as FabricMSPConfig, and rorderer endpoints.
	// The client has to query a peer it trusts as it doesn't have means to self-verify
	// the authenticity of the returned result.
	// The result is returned in the form of ConfigResult.
	ConfigQuery *ConfigQuery `protobuf:"bytes,2,opt,name=config_query,json=configQuery,proto3,oneof"`
}

type Query_PeerQuery struct {
	// PeerMembershipQuery queries for peers in a channel context,
	// and returns PeerMembershipResult
	PeerQuery *PeerMembershipQuery `protobuf:"bytes,3,opt,name=peer_query,json=peerQuery,proto3,oneof"`
}

type Query_CcQuery struct {
	// ChaincodeQuery queries for chaincodes by their name and version.
	// An empty version means any version can by returned.
	CcQuery *ChaincodeQuery `protobuf:"bytes,4,opt,name=cc_query,json=ccQuery,proto3,oneof"`
}

type Query_LocalPeers struct {
	// LocalPeerQuery queries for peers in a non channel context,
	// and returns PeerMembershipResult
	LocalPeers *LocalPeerQuery `protobuf:"bytes,5,opt,name=local_peers,json=localPeers,proto3,oneof"`
}

func (*Query_ConfigQuery) isQuery_Query() {}

func (*Query_PeerQuery) isQuery_Query() {}

func (*Query_CcQuery) isQuery_Query() {}

func (*Query_LocalPeers) isQuery_Query() {}

// QueryResult contains a result for a given Query.
// The corresponding Query can be inferred by the index of the QueryResult from
// its enclosing Response message.
// QueryResults are ordered in the same order as the Queries are ordered in their enclosing Request.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Result:
	//
	//	*QueryResult_Error
	//	*QueryResult_ConfigResult
	//	*QueryResult_CcQueryRes
	//	*QueryResult_Members
	Result isQueryResult_Result `protobuf_oneof:"result"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{5}
}

func (m *QueryResult) GetResult() isQueryResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *QueryResult) GetError() *Error {
	if x, ok := x.GetResult().(*QueryResult_Error); ok {
		return x.Error
	}
	return nil
}

func (x *QueryResult) GetConfigResult() *ConfigResult {
	if x, ok := x.GetResult().(*QueryResult_ConfigResult); ok {
		return x.ConfigResult
	}
	return nil
}

func (x *QueryResult) GetCcQueryRes() *ChaincodeQueryResult {
	if x, ok := x.GetResult().(*QueryResult_CcQueryRes); ok {
		return x.CcQueryRes
	}
	return nil
}

func (x *QueryResult) GetMembers() *PeerMembershipResult {
	if x, ok := x.GetResult().(*QueryResult_Members); ok {
		return x.Members
	}
	return nil
}

type isQueryResult_Result interface {
	isQueryResult_Result()
}

type QueryResult_Error struct {
	// Error indicates failure or refusal to process the query
	Error *Error `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type QueryResult_ConfigResult struct {
	// ConfigResult contains the configuration of the channel,
	// such as FabricMSPConfig and orderer endpoints
	ConfigResult *ConfigResult `protobuf:"bytes,2,opt,name=config_result,json=configResult,proto3,oneof"`
}

type QueryResult_CcQueryRes struct {
	// ChaincodeQueryResult contains information about chaincodes,
	// and their corresponding endorsers
	CcQueryRes *ChaincodeQueryResult `protobuf:"bytes,3,opt,name=cc_query_res,json=ccQueryRes,proto3,oneof"`
}

type QueryResult_Members struct {
	// PeerMembershipResult contains information about peers,
	// such as their identity, endpoints, and channel related state.
	Members *PeerMembershipResult `protobuf:"bytes,4,opt,name=members,proto3,oneof"`
}

func (*QueryResult_Error) isQueryResult_Result() {}

func (*QueryResult_ConfigResult) isQueryResult_Result() {}

func (*QueryResult_CcQueryRes) isQueryResult_Result() {}

func (*QueryResult_Members) isQueryResult_Result() {}

// ConfigQuery requests a ConfigResult
type ConfigQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ConfigQuery) Reset() {
	*x = ConfigQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigQuery) ProtoMessage() {}

func (x *ConfigQuery) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigQuery.ProtoReflect.Descriptor instead.
func (*ConfigQuery) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{6}
}

type ConfigResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// msps is a map from MSP_ID to FabricMSPConfig
	Msps map[string]*msp.FabricMSPConfig `protobuf:"bytes,1,rep,name=msps,proto3" json:"msps,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// orderers is a map from MSP_ID to endpoint lists of orderers
	Orderers map[string]*Endpoints `protobuf:"bytes,2,rep,name=orderers,proto3" json:"orderers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ConfigResult) Reset() {
	*x = ConfigResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigResult) ProtoMessage() {}

func (x *ConfigResult) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigResult.ProtoReflect.Descriptor instead.
func (*ConfigResult) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{7}
}

func (x *ConfigResult) GetMsps() map[string]*msp.FabricMSPConfig {
	if x != nil {
		return x.Msps
	}
	return nil
}

func (x *ConfigResult) GetOrderers() map[string]*Endpoints {
	if x != nil {
		return x.Orderers
	}
	return nil
}

// PeerMembershipQuery requests PeerMembershipResult.
// The filter field may be optionally populated in order
// for the peer membership to be filtered according to
// chaincodes that are installed on peers and collection
// access control policies.
type PeerMembershipQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filter *peer.ChaincodeInterest `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *PeerMembershipQuery) Reset() {
	*x = PeerMembershipQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeerMembershipQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerMembershipQuery) ProtoMessage() {}

func (x *PeerMembershipQuery) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerMembershipQuery.ProtoReflect.Descriptor instead.
func (*PeerMembershipQuery) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{8}
}

func (x *PeerMembershipQuery) GetFilter() *peer.ChaincodeInterest {
	if x != nil {
		return x.Filter
	}
	return nil
}

// PeerMembershipResult contains peers mapped by their organizations (MSP_ID)
type PeerMembershipResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PeersByOrg map[string]*Peers `protobuf:"bytes,1,rep,name=peers_by_org,json=peersByOrg,proto3" json:"peers_by_org,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PeerMembershipResult) Reset() {
	*x = PeerMembershipResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeerMembershipResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerMembershipResult) ProtoMessage() {}

func (x *PeerMembershipResult) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerMembershipResult.ProtoReflect.Descriptor instead.
func (*PeerMembershipResult) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{9}
}

func (x *PeerMembershipResult) GetPeersByOrg() map[string]*Peers {
	if x != nil {
		return x.PeersByOrg
	}
	return nil
}

// ChaincodeQuery requests ChaincodeQueryResults for a given
// list of chaincode invocations.
// Each invocation is a separate one, and the endorsement policy
// is evaluated independantly for each given interest.
type ChaincodeQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Interests []*peer.ChaincodeInterest `protobuf:"bytes,1,rep,name=interests,proto3" json:"interests,omitempty"`
}

func (x *ChaincodeQuery) Reset() {
	*x = ChaincodeQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeQuery) ProtoMessage() {}

func (x *ChaincodeQuery) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeQuery.ProtoReflect.Descriptor instead.
func (*ChaincodeQuery) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{10}
}

func (x *ChaincodeQuery) GetInterests() []*peer.ChaincodeInterest {
	if x != nil {
		return x.Interests
	}
	return nil
}

// ChaincodeQueryResult contains EndorsementDescriptors for
// chaincodes
type ChaincodeQueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Content []*EndorsementDescriptor `protobuf:"bytes,1,rep,name=content,proto3" json:"content,omitempty"`
}

func (x *ChaincodeQueryResult) Reset() {
	*x = ChaincodeQueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChaincodeQueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChaincodeQueryResult) ProtoMessage() {}

func (x *ChaincodeQueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChaincodeQueryResult.ProtoReflect.Descriptor instead.
func (*ChaincodeQueryResult) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{11}
}

func (x *ChaincodeQueryResult) GetContent() []*EndorsementDescriptor {
	if x != nil {
		return x.Content
	}
	return nil
}

// LocalPeerQuery queries for peers in a non channel context
type LocalPeerQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LocalPeerQuery) Reset() {
	*x = LocalPeerQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalPeerQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalPeerQuery) ProtoMessage() {}

func (x *LocalPeerQuery) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalPeerQuery.ProtoReflect.Descriptor instead.
func (*LocalPeerQuery) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{12}
}

// EndorsementDescriptor contains information about which peers can be used
// to request endorsement from, such that the endorsement policy would be fulfilled.
// Here is how to compute a set of peers to ask an endorsement from, given an EndorsementDescriptor:
// Let e: G --> P be the endorsers_by_groups field that maps a group to a set of peers.
// Note that applying e on a group g yields a set of peers.
//  1. Select a layout l: G --> N out of the layouts given.
//     l is the quantities_by_group field of a Layout, and it maps a group to an integer.
//  2. R = {}  (an empty set of peers)
//  3. For each group g in the layout l, compute n = l(g)
//     3.1) Denote P_g as a set of n random peers {p0, p1, ... p_n} selected from e(g)
//     3.2) R = R U P_g  (add P_g to R)
//  4. The set of peers R is the peers the client needs to request endorsements from
type EndorsementDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Chaincode string `protobuf:"bytes,1,opt,name=chaincode,proto3" json:"chaincode,omitempty"`
	// Specifies the endorsers, separated to groups.
	EndorsersByGroups map[string]*Peers `protobuf:"bytes,2,rep,name=endorsers_by_groups,json=endorsersByGroups,proto3" json:"endorsers_by_groups,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies options of fulfulling the endorsement policy.
	// Each option lists the group names, and the amount of signatures needed
	// from each group.
	Layouts []*Layout `protobuf:"bytes,3,rep,name=layouts,proto3" json:"layouts,omitempty"`
}

func (x *EndorsementDescriptor) Reset() {
	*x = EndorsementDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndorsementDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndorsementDescriptor) ProtoMessage() {}

func (x *EndorsementDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndorsementDescriptor.ProtoReflect.Descriptor instead.
func (*EndorsementDescriptor) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{13}
}

func (x *EndorsementDescriptor) GetChaincode() string {
	if x != nil {
		return x.Chaincode
	}
	return ""
}

func (x *EndorsementDescriptor) GetEndorsersByGroups() map[string]*Peers {
	if x != nil {
		return x.EndorsersByGroups
	}
	return nil
}

func (x *EndorsementDescriptor) GetLayouts() []*Layout {
	if x != nil {
		return x.Layouts
	}
	return nil
}

// Layout contains a mapping from a group name to number of peers
// that are needed for fulfilling an endorsement policy
type Layout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how many non repeated signatures of each group
	// are needed for endorsement
	QuantitiesByGroup map[string]uint32 `protobuf:"bytes,1,rep,name=quantities_by_group,json=quantitiesByGroup,proto3" json:"quantities_by_group,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *Layout) Reset() {
	*x = Layout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Layout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Layout) ProtoMessage() {}

func (x *Layout) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Layout.ProtoReflect.Descriptor instead.
func (*Layout) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{14}
}

func (x *Layout) GetQuantitiesByGroup() map[string]uint32 {
	if x != nil {
		return x.QuantitiesByGroup
	}
	return nil
}

// Peers contains a list of Peer(s)
type Peers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Peers []*Peer `protobuf:"bytes,1,rep,name=peers,proto3" json:"peers,omitempty"`
}

func (x *Peers) Reset() {
	*x = Peers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Peers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Peers) ProtoMessage() {}

func (x *Peers) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Peers.ProtoReflect.Descriptor instead.
func (*Peers) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{15}
}

func (x *Peers) GetPeers() []*Peer {
	if x != nil {
		return x.Peers
	}
	return nil
}

// Peer contains information about the peer such as its channel specific
// state, and membership information.
type Peer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is an Envelope of a GossipMessage with a gossip.StateInfo message
	StateInfo *gossip.Envelope `protobuf:"bytes,1,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// This is an Envelope of a GossipMessage with a gossip.AliveMessage message
	MembershipInfo *gossip.Envelope `protobuf:"bytes,2,opt,name=membership_info,json=membershipInfo,proto3" json:"membership_info,omitempty"`
	// This is the msp.SerializedIdentity of the peer, represented in bytes.
	Identity []byte `protobuf:"bytes,3,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *Peer) Reset() {
	*x = Peer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Peer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Peer) ProtoMessage() {}

func (x *Peer) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Peer.ProtoReflect.Descriptor instead.
func (*Peer) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{16}
}

func (x *Peer) GetStateInfo() *gossip.Envelope {
	if x != nil {
		return x.StateInfo
	}
	return nil
}

func (x *Peer) GetMembershipInfo() *gossip.Envelope {
	if x != nil {
		return x.MembershipInfo
	}
	return nil
}

func (x *Peer) GetIdentity() []byte {
	if x != nil {
		return x.Identity
	}
	return nil
}

// Error denotes that something went wrong and contains the error message
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{17}
}

func (x *Error) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Endpoints is a list of Endpoint(s)
type Endpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Endpoint []*Endpoint `protobuf:"bytes,1,rep,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *Endpoints) Reset() {
	*x = Endpoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoints) ProtoMessage() {}

func (x *Endpoints) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoints.ProtoReflect.Descriptor instead.
func (*Endpoints) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{18}
}

func (x *Endpoints) GetEndpoint() []*Endpoint {
	if x != nil {
		return x.Endpoint
	}
	return nil
}

// Endpoint is a combination of a host and a port
type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_discovery_protocol_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_discovery_protocol_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_discovery_protocol_proto_rawDescGZIP(), []int{19}
}

func (x *Endpoint) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Endpoint) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

var File_discovery_protocol_proto protoreflect.FileDescriptor

var file_discovery_protocol_proto_rawDesc = []byte{
	0x0a, 0x18, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x1a, 0x14, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x6d, 0x73, 0x70,
	0x2f, 0x6d, 0x73, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x70, 0x65, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x47, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x72, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2a, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x3c, 0x0a, 0x08,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x64, 0x0a, 0x08, 0x41, 0x75,
	0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x2f, 0x0a, 0x14, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x6c, 0x73, 0x43, 0x65, 0x72, 0x74, 0x48, 0x61, 0x73, 0x68,
	0x22, 0x9e, 0x02, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x09, 0x70, 0x65, 0x65, 0x72, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x36, 0x0a, 0x08, 0x63, 0x63, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48,
	0x00, 0x52, 0x07, 0x63, 0x63, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x0b, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x50, 0x65, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x50, 0x65, 0x65, 0x72, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x22, 0x83, 0x02, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x10, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3e, 0x0a, 0x0d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x43, 0x0a, 0x0c, 0x63,
	0x63, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x63, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x12, 0x3b, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x65,
	0x65, 0x72, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x0d, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0xaa, 0x02, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6d, 0x73, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4d,
	0x73, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6d, 0x73, 0x70, 0x73, 0x12, 0x41,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x72,
	0x73, 0x1a, 0x4d, 0x0a, 0x09, 0x4d, 0x73, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x6d, 0x73, 0x70, 0x2e, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x4d, 0x53, 0x50, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x51, 0x0a, 0x0d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x48, 0x0a, 0x13, 0x50, 0x65, 0x65, 0x72, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x65, 0x73, 0x74, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xba, 0x01,
	0x0a, 0x14, 0x50, 0x65, 0x65, 0x72, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x73, 0x5f,
	0x62, 0x79, 0x5f, 0x6f, 0x72, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x65,
	0x65, 0x72, 0x73, 0x42, 0x79, 0x4f, 0x72, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70,
	0x65, 0x65, 0x72, 0x73, 0x42, 0x79, 0x4f, 0x72, 0x67, 0x1a, 0x4f, 0x0a, 0x0f, 0x50, 0x65, 0x65,
	0x72, 0x73, 0x42, 0x79, 0x4f, 0x72, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x26,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x73, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x0e, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x37, 0x0a, 0x09,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x65, 0x73, 0x74, 0x73, 0x22, 0x52, 0x0a, 0x14, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3a, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x6e, 0x64, 0x6f, 0x72,
	0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x10, 0x0a, 0x0e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x50, 0x65, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0xa3, 0x02, 0x0a, 0x15,
	0x45, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x12, 0x67, 0x0a, 0x13, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x73,
	0x5f, 0x62, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x6e, 0x64,
	0x6f, 0x72, 0x73, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x2e, 0x45, 0x6e, 0x64, 0x6f, 0x72, 0x73, 0x65, 0x72, 0x73, 0x42, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x65, 0x6e, 0x64, 0x6f, 0x72,
	0x73, 0x65, 0x72, 0x73, 0x42, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2b, 0x0a, 0x07,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x52, 0x07, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x1a, 0x56, 0x0a, 0x16, 0x45, 0x6e, 0x64,
	0x6f, 0x72, 0x73, 0x65, 0x72, 0x73, 0x42, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x26, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xa8, 0x01, 0x0a, 0x06, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x58, 0x0a, 0x13,
	0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x62, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x2e, 0x51, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x11, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x1a, 0x44, 0x0a, 0x16, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x42, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x2e, 0x0a, 0x05,
	0x50, 0x65, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x65, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x52, 0x05, 0x70, 0x65, 0x65, 0x72, 0x73, 0x22, 0x8e, 0x01, 0x0a,
	0x04, 0x50, 0x65, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73,
	0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x39, 0x0a, 0x0f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x10, 0x2e, 0x67, 0x6f, 0x73, 0x73, 0x69, 0x70, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x52, 0x0e, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x21, 0x0a,
	0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x22, 0x3c, 0x0a, 0x09, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x2f, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x32,
	0x0a, 0x08, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x32, 0x46, 0x0a, 0x09, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12,
	0x39, 0x0a, 0x08, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x18, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0xb5, 0x01, 0x0a, 0x27, 0x6f,
	0x72, 0x67, 0x2e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2e, 0x66,
	0x61, 0x62, 0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x42, 0x0d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x72, 0x2f,
	0x66, 0x61, 0x62, 0x72, 0x69, 0x63, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2d, 0x67, 0x6f,
	0x2d, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0xa2, 0x02, 0x03, 0x44, 0x58, 0x58, 0xaa, 0x02, 0x09, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0xca, 0x02, 0x09, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0xe2, 0x02,
	0x15, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x09, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_discovery_protocol_proto_rawDescOnce sync.Once
	file_discovery_protocol_proto_rawDescData = file_discovery_protocol_proto_rawDesc
)

func file_discovery_protocol_proto_rawDescGZIP() []byte {
	file_discovery_protocol_proto_rawDescOnce.Do(func() {
		file_discovery_protocol_proto_rawDescData = protoimpl.X.CompressGZIP(file_discovery_protocol_proto_rawDescData)
	})
	return file_discovery_protocol_proto_rawDescData
}

var file_discovery_protocol_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_discovery_protocol_proto_goTypes = []interface{}{
	(*SignedRequest)(nil),          // 0: discovery.SignedRequest
	(*Request)(nil),                // 1: discovery.Request
	(*Response)(nil),               // 2: discovery.Response
	(*AuthInfo)(nil),               // 3: discovery.AuthInfo
	(*Query)(nil),                  // 4: discovery.Query
	(*QueryResult)(nil),            // 5: discovery.QueryResult
	(*ConfigQuery)(nil),            // 6: discovery.ConfigQuery
	(*ConfigResult)(nil),           // 7: discovery.ConfigResult
	(*PeerMembershipQuery)(nil),    // 8: discovery.PeerMembershipQuery
	(*PeerMembershipResult)(nil),   // 9: discovery.PeerMembershipResult
	(*ChaincodeQuery)(nil),         // 10: discovery.ChaincodeQuery
	(*ChaincodeQueryResult)(nil),   // 11: discovery.ChaincodeQueryResult
	(*LocalPeerQuery)(nil),         // 12: discovery.LocalPeerQuery
	(*EndorsementDescriptor)(nil),  // 13: discovery.EndorsementDescriptor
	(*Layout)(nil),                 // 14: discovery.Layout
	(*Peers)(nil),                  // 15: discovery.Peers
	(*Peer)(nil),                   // 16: discovery.Peer
	(*Error)(nil),                  // 17: discovery.Error
	(*Endpoints)(nil),              // 18: discovery.Endpoints
	(*Endpoint)(nil),               // 19: discovery.Endpoint
	nil,                            // 20: discovery.ConfigResult.MspsEntry
	nil,                            // 21: discovery.ConfigResult.OrderersEntry
	nil,                            // 22: discovery.PeerMembershipResult.PeersByOrgEntry
	nil,                            // 23: discovery.EndorsementDescriptor.EndorsersByGroupsEntry
	nil,                            // 24: discovery.Layout.QuantitiesByGroupEntry
	(*peer.ChaincodeInterest)(nil), // 25: protos.ChaincodeInterest
	(*gossip.Envelope)(nil),        // 26: gossip.Envelope
	(*msp.FabricMSPConfig)(nil),    // 27: msp.FabricMSPConfig
}
var file_discovery_protocol_proto_depIdxs = []int32{
	3,  // 0: discovery.Request.authentication:type_name -> discovery.AuthInfo
	4,  // 1: discovery.Request.queries:type_name -> discovery.Query
	5,  // 2: discovery.Response.results:type_name -> discovery.QueryResult
	6,  // 3: discovery.Query.config_query:type_name -> discovery.ConfigQuery
	8,  // 4: discovery.Query.peer_query:type_name -> discovery.PeerMembershipQuery
	10, // 5: discovery.Query.cc_query:type_name -> discovery.ChaincodeQuery
	12, // 6: discovery.Query.local_peers:type_name -> discovery.LocalPeerQuery
	17, // 7: discovery.QueryResult.error:type_name -> discovery.Error
	7,  // 8: discovery.QueryResult.config_result:type_name -> discovery.ConfigResult
	11, // 9: discovery.QueryResult.cc_query_res:type_name -> discovery.ChaincodeQueryResult
	9,  // 10: discovery.QueryResult.members:type_name -> discovery.PeerMembershipResult
	20, // 11: discovery.ConfigResult.msps:type_name -> discovery.ConfigResult.MspsEntry
	21, // 12: discovery.ConfigResult.orderers:type_name -> discovery.ConfigResult.OrderersEntry
	25, // 13: discovery.PeerMembershipQuery.filter:type_name -> protos.ChaincodeInterest
	22, // 14: discovery.PeerMembershipResult.peers_by_org:type_name -> discovery.PeerMembershipResult.PeersByOrgEntry
	25, // 15: discovery.ChaincodeQuery.interests:type_name -> protos.ChaincodeInterest
	13, // 16: discovery.ChaincodeQueryResult.content:type_name -> discovery.EndorsementDescriptor
	23, // 17: discovery.EndorsementDescriptor.endorsers_by_groups:type_name -> discovery.EndorsementDescriptor.EndorsersByGroupsEntry
	14, // 18: discovery.EndorsementDescriptor.layouts:type_name -> discovery.Layout
	24, // 19: discovery.Layout.quantities_by_group:type_name -> discovery.Layout.QuantitiesByGroupEntry
	16, // 20: discovery.Peers.peers:type_name -> discovery.Peer
	26, // 21: discovery.Peer.state_info:type_name -> gossip.Envelope
	26, // 22: discovery.Peer.membership_info:type_name -> gossip.Envelope
	19, // 23: discovery.Endpoints.endpoint:type_name -> discovery.Endpoint
	27, // 24: discovery.ConfigResult.MspsEntry.value:type_name -> msp.FabricMSPConfig
	18, // 25: discovery.ConfigResult.OrderersEntry.value:type_name -> discovery.Endpoints
	15, // 26: discovery.PeerMembershipResult.PeersByOrgEntry.value:type_name -> discovery.Peers
	15, // 27: discovery.EndorsementDescriptor.EndorsersByGroupsEntry.value:type_name -> discovery.Peers
	0,  // 28: discovery.Discovery.Discover:input_type -> discovery.SignedRequest
	2,  // 29: discovery.Discovery.Discover:output_type -> discovery.Response
	29, // [29:30] is the sub-list for method output_type
	28, // [28:29] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_discovery_protocol_proto_init() }
func file_discovery_protocol_proto_init() {
	if File_discovery_protocol_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_discovery_protocol_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeerMembershipQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeerMembershipResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChaincodeQueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalPeerQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndorsementDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Layout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Peers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Peer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_discovery_protocol_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_discovery_protocol_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Query_ConfigQuery)(nil),
		(*Query_PeerQuery)(nil),
		(*Query_CcQuery)(nil),
		(*Query_LocalPeers)(nil),
	}
	file_discovery_protocol_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*QueryResult_Error)(nil),
		(*QueryResult_ConfigResult)(nil),
		(*QueryResult_CcQueryRes)(nil),
		(*QueryResult_Members)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_discovery_protocol_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_discovery_protocol_proto_goTypes,
		DependencyIndexes: file_discovery_protocol_proto_depIdxs,
		MessageInfos:      file_discovery_protocol_proto_msgTypes,
	}.Build()
	File_discovery_protocol_proto = out.File
	file_discovery_protocol_proto_rawDesc = nil
	file_discovery_protocol_proto_goTypes = nil
	file_discovery_protocol_proto_depIdxs = nil
}
