package config

var SECP256K1 = Curve{
	Name:         "secp256k1",
	CurvePackage: "secp256k1",
	EnumID:       "SECP256k1",
	FrModulus:    "115792089237316195423570985008687907852837564279074904382605163141518161494337",
	FpModulus:    "115792089237316195423570985008687907853269984665640564039457584007908834671663",
	G1: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g1",
		GLV:              true,
		CofactorCleaning: false,
		CRange:           []int{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
	},
	HashE1: &HashSuiteSvdw{
		z:  []string{"1"},
		c1: []string{"8"},
		c2: []string{"57896044618658097711785492504343953926634992332820282019728792003954417335831"},
		c3: []string{"10388779673325959979325452626823788324994718367665745800388075445979975427086"},
		c4: []string{"77194726158210796949047323339125271902179989777093709359638389338605889781098"},
	},
}

func init() {
	addCurve(&SECP256K1)
}
