package config

var BW6_761 = Curve{
	Name:         "bw6-761",
	CurvePackage: "bw6761",
	EnumID:       "BW6_761",
	FrModulus:    "258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177",
	FpModulus:    "6891450384315732539396789682275657542479668912536150109513790160209623422243491736087683183289411687640864567753786613451161759120554247759349511699125301598951605099378508850372543631423596795951899700429969112842764913119068299",
	G1: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g1",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           []int{4, 5, 8, 16},
	},
	G2: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g2",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           []int{4, 5, 8, 16},
		Projective:       true,
	},
	// 2-isogeny
	HashE1: &HashSuiteSswu{
		A: []string{"0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f49d00000000007c"},
		B: []string{"0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f49d000000000075"},
		Z: []int{2},
		Isogeny: &Isogeny{
			XMap: RationalPolynomial{
				Num: [][]string{
					{"0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1c000020bd27400000000022"},
					{"0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f34380000417a4e800000000046"},
					{"0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1c000020bd27400000000023"},
				},
				Den: [][]string{
					{"2"},
				},
			},
			YMap: RationalPolynomial{
				Num: [][]string{
					{"0xda2e1bbca2da881d25d6f003bc3f6f0adc924fe15cf4e63de1d873a065ceb1145cbcaaac23aed2c2db0c3f5c471a4364e756b1ce3b7e2c55659ee556f0ff62f278d111c0cdbeba1089ba8330347b29ececeece540000623775c0000000006a"},
					{"0x6d170dde516d440e92eb7801de1fb7856e4927f0ae7a731ef0ec39d032e7588a2e5e555611d769616d861fae238d21b273ab58e71dbf162ab2cf72ab787fb1793c6888e066df5d0844dd41981a3d94f67677672a0000311bbae00000000036"},
					{"0xda2e1bbca2da881d25d6f003bc3f6f0adc924fe15cf4e63de1d873a065ceb1145cbcaaac23aed2c2db0c3f5c471a4364e756b1ce3b7e2c55659ee556f0ff62f278d111c0cdbeba1089ba8330347b29ececeece540000623775c00000000069"},
					{"0xb5d1171d3260c6c2f4ddc8031cdf8733b7cf429122cc15339189b5b054d6e8e64d47e38f7311afa26134df779095e2d4161d942bdc3e7a472a0469c8737f7d1f64ae397600c99b0dc81b6d52d666a2f01ac70146000051d8e2200000000057"},
				},
				Den: [][]string{
					{"8"},
					{"12"},
					{"6"},
				},
			},
		},
	},

	// 37-isogeny
	HashE2: &HashSuiteSswu{
		A: []string{"0x10f6a7725da2bcbd3df98cd57fb04b0378eb7ff3d8fa48869b2b9ddf31d3fc46fa7c4805b5d4a79e54f495b52586a15154dca22425367989fae305ea22f0b5a4f979aa9f1d46f7cad2f21696aab503eb53485d6ccbfdedca97936b7702a7d20"},
		B: []string{"0xe1c43bfe2767901cf467cf40adfb7afe484d0d477552a8570a117661033c8dce4d56ccf35850bb0a5c646e4433a9b0e43b8701384b604cf95ffbd668698f8bd2f2739baa20c154eb7c88974a36fb5487c4cd8a1eb00205769d93924cfb0ba0"},
		Z: []int{11},
		Isogeny: &Isogeny{

			XMap: RationalPolynomial{
				Num: [][]string{
					{"0x25398befd780935a98ddee5ea60e4ee96dcc3cc7e2f9f2ce97adb5eee13f1f1d35eba83968f25cdff13be2d0446e1ee6e19d332712d7b1f63509e090425865b0383f77a43ec7c63055a6631892a33b84b81457257314d13bbfbcc995aa9def"},
					{"0xbf9fff0b23525e2cea97716a08dd64003da7fce131cc13876e7ae922718e7c7b8a219fde11b35b7442d2f97a46f689a9c48636800a987bbfb5878e89b551db4b37469c6d446d4d6b59255708ea4a3f127b3199065213283b886788a53960bb"},
					{"0x4eff3f1c655d2a87d2d8283ee2451dd85a772545d9213f5dbe1f3410d2e21ac1808ca7876eae1110b33a6fd2073d467ece168630a242486579def540c85a2d66fec67d057d6091b08e20aaf4c3900a8c9f901844d51d38ec5ef4abb1b0f811"},
					{"0x1e9c0bcdf00775a750d64d31305f42117cd59252c0a3ed281e6b08cc26c3503e7d05a200d062300d173f5bc69a0c0fed0be50d429b72ddefc9aebb14a47596d061f1bd6ecc6a303dfd9b3a47a35b12829b3c40eb8012f2b68c765be361f50e"},
					{"0x116276c9e850399fd7f4da35f933e4b185e5932d984665cfb821f13cbc8726a455e5efa50ccc596ccddfe93c3d9bb016f1b95e42631f82ba4207ccbc0c1aa33ba899a6c1bb9a54571ac158f417dcf0ad4eff05a3ba55e9b9dcb0e5b01bbf218"},
					{"0x5619dcaec9c5296187bd9bae9507ba8e6c764f581fcd92d618cd9a9246e7fc50fc7f9fc8b5ac87c1897dd329ce72a85b9194b010ac6877b5ff0e5fc60379ece4bffe6e7b08d3aaba9a2301aaa0a77ccc80e216f0a8bb8b4a261eb76080b1a0"},
					{"0xc6b516997dc93cdfa17c6218ac94a6a91248abd4c6f43fa5b4fc697fc3a51effd39e55b261bc89b4aa71955df8380a40b7dfc1ffa29a01e26df9ffad6e3f3d756cf5b0793b92846b66d18057e2cf6366e3030836caad9abe69b47472abe20"},
					{"0x4159773ff45be12f91af867bbc0af2809e340c244c1e4be605650a2d3c609120ceedba9b1808a1307ec320948f88df769d1b678fc9de1c010756fe9464e4b5e0d11010524bc0cc292cae038ff9590096b71194706660fa88f6a001f17e4148"},
					{"0xaa0ec8348732fa3c9a97761f624ea4478cf6d4419f0b2f9dd9a54f91c5a95df61a058d1be7bd5c791e5b7f3a662bff96ad246272e77d2955ac52b817e161e397d8ade57c4f1be9df28eab1ae49a7d53ab57fc1dd84dc967f8bfb768731e132"},
					{"0x5626a46d9768ffdae515e2f43220eb9bc29cad1e6793bc78b1f1be6d8f55cd60cdc4d6653c7fd12024398d4ab901d283ca67c9798e8a1b6983a8a07db5897134b381dc523cdf9799229e5aedfd6b680cd75083a78b24cc73f6b3e515a00fc5"},
					{"0x68dd735eddf59490dad172f6aa60ae8110aaadb1fd2e1b708a8d429feca6b81381225666854277c93a5275ba75045d83e407ddc6a763ae980dfefa0b2523cd61362d7a658c622b5766e55a1b1d054b7199a9e0ccfac1d6bcfee34dff34b476"},
					{"0xf4d4ce5273a64c3463d1f51ed0895d3e20ea073bd4ca22febba741c47b6f6883866e984d62de4976b2890d5541e63af463d3b0b96b17b8b5821149389544a0c7bad5736bbe9b58395827786cd4f06f2c7c882980b290e4e5d7799004039838"},
					{"0x7563caac9e1636456f2e72d9034a59342e3a863bcce6b762e1b683fd1f9d7851b192b15bc2e19ffeff8560621285497077cacf7a160b59a22f3c3db6aadec7f650a575732b62884994e454ec534c0e955a38c42bb24a748129f53becb91d3c"},
					{"0x8250dc5250d43ba6fd216c9b07c2a8553cf26f9486c053518e2ef1d3acb59f2413bbfa33967b4225c1e3beb6ddcd94465c6f5dc1486d70853b86f092fa65e0d1786a8c3fb2f2dd10b309a98fc123d556e30c14737e05ed4cc7cec012423f4a"},
					{"0x110eb883b84c0238f7acbb20d75f08db04da7ecdf1c7dd8ed99d8f75c923154e280a750318163921759043a5c88c1cc2ba425380bb8486f9c3a9f9d716cdb0f4c2f1dcf96686fe582d4a88fdf21727d4342d7183b1d58de15587a280e1b16ba"},
					{"0x12187cc667349a16a75bdaea33e2993f7cd21d582124bdb248d746264fdd53091cb92188d8da7ba18e5ae858f047724f0d088320747de67e34ceff1e0199fb760f49dd57670711a1be6d4b6898f568fa44b560463b95adc10267acc34419791"},
					{"0xc40934532a6e2559a91a4b56f795bb6d7ab621deac562916e0fac5082c42d6ad331b9b83d4b9741925518bb8d963fa934dd3ec288a062437669f25104de2110e4ce5fc21a60590e0cbda800df12e1900d474846c0276c9f11084032b75a610"},
					{"0x950b7a24e3005b05c4d6cff3719f15f292b33ab2b6b52f5e0f4562d44233fb554d53bfc048ebc9bb5fcd3c92a88824de5ffbb5c1eb887c0dbb4fc5c20663dca7f66b5cec7bd641f751e21af2136f5e8eeb5dedf9d0d5e866566fc73de38afe"},
					{"0xd9e2458632e3e1f2a102f36965e3130f9d5e5eb0dce8240464bf79d11cf57f41c8fe66c04d820811d9d2af9f9e09d0265070fccc415e0aabdc0fd0ad081e12a5290090f531562d4c717b411165d8e1eb1a4cbaf5f239fcb6581c1a75712a1c"},
					{"0x122bf1411d59559e306075c9a9e73edba1dcba34443b235a1f3942a0f8edbc955d9ea0d9af240d05809eb3c0ca980527fd545e5988e6dece2da9e35061a2f637bd9f1f35aed13871ae23e6283c7e18e7459971cdbfde54507f7f22f281b63e8"},
					{"0x87f8706b78c7434a1e7d3eb3bd363eebf95d01ad6872e8660a6946347699f965417b8fff42df607d4fb609f414ab8eec9c02a4eb0e9b887a1765aabacdb3c1dba24cd1834095e31d358be65cde6d7a498163678ba1bc763da43c538dacda43"},
					{"0x99598dd5d2443bac8cd6e5c3ecc45cc4aeacf527c1b3567d300698a2ad073f5568544c5b71529380fd88d628416643b95c1afc65436bd2d12bcb4072876e5117b0e5c841b35a019fdffa973882e72a6118c03201210f4161d8179a77fa96c1"},
					{"0x395ccb482186b0d3462ee62749d639e3c946f14379eb2adfae39a686af0d4f512da5e99d9af6022457a75ece4bbad3c805d8d4a74640e02abc3ad625ef7c5b763d0b6c1251f66c991e087a392b0beb82edf72225a85c8d6466b035edbf2627"},
					{"0x3770ad705bdb83b47be929dc5dbd908ea8d79598a767879033c5fc2a0c7b91722c960bc130c0efe87d53576e8c5584a26c62a0e740d13db50d1adb0312b21f33b91fa89dedb493a757ca9aeed1bc2a4dca12793197678cc8fc57fb2e6a56ac"},
					{"0xb257db251cd766a618b10b3eb05d4af66e0aea31f5b3ad460f9d2ee1692d5e8bee298b3ff61841b1706de0438fc9e2081e54ef4b70ab63a355cbf3e06dea5b41435f7b3882192ba5af9b9414da295a0f419f4b95b543208c06f7ecb2cee716"},
					{"0x7c600c60c02239ce8ebf41f0319bd21e2552cd6d452ac9e8aa6608a38158307eab1e9425d494bbea54615c07dfa0470939e3434510c0d1241407c57b28097da2b181d27d3886d4856fd784a1d2dc53001117ecc1f7fd1e581f192e17b098e4"},
					{"0x6045e5de1830a58673c025130d7e80ca97bdf40887772da41dfa549d9869292e1739c1a407e6beb8fe2b99199b4e942be609f5dff7996e0af243b4b11f95f1786c4a1ca576a1265de1e7c3b2546ffa8a5bedea1ca96dc7a81f84a5e4c77a04"},
					{"0x1116eaf37b6d0408ff038d49e29bbcbeb447cdbf49cc259e3f4d48a852ae1ab74c117ff277ca19f08fdc9e4216d315b3a9119460a4f60001dd6be6807db300b5ea9afdd5dc63959275c79bb59c4f32368ea77ec4a4d15a476cd0590165bfa10"},
					{"0x10c94d5d3bb80cf510755331b3761f7ec4df14992881bfca3bc7c43801a077bcb294c8186153487ac19f724a22735b8979e9b86fe34fb6c262367c41a8c76af62fc7da83db17f6ed4eca215750b6d12d2b278585c654ec29d0937b7788940cf"},
					{"0x1adc9be54368e5538aea2182f9892b6fc66405c9a6ee59731427aad5ca1d09ede3e3dd2bcbe7e04c582d8b2fac638d2a329bef768de78a149589710130f3bd407b9ed5535d7b45778b5c1a5ce3957fb462cfea58a7c29dc22c876bc3992eba"},
					{"0xf92aafea05c0b551ae26fc31b31a624c28d43b2633de8dffa690d627760fd04ecc01e0a43cd2e7969263d703cde2cf4dce88410004356d82e535ece5f3ad1a38cd9d787aed584380a438416810b4e3d756be29b52f16db58cb885b83891e8a"},
					{"0xf6e4a497e67292d3b2ed5800dc4c716545175e45f04fbe0e16c6a905e5d2bf099b5c6d989299fa31f11352a7b0423cce76646b492696aeb3a7e139b8e5caa737c3cd3513cff20173437870a9943d5bf1d6c6dc4732032256fdfae43caae4af"},
					{"0xef6b9dc12aff103afb6d8f85d712538920f39072ae840d58faa0774a7df1f5a17e3f741298e9e83ac88fee4b5105f489e0b72b470b5219bf21f8af05c1f8f848904da49371d8c95b5cc896bf727d0fe6b0ddf965c1e3dd973bf8bcb5b2d932"},
					{"0x37bd2a9eca40df6fb0a16dea501ffc6dbe8b455c21dc65f29692d9d31a98ca815a302e0d0b8bbcefe63b793e4c81bd825704414613e8457453e1be9bac8a7f7b282310f4f7e8a281c422256ceed512339ecb348bc9bab690ee7db0b90202c9"},
					{"0xa29355f9bb4369fe4ed85ef14ed5a3c7307701d32c7f31d71947530f8064d5ec499eb17ae6d82853c8ed14eca3b3bcc1cf7cf698b7364a7aa6e63a8ddf20d34757eb4f206648f43a009d6c9caa25290617164247c47dc48ff1743446f7b562"},
					{"0xc505e34288c6805efcec5bd0586564640e784560bca7cafccb08a8b0a53d7c8d646fb60288a071f5cf1e2454d1ee1866365f32535d94e4a8cd0a05c209dedcc42eabbc105c080a94185fc6bbb331d3b77382a663a40b36098c030d178e3021"},
					{"0x110e5f69e48a34b6f6fbbf1c7525e873245669b5fced30ad78975d61b872b5d5e91dab7f4cd23259d7e04c517730240eaec702f238c42fae550b64d4deb617b0b6fd1beb61403c45268912bf795ba2d35d9e292ea1add7e535361761270669a"},
					{"0x11d2b5f8809e696da7ce154a2b558753626d70bd7b5067f4698f205252bde384b7ba440c014b56084035045d969b63e08179de17ac29216aa5592e88f8e24f8c1c021e7750d2a67b1628c2e8dab61965aa233740750f8d5a4cd83d55d4fd9a3"},
				},
				Den: [][]string{
					{"0x83be65e9149262d3203a99fc9235079469fd8d9c911ccd0f38c12cfa4c622ce757f49b41f1ea4687b29ee8e01212e58d238c956a5b1649f1c477e1ff8a6a6bc1f109dfcad55d5a778c8fb21cb49743c66d8cb6619163d013bb217cfcd15e05"},
					{"0xaa517d92a19b280dbc13f7f29fa923a05e4e8bb01bc2e44c40a96c6af237ba313bae0ea41f64bf4fe6b7d864dfb1c747ef73e9a6dfc1b5b4d299b0826c99357c1676f61345c05f9d8a532ca415fabb4199a33cd0a482c684e3c8c259d78aa1"},
					{"0xe1629421ebe8e0a16cb1565702c894b7f3a2509d42812b8937a081006435279fc5e3243489c3ae9448f42e0cc419c63b57cb203c524bec8fd171c1866ac52b773ce80494d0e2637d4bec5faa81b7c2c2f21e91d8fbee3c7f16cb858eb70520"},
					{"0x57980339d02e07fff4324765c596e2799aae01736d752ced8e6086fda14d435dcb1297ff21ee6d272be5d2bd6fc2bfc3190ac40dfa02e83990d5fe9a026656f64c6d99261dfd05fba525230d034791591e40c7aa7e73b38cbf54f627495f04"},
					{"0x807a9d43baffb4c128a86c128170656322ef19ef433ef5111ebf61c6ffa11be2f2efe09bd80e833650c2c6387de30f62198c8e02b2e812bead3143f06ade297f06f14b1646dc66cf282ca33cf458990ac6f3c071503a7932c19b9c48043f7d"},
					{"0x4da51c8bf1b1c0bdbf2c7825ef3b1fdea3b7fe74d8f897a874b2c4ca00b378d789d36d51d1dd7da1d548867183f030b9670a67b481c8fc587e8d9b67f363a4a0185cef41f30caa824b6e9411dd28dad32434ed655c99623e00314350319ed7"},
					{"0xd678e47f25725d1140f98408eebb2bf4db0ea59317a2e77c4ffa7f5e9c346d01387f79c929418fda184a7276209c9b05ae0b9a176d9757100b3713e1098c0ab035ad8969adea919a6200a879e27f01d2e5f2637dafe1ab78e03ac41fe61f71"},
					{"0x5d25a1d2d6b36bce592661279a360506c0422e78491c50618be960b85a7754b3a2fc8773c11d48c73cce13c69c5779d336405c1e236474d499fc63f0200673c4de4ee42dd2f2f295dc48d093e671b13eb94bb2a9534bf739c4a19098760a7b"},
					{"0x4fc12158207d5bd8cce8d1ea3f5c39517edc59e368546db2527caa4d5435654fa55fe40851cbd6c51c0ea8a22fdc4a5c0c180b1849b078b708a83b0f58edce813c6fd60f8d55063343a94722d0185cd273db90cc68a8daa7b2e2031557671b"},
					{"0x31c9b9108620d96f550a9746df4c3d85583fdb9d2d0f68a5bece080110ee8014cebe83083d1faf3b9389969a2481ebb2a98a90b207abd3743414a7365368e689738bdf5ba4b922d15f5dd1e2c40fe9565ad6338b0799d81ed1399106858606"},
					{"0x1117948c172e353417c135bb8d8da0d60ad5c7a0134739917b9f4eac2962e531e85faaf3642bee15183c801da80af4ca79e14256eb769421adc15349fd7a64d945f2916a9e673fcb5bf70f115045a314aefc405e3d277514bba37e932c814df"},
					{"0x3c242e9ec4fbecd4bb2508c41d59c4b626cf707a0bcee49bbec0b8a4a2777c5763c1ac8a0fecb629123f4c9648b5ef86fc81d40ec29525105ab3852df29d4123e143f005ca3445d6a5bff17dfff186eb5f4e257790dde0f1a0b35b7c519b02"},
					{"0x12004baa7bf2797052c48564d94448af483b791a8a58bb0fdfac7206aa30d90a19c75fa26826f6c0e50883fb357d08a13eb13f7b5c64a4a25dcf61cd4c2c04de84df8239a04ec26af80bd483d5843ba5e761284263c974e3877bc21f1dbc197"},
					{"0x40fb8a400112da16c9c847085bd345e2ce2b11e484e5b3361e5e12b0e9b99eef6e1a527cdd123882805d27b8c39737634b9ba27e953a7f26e7bbbaf3a92eaf7cc3496b7505c67958ef08de00740cf7168bb49e7be687c65630847ec9cf64c9"},
					{"0xdb841e9665a8721fbe1361196f1abffbaaf8e61aa13128b8595719b3f8fb1cbdd3b350ca0de1c3188ef820ad8490998744bc8a5e177284ff0d43c84428deee9d41f7f1a042eefb03d02cdcef7653fc6be44f80826df6dc54146f14e3aec5cb"},
					{"0x86d23a6f45e1098d00b8ffec6b12be016250481227e1f2d81b90c3e1cda0ebd2f4efdf381c8bb523f227f275bb681f78a6c95523259720ac3723be36b282cf191288be453008a231c23b67db1eb959d0e149a8135000c5b44ffd1ca5c2439f"},
					{"0x109f5d1ef11a74270bc231cf7083d7278ba957f6d56fbfb3e8fde415ec551664198b8505ffffe1e15dd118b0a4331a8c17a3b98b50643e84dda3165037e42bb9c6019281a3f4be180a738fcb5168c9d76140a06e27d5089ba7f377b9132a05d"},
					{"0x1f274511e3255d4b4a9ad16cce613ed711a05c14758fc9493891cd2d7648807dd6e4556cad36a50945e3e31e4056d27cd49d3dd9ad86701305943bda400c3751bb082764aeda446723655be92a8100fe76f0c7933540daa8afabdc002806b4"},
					{"0x59843e330375000405b054eb5a19aa651450f2c5e26bfaa5032ad4778fbfad597a13691eb8576642f74dc05243b74750701ca40bd7308dae55746104e41cba2226d91cd70b541be8944e403b8930c835f8fc924f556f0274dc8c241c1b1fec"},
					{"0x171ec81a25db9e6028013ed9a5456bb33310e6d3198f21a8e7cf9ce447f30b8830709b9888078e38d676bef24209e26fc81cfd8b80a13d17461841767498fb47afd44ec6239c843f1312f26b0c8025f05f13e8f68db73bba437745b394b0aa"},
					{"0xd1b60042578201579ee9af7daf134f171ac865a3c7165f7a5732ad4a9f2bd301d10e4fee128e96037d468e035e418c46d3c9a11d00622b09d61761fb05f99f2aa2a9ce622cda95c2b321122e7e5c5a1f664e1c44fe46fc9db8a745eb0837af"},
					{"0x6bded64c75b35c01a8313a4bc6695d762020056e0fe4d87677e9088d5cf5585c8482facc8637ee4e619906637a26245ee4694f78d1afd6cb0071844e710d7498e924478db66d35e1f8eb480537873ace7d72c4cce9c5e409e93fd19cb4390f"},
					{"0x409e187b5c36bc9b744db93e60f4f26fe820f8f9ac1731a4ec4220adb0ad1d92b89b69bdabc9bd1db1b99d029c083a5345d9b8681866f3100a77a5e69a9616a7142416b98a84f701740c4f95de3cdda3a198e9861b6cec6e26255bbe772da2"},
					{"0x10366573a3c6655de24305051f27ed68efeec35822c0137e5e2b286cfb2c535c78ff42dc67539545ef780f8cbd8044e9f96e58387cc4f1ebcc1fe836cf359d02e71eb64eb313279edae20943c0642d57338e60b031adfd4bbb424dda4d2872d"},
					{"0x4146d8d1bb6cb1c43ded16f5c07010cb808fa767a0b59047519679124a5a1ab4a1f2cee179146460ff296440254807b842c968e364611b56d0ce862f3e4f79a9d3dc0d7f5c0a3aec81ace2208b3d6710fded09f7864d29bbef79886571cb09"},
					{"0x8f94d7b08b0685963d24fc8b9281d6c290a4124e987136973122a30db0749c48ffc8fdca733627914344dc1077e20be895e36ba93ced63e9792812913c9762277d8556ebc293c4cfe6f89c5f7358e9284b59c1fbdd37b0e066cd8bf282b1a9"},
					{"0xae19c1dd2ea2e1f7a7e0a05a24945897e533f3bd719347b3050acf6d68480a01d574f10498145d27d505bdeb3bcb9bcf931275c48c6e1a4f18a46b7c03d9c0bd458032e2198b4823371c9ced7c68826b05a1b94f09bcb2e16217baf4c9a2b7"},
					{"0x3937cfd56241d0c6ece2dbbba9fbf5b7e5e4432feb90c2641baa78ee87828a5c3659d9f06dc762dd5d91cb5fece510f4d29802513a25db34f734d4338a4e473fb50e4cd4617ed3a93f2f00f00d543522dc42a4255be811e68869ffcf502f13"},
					{"0xf056010b5a01c99c3eb8515f0c20cf81567cdfd453df66412443c4853dc34a994126d11fa6c1a59c5b3de3d5572c95cf0daebd76733cd1a61436adf73571077dfcd4ee452ef07acba0fd15371473f7c7127b4dc1f97da8227b87dad9530dfa"},
					{"0x1193e22533f0c5ea8a191ae0ae6055d62c68c59d05e3dd03eb343777b3615485da3ea5174759b34b9f486f97b6657580d810f573e57ed46c8649c002a6441c3666526fe8f7140b870760ca5be04a3339bdfc10d996752c61819e18d862f868c"},
					{"0x788926be987f1259c031ac18dd6771beef4ff0580dcb455bc125fe1385113df0cbff993559f55752ea1502a3e8e84087b4f9531a48e939cdf4f41f31a10198e9a82cb07f0d78e82deb8aa18cb2e3cee5319d4df2fe4f4bf69201e84fd2f575"},
					{"0x66be610c58e904d4b5827f9b746ea5fcdf60f2e66e1ab240fb5c65eafc982d5e3eec9134d29b991497cc387471e05462a1925828c6e296c6f1a965c209f33e48cba22997fb02d315c63aaaca45b6ef7c0beaa2a96da60e839cf4957d6bbcc9"},
					{"0x3487a8ea28fc7b67a089b3e70e5eb268ab99485f31d1c7d7f281853c4e0d1e7d9e0c9521839d7286e6e1729df7da275bc576bbcf8b1e00d1e2f996150fbc725b904bc0077173d29ffcfcf6e03469176987f60ba39a8f6ee0c29d448a7a750f"},
					{"0xc68234b4d6bd5a4a37d13151f8e0f13a90cb6ce91d72e9ae916b2a29837bd01e5d4ce2adb1d90e883a1f6b5ac9b25ff7a37cefb7d9e29fd88ec1e9f3578cda671ce824b3253bc69319490268f60bcb93de665904d44acf45dd4c19861070f7"},
					{"0xe84f9cfffdd42f1f808768789dbcfcc30a49ab979995fda69cdf696e4f6b8d453573937c1801d258fcfbb3836f79e39ffff9f88084f61369cba6ed1f84bdeda53f1d7615f2971ad92d6ca0aa810ee44e94c6c5df4aed9b849eac77e0ee83c0"},
					{"0x496a56f15bd023ff76aad9ec934a63320f3eb03b60d13cc7bfa0b88d00a6168dccec5cee5fd2b01e059a414a876a757f502701eb366739350845b04410654aa1027e22511ca88e182106cca0b8f36489af9fd429a7e7b8b57030689b11f45e"},
				},
			},
			YMap: RationalPolynomial{
				Num: [][]string{
					{"0x5d38ef6582e5d7a838009ac71ecc25a6c64fdd19f4bc0d74af29b637cf51a14f40aa1bfc18a0f412ee1275c5211795d5dabcb7f7512dd4444f8725595ab965db9a2a330376fd7467616cf35fb20d8f65c93d02c1ee651929bfef3a02010998"},
					{"0x4dc036c1f4c016a18f48ccaeee3d1fce48ead68ff10b5d267a4e8090ef866a3fbfc9c826b1794ee575247585a3ee598e23e636b0e4f8a54b1bd182ccae0edd530e76c56b88bf2af50ac380ae79d88debeef0b16ca39f174df39b08284a51bc"},
					{"0x3032bb517e9743a55bb8f645f20cc63ceb8e92584534d6b157d461483dc394441df9ffd30fa13a5bad96c22b1ba1c0bb6f88899d3133f4b56cb1fc503627425bfe13de5eed7f9819a9afc6944c7537df20aafc097ad6650d17ae743d1cee77"},
					{"0x971c6e281c15dd21949eebccdb904c1ce2ddb0e4b541c93acbea7528285822fc660b6fdda6b92cd4872bc83ee741775f2d9c3a5765d7e70ae7ba2de60c3c73a1a54ccafae655deebaab1c03efa9bea4f5f51a718088eefe57f0292b5b14798"},
					{"0x7ab3de0b6540aac0819b8e9e40d8ab1599106f942af09c137f4242c9c26ea921dd782682c76b266b6e44cbe3843b0ad523e02a80d2af69efa3eec5c39e58566df3cd8157a20ca4c7383eee7b2c32f2459464abd5b9ffd5351c3d881a41dcf6"},
					{"0xfaecdb4a216f5c7f32b59689f8faa85d747f95adb8920419474afb8d55def7b52682c26fba23bdea292ebe6076a67e9ff4740cd2c0d222dc90412eef46c7902dfde4eac64e1d7399d4e2fa756be80bccca12b9b64f0bd9ebb616458aa651af"},
					{"0x8397c87fe6e56393d59e832cc69bf1daa706aff0f68f038d9cc3049d41dce6557e412256d8cc41d57deeff92852eb959fd7d2e8bbc39a3bee17b956ba9645f05e5cfa1fc66ce57d80cdcc9ae937c26555f0c238f158150aa6aab8494457159"},
					{"0xfd13e17f5b33195a3e4c6d3ef8d0fa3de081bf635cc38b22101eebbc673ad40e5212a5cae0285df75c6769b83d84610f3ea9b5a93dd2081ceb23cf5834c7efb2e39153e8d40277887343b630410b7581b9629a92f85236e04d1aa471383f36"},
					{"0xd2a831f4ed31fc9f53cf9e502189be67bf2ef9a4f1a05187e18f2f0158c40e421e8e747c5fb1c706c7830f2fd8186e99bfc4ee25a2f5a2e9adb4509e98c131abdf595fea29a48cadf69d57c9b08d71fe6661c6b597dfb30d4c4d83cd504522"},
					{"0x10f83707440c9575bbfb5e4779d00f3adab570857d6b2811efc6a36563c05877d23b8aee98b99e041a5d5677a5da2d59e16d1b9918956f720339f140f4b09ee23748dcb557135e538413f14e78199b2a7f5cc106c644fcb2ea142dce8f1fd4b"},
					{"0xea00809253d1081f62d4bca37aa536bd29dfa9d57ff211e93bf7d291dba621af65fbc05fea7fbd771e330b360ac2ef1c86f267f7d790a4c49b3a35855de520fae53b016499e2e4d34572ddf22182f45e0427f4e2af38dabca89918101013a6"},
					{"0x7a484843420c7079e43d6ec50dc2f94949b813b16c3e517c61034acab7ff1d212d5a6599460cb97a848e98ff86b779b57b9230fafdcb310bce8bdff32facfb7e8ff5d5a6a141e9aff51d0638810bfad02b374b56b167e1ce274d752d80cec0"},
					{"0x549b03fc6497586f83bd2db5fe2657effee7d0e500b4e694f966895bffda5393c27db4075cde98805be3c10994e10de502ea076e860ddca3dcb79e63ce6bee9a1b6703bcb605c43087318f0d9036c301e7841d0c7b032de1661ccd715d16c4"},
					{"0x76b1f83abc358751cf969aad2c4e59899996d0dafddf76f497fb693264670c7a65a536aae27c30bb34d8511d64c396cea615ef78c116d62dd81eee16e9882159fe92c56df94c27eb7aaac74e5a8ba04244451552360419feee867f6cac723"},
					{"0xd92f770caca73c3505c3a4e58a7eae19c1851ef9db25f07a785cbb78e4f4aecedfa7a5a5046f4622f3179b37ba00c45cc4bdc6b1fe86ebe49c8e9fa4290d257bc319185c825b66e8b180472ab7f80ad3c71a1dce9938ede56e2d7ece900d05"},
					{"0xfd5ac3a657102e0a54acb58d0a04e488934116e5d876c58b86a4e35d3af411aa83627651dc8198133a4eebf14e19286ef5b491286e562465445f465b742f94cc23dd887057cbb808afd477ab63bc467215b1971ba490fa2827e0d81a108f04"},
					{"0x10d6bec8b4dc04bbec4fb4149db3eb29604aae9f7a45f258015e66821b85b690cebb16777021aa0cfa0fa34d3e1f85161d11bc16183faa6051d6f726d0d26d1e7772543c32487fe27d852626b42cbd04256b5f9f5929cce9e84ce3a35eca852"},
					{"0x10d36f163c2f08d03557ace6308c74b4985dda1228f121e4c469dc37fe80c9b15fb569f5620065425a517010c93c0957a3bfe5b960d77e28d9bbe429518b494ffd268084140d17ab534b79f2bc5cfa780e5cb6fd5857f00251437d184fc3f36"},
					{"0x94302fe280a10e8c5c6601016f8744495ca119f4195d4eaa219e74506a25e93030a47862ca125d213b260738ab01882fb14e1971bd92b5c59e8f29172ed2f4ae8c9cc142a1044b8d3219e9bb292ca5e7bb3f5c0294f64a67e33642c8cedebd"},
					{"0xf062482aea1a30b121edd74c39fc070f3981682f0566f5c9143c65ef8f33182291639e5ab1db19070742f6e39d7bf38f66171536a9f164d1e7a5b478bcc9638a908135644b4fdb979659c28be6bf01b89adf6dbe5108084824251a5eec8f4e"},
					{"0x867a161c059d9df42b5fd6674cd91ecf88204c3bd498d793b67baf81420007af8dcf3327ac0402d6a72ba8af92b62c55509e3fb37bf8ce4bf048104f61229f8b52ee9a4bb45d6dd2362173e276d6857d5adb961662cf301618899b2c8acee4"},
					{"0xbac156f5735f9db804c79b3be77614d0365928205198a8405fe744332cbe784d46a3754dff8864841a2095232a01803ff43459f8904e6158f003b6917075bc588ac2424bbb9546ed2a7df59247dec3675e3150a892d82d592a2dac11077577"},
					{"0x9db7d39ec19ee775c663f000d726ff2373d9355bc9bad384d0f297b0a5b5e3173f6ba8dda95db0e29f6440102e90ee524a30eec0be66e95780a25e43123ee678c407256a77ac16334bf85e2ec00871599facc241bb42e6e8aef8454bc2193c"},
					{"0x5d679b51a45e040c495721d309dc5d813db4670a1f71d020beeb499fd28e420b9c46edbd145d83fc514c5af80a70690b8ad616242723b732929ed3780050ed2802adc6bddaaf8180303c7ed3723c217acd225430db169b18377f482c9c67ed"},
					{"0x1083a6218e20e989bd3d5a8dc6b72927ee61b6f1ae6520d5058f8414abdae3dc928be29740397c34e7c47099981a6418227b692bd23e6d8e0f17c9ecdcac75fc71b9746675772b093583c55451077c29cfbcfc20f10cc3c33b6d3fa576fb798"},
					{"0x2a2684b5ed4c54325a36d5472a22ddb44e499780360ac833a0d88b5bc6ae75c58a7f62540701579c56d530f8d7681c8c784854e40a58816f5fbb6432eaa776534dd47b3611bec33b6e87464163f7e9e44d485b2e47d9a07e64ec57dd29cc4d"},
					{"0x47402b33b50d3ddcf4a15f745e0102d11be7528f1f5996e4042f107bd090237bf5d75cd37f0912d86e971ef9452cc46312b7428a952dcbbe959fa1d767ecca1a0b36e1e30a30e0f71dfc457c548a04390371a2221556232dae36edb8da064f"},
					{"0x11da53c9271b02c7158fb2ee86ebdae385da9ea1fbc07ffd9dbd8c3e8aa15ecda86d607469df1146982d7261aa35c97b7d74d09bb9ffb479f935e71c69f3c60005dbca5491a4954b01fb413b5e506092664ad2cfb727419b104acd72e036f7"},
					{"0x536cf5aa2222d8de443b557d093c9f29f4a16dfd168e6afc1382d9841697ffd7ddeba4d099d2bced00a1aa2285b1788db932d59fb3fa891ce97d2f74e9475927fd9616c5594b9152e99dd586d5ca8ae8be11cb213289ae895cbdd4b2fd465f"},
					{"0x1da860f7c3597b35726e87cb3bf0b209effb0ef9ff5b2f116098e644235ff06707de8383e4cedca3defa727819c6a7fa4574dcca3844096d8e55ec3405ea3036e724ad26480fc08be1d562c7db9a0e0795b37e337e09e16c7e5033546ee8f5"},
					{"0xd07de606072f1a8a527374c766ddbbf30dbcf9fcc9ef0dbee36409d153931702895dff106c34aec8d2f6b85c4e2b310c4a6df78a37e45b4cce27062ae58f9a7ab8b3e8d7b3b60585903ff5bb83b5861ad82d740046741b91f7b951a5dc3cbf"},
					{"0x2606343340db37698dead78d4cddcaf70a6850b005f27101986c5c402a6d7b86ebaab95f8345807c243ae39a51ad91df6b27ebd90b4aff85afec988b3889012caa8fffad0c621eee9993dcc69f370fc96b5e854cb8eee096061ae383c00b4c"},
					{"0x5eef4743e715650a29dfe5d51bd349b00d506292b178708638d69fb99ad660056b8b80f206e1d507b863f2b1b7a26f3a2c115ad138ad6aef6591d911993705da206b6107e5469f8cc1d7623bcc867c10fc3bf41c10b4104dadc1914da7a424"},
					{"0x76727dcb29badfdf33c34dbb80cddf85084d5def7241d7ac8b6b29fa04e1097c534b5272704c75de0b439d26ae3089a3db2899041e275f3bcdcf5364b8505ecd98cae322ff7b37fafba7a8c9f7b81bbead4e4831bfa37dce31ccd4c0ec0393"},
					{"0x1121863773817cea34fb74e529bb85fb5eedd5cd253a9b209f248b1095a79371ba0d58cc7ab19fe62fc91bff7d55b99a1c92b6f299a157d6abd061c56b99a40f4ae8f571ca8bae37cc46f7d72e31283358d089786ed293882489deb19f2fa5c"},
					{"0x380aa09030f5968743a51f91b9f4f2e76ffdfdf93c0c1e481db8f7ab2f12b6f1af4c65388b2283f4dafed85cbc94f02482426fb73d27c1f9bbb98fd1ee37baf2ff25c8d28160f91cb356679908cc289c5ddd7c3b0c10d70ce520877d6a5ed8"},
					{"0x3d32fd2068147a3f7da278555ed406ade542cf524e674563b2cf9b4e8bded523fe0c6cfa7ba4366049ef1853ec49dbec71308f9d9c07fb2c92669f403228ec339e9c0d854340e32a0d312366872b84850b002246a56dc42da0d78a794f82e0"},
					{"0x8d03083b6680f456a6ca2f12731aec4d9bc3047f1338dca3dface56f3e5dcaa248034a8008c1cb6e2103cb759d3ee7f9bf050ccf5fa589cf3da4fc83ad8abad35cadd716d51de0f823f8874aa7b1759c1265d7767ce44a23e0fa26cfede36b"},
					{"0xc153033cca117585a8e7e559a8b5afee72d31ac7c96ea9660856b636d26664619b0d16312f43c760798af878a41561ac18b87cb636c456d653b58d0343cc76cac997ca14928b935bf6c9b9912d6cd88ce3ad7b2525c09727dc2e15752ff950"},
					{"0x9e424fec6f5e28209f0dccf860a5bf271461173cb2f2c63922b520ea861c8b17876b00af0a926be498559104ab3701da59cde8972717093092fdcf0f4f1cf5ef798db7f5bb86db0db37c4ded8e979869c1a62aa3e84f2091906b0838a3822e"},
					{"0x1f7b0fd3b4c9a79f8302d026517b9018ec27da4cae421b702cf5e7c4923c438d89a24c946e473af82528298e92df34b54ec696ef86299d10c3fd8252b951b2b4dfd3b829a59c81c6ace17f6001df90e6be71bd5d68d42de866f3ab1a202423"},
					{"0x9402f37c7ba1e44be19ae14fe91a6545acef0b2a0a5e36b28179853b1f2c7f98e988945246a9d0bd433602ad0a75d66c4ccaad92800b997574767815e9ace78b11abe421571bf819ccdc2068accedae0e729315b2a1520c7bf579272dffd49"},
					{"0x331d1df12f90a78ef9e864e208ca152c9de1601075da588eeac25127988d0f04e16af1f2c817b2c33bfacf0c4696b86f5015b0f66c40cdb768aa2eec7bb555a17a245f7136ff01da8de4970bcba352e698e1f350dd17890e07447f13f2928b"},
					{"0xf6fe753cc6edfb75968c8f6b8cd121a06115ed350ee30dee74f5bf91816efa1a47d450f52febdbd8ebcb5483c9b169ceae1125e2f69f254cc91e9077d7e6e409b9e80ea5e76ec5e6d9a84a25bfda45ab2555314aa4a458243fe5c225c1d149"},
					{"0xc1034618a75481d52de528c17b76c6f30c350df5827accfe92a886055129790032d1cc01eac8727255e1ba03557cacd704ba2912a0737ed16a69f98bd196588d474d6cad779bb90d87f6743a87573f081a734090b05d1a591bcb6d4526c7c2"},
					{"0x19ecb6f5a4ad4557134ccbd3ebbbf4d3d0062a9a5d288da6f0e21bf98f2c04ec673033817c2ba1e808a23e96b99e945ce33a695884cacbdf15991bf2b9c4b3b9a5133888ae5f3947be1f9d499316f170f8218494d43536d883db4c24584adb"},
					{"0x32f37e3a71b888b9fe0a88c42666b32112b5444f24cbc4d7a805dc02b4538e0bf86cc74ac277acf8acb9dbf815605dc54a746ff5595cf472eabd6299597dd15d479dfb59307169b2b2f1e50c9c6d83d28eaedd5569d7f6f1f40657df2614c3"},
					{"0x107ee94600281e0d5b68e55349f03c7b886c4b2fc8a827b7a353fda767beabf06fccae229fc2bc576b49ab29263c7d21499172898b4757f3b44aa54fbe99015cc1b263d929c94b3a7019490d6e28b2c7475a7977d4822a065bdefc470912dc3"},
					{"0x3b4583aa3c1f1cdcbd1b268fecbd5c85c46d7ecac4cfa94d2ed766887ea79549a9580d8a0ce47039ff60bc4d3aa202435af74c97403c172ece712bf15c246650d6612baac5f7019cb0bdc7175840fe1d7c8c2e9d5c8663cd12a62501e9164d"},
					{"0xf6eab8fc5a94f484333df010d6f2c6b620520cdac1a40546769fa2b02f9d6e466724df638732a4eff5446436296dface1495dcaa6ad4e24b3a14a0c6c98364d2022406167ce327f82da7c59056962b5238085af38db3f39758e9d1bee007f6"},
					{"0x9157bcfa227476f05aae9ed56e79824236cb30f1f47dc82a9648703881f75342ea4dd3f208102bb034ad52f7c0a64d33806df1634fc233317e55e17c70abec3d1fc16cd473e7a1693dc312a5dc498709166bf78607b2726557f1dbfa3af42"},
					{"0x13e95f1b69c1bb059b35da52693903820813354d0c2a3ee18c0077aa967afc4b7115d0fb99e814c7b256acc47cc4f9995bb0df178a604f5ca838ace81cb080dbd40e67dd731e8c54ace47e999d79841e38881f52e8ba7eb82420e457069bc7"},
					{"0x5d6d5a496bda19771b6fcdf7cefd6dfbcaa8945fe445b5223cc538ac2ba0df97e495af83fd6f9c272e3e4914ebf9277380079d9290a356d9111bc382492cbc13ae4ddd0e0d7ba5a1f3c117569a2a8e96d169af588d1d4085d0d801a598d121"},
					{"0x12ed009e830c3052d44ec9cd6787457249084772a2cc3118ce49b1bf668dd1a977f524abcda366867cdbbbdbea655cb336d2a088df78456d3d21df942137d25b1343edd948cd5e3b49c76ad5937e25f032d00fb29262f071c5e4d0e512650a"},
					{"0xe3da5cd6c4e06d21025932bc0ef3fb4863115ec20420cb77b2f8017df249e00422a4d2dc652400c82dd4dea5de342e9d61fd2f1f842b9e5ac519eb62860061562526e56e1087eef9ce359a629824f703f5c1ea62cad6ae10980a7b6363064b"},
				},
				Den: [][]string{
					{"0xb35848a97889d06c9d137621e2f283fedffc9d4fc1a32da73338a90d0a46fb076bee393363f551ec5bc14317a92290831636fb97eb217a7dfa6e64ee0250a2f0ae408c60ad721aca20082b11124ed0af26b9b472706b58c8e258dec46457d6"},
					{"0x11bd48159d3f3f0a15e56f4758e253a1d2b3b14bc308c858f3837abb8e3868658920679627e8a93ad269631ef17b1b1693afc409afe41a71e49f64a1e2535fea30f085d24b7b6cf9aebcb322358f81a34b6599c88bc90b978d0218b755cf2c1"},
					{"0x1c14b675d0ee3fe6c012a5be16d84618112e7838d3621e79f62729f8c76dee05199cd66a64c52aa80351363fc91830a3e7eff500235ff5c69ff02823bc95ac6a89a3fd461e7921c71a8ccb57635f073f3a1b29a71071003fc0be48a5aa8990"},
					{"0xa40a04a2472305ed9478e4c4eb679c1cf87bad62fff861126ad8969c548ffa26543e86f1c1d27957a59aa160465d5ef918cd65e450a2973cd329b5480adf5911a750b83ec47ca6f60866eba9f5cb0f2c11b38e7caa549f970d2a3190a03dca"},
					{"0x1e0f2070926cb9da608e7a9daad66a92ea5236683edecabeb6fa27abf86c91f8007095f818b4581f306698731cda8328dbf7ec5526cd091746e7a9545a34f943ed863ba6982ce022f6f63d9102c7508f332dc3b5de64c22435f0937548c9a2"},
					{"0xc3a32f1093a2d37f26a614efc790a279c8284c321c191637dd146829dc90518ff37b4801cf7688fdbedf8984cd0292c99034198757d5b07e946c0f4aaf869d7613162bdb8c2b9f64e958a97391e099d0f12f032c6458e1213a0a44282225fa"},
					{"0xe02ea67182f3fe3d578b08f0d7928b7c6fdca2115b687ebf858dfa3ed273ed68a9853fa0675254cdbf5e038e2dff11fe6be1ac0acfb7e2d69713c9e5053107232558137964f4d8c75f9d499b5d1172c7c7c7ca17ba1552c181482c6fde568c"},
					{"0xb7bdc820045b8cb4750d2cf14442e75e71ff88850bb68c703a9d570b4ead2265e1433921511be60f0f494ef406d6ffab61439f2492902d06a47ab797611ed56a2db85dbc6ca66ea91fbded330d1607a8f0665333167eac5036e8809c424602"},
					{"0x4b874c4266a94c9645d7235482a22dc864d3a95f9123f6dd42ac37687a32fb96d6d078704623519d355e7d2942b96183761b60a96d86b24158041b2d27e0b6d83f524e2dfd36aa32c722dc52e6c8f90b372e4c69b8d57c400535580e741931"},
					{"0xed7683d3ed7bd7b795127161c1c3d283e2e5264b38ec25fff29cd620f0f35b50bae6134ca7c707fda9f21f1e5ed72dba00b4db93a2289a0ca3325006b7901fd25eb3112b01280113100c8c706e5cf754cfebdadea45bfb1bcad9b55b6a8bec"},
					{"0x798e60091f0baff46af8096d5d385c3ac834078bc68a5a0264b38d84d3e575383492076590dd1c78ce517c938bb2977a4a53c19a224ef3c06480ba9458bc3810382e54b052a61ea2a9eab88b7f2e4379616e835e8aaf9ceb8f7725c00e473b"},
					{"0xe25d6afa99d9845550da2d8be7e54972c881f60e60fc44e1aa4639a469895429c40ded2c5a915747487760917ba655e5bd70e760a60bce724ebe669a6f9a26e612a7e471c491eb901f086651f804b2e8ae65cbc30fbfecc3ab056254152e1e"},
					{"0xd3bd269478c18fe4ae906db51c2c61c8e8eba8c0ffeafee1a4590f0f771c420738c368e903c5bb0ab4ae5d764f1db9d32dd0941af5abdcb799a0a7868ab22b8066bb43409f5618113ee9dbd7095a1132467d7cf792c2edcee3f32fc76e377"},
					{"0x10d8abdaa3480b89ebfe1c4f750c43d1ebec7cfd63adfdcff0904e9b54b762843fc0dd9edb82ce3a6dab718b3805f8bf23d59fe0be8558d3168557f22e481614c83c08a53ef37d647faecda297e45535112f46edc37101ca78aa36db8baa52e"},
					{"0x73757c884a1e868d44f45a39a70be12ca5fbca1045af3c5dfce747238edd7926dc150df6bae0de22fe58a951f68e395e3c6b58285afb6e13d04f58f3be13f468f1d95d89be6973f4af4a03c854d956e4bb87cdb1e85aea019e5f0e2bca4543"},
					{"0x43b12c0a691c949e92b6c9de3f2fd57d511a8f558567437c329ea1602a4f9575c328c6ce9abe3a41d6977eef727257a82e1bbdc6cd86ef0176fbe891af806075e500c1f05f54880ec857442d6fdfe701cfac8e0bfed571913c10eb250e0022"},
					{"0x5dd753e576c5e17fdb31053f4583d11a7efc9842522012c64dcdf4fb1813de9e2342aca1ea200c8e8ea86c846041648ea1ab64d8286960d339fc3605f38472ebd8a8a371d7a6a99360c4a35173bbc8fea0433e13b00707ca26f29726c1201"},
					{"0xf9cb66cab40e4b021cb9ab0d6ecb29134a25c87261d856001610a3d7fcfc485c34c1acb355a69c9fb3e171b3e36814b50b1d58b14f86d2fd7eeed7fd1ab7785800dece186c33a4fab38104a0c5a8abd353622161daf40d37a6d072443c4d84"},
					{"0x11aa8006f5e3cf018df2a06234daddc183d82f632c47e1adfba4c1747e717c7bc6708aef8baaf81d65520bf3eb7543d6ba7267adac6c2b1fdaaada6f47d96485e0ae6a1a959da775932766eb8c044905d42d295e4609c41019d3215a0ecf1ce"},
					{"0x11cebd8fefc74f456542424a4260474172f2ea3de5ae199758cff05a90330816514c564a4ea7b56ff8173a10c9be915b4c4cbc6dacbfde9ae946a963ecfde2fff66ff267019fb3f6bb80f77aaea5a09d18b8fa6f0b9c4f730c41077a869ea60"},
					{"0x43816faa84ded72d8298e803ffd4500b0d6fc6e4fd2febb9f773a0b2b9a7d2d6e2737798e7a85433717d7c3df4cca47295c9763cd9a14a2a5efd2a535d7af007f795da423ddc4709a0fb39ef1159d316b9a072d30a28f62b79383ae61672c"},
					{"0xbd64fcab7189eba72da0f52543636cdf11c17cf200f39297021b4ddd528da640175c9e79cab502feda518f5643053e92672e569935848dde1411b4f9abf62875b4b0dae6f8a249a05f984d8e2cbe7bc8216896251fc9c801d232ee0a6ace1e"},
					{"0x11908b0ee96ce37dfa9655c3cf2417961b6890de361366d3c889cd33cf5d9726801f9db61f7a445bf3d30e5d2632d899a45da474ca5bc5257cdbeaefee742e5549975d293d3a211b0bff06206bd8da0d66a31684300aa30275ec98af2204fe"},
					{"0x7e3dd2299ac6f6c9b0ca812e5250a5a0a9ac696649ea44304efc9eb17873ba05758cc68535699b63a921dca0c065bc0c74f47dcf13eddfa9a49ade0dfcff10a185ad8a1ea9c0546fd04335ed21eb0c32813b8d98d38ac8444619053ab9e9db"},
					{"0xcecbd40f99ea98da90fa06c98dd11219e5e9dda72c183523827b1fc889ab4a306695fe674307047144468aef1f17993762be4b859483db87b27f442bddb107489d094a51ddf3b5dde5499d79a806e31528ecbebc9894584135547e9875dee7"},
					{"0x8fcd9b98a111fb0b88bc45e05c13e919903c015e73e51c79b1d76f351e36c5640624fcde3e60ad3a5949f9a35dae56bcc3a1886854433eeb48c3498b4b32a913b34b78220b02b0a1cbce157f236d37fb69ef96e98f07644e37c9abd1ceea1c"},
					{"0xbc6e2187eb737df544826df89d5279d06046a2b47664dbb87fce1ab6a3f7edba758835bf0810b4ec4237719e7f801e24e64247f3fec548baf27dbfd691eec0e490ac592e1e066480706aae437bd7bb3ee5c982a9c0ca1575b556005bbea58f"},
					{"0x12170c6c8cd5d3a968d03315342c1251b7e384f85fdfa0d3926b793bd740afa3dc0dc8a51eb829450218c01c0ac8b4eb6163ec1132283f4d366dfbc0582225a6b14163a15df63a27a2ffa2a5da74ee5845d71a8346187ca736714ccbd2b00ce"},
					{"0x1d8792a1d4b4411685a26918d785823cc142a0912ee9a8c1981586b35fb2581492b26b7150fdf1899f678b13789c48c28bae260fb93742507d0323f3f2c908a4b089a4e018ed7b351cf17d05cdca5d13c92201596045f7f89bb44c7e42e17f"},
					{"0x1b457948b6d5eab15ce534d9c997bc32978fce85a19025d325c1705231586ff07f2e334ea9bf39f572423f10f0938ddfb7b44ca8dc8d21317f5ab1c66248922f53126875ee0e35c060f413f4376c474938abc5b57a9ce17c15cdac17c7fce1"},
					{"0x509b78d33906267310fb5764df3a83af5e10b24b3d04ff9a64f1e87872403650d8f05e039b0bbfa50ac9a9a496f509541a5d1ae590acd31e0efea18f9f9b0eae82f2214364c91528dd297288a4a3e04cc82aea73b257947cba2d3c027f3b4e"},
					{"0x34c92249a79e2afe89113c83ff829e7376ebd2bd99f61023336e601144565a3060888f77f83071095752205b778702253fa2a187d9cc0f240fa1401be60298736dabcea50ba63065cc6aae3a089c3bb77dbceefc83fc029a2adf90289d5269"},
					{"0x6158d56b2f6902c287d980c970d8aca6f6d10072eb749afaabdd9a9d098bc6e7bcf07bd1bc8958cb79cbf53dcce6eb72bc34a5c2613384bcde79a64b340640e821855e49f71c073c715dd55768fbbb5a27397cf584fa639d927837ba9a52cf"},
					{"0x6e3c4990d0e48167ffd607fe2c5f4d5e22afdbd2c39113dfb8ff2583d930a9bfa6c2074eefb455bb8ee0618600768b2f85e634791a2f6465642268d8f46d3f10a38d980a60d05c71030b500691002cd7cd01a5497eda666bd77bf2498dfdcf"},
					{"0x2b15f6bcfe35e5d93d3c369fa9e283b137865559be088eb6dcc6e73eb50854b68943546f83849a34668275fa3292da90ea6941391738c9abdda4bdee838b80e7959ad5d72b9fafc33bd1526c7c993dadfed5a79b9bb119c277cef9c7a71dc"},
					{"0xdaf7f2929e35d0ba56ce2742d5d9cce74d572dac5882c678bd6b5f39d7c6d74ee3ec0e4c2e052c635a12ca1389bf62b147c6c85df6adba1b2c70ed3c60424c84dc6b5265e11ec4788ae277f04576101c11009182de27a8eb5953c1aab8e1e2"},
					{"0x4a1b0c9af273773fdf3bd29eae337f09acb8e1b10457187a5f7d43450a6de3b93d3cf86a298a6e99030c0cd203113c46a67fc1689dca1cfbbc663899b2ebf8781db80872c647934862ca898a564fa156b58c554786a7712fdea39d78a366fd"},
					{"0xe22946eb7bdbef6cf67b1b30ff0c6ff4a2d3108d338c55bc561b3ab50db2cb0826365f812464f2cdfd2940476d7fb7db692ce19e2f53bd3486412d1258f91ef75cc0a09b3d72955a6e867452e4e7aa2f1c496fec0b41ff2d5df172664683f0"},
					{"0xcaf9adb7a9fe17c553022cb9fa3ed693a6fe017b6c667b9b3fee7f904fe34ea15e1b671bda21c0e3b8bb07f3301bec8986d8ed48b1461666a88d1b1ec3d12a51b07930b81e544907804d14c5ed8834fc6edc7d660254d8491968ce6034642d"},
					{"0xdae7c72155f240753502352e5ef320d206adde735e9fdda0c6cea0bd48acc5eeca42e615e6a79bfe4f57a3c75816ec327b0fe017bdafda135db84ee4a5cadd38b6c3f32216f411f2a69a45daf35d5242c9ea218557aedfc0c241bef5c25d47"},
					{"0xa44e2a4243eb71846e0c033d0b508654b71ddcbf86b859adcfe48fc5330c4226986f8fe2b405a587c37fb51173e2f438759dd8250235b555a7f99915aba1961c0c1e4abaefcc9ba4d88d08254bef4b4ad5efdebb0f15586981614e65f5a262"},
					{"0x11d90321c1a5e68ce6aeb22eb2c666145d256b2541178474d03d8e918d8ad4fb6e584f004810f1d3e5ebf0ae73645bc8851cd382bb88abf2e65019ca263ce9f961956f03db70d927acff8a5ce8918f6ed96762782c5c78ae56ef3741eeec30e"},
					{"0x73067c544d14eb0fbe73111b96dc68c493c312a408bd3138e176ade7405d93b6553004d77e05da6cf32defa9e65e1267ffe94f6d971f8de118e3bc21fa8b59896ba9a3a1494f176e24195c65730b3fb2c3d0d048de7e13cbe64f64cff8a466"},
					{"0xea2438249db0c31564caec1d831128fe9688db01a3e9b017c68f007bf1dc6782d46226efc730bceb0a4b5d6413f7048bc5b704affb912aed0fdb9d26a3d0add40ebe02bf786a38e8e29e88c6143b9eb289b27fba11a6979905a0bae8c272ce"},
					{"0xb8998d5ec7393dedffe4f708881d1cc145104c8485261ab6df727bc0fa4a7b55dea1a7893791a93790e6af9d1bc0bf3ebe5feb40b340e9e89cee859bc443162e3dbdcda09f1680d74700f56f037e4388aa741daee7bbca5ac789d34210b9ac"},
					{"0x9db9607a944de0743644a01a2bbc68dd869d4df41655c78b91678efa6b297efa53ea116f68a0d01b696ba23cccc34a180d0e888c9d0cd6170b21c7cc47e7040193e605122d2487d0960d31f40fa0f9fb1979f3c9f070ae21d4987aa10635e6"},
					{"0x1064c0575f32e8a01dbb0902016549291db671757d01133b941f80b48ffc6cf6e97ca4112be781a452e4bdaf8188c3db4245c089a8cd9a20a9380970a2f583371a03a3306955b512b8c15992c2689ddd948200fefbd9a23b581426419bdd44a"},
					{"0xb38eb53f5c01ec437a38102c26e021ceab2096dbff88cf994a5e676c67b5e9e2aa0b7b8e5fbf481b9ebb1f2e1143c5d2331b4a7307543827f08ac9b085c9f763eace96795934aaececdb8d5667438f023bd0dcc10a1f53751b46aca1e1a0b3"},
					{"0xd3a1a4efb742aa1a15b063d6601a48f9119b6ad86d32432ed0d80e91fdd274b5a2fb4178cdb5cfadfa462775bed589a228c2974d988b40a7856b1e6f5b7a69201c7226f38239c0e4f57729b74a2a35d56876815defeff9019a4aeaec8ace2a"},
					{"0x890f6b8f09c172a9759a98d2992c4ec9a89e19af59dd9aabcd54dbae2c8bec58b63b35d8b2e0434532e8aea16ac6155c20c944777a8ca9003afa8dd3d6d6ba35ba41c8ea40710297a073dbf4f4b7e2828b20eeb168b3ed9513f7359f8fc075"},
					{"0xec2327808b9cd4a32bc9540933cb13b19057ddfb9d0815a9c3570d94158d5ffff7b1a837c905ea8515e45f571e080770a6d574c1735ec3000d79a494dbab3b2e7c463c8f518ab36199573c42837d74f7b42b001d232aa9847548b8d8c2e9c0"},
					{"0x3347dd7683ba2e167d3b718be720970c262bf6aac6783b7c0c56059a2e218e3983530c568d9666b9e7b1bfd947e1e321e1ef041fad5fdd9e7392055a45b9a13accfb5e13fa30a15f00355721459f71856aa768476a8ea9e0b18cade6ab4f49"},
					{"0x64a3e6bd3ee53dcd1ae4764d398d44760b5c5192d0745d71a452accbbfd3f0f9f106f9866b973d599c20c64ec4b9311f4ec1b991ab43b5b23e865875b56926456fe6399c3f69b7cf8d3bbf6254aef3c137e16a22792898bdf6265a4275368"},
					{"0x6e1f826a09b835ff320046e2dcef94cb16de08591139db2b9f7114d380f921d4b3628b658fbc082d086761efcb1fb03ef83a82e0d19ad5cf8c6888661897eff183bd3379aafcd524318a32f1156d16ce876fbe3e7bdb951028489ce89aee8d"},
				},
			},
		},
	},
}

var tBW6_761 = TwistedEdwardsCurve{
	Name:     BW6_761.Name,
	Package:  "twistededwards",
	EnumID:   BW6_761.EnumID,
	A:        "-1",
	D:        "79743",
	Cofactor: "8",
	Order:    "32333053251621136751331591711861691692049189094364332567435817881934511297123972799646723302813083835942624121493",
	BaseX:    "109887223397525145051017418760180386187632078445902299543670312117371514695798874370143656894667315818446285582389",
	BaseY:    "31146823455109675839494591101665406662142618451815824757336761504421066243585705807124836638254810186490790034654",
}

func init() {
	addCurve(&BW6_761)
	addTwistedEdwardCurve(&tBW6_761)
}
