package config

var BN254 = Curve{
	Name:         "bn254",
	CurvePackage: "bn254",
	EnumID:       "BN254",
	FrModulus:    "21888242871839275222246405745257275088548364400416034343698204186575808495617",
	FpModulus:    "21888242871839275222246405745257275088696311157297823662689037894645226208583",
	G1: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g1",
		GLV:              true,
		CofactorCleaning: false,
		CRange:           defaultCRange(),
	},
	G2: Point{
		CoordType:        "fptower.E2",
		CoordExtDegree:   2,
		PointName:        "g2",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           defaultCRange(),
		Projective:       true,
	},
	HashE1: &HashSuiteSvdw{
		z:  []string{"1"},
		c1: []string{"4"},
		c2: []string{"10944121435919637611123202872628637544348155578648911831344518947322613104291"},
		c3: []string{"8815841940592487685674414971303048083897117035520822607866"},
		c4: []string{"7296080957279758407415468581752425029565437052432607887563012631548408736189"},
	},
	HashE2: &HashSuiteSvdw{
		z: []string{
			"1",
			"0",
		},
		c1: []string{
			"19485874751759354771024239261021720505790618469301721065564631296452457478374",
			"266929791119991161246907387137283842545076965332900288569378510910307636690",
		},
		c2: []string{
			"10944121435919637611123202872628637544348155578648911831344518947322613104291",
			"0",
		},
		c3: []string{
			"18992192239972082890849143911285057164064277369389217330423471574879236301292",
			"21819008332247140148575583693947636719449476128975323941588917397607662637108",
		},
		c4: []string{
			"10499238450719652342378357227399831140106360636427411350395554762472100376473",
			"6940174569119770192419592065569379906172001098655407502803841283667998553941",
		},
	},
}

var tBN254 = TwistedEdwardsCurve{
	Name:     BN254.Name,
	Package:  "twistededwards",
	EnumID:   BN254.EnumID,
	A:        "-1",
	D:        "12181644023421730124874158521699555681764249180949974110617291017600649128846",
	Cofactor: "8",
	Order:    "2736030358979909402780800718157159386076813972158567259200215660948447373041",
	BaseX:    "9671717474070082183213120605117400219616337014328744928644933853176787189663",
	BaseY:    "16950150798460657717958625567821834550301663161624707787222815936182638968203",
}

func init() {
	addCurve(&BN254)
	addTwistedEdwardCurve(&tBN254)
}
