package config

var BLS24_317 = Curve{
	Name:         "bls24-317",
	CurvePackage: "bls24317",
	EnumID:       "BLS24_317",
	FrModulus:    "30869589236456844204538189757527902584594726589286811523515204428962673459201",
	FpModulus:    "136393071104295911515099765908274057061945112121419593977210139303905973197232025618026156731051",
	G1: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g1",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           defaultCRange(),
	},
	G2: Point{
		CoordType:        "fptower.E4",
		CoordExtDegree:   4,
		PointName:        "g2",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           defaultCRange(),
		Projective:       true,
	},
	// 5-isogeny
	HashE1: &HashSuiteSswu{
		A: []string{"0x8e4edadd82ff003e6762cff9b559b8cd0f3f6c9311276a6d560dcce30e697a982e1866e3e7c28d5"},
		B: []string{"0x2064f87ea0196ecbb9b075804c613d4776224e78064823a8568e30f5ad5af3bb70ee17723af3a0d"},
		Z: []int{8},
		Isogeny: &Isogeny{
			XMap: RationalPolynomial{
				Num: [][]string{
					{"0x236b5fd9cca05871bd84a4837633e369779c83cdd8e57f5e6c225b947983cf102a89412ca193804"},
					{"0xbd5fdd72856b15e73452512781cb8a44afc43fd20722b37bf41b260fcb6b2a53697eaaf34dd4055"},
					{"0xe48ccd9c11799e37b9f9713ad4c23c792bfe9cce20bb64b953983bb7789d7a5d28b1cfdd29c6212"},
					{"0x3c02ee7a69adc553341746545c583c06a0d844f638330a35305f5e8e312457c0ab57bc2702dc270"},
					{"0xc836be99bb812fca77c672366482945f54dd793103efb9504eb992da7132416060b75c14fb7999e"},
					{"0xfb165e39e1f3c02308a056717044d039ad1a5aa191127f2160837936541ff83badd4b3430f63d71"},
				},
				Den: [][]string{
					{"0xac526aaa4ccfab9e20d1af55e1b46e59df4ccdf5efa58766d0c18ac6326551818ee9e90fa19a875"},
					{"0xd8ed9eb76dc3ca65e3c54629ff1dbc57619627e2efb082c3f4601ec65d293de69e57eb95404a6b1"},
					{"0x6fc49fca38657cde5fab7a027bf50b888cb23b6952698615ff744257a41fa35df7f708c34184a19"},
					{"0x23e8941f0cfac565a7a6787558193984724c940bb5db04b86f4a98572244fc21a180f77d539d5bd"},
				},
			},
			YMap: RationalPolynomial{
				Num: [][]string{
					{"0xff4f99c01dfcb3892a91fa883b348828de9460cb96389fb35ffb06434cdeef1ce46b03c5dd5d0f7"},
					{"0x81224ed3f6692419ae30d702d3eda4710053bdbae2d49fe1f4ae22ca850ba727e1ccf7e5701c164"},
					{"0x45054affadf894503d5833cfd9dbad5eb905a527a12b5e7dcabd0052793f9b49e64e957dd42da4"},
					{"0x18eeec003ff866c9fb04c7371fc3383d385a2be91d8a0433f6974c71a0ce405f122c83719f1393e"},
					{"0x31dd068a643f47a6596e317e958886ea2ac504968e1c5cf09c8d5776c6643ef4de74fbdd8c4a619"},
					{"0x2c8e3ae176f645fc860fce8de1b13b50c4000167d09963c6e1a9c672f88f4f8d0503c022726fc95"},
					{"0x9f05a21397a2e89eb8a9d058e93ca60265193966535883b745a89991576994ae547e2d441247c3f"},
				},
				Den: [][]string{
					{"0xd3e018c50c3942dd4d09a4ab202a25696610ba38204d026ecdaf526c2f6f7087e577ad578cd63a4"},
					{"0x8287e2ff37ee6fdebecdbb7847a885def88d0241d5cff2567cb4bc388b67da5687eb6031701f843"},
					{"0x59d82ad3a832a32188e27cac33b5e6c5598cb76c8ac13ef00b5d65852db61f05669c372e5dcc771"},
					{"0x56b84eb18c4f8eadcddfdda011cc2f7b5c06990035936f127ba77996f19017f4ff02c13009b3e70"},
					{"0x7d08817b694fb1681686e845fda634911d8d84dc73472bbe89ad038a351d9729f4e2626dc0ec353"},
					{"0xb8a32f420e7c71800ff7e1b5c3f4580f6045ed45b702294b5e89b3a4548d7626dccae5eeeac55f1"},
				},
			},
		},
	},
}

var tBLS24_317 = TwistedEdwardsCurve{
	Name:     BLS24_317.Name,
	Package:  "twistededwards",
	EnumID:   BLS24_317.EnumID,
	A:        "-1",
	D:        "20748505950524021841644589704740731932416084248011369709738936344973878925081",
	Cofactor: "8",
	Order:    "3858698654557105525567273719690987823069521430163883173133245580997415449969",
	BaseX:    "4348505656527095883506785370890963704100065639426869666063106978260788240233",
	BaseY:    "1929349327278552762783636859845493911537170411830425720219700276810167091201",
}

func init() {
	addCurve(&BLS24_317)
	addTwistedEdwardCurve(&tBLS24_317)
}
