// Code generated by protoc-gen-go. DO NOT EDIT.
// source: bccsp/schemes/dlog/crypto/idemix.proto

package idemix

import (
	fmt "fmt"
	amcl "github.com/IBM/idemix/bccsp/schemes/dlog/crypto/translator/amcl"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IssuerPublicKey specifies an issuer public key that consists of
// attribute_names - a list of the attribute names of a credential issued by the issuer
// h_sk, h_rand, h_attrs, w, bar_g1, bar_g2 - group elements corresponding to the signing key, randomness, and attributes
// proof_c, proof_s compose a zero-knowledge proof of knowledge of the secret key
// hash is a hash of the public key appended to it
type IssuerPublicKey struct {
	AttributeNames       []string    `protobuf:"bytes,1,rep,name=attribute_names,json=attributeNames,proto3" json:"attribute_names,omitempty"`
	HSk                  *amcl.ECP   `protobuf:"bytes,2,opt,name=h_sk,json=hSk,proto3" json:"h_sk,omitempty"`
	HRand                *amcl.ECP   `protobuf:"bytes,3,opt,name=h_rand,json=hRand,proto3" json:"h_rand,omitempty"`
	HAttrs               []*amcl.ECP `protobuf:"bytes,4,rep,name=h_attrs,json=hAttrs,proto3" json:"h_attrs,omitempty"`
	W                    *amcl.ECP2  `protobuf:"bytes,5,opt,name=w,proto3" json:"w,omitempty"`
	BarG1                *amcl.ECP   `protobuf:"bytes,6,opt,name=bar_g1,json=barG1,proto3" json:"bar_g1,omitempty"`
	BarG2                *amcl.ECP   `protobuf:"bytes,7,opt,name=bar_g2,json=barG2,proto3" json:"bar_g2,omitempty"`
	ProofC               []byte      `protobuf:"bytes,8,opt,name=proof_c,json=proofC,proto3" json:"proof_c,omitempty"`
	ProofS               []byte      `protobuf:"bytes,9,opt,name=proof_s,json=proofS,proto3" json:"proof_s,omitempty"`
	Hash                 []byte      `protobuf:"bytes,10,opt,name=hash,proto3" json:"hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *IssuerPublicKey) Reset()         { *m = IssuerPublicKey{} }
func (m *IssuerPublicKey) String() string { return proto.CompactTextString(m) }
func (*IssuerPublicKey) ProtoMessage()    {}
func (*IssuerPublicKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{0}
}

func (m *IssuerPublicKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssuerPublicKey.Unmarshal(m, b)
}
func (m *IssuerPublicKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssuerPublicKey.Marshal(b, m, deterministic)
}
func (m *IssuerPublicKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssuerPublicKey.Merge(m, src)
}
func (m *IssuerPublicKey) XXX_Size() int {
	return xxx_messageInfo_IssuerPublicKey.Size(m)
}
func (m *IssuerPublicKey) XXX_DiscardUnknown() {
	xxx_messageInfo_IssuerPublicKey.DiscardUnknown(m)
}

var xxx_messageInfo_IssuerPublicKey proto.InternalMessageInfo

func (m *IssuerPublicKey) GetAttributeNames() []string {
	if m != nil {
		return m.AttributeNames
	}
	return nil
}

func (m *IssuerPublicKey) GetHSk() *amcl.ECP {
	if m != nil {
		return m.HSk
	}
	return nil
}

func (m *IssuerPublicKey) GetHRand() *amcl.ECP {
	if m != nil {
		return m.HRand
	}
	return nil
}

func (m *IssuerPublicKey) GetHAttrs() []*amcl.ECP {
	if m != nil {
		return m.HAttrs
	}
	return nil
}

func (m *IssuerPublicKey) GetW() *amcl.ECP2 {
	if m != nil {
		return m.W
	}
	return nil
}

func (m *IssuerPublicKey) GetBarG1() *amcl.ECP {
	if m != nil {
		return m.BarG1
	}
	return nil
}

func (m *IssuerPublicKey) GetBarG2() *amcl.ECP {
	if m != nil {
		return m.BarG2
	}
	return nil
}

func (m *IssuerPublicKey) GetProofC() []byte {
	if m != nil {
		return m.ProofC
	}
	return nil
}

func (m *IssuerPublicKey) GetProofS() []byte {
	if m != nil {
		return m.ProofS
	}
	return nil
}

func (m *IssuerPublicKey) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

// IssuerKey specifies an issuer key pair that consists of
// ISk - the issuer secret key and
// IssuerPublicKey - the issuer public key
type IssuerKey struct {
	Isk                  []byte           `protobuf:"bytes,1,opt,name=isk,proto3" json:"isk,omitempty"`
	Ipk                  *IssuerPublicKey `protobuf:"bytes,2,opt,name=ipk,proto3" json:"ipk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *IssuerKey) Reset()         { *m = IssuerKey{} }
func (m *IssuerKey) String() string { return proto.CompactTextString(m) }
func (*IssuerKey) ProtoMessage()    {}
func (*IssuerKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{1}
}

func (m *IssuerKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssuerKey.Unmarshal(m, b)
}
func (m *IssuerKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssuerKey.Marshal(b, m, deterministic)
}
func (m *IssuerKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssuerKey.Merge(m, src)
}
func (m *IssuerKey) XXX_Size() int {
	return xxx_messageInfo_IssuerKey.Size(m)
}
func (m *IssuerKey) XXX_DiscardUnknown() {
	xxx_messageInfo_IssuerKey.DiscardUnknown(m)
}

var xxx_messageInfo_IssuerKey proto.InternalMessageInfo

func (m *IssuerKey) GetIsk() []byte {
	if m != nil {
		return m.Isk
	}
	return nil
}

func (m *IssuerKey) GetIpk() *IssuerPublicKey {
	if m != nil {
		return m.Ipk
	}
	return nil
}

// Credential specifies a credential object that consists of
// a, b, e, s - signature value
// attrs - attribute values
type Credential struct {
	A                    *amcl.ECP `protobuf:"bytes,1,opt,name=a,proto3" json:"a,omitempty"`
	B                    *amcl.ECP `protobuf:"bytes,2,opt,name=b,proto3" json:"b,omitempty"`
	E                    []byte    `protobuf:"bytes,3,opt,name=e,proto3" json:"e,omitempty"`
	S                    []byte    `protobuf:"bytes,4,opt,name=s,proto3" json:"s,omitempty"`
	Attrs                [][]byte  `protobuf:"bytes,5,rep,name=attrs,proto3" json:"attrs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Credential) Reset()         { *m = Credential{} }
func (m *Credential) String() string { return proto.CompactTextString(m) }
func (*Credential) ProtoMessage()    {}
func (*Credential) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{2}
}

func (m *Credential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Credential.Unmarshal(m, b)
}
func (m *Credential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Credential.Marshal(b, m, deterministic)
}
func (m *Credential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Credential.Merge(m, src)
}
func (m *Credential) XXX_Size() int {
	return xxx_messageInfo_Credential.Size(m)
}
func (m *Credential) XXX_DiscardUnknown() {
	xxx_messageInfo_Credential.DiscardUnknown(m)
}

var xxx_messageInfo_Credential proto.InternalMessageInfo

func (m *Credential) GetA() *amcl.ECP {
	if m != nil {
		return m.A
	}
	return nil
}

func (m *Credential) GetB() *amcl.ECP {
	if m != nil {
		return m.B
	}
	return nil
}

func (m *Credential) GetE() []byte {
	if m != nil {
		return m.E
	}
	return nil
}

func (m *Credential) GetS() []byte {
	if m != nil {
		return m.S
	}
	return nil
}

func (m *Credential) GetAttrs() [][]byte {
	if m != nil {
		return m.Attrs
	}
	return nil
}

// CredRequest specifies a credential request object that consists of
// nym - a pseudonym, which is a commitment to the user secret
// issuer_nonce - a random nonce provided by the issuer
// proof_c, proof_s - a zero-knowledge proof of knowledge of the
// user secret inside Nym
type CredRequest struct {
	Nym                  *amcl.ECP `protobuf:"bytes,1,opt,name=nym,proto3" json:"nym,omitempty"`
	IssuerNonce          []byte    `protobuf:"bytes,2,opt,name=issuer_nonce,json=issuerNonce,proto3" json:"issuer_nonce,omitempty"`
	ProofC               []byte    `protobuf:"bytes,3,opt,name=proof_c,json=proofC,proto3" json:"proof_c,omitempty"`
	ProofS               []byte    `protobuf:"bytes,4,opt,name=proof_s,json=proofS,proto3" json:"proof_s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CredRequest) Reset()         { *m = CredRequest{} }
func (m *CredRequest) String() string { return proto.CompactTextString(m) }
func (*CredRequest) ProtoMessage()    {}
func (*CredRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{3}
}

func (m *CredRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CredRequest.Unmarshal(m, b)
}
func (m *CredRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CredRequest.Marshal(b, m, deterministic)
}
func (m *CredRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CredRequest.Merge(m, src)
}
func (m *CredRequest) XXX_Size() int {
	return xxx_messageInfo_CredRequest.Size(m)
}
func (m *CredRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CredRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CredRequest proto.InternalMessageInfo

func (m *CredRequest) GetNym() *amcl.ECP {
	if m != nil {
		return m.Nym
	}
	return nil
}

func (m *CredRequest) GetIssuerNonce() []byte {
	if m != nil {
		return m.IssuerNonce
	}
	return nil
}

func (m *CredRequest) GetProofC() []byte {
	if m != nil {
		return m.ProofC
	}
	return nil
}

func (m *CredRequest) GetProofS() []byte {
	if m != nil {
		return m.ProofS
	}
	return nil
}

// EIDNym specifies a pseudonymous enrollment id object that consists of
// nym - pseudonymous enrollment id
// s_eid - field element
type EIDNym struct {
	Nym                  *amcl.ECP `protobuf:"bytes,1,opt,name=nym,proto3" json:"nym,omitempty"`
	ProofSEid            []byte    `protobuf:"bytes,2,opt,name=proof_s_eid,json=proofSEid,proto3" json:"proof_s_eid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *EIDNym) Reset()         { *m = EIDNym{} }
func (m *EIDNym) String() string { return proto.CompactTextString(m) }
func (*EIDNym) ProtoMessage()    {}
func (*EIDNym) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{4}
}

func (m *EIDNym) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EIDNym.Unmarshal(m, b)
}
func (m *EIDNym) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EIDNym.Marshal(b, m, deterministic)
}
func (m *EIDNym) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EIDNym.Merge(m, src)
}
func (m *EIDNym) XXX_Size() int {
	return xxx_messageInfo_EIDNym.Size(m)
}
func (m *EIDNym) XXX_DiscardUnknown() {
	xxx_messageInfo_EIDNym.DiscardUnknown(m)
}

var xxx_messageInfo_EIDNym proto.InternalMessageInfo

func (m *EIDNym) GetNym() *amcl.ECP {
	if m != nil {
		return m.Nym
	}
	return nil
}

func (m *EIDNym) GetProofSEid() []byte {
	if m != nil {
		return m.ProofSEid
	}
	return nil
}

// RHNym specifies a pseudonymous revocation handle object that consists of
// nym - pseudonymous revocation handle
// s_rh - field element
type RHNym struct {
	Nym                  *amcl.ECP `protobuf:"bytes,1,opt,name=nym,proto3" json:"nym,omitempty"`
	ProofSRh             []byte    `protobuf:"bytes,2,opt,name=proof_s_rh,json=proofSRh,proto3" json:"proof_s_rh,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RHNym) Reset()         { *m = RHNym{} }
func (m *RHNym) String() string { return proto.CompactTextString(m) }
func (*RHNym) ProtoMessage()    {}
func (*RHNym) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{5}
}

func (m *RHNym) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RHNym.Unmarshal(m, b)
}
func (m *RHNym) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RHNym.Marshal(b, m, deterministic)
}
func (m *RHNym) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RHNym.Merge(m, src)
}
func (m *RHNym) XXX_Size() int {
	return xxx_messageInfo_RHNym.Size(m)
}
func (m *RHNym) XXX_DiscardUnknown() {
	xxx_messageInfo_RHNym.DiscardUnknown(m)
}

var xxx_messageInfo_RHNym proto.InternalMessageInfo

func (m *RHNym) GetNym() *amcl.ECP {
	if m != nil {
		return m.Nym
	}
	return nil
}

func (m *RHNym) GetProofSRh() []byte {
	if m != nil {
		return m.ProofSRh
	}
	return nil
}

// Signature specifies a signature object that consists of
// a_prime, a_bar, b_prime, proof_* - randomized credential signature values
// and a zero-knowledge proof of knowledge of a credential
// and the corresponding user secret together with the attribute values
// nonce - a fresh nonce used for the signature
// nym - a fresh pseudonym (a commitment to to the user secret)
type Signature struct {
	APrime               *amcl.ECP           `protobuf:"bytes,1,opt,name=a_prime,json=aPrime,proto3" json:"a_prime,omitempty"`
	ABar                 *amcl.ECP           `protobuf:"bytes,2,opt,name=a_bar,json=aBar,proto3" json:"a_bar,omitempty"`
	BPrime               *amcl.ECP           `protobuf:"bytes,3,opt,name=b_prime,json=bPrime,proto3" json:"b_prime,omitempty"`
	ProofC               []byte              `protobuf:"bytes,4,opt,name=proof_c,json=proofC,proto3" json:"proof_c,omitempty"`
	ProofSSk             []byte              `protobuf:"bytes,5,opt,name=proof_s_sk,json=proofSSk,proto3" json:"proof_s_sk,omitempty"`
	ProofSE              []byte              `protobuf:"bytes,6,opt,name=proof_s_e,json=proofSE,proto3" json:"proof_s_e,omitempty"`
	ProofSR2             []byte              `protobuf:"bytes,7,opt,name=proof_s_r2,json=proofSR2,proto3" json:"proof_s_r2,omitempty"`
	ProofSR3             []byte              `protobuf:"bytes,8,opt,name=proof_s_r3,json=proofSR3,proto3" json:"proof_s_r3,omitempty"`
	ProofSSPrime         []byte              `protobuf:"bytes,9,opt,name=proof_s_s_prime,json=proofSSPrime,proto3" json:"proof_s_s_prime,omitempty"`
	ProofSAttrs          [][]byte            `protobuf:"bytes,10,rep,name=proof_s_attrs,json=proofSAttrs,proto3" json:"proof_s_attrs,omitempty"`
	Nonce                []byte              `protobuf:"bytes,11,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Nym                  *amcl.ECP           `protobuf:"bytes,12,opt,name=nym,proto3" json:"nym,omitempty"`
	ProofSRNym           []byte              `protobuf:"bytes,13,opt,name=proof_s_r_nym,json=proofSRNym,proto3" json:"proof_s_r_nym,omitempty"`
	RevocationEpochPk    *amcl.ECP2          `protobuf:"bytes,14,opt,name=revocation_epoch_pk,json=revocationEpochPk,proto3" json:"revocation_epoch_pk,omitempty"`
	RevocationPkSig      []byte              `protobuf:"bytes,15,opt,name=revocation_pk_sig,json=revocationPkSig,proto3" json:"revocation_pk_sig,omitempty"`
	Epoch                int64               `protobuf:"varint,16,opt,name=epoch,proto3" json:"epoch,omitempty"`
	NonRevocationProof   *NonRevocationProof `protobuf:"bytes,17,opt,name=non_revocation_proof,json=nonRevocationProof,proto3" json:"non_revocation_proof,omitempty"`
	EidNym               *EIDNym             `protobuf:"bytes,18,opt,name=eid_nym,json=eidNym,proto3" json:"eid_nym,omitempty"`
	RhNym                *RHNym              `protobuf:"bytes,19,opt,name=rh_nym,json=rhNym,proto3" json:"rh_nym,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Signature) Reset()         { *m = Signature{} }
func (m *Signature) String() string { return proto.CompactTextString(m) }
func (*Signature) ProtoMessage()    {}
func (*Signature) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{6}
}

func (m *Signature) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signature.Unmarshal(m, b)
}
func (m *Signature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signature.Marshal(b, m, deterministic)
}
func (m *Signature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signature.Merge(m, src)
}
func (m *Signature) XXX_Size() int {
	return xxx_messageInfo_Signature.Size(m)
}
func (m *Signature) XXX_DiscardUnknown() {
	xxx_messageInfo_Signature.DiscardUnknown(m)
}

var xxx_messageInfo_Signature proto.InternalMessageInfo

func (m *Signature) GetAPrime() *amcl.ECP {
	if m != nil {
		return m.APrime
	}
	return nil
}

func (m *Signature) GetABar() *amcl.ECP {
	if m != nil {
		return m.ABar
	}
	return nil
}

func (m *Signature) GetBPrime() *amcl.ECP {
	if m != nil {
		return m.BPrime
	}
	return nil
}

func (m *Signature) GetProofC() []byte {
	if m != nil {
		return m.ProofC
	}
	return nil
}

func (m *Signature) GetProofSSk() []byte {
	if m != nil {
		return m.ProofSSk
	}
	return nil
}

func (m *Signature) GetProofSE() []byte {
	if m != nil {
		return m.ProofSE
	}
	return nil
}

func (m *Signature) GetProofSR2() []byte {
	if m != nil {
		return m.ProofSR2
	}
	return nil
}

func (m *Signature) GetProofSR3() []byte {
	if m != nil {
		return m.ProofSR3
	}
	return nil
}

func (m *Signature) GetProofSSPrime() []byte {
	if m != nil {
		return m.ProofSSPrime
	}
	return nil
}

func (m *Signature) GetProofSAttrs() [][]byte {
	if m != nil {
		return m.ProofSAttrs
	}
	return nil
}

func (m *Signature) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

func (m *Signature) GetNym() *amcl.ECP {
	if m != nil {
		return m.Nym
	}
	return nil
}

func (m *Signature) GetProofSRNym() []byte {
	if m != nil {
		return m.ProofSRNym
	}
	return nil
}

func (m *Signature) GetRevocationEpochPk() *amcl.ECP2 {
	if m != nil {
		return m.RevocationEpochPk
	}
	return nil
}

func (m *Signature) GetRevocationPkSig() []byte {
	if m != nil {
		return m.RevocationPkSig
	}
	return nil
}

func (m *Signature) GetEpoch() int64 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

func (m *Signature) GetNonRevocationProof() *NonRevocationProof {
	if m != nil {
		return m.NonRevocationProof
	}
	return nil
}

func (m *Signature) GetEidNym() *EIDNym {
	if m != nil {
		return m.EidNym
	}
	return nil
}

func (m *Signature) GetRhNym() *RHNym {
	if m != nil {
		return m.RhNym
	}
	return nil
}

// NonRevocationProof contains proof that the credential is not revoked
type NonRevocationProof struct {
	RevocationAlg        int32    `protobuf:"varint,1,opt,name=revocation_alg,json=revocationAlg,proto3" json:"revocation_alg,omitempty"`
	NonRevocationProof   []byte   `protobuf:"bytes,2,opt,name=non_revocation_proof,json=nonRevocationProof,proto3" json:"non_revocation_proof,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NonRevocationProof) Reset()         { *m = NonRevocationProof{} }
func (m *NonRevocationProof) String() string { return proto.CompactTextString(m) }
func (*NonRevocationProof) ProtoMessage()    {}
func (*NonRevocationProof) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{7}
}

func (m *NonRevocationProof) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NonRevocationProof.Unmarshal(m, b)
}
func (m *NonRevocationProof) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NonRevocationProof.Marshal(b, m, deterministic)
}
func (m *NonRevocationProof) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NonRevocationProof.Merge(m, src)
}
func (m *NonRevocationProof) XXX_Size() int {
	return xxx_messageInfo_NonRevocationProof.Size(m)
}
func (m *NonRevocationProof) XXX_DiscardUnknown() {
	xxx_messageInfo_NonRevocationProof.DiscardUnknown(m)
}

var xxx_messageInfo_NonRevocationProof proto.InternalMessageInfo

func (m *NonRevocationProof) GetRevocationAlg() int32 {
	if m != nil {
		return m.RevocationAlg
	}
	return 0
}

func (m *NonRevocationProof) GetNonRevocationProof() []byte {
	if m != nil {
		return m.NonRevocationProof
	}
	return nil
}

// NymSignature specifies a signature object that signs a message
// with respect to a pseudonym. It differs from the standard idemix.signature in the fact that
// the  standard signature object also proves that the pseudonym is based on a secret certified by
// a CA (issuer), whereas NymSignature only proves that the the owner of the pseudonym
// signed the message
type NymSignature struct {
	// proof_c is the Fiat-Shamir challenge of the ZKP
	ProofC []byte `protobuf:"bytes,1,opt,name=proof_c,json=proofC,proto3" json:"proof_c,omitempty"`
	// proof_s_sk is the s-value proving knowledge of the user secret key
	ProofSSk []byte `protobuf:"bytes,2,opt,name=proof_s_sk,json=proofSSk,proto3" json:"proof_s_sk,omitempty"`
	// proof_s_r_nym is the s-value proving knowledge of the pseudonym secret
	ProofSRNym []byte `protobuf:"bytes,3,opt,name=proof_s_r_nym,json=proofSRNym,proto3" json:"proof_s_r_nym,omitempty"`
	// nonce is a fresh nonce used for the signature
	Nonce                []byte   `protobuf:"bytes,4,opt,name=nonce,proto3" json:"nonce,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NymSignature) Reset()         { *m = NymSignature{} }
func (m *NymSignature) String() string { return proto.CompactTextString(m) }
func (*NymSignature) ProtoMessage()    {}
func (*NymSignature) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{8}
}

func (m *NymSignature) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NymSignature.Unmarshal(m, b)
}
func (m *NymSignature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NymSignature.Marshal(b, m, deterministic)
}
func (m *NymSignature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NymSignature.Merge(m, src)
}
func (m *NymSignature) XXX_Size() int {
	return xxx_messageInfo_NymSignature.Size(m)
}
func (m *NymSignature) XXX_DiscardUnknown() {
	xxx_messageInfo_NymSignature.DiscardUnknown(m)
}

var xxx_messageInfo_NymSignature proto.InternalMessageInfo

func (m *NymSignature) GetProofC() []byte {
	if m != nil {
		return m.ProofC
	}
	return nil
}

func (m *NymSignature) GetProofSSk() []byte {
	if m != nil {
		return m.ProofSSk
	}
	return nil
}

func (m *NymSignature) GetProofSRNym() []byte {
	if m != nil {
		return m.ProofSRNym
	}
	return nil
}

func (m *NymSignature) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

type CredentialRevocationInformation struct {
	// epoch contains the epoch (time window) in which this CRI is valid
	Epoch int64 `protobuf:"varint,1,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// epoch_pk is the public key that is used by the revocation authority in this epoch
	EpochPk *amcl.ECP2 `protobuf:"bytes,2,opt,name=epoch_pk,json=epochPk,proto3" json:"epoch_pk,omitempty"`
	// epoch_pk_sig is a signature on the EpochPK valid under the revocation authority's long term key
	EpochPkSig []byte `protobuf:"bytes,3,opt,name=epoch_pk_sig,json=epochPkSig,proto3" json:"epoch_pk_sig,omitempty"`
	// revocation_alg denotes which revocation algorithm is used
	RevocationAlg int32 `protobuf:"varint,4,opt,name=revocation_alg,json=revocationAlg,proto3" json:"revocation_alg,omitempty"`
	// revocation_data contains data specific to the revocation algorithm used
	RevocationData       []byte   `protobuf:"bytes,5,opt,name=revocation_data,json=revocationData,proto3" json:"revocation_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CredentialRevocationInformation) Reset()         { *m = CredentialRevocationInformation{} }
func (m *CredentialRevocationInformation) String() string { return proto.CompactTextString(m) }
func (*CredentialRevocationInformation) ProtoMessage()    {}
func (*CredentialRevocationInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f94c3d451691341, []int{9}
}

func (m *CredentialRevocationInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CredentialRevocationInformation.Unmarshal(m, b)
}
func (m *CredentialRevocationInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CredentialRevocationInformation.Marshal(b, m, deterministic)
}
func (m *CredentialRevocationInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CredentialRevocationInformation.Merge(m, src)
}
func (m *CredentialRevocationInformation) XXX_Size() int {
	return xxx_messageInfo_CredentialRevocationInformation.Size(m)
}
func (m *CredentialRevocationInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_CredentialRevocationInformation.DiscardUnknown(m)
}

var xxx_messageInfo_CredentialRevocationInformation proto.InternalMessageInfo

func (m *CredentialRevocationInformation) GetEpoch() int64 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

func (m *CredentialRevocationInformation) GetEpochPk() *amcl.ECP2 {
	if m != nil {
		return m.EpochPk
	}
	return nil
}

func (m *CredentialRevocationInformation) GetEpochPkSig() []byte {
	if m != nil {
		return m.EpochPkSig
	}
	return nil
}

func (m *CredentialRevocationInformation) GetRevocationAlg() int32 {
	if m != nil {
		return m.RevocationAlg
	}
	return 0
}

func (m *CredentialRevocationInformation) GetRevocationData() []byte {
	if m != nil {
		return m.RevocationData
	}
	return nil
}

func init() {
	proto.RegisterType((*IssuerPublicKey)(nil), "idemix.IssuerPublicKey")
	proto.RegisterType((*IssuerKey)(nil), "idemix.IssuerKey")
	proto.RegisterType((*Credential)(nil), "idemix.Credential")
	proto.RegisterType((*CredRequest)(nil), "idemix.CredRequest")
	proto.RegisterType((*EIDNym)(nil), "idemix.EIDNym")
	proto.RegisterType((*RHNym)(nil), "idemix.RHNym")
	proto.RegisterType((*Signature)(nil), "idemix.Signature")
	proto.RegisterType((*NonRevocationProof)(nil), "idemix.NonRevocationProof")
	proto.RegisterType((*NymSignature)(nil), "idemix.NymSignature")
	proto.RegisterType((*CredentialRevocationInformation)(nil), "idemix.CredentialRevocationInformation")
}

func init() {
	proto.RegisterFile("bccsp/schemes/dlog/crypto/idemix.proto", fileDescriptor_7f94c3d451691341)
}

var fileDescriptor_7f94c3d451691341 = []byte{
	// 949 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x56, 0xcd, 0x8e, 0xe3, 0x44,
	0x10, 0x96, 0xe3, 0xd8, 0x99, 0x54, 0x3c, 0x33, 0xbb, 0xbd, 0x23, 0x8d, 0x35, 0xac, 0x96, 0x60,
	0x31, 0x4c, 0xe0, 0x30, 0x61, 0x33, 0x9c, 0xb8, 0x6d, 0x66, 0xa3, 0xdd, 0x08, 0x36, 0x8a, 0x3a,
	0x97, 0x15, 0x42, 0xb2, 0xda, 0x76, 0x6f, 0xdc, 0x4a, 0xfc, 0x43, 0xdb, 0x61, 0xc9, 0x05, 0x24,
	0x1e, 0x85, 0x23, 0x0f, 0xc1, 0x81, 0x23, 0x27, 0x9e, 0x81, 0x23, 0x4f, 0x81, 0xba, 0xdb, 0x7f,
	0x19, 0xcf, 0x2c, 0x97, 0xa4, 0xbb, 0xaa, 0xfa, 0xab, 0xea, 0xaf, 0xbe, 0xb2, 0x0d, 0x9f, 0x79,
	0xbe, 0x9f, 0xa5, 0xe3, 0xcc, 0x0f, 0x69, 0x44, 0xb3, 0x71, 0xb0, 0x4d, 0xd6, 0x63, 0x9f, 0xef,
	0xd3, 0x3c, 0x19, 0xb3, 0x80, 0x46, 0xec, 0xa7, 0xeb, 0x94, 0x27, 0x79, 0x82, 0x4c, 0xb5, 0xbb,
	0xf8, 0xea, 0xe1, 0xf8, 0x9c, 0x93, 0x38, 0xdb, 0x92, 0x3c, 0xe1, 0x63, 0x12, 0xf9, 0x5b, 0xf9,
	0xa3, 0x4e, 0x3b, 0x7f, 0x76, 0xe0, 0x74, 0x9e, 0x65, 0x3b, 0xca, 0x97, 0x3b, 0x6f, 0xcb, 0xfc,
	0x6f, 0xe8, 0x1e, 0x5d, 0xc1, 0x29, 0xc9, 0x73, 0xce, 0xbc, 0x5d, 0x4e, 0xdd, 0x98, 0x44, 0x34,
	0xb3, 0xb5, 0xa1, 0x3e, 0xea, 0xe3, 0x93, 0xca, 0xbc, 0x10, 0x56, 0xf4, 0x14, 0xba, 0xa1, 0x9b,
	0x6d, 0xec, 0xce, 0x50, 0x1b, 0x0d, 0x26, 0xfd, 0x6b, 0x89, 0x3b, 0xbb, 0x5d, 0x62, 0x3d, 0x5c,
	0x6d, 0xd0, 0x10, 0xcc, 0xd0, 0xe5, 0x24, 0x0e, 0x6c, 0xfd, 0xae, 0xdf, 0x08, 0x31, 0x89, 0x03,
	0xe4, 0x40, 0x2f, 0x74, 0x05, 0x66, 0x66, 0x77, 0x87, 0xfa, 0x61, 0x88, 0x19, 0xbe, 0x10, 0x0e,
	0x64, 0x83, 0xf6, 0xde, 0x36, 0x24, 0x00, 0x54, 0xde, 0x09, 0xd6, 0xde, 0x0b, 0x7c, 0x8f, 0x70,
	0x77, 0xfd, 0xdc, 0x36, 0x5b, 0xf8, 0x1e, 0xe1, 0xaf, 0x9e, 0x57, 0x11, 0x13, 0xbb, 0x77, 0x6f,
	0xc4, 0x04, 0x9d, 0x43, 0x2f, 0xe5, 0x49, 0xf2, 0xce, 0xf5, 0xed, 0xa3, 0xa1, 0x36, 0xb2, 0xb0,
	0x29, 0xb7, 0xb7, 0xb5, 0x23, 0xb3, 0xfb, 0x0d, 0xc7, 0x0a, 0x21, 0xe8, 0x86, 0x24, 0x0b, 0x6d,
	0x90, 0x56, 0xb9, 0x76, 0x5e, 0x43, 0x5f, 0x71, 0x28, 0xd8, 0x7b, 0x04, 0x3a, 0xcb, 0x36, 0xb6,
	0x26, 0xfd, 0x62, 0x89, 0x3e, 0x07, 0x9d, 0xa5, 0x25, 0x4b, 0xe7, 0xd7, 0x45, 0xf7, 0xee, 0xb0,
	0x8e, 0x45, 0x8c, 0x93, 0x02, 0xdc, 0x72, 0x1a, 0xd0, 0x38, 0x67, 0x64, 0x8b, 0xce, 0x41, 0x23,
	0x12, 0xe8, 0xa0, 0x74, 0x8d, 0x08, 0x87, 0xd7, 0x66, 0x5d, 0xf3, 0x90, 0x05, 0x1a, 0x95, 0x74,
	0x5b, 0x58, 0xa3, 0x62, 0x27, 0x98, 0x95, 0xbb, 0x0c, 0x9d, 0x81, 0xa1, 0xb8, 0x36, 0x86, 0xfa,
	0xc8, 0xc2, 0x6a, 0xe3, 0xfc, 0x02, 0x03, 0x91, 0x11, 0xd3, 0x1f, 0x76, 0x34, 0xcb, 0xd1, 0x47,
	0xa0, 0xc7, 0xfb, 0xa8, 0x9d, 0x54, 0x58, 0xd1, 0x27, 0x60, 0x31, 0x59, 0xb5, 0x1b, 0x27, 0xb1,
	0x4f, 0x65, 0x05, 0x16, 0x1e, 0x28, 0xdb, 0x42, 0x98, 0x9a, 0x84, 0xea, 0x0f, 0x11, 0xda, 0x6d,
	0x12, 0xea, 0xcc, 0xc0, 0x9c, 0xcd, 0x5f, 0x2e, 0xf6, 0xd1, 0x87, 0x73, 0x3f, 0x83, 0x41, 0x71,
	0xde, 0xa5, 0x2c, 0x28, 0x52, 0xf7, 0x15, 0xc6, 0x8c, 0x05, 0xce, 0x14, 0x0c, 0xfc, 0xfa, 0x7f,
	0x51, 0x9e, 0x02, 0x94, 0x28, 0x3c, 0x2c, 0x40, 0x8e, 0x14, 0x08, 0x0e, 0x9d, 0x3f, 0x0c, 0xe8,
	0xaf, 0xd8, 0x3a, 0x26, 0xf9, 0x8e, 0x53, 0xa1, 0x4e, 0xe2, 0xa6, 0x9c, 0x45, 0xb4, 0x0d, 0x66,
	0x92, 0xa5, 0x70, 0xa0, 0x67, 0x60, 0x10, 0xd7, 0x23, 0xbc, 0xdd, 0x8c, 0x2e, 0x99, 0x12, 0x2e,
	0x30, 0xbc, 0x02, 0xa3, 0x35, 0x04, 0xa6, 0xa7, 0x30, 0x1a, 0x94, 0x75, 0x0f, 0x28, 0x6b, 0x14,
	0x9b, 0x6d, 0xe4, 0x0c, 0x54, 0xc5, 0xae, 0x36, 0xe8, 0x02, 0xfa, 0x15, 0x21, 0x72, 0x02, 0x2c,
	0xdc, 0x2b, 0xe8, 0x38, 0xb8, 0xa6, 0x12, 0x7f, 0x7d, 0xcd, 0xc9, 0x81, 0xf7, 0xa6, 0xd0, 0x7d,
	0xe9, 0xbd, 0x41, 0x97, 0x70, 0x5a, 0x65, 0x2d, 0x4a, 0x57, 0x13, 0x60, 0x15, 0xa9, 0x55, 0xd5,
	0x0e, 0x1c, 0x97, 0x61, 0x4a, 0x55, 0x20, 0x55, 0xa5, 0x9a, 0xb4, 0x52, 0xb3, 0x7b, 0x06, 0x86,
	0x12, 0xca, 0x40, 0x02, 0xa8, 0x4d, 0xd9, 0x20, 0xeb, 0x01, 0x89, 0x55, 0xb0, 0xdc, 0x15, 0x61,
	0xc7, 0xf2, 0x28, 0x14, 0xe5, 0x89, 0x06, 0x7f, 0x0d, 0x4f, 0x38, 0xfd, 0x31, 0xf1, 0x49, 0xce,
	0x92, 0xd8, 0xa5, 0x69, 0xe2, 0x87, 0x6e, 0xba, 0xb1, 0x4f, 0x5a, 0xcf, 0x88, 0xc7, 0x75, 0xd8,
	0x4c, 0x44, 0x2d, 0x37, 0xe8, 0x0b, 0x68, 0x18, 0xdd, 0x74, 0xe3, 0x66, 0x6c, 0x6d, 0x9f, 0xca,
	0x14, 0xa7, 0xb5, 0x63, 0xb9, 0x59, 0xb1, 0xb5, 0xa8, 0x5e, 0x82, 0xdb, 0x8f, 0x86, 0xda, 0x48,
	0xc7, 0x6a, 0x83, 0xbe, 0x85, 0xb3, 0x38, 0x89, 0xdd, 0x26, 0x8a, 0x28, 0xcd, 0x7e, 0x2c, 0xd3,
	0x5f, 0x94, 0xd3, 0xbd, 0x48, 0x62, 0x5c, 0xe3, 0x89, 0x08, 0x8c, 0xe2, 0x96, 0x0d, 0x5d, 0x41,
	0x8f, 0xb2, 0x40, 0x5e, 0x14, 0x49, 0x80, 0x93, 0x12, 0x40, 0xcd, 0x04, 0x36, 0x29, 0x0b, 0xc4,
	0xa5, 0x3f, 0x05, 0x93, 0x87, 0x32, 0xee, 0x89, 0x8c, 0x3b, 0x2e, 0xe3, 0xa4, 0xe8, 0xb1, 0xc1,
	0xc3, 0xc5, 0x3e, 0x72, 0x22, 0x40, 0xed, 0xc4, 0xe8, 0x12, 0x4e, 0x1a, 0xe5, 0x92, 0xed, 0x5a,
	0xea, 0xd9, 0xc0, 0xc7, 0xb5, 0xf5, 0xc5, 0x76, 0x8d, 0xbe, 0x7c, 0xe0, 0x66, 0x6a, 0x4a, 0xee,
	0xa9, 0xde, 0xf9, 0x19, 0xac, 0xc5, 0x3e, 0xaa, 0x27, 0xa6, 0xa1, 0x64, 0xed, 0x03, 0x4a, 0xee,
	0xdc, 0x51, 0x72, 0xab, 0xe7, 0x7a, 0xab, 0xe7, 0x95, 0x92, 0xba, 0x0d, 0x25, 0x39, 0x7f, 0x6b,
	0xf0, 0x71, 0xfd, 0xb8, 0xac, 0xab, 0x9b, 0xc7, 0xef, 0x12, 0x1e, 0xc9, 0x65, 0xdd, 0x45, 0xad,
	0xd9, 0xc5, 0x4b, 0x38, 0xaa, 0x84, 0xd3, 0x69, 0x09, 0xa7, 0x47, 0x0b, 0xb9, 0x0c, 0xc1, 0x2a,
	0xc3, 0xa4, 0x52, 0x8a, 0xc2, 0x0a, 0xb7, 0x10, 0x49, 0x9b, 0xdb, 0xee, 0x7d, 0xdc, 0x5e, 0x41,
	0x43, 0x5e, 0x6e, 0x40, 0x72, 0x52, 0xcc, 0x73, 0xe3, 0xf4, 0x4b, 0x92, 0x93, 0xe9, 0xaf, 0x1a,
	0x80, 0x9f, 0x44, 0x45, 0x77, 0xa7, 0x83, 0xb9, 0xfc, 0x5f, 0x8a, 0x77, 0xf5, 0x52, 0xfb, 0x6e,
	0xbc, 0x66, 0x79, 0xb8, 0xf3, 0xae, 0xfd, 0x24, 0x1a, 0xcf, 0xa7, 0x6f, 0x8a, 0x0f, 0x81, 0xf1,
	0x3d, 0x6f, 0x7e, 0xe5, 0xf9, 0xad, 0xa3, 0xcf, 0xdf, 0xbe, 0xfd, 0xbd, 0x63, 0x2a, 0x98, 0xbf,
	0xca, 0xc5, 0x3f, 0x1d, 0xa4, 0x16, 0xdf, 0xbf, 0x5a, 0x4e, 0xdf, 0xd0, 0x9c, 0x88, 0x8a, 0xfe,
	0x2d, 0xbd, 0x9e, 0x29, 0xbf, 0x0d, 0x6e, 0xfe, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xe3, 0x36, 0xd7,
	0xe8, 0x83, 0x08, 0x00, 0x00,
}
