v3.0.0-rc1 Release Notes - September 17, 2024
=============================================

New features
------------

**Byzantine Fault Tolerant (BFT) ordering service**

Hyperledger Fabric has utilized a Raft crash fault tolerant (CFT) ordering service since version v1.4.1.
A Byzantine Fault Tolerant (BFT) ordering service can withstand not only crash failures, but also a subset of nodes behaving maliciously.
Fabric v3.0.0 provides a BFT ordering service based on the [SmartBFT](https://arxiv.org/abs/2107.06922) [consensus library](https://github.com/hyperledger-labs/SmartBFT).
Consider using the BFT orderer if true decentralization is required, where up to and not including a third of the parties running the orderers may not be trusted due to malicious intent or being compromised.
Channel capability `V3_0` must be enabled to utilize SmartBFT consensus.
For more details of the BFT ordering service and other recent features, see the [What's New documentation](https://hyperledger-fabric.readthedocs.io/en/latest/whatsnew.html).

**Query all approved chaincodes on a channel**

The updated `peer lifecycle chaincode queryapproved` command allows you to pass only a channel name.
The command will return all approved chaincodes on the channel.

**Support for Ed25519**

Ed25519 cryptographic algorithm is now supported in addition to ECDSA for MSP functions including transaction signing and verification.
Channel capability `V3_0` must be enabled to utilize certificates with Ed25519 keys.


Improvements and Fixes
----------------------

All improvements and fixes as of v2.5.9 have also been included in v3.0.0.


Dependencies
------------
Fabric v3.0.0 has been tested with the following dependencies:
* Go 1.23.1
* CouchDB v3.3.3

Fabric docker images on dockerhub utilize Ubuntu 22.04.


Changes
-------

**peer.gossip.pvtData.transientstoreMaxBlockRetention default value increased from 1000 to 20000**

`peer.gossip.pvtData.transientstoreMaxBlockRetention` specifies the number of blocks to keep uncommitted private data
in the transient store before it is purged. Increasing the value provides more tolerance for delayed commits
before the data is purged.

**TimeWindowCheck for proposal timestamps**

New `TimeWindowCheck` endorsement authFilter configured at `peer.handlers.authFilters.name` checks the timestamp of a proposal request against endorsing peer time,
using the time window configured at `peer.authentication.timewindow`.
This check helps to ensure that the proposal timestamp that eventually gets committed in a transaction is accurate relative to the endorsing peers.

**peer.deliveryclient.blockGossipEnabled default value changed to false** 

Block dissemination via gossip is deprecated and may be removed in a future release,
therefore `peer.deliveryclient.blockGossipEnabled` now defaults to false.
Fabric peers should be configured to receive blocks directly from an ordering service
node, and not gossip blocks, by using the following configuration:
```
peer.gossip.orgLeader: true
peer.gossip.useLeaderElection: false
peer.gossip.state.enabled: false
peer.deliveryclient.blockGossipEnabled: false
```

Removals
--------

**Support for ordering service system channel has been removed**

v2.3 introduced the ability to manage an ordering service without a system channel.
Managing an ordering service without a system channel has privacy, scalability, and operational benefits.
The system channel is removed in Fabric v3.0, as well as the concept of a 'consortium' of organizations that can create channels.
If you used the system channel in prior releases, you must remove the system channel and migrate to the channel participation API before upgrading to v3.x.
For information about removal of the system channel, see the [Create a channel without system channel documentation](https://hyperledger-fabric.readthedocs.io/en/release-2.5/create_channel/create_channel_participation.html).

**Support for 'Solo' consensus ordering service has been removed**

The 'Solo' consensus type was intended for test environments only in prior releases and has never been supported for production environments.
Support for 'Solo' consensus has been removed in Fabric v3.0.
For trial environments you can utilize a single node Raft ordering service as demonstrated in the [test network tutorial](https://hyperledger-fabric.readthedocs.io/en/latest/test_network.html).

**Support for 'Kafka' consensus ordering service has been removed**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred production Crash Fault Tolerant consensus type.
Support for 'Kafka' consensus has been removed in Fabric v3.0.
If you used Kafka consensus in prior releases, you must migrate to Raft consensus prior to upgrading to v3.x.
For details about the migration process, see the [Migrating from Kafka to Raft documentation](https://hyperledger-fabric.readthedocs.io/en/release-2.5/kafka_raft_migration.html).

**Legacy chaincode lifecycle has been removed**

The legacy chaincode lifecycle from Fabric v1.x is removed in v3.x.
Prior to upgrading peers to v3.x, you must update all channels to utilize the v2.x lifecycle
by setting the channel application capability to either V2_0 or V2_5,
and redeploying all chaincodes using the v2.x lifecycle. The new
chaincode lifecycle provides a more flexible and robust governance model
for chaincodes. For more details see the
[documentation for enabling the new lifecycle](https://hyperledger-fabric.readthedocs.io/en/release-2.5/enable_cc_lifecycle.html).

**Support for specifying orderer endpoints at the `OrdererAddresses` global level in channel configuration has been removed when using V3_0 channel capability**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of an organization instead.
Configuring orderer endpoints at the organization level accommodates
scenarios where orderers are run by different organizations. Using
this configuration ensures that only the TLS CA certificates of that organization
are used for orderer communications; in contrast to the global channel level endpoints which
would cause an aggregation of all orderer TLS CA certificates across
all orderer organizations to be used for orderer communications.
Remove the `OrdererAddresses` global configuration prior to enabling the `V3_0` channel capability.

**Support for configtxgen flag `--outputAnchorPeersUpdate` has been removed**

The former `--outputAnchorPeersUpdate` mechanism for updating anchor peers has always had
limitations (for instance, it only works the first time anchor peers are updated).
Instead, anchor peer updates should be performed through channel configuration updates.

**The fabric-tools docker image is no longer available**

The fabric-tools docker image is no longer published for Fabric releases.
Instead of using the fabric-tools docker image, users should utilize the
published Fabric binaries. The Fabric binaries can be used to make client calls
to Fabric runtime components, regardless of where the Fabric components are running.

Deprecated features
-------------------

**Block dissemination via gossip is deprecated and may be removed**

Block dissemination via gossip is deprecated and may be removed in a future release.
Fabric peers can be configured to receive blocks directly from an ordering service
node, and not gossip blocks, by using the following configuration:
```
peer.gossip.orgLeader: true
peer.gossip.useLeaderElection: false
peer.gossip.state.enabled: false
peer.deliveryclient.blockGossipEnabled: false
```
