# Quick reference

-	**Hyperledger Fabric project page**: https://www.hyperledger.org/projects/fabric

-	**Where to get Docker help**:  
	[the Docker Community Forums](https://forums.docker.com/),
	[the Docker Community Slack](http://dockr.ly/slack),
	or [Stack Overflow](https://stackoverflow.com/search?tab=newest&q=docker)

-	**Where to get Hyperledger Fabric help**:  
	[Fabric documentation](https://hyperledger-fabric.readthedocs.io/en/latest/),
	[Stackoverflow](https://stackoverflow.com/questions/tagged/hyperledger-fabric),
	or [Discord](https://discord.com/servers/hyperledger-foundation-905194001349627914)

-	**Where to get support**:
	The Fabric images are provided for development and test purposes. Various vendors provide
	supported offerings for production use.

-	**Architectures available**:
	amd64

-	**Tags available**:
	Architecture specific (e.g. `amd64-2.0.0`), release specific (e.g. `2.0.0`), and latest patch of minor release (e.g. `2.0`).

-	**Image Dockerfile**:  
	[Dockerfile location](https://github.com/hyperledger/fabric/blob/main/images/peer/Dockerfile)

-	**Source of this description**:  
	[Fabric github repository](https://github.com/hyperledger/fabric/blob/main/images/peer/README.md)

# What is a Hyperledger Fabric peer?

Hyperledger Fabric is an enterprise-grade permissioned distributed ledger framework for developing solutions and applications. Its modular and versatile design satisfies a broad range of industry use cases. It offers a unique approach to consensus that enables performance at scale while preserving privacy.

The Fabric peer is the main runtime node that manages and provides access to the ledger.
It receives blocks from an ordering service node and commits them to the ledger.

# How to use this image

## Start a fabric peer

You can run a Fabric peer container as follows:

```console
$ docker run -d --publish 7051:7051 \
-v /tmp/fabric/config/peer0.org1.example.com:/etc/hyperledger/fabric \
-v /tmp/fabric/crypto-config/peerOrganizations/org1.example.com/peers/peer0.org1.example.com/msp:/etc/hyperledger/fabric/msp \
-v /tmp/fabric/crypto-config/peerOrganizations/org1.example.com/peers/peer0.org1.example.com/tls:/etc/hyperledger/fabric/tls \
-v /tmp/fabric/data/peer0.org1.example.com:/var/hyperledger/production \
-v /var/run:/host/var/run \
--name peer0.org1.example.com hyperledger/fabric-peer:2.0 peer node start
```

In this example, a container will be started running the most recent 2.0.x patch for the
Hyperledger Fabric peer, using name peer0.org1.example.com, and exposing the peer's 7051 port
on the host as port 7051.

Read on for a quick primer on the configuration and data volumes. For full details, see
the [Hyperledger Fabric documentation](https://hyperledger-fabric.readthedocs.io/en/latest/).

## Configuring Fabric peer containers

Three sets of configuration information need to be provided to a Fabric peer:

- `core.yaml` configuration file
- Membership service provider (MSP) directory for peer's membership credentials
- tls directory for peer's tls credentials (if tls is configured)

Let's look at each of these configuration inputs...

### core.yaml configuration file

The peer image preconfigured environment variable `FABRIC_CFG_PATH` is used by the peer process to locate
the `core.yaml` configuration file at runtime. `FABRIC_CFG_PATH` is preset to the image directory `/etc/hyperledger/fabric`.
Inside this directory you'll find a default core.yaml configuration file with a SampleOrg organization (aka mspid) configured.

You can provide your own `core.yaml` configuration file on your host, and then mount this directory inside your peer container at `/etc/hyperledger/fabric`, thereby overriding the default peer configuration. For example, your core.yaml may
set `peer.localMspId` to your own organization's mspid.

The `docker run` command above demonstrates how to mount such a configuration directory from your host to the
peer container's `/etc/hyperledger/fabric` directory.

Alternatively, you can override individual `core.yaml` configuration properties by passing
environment variables to the peer container, for example `CORE_PEER_LOCALMSPID`.

### Membership service provider (MSP) directory for peer's membership credentials

Because Hyperledger Fabric is a permissioned blockchain, the peer needs credentials to join a channel
on a Fabric network. The credentials are a set of certificates and private keys that are issued
by a certificate authority that has permissions for a certain organization on a Fabric network.
These credentials can be generated by Fabric CA or the cryptogen utility (or by any CA for that matter),
and then provided to a peer in a msp configuration directory. The peer image comes with a set of SampleOrg
credentials in the msp directory. The msp directory location is set by `core.yaml` `peer.mspConfigPath`
property, and by default it points to the `msp` directory within the `FABRIC_CFG_PATH` directory, (`/etc/hyperledger/fabric/msp`).

As with the core.yaml directory, you can provide your own credentials msp directory on your host,
and then mount this directory inside your peer container at `/etc/hyperledger/fabric/msp`, thereby
overriding the default msp credentials.

The `docker run` command above demonstrates how to mount such a msp directory from your host.

### tls directory for peer's tls credentials

If your network components are configured for server-side tls, or mutual tls (server and client auth),
you will also need to provide the peer with tls credentials. The default core.yaml sets
`peer.tls.enabled` and `peer.tls.clientAuthRequired` to false. If setting to true, then you
will need to provide tls credentials in a `tls` directory.

As with the msp directory, you can provide your own credentials tls directory on your host,
and then mount this directory inside your peer container at `/etc/hyperledger/fabric/tls`, to
provide the peer with its tls credentials.

The `docker run` command above demonstrates how to mount such a tls directory from your host.

## Where to Store Data

There are several ways to store data used by applications that run in Docker containers.
We encourage users of the Fabric images to familiarize themselves with the available options,
especially the use of [volumes](https://docs.docker.com/storage/volumes/).

The peer container by default writes data, including the blockchain ledger, to its
`/var/hyperledger/production` directory, as configured by the `core.yaml` `peer.fileSystemPath` property.

The `docker run` command above demonstrates how to use a data directory on the host system and then
mount this to a directory visible from inside the container. This places the peer
data files in a known location on the host system. The user needs to make sure that the host
directory exists, and that the container has permissions to write to this directory.

## Docker daemon

Finally, the `docker run` command above mounts the host's `/var/run` directory, so that the container
can communicate with the Docker daemon via the socket defined in `/var/run/docker.sock`.

## Logging

The peer log is available through Docker's container logging, for example to view the log
for the peer container named peer0.org1.example.com:

```console
$ docker logs peer0.org1.example.com
```
Log levels are not configured in `core.yaml`. Instead, you can override the default INFO logging
by setting environment variable FABRIC_LOGGING_SPEC when starting the container. For example,
pass the FABRIC_LOGGING_SPEC environment variable within the `docker run` command as follows:

`-e FABRIC_LOGGING_SPEC='info:kvledger,chaincode.platform=debug'`

This would add ledger and chaincode build debug information to the peer log, which could be used
to troubleshoot ledger or chaincode build issues.

Alternatively, use the peer operations service to update the log level of a running peer. See the
[Log Level Management documentation](https://hyperledger-fabric.readthedocs.io/en/latest/operations_service.html#log-level-management)
for additional information.

# Creating your own Fabric image

You can use the Fabric Dockerfiles as an example of how to create your own Fabric images.
Alternatively, you could use the Fabric images as the basis for your own images, for example to provide
to your own `core.yaml` file within the image.

# License

Hyperledger Fabric is licensed under the [Apache License, version 2.0](https://github.com/hyperledger/fabric/blob/main/LICENSE).
