<!---
 File generated by help_docs.sh. DO NOT EDIT.
 Please make changes to preamble and postscript wrappers as appropriate.
 --->

# peer node

The `peer node` command allows an administrator to start a peer node,
pause and resume a channel, rebuild databases, reset all channels in a peer to the genesis block,
rollback a channel to a given block number, and upgrade the database format.

## Syntax

The `peer node` command has the following subcommands:

  * pause
  * rebuild-dbs
  * reset
  * resume
  * rollback
  * start
  * unjoin
  * upgrade-dbs

## peer node pause
```
Pauses a channel on the peer. When the command is executed, the peer must be offline. When the peer starts after pause, it will not receive blocks for the paused channel.

Usage:
  peer node pause [flags]

Flags:
  -c, --channelID string   Channel to pause.
  -h, --help               help for pause
```


## peer node rebuild-dbs
```
Drops the databases for all the channels and rebuilds them upon peer restart. When the command is executed, the peer must be offline. The command is not supported if the peer contains any channel that was bootstrapped from a snapshot.

Usage:
  peer node rebuild-dbs [flags]

Flags:
  -h, --help   help for rebuild-dbs
```


## peer node reset
```
Resets all channels to the genesis block. When the command is executed, the peer must be offline. When the peer starts after the reset, it will receive blocks starting with block number one from an orderer or another peer to rebuild the block store and state database. The command is not supported if the peer contains any channel that was bootstrapped from a snapshot.

Usage:
  peer node reset [flags]

Flags:
  -h, --help   help for reset
```


## peer node resume
```
Resumes a channel on the peer. When the command is executed, the peer must be offline. When the peer starts after resume, it will receive blocks for the resumed channel.

Usage:
  peer node resume [flags]

Flags:
  -c, --channelID string   Channel to resume.
  -h, --help               help for resume
```


## peer node rollback
```
Rolls back a channel to a specified block number. When the command is executed, the peer must be offline. When the peer starts after the rollback, it will receive blocks, which got removed during the rollback, from an orderer or another peer to rebuild the block store and state database. The command is not supported if the peer contains any channel that was bootstrapped from a snapshot.

Usage:
  peer node rollback [flags]

Flags:
  -b, --blockNumber uint   Block number to which the channel needs to be rolled back to.
  -c, --channelID string   Channel to rollback.
  -h, --help               help for rollback
```


## peer node start
```
Starts a node that interacts with the network.

Usage:
  peer node start [flags]

Flags:
  -h, --help                help for start
      --peer-chaincodedev   start peer in chaincode development mode
```


## peer node unjoin
```
Unjoin the peer from a channel.  When the command is executed, the peer must be offline.

Usage:
  peer node unjoin [flags]

Flags:
  -c, --channelID string   Channel to unjoin.
  -h, --help               help for unjoin
```


## peer node upgrade-dbs
```
Upgrades databases by directly updating the database format or dropping the databases. Dropped databases will be rebuilt with new format upon peer restart. When the command is executed, the peer must be offline.

Usage:
  peer node upgrade-dbs [flags]

Flags:
  -h, --help   help for upgrade-dbs
```

## Example Usage

### peer node pause example

The following command:

```
peer node pause -c ch1
```

pauses a channel on the peer. When the peer starts after pause, the paused channel will not be started
and the peer will not receive blocks for the paused channel.


### peer node rebuild-dbs example

The following command:

```
peer node rebuild-dbs
```

drops the databases for all the channels. When the peer is started after running this command, the peer will
retrieve the blocks stored on the peer and rebuild the dropped databases for all the channels.

### peer node reset example

The following command:

```
peer node reset
```

resets all channels in the peer to the genesis block, i.e., the first block in the channel. The command also records the pre-reset height of each channel in the file system. Note that the peer process should be stopped while executing this command. If the peer process is running, this command detects that and returns an error instead of performing the reset. When the peer is started after performing the reset, the peer will fetch the blocks for each channel which were removed by the reset command (either from other peers or orderers) and commit the blocks up to the pre-reset height. Until all channels reach the pre-reset height, the peer will not endorse any transactions.

### peer node resume example

The following command:

```
peer node resume -c ch1
```

resumes a channel on the peer. When the peer starts after resume, the resumed channel will be started
and the peer will receive blocks for the resumed channel.

### peer node rollback example

The following command:

```
peer node rollback -c ch1 -b 150
```

rolls back the channel ch1 to block number 150. The command also records the pre-rolled back height of channel ch1 in the file system. Note that the peer should be stopped while executing this command. If the peer process is running, this command detects that and returns an error instead of performing the rollback. When the peer is started after performing the rollback, the peer will fetch the blocks for channel ch1 which were removed by the rollback command (either from other peers or orderers) and commit the blocks up to the pre-rolled back height. Until the channel ch1 reaches the pre-rolled back height, the peer will not endorse any transaction for any channel.

### peer node start example

The following command:

```
peer node start --peer-chaincodedev
```

starts a peer node in chaincode development mode. Normally chaincode containers are started
and maintained by peer. However in chaincode development mode, chaincode is built and started by the user. This mode is useful during chaincode development phase for iterative development.

### peer node unjoin example 

The following command: 

```
peer node unjoin -c mychannel
```

unjoins the peer from channel `mychannel`, removing all content from the ledger and transient storage.  When unjoining a channel, the peer must be shut down.


### peer node upgrade-dbs example

The following command:

```
peer node upgrade-dbs
```

checks the data format in the databases for all the channels and drops databases if data format is in the previous version.
The command will return an error if the data format is already up to date. When the peer is started after running this command,
the peer will retrieve the blocks stored on the peer and rebuild the dropped databases in the new format.

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.
