# Connect with other writers

**Audience**: Writers who would like to contribute to the Fabric documentation.

This topic gives you general advice on how to contribute to one of the many
language translations provided by Fabric.

In this topic, we're going to cover:

* [How to get started](#getting-started)
* [Using Discord chat](#discord)
* [Documentation workgroup call](#documentation-workgroup-call)
* [Join a language translation workgroup](#join-a-language-translation-workgroup)
* [Other ways to connect](#other-ways-to-connect)

## Getting started

Before you make a documentation change, you might like to connect with other
people working on the Fabric documentation. Use any or all of the following
mechanisms to connect with others.

## Discord

Hyperledger Fabric uses [Discord](https://discord.com/invite/hyperledger) for
interactive discussions on a variety of project topics.
Reach out to us on the fabric-documentation channel to discuss documentation
topics including contributions, questions, feedback, and translation.

## Documentation workgroup call

A great place to meet people working on documentation is the monthly Documentation workgroup
call. The agenda is published in advance, and
there are minutes and recordings of each session. Find out more on the
[Documentation
wiki](https://wiki.hyperledger.org/display/fabric/Documentation+Working+Group).

## Join a language translation workgroup

Each of the international languages has a welcoming workgroup that you are
encouraged to join. View the [list of international
workgroups](https://wiki.hyperledger.org/display/I18N/International+groups).
See what your favorite workgroup is doing, and get connected with them.
Each workgroup has a list of members and their contact information.

## Other ways to connect

Hyperledger Fabric has many other collaboration mechanisms such as mailing
list and contributor meetings. Find out about these and
more [here](./CONTRIBUTING.html).

Good luck getting started and thanks for your contribution.

<!--- Licensed under Creative Commons Attribution 4.0 International License
https://creativecommons.org/licenses/by/4.0/ -->
