v1.4.8 Release Notes - July 22, 2020
====================================

Fixes
-----

**Ordering Service: Check suspect info once per suspect interval when using Raft**

The raft-based ordering service node was checking to see if it was evicted too often.
This fix ensures that the ordering service node only checks once per suspect interval,
every 10 minutes by default.


Dependency updates
------------------
Bump Go to 1.13.12.
Bump Fabric baseimage to 0.4.21.
Fabric v1.4.8 has been tested with CouchDB v2.3.1.


Changes, Known Issues, and Workarounds
--------------------------------------

**core.yaml chaincode.builder property updated to pull correct fabric-ccenv image**

The sample core.yaml configuration that gets included in fabric-peer docker
image now sets chaincode.builder property to ``$(DOCKER_NS)/fabric-ccenv:$(TWO_DIGIT_VERSION)``
instead of ``$(DOCKER_NS)/fabric-ccenv:latest``, since ``fabric-ccenv:latest`` tag
has been retired from dockerhub. This change ensures that v1.4.x peers using the default
configuration will pull the latest v1.4 fabric-ccenv image from dockerhub to build chaincode,
if the local fabric-ccenv image is not found.

**FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
Chaincode installed in different ways may result in "chaincode fingerprint
mismatch data mismatch" error upon instantiation. This may happen when
installing chaincode by using different SDKs. To workaround the problem,
package the chaincode prior to installation and instantiation, by using
the "peer chaincode package" command.


Known Vulnerabilities
---------------------

**FAB-8664: Peer should detect and react when its org has been removed**
This is a relatively low severity problem, because it requires a significant
conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations
------------
The following functions are deprecated and are targeted for removal in a future release.

**Support for automatically vendoring the chaincode shim into user chaincodes**

The fabric-ccenv image which is used to build chaincode, currently includes
the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
This is convenient, as it provides the ability to package chaincode
without the need to include the "shim". However, this may cause issues in future
releases (and/or when trying to use packages which are included by the "shim").
In order to avoid any issues, users are advised to manually vendor the "shim"
package with their chaincode prior to using the peer CLI for packaging and/or
for installing chaincode.
For more details see FAB-5177.

**Support for CAR chaincode package format**

Support for packaging chaincode using the CAR format will be removed in
a future release.
For more details see FAB-14720.

**Support for specifying orderer endpoints at the global level in channel configuration.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
an organization instead.
For more details see FAB-7559.

**Support for invoking system chaincodes from user chaincodes.**

System chaincodes, for example QSCC, are intended to be invoked by
a client rather than by a user chaincode. Invoking from a user chaincode
may cause deadlocks.
For more details see FAB-15285.

**Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
logging mechanism.
For more details see FAB-15366.

**Support for peer's Admin service**

The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
Instead of using these services, utilize the HTTP operations service that was
introduced in v1.4.0.
For more details see FAB-15390.

**The 'Solo' consensus type is deprecated.**

With the introduction of Raft-based ordering service in v1.4.1, it is possible
to deploy a single-node (non-production) or multi-node
Raft-based ordering service with no external dependencies.
For single-node (non-production) ordering services, utilize Raft-based ordering
service with a single node instead of Solo ordering service.
For more details see FAB-15754.

**The 'Kafka' consensus type is deprecated**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type. There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**fabric-couchdb docker image no longer updated, maintained, or published**

The fabric-couchdb docker image will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v148
