v1.4.6 Release Notes - February 25, 2020
========================================

Fixes
-----

- **FAB-17519: Improve Discovery endorsement policy performance**

  Fix peer CPU spikes during evaluation of endorsement policy
  combinations, due to expensive reflection.

- **Fix nil dereference in etcdraft config parsing**

  The etcdraft config parsing code was failing to check that the consensus
  metadata options are not nil.

- **FAB-17523: Endorsing peer was not honoring private data RequiredPeerCount**

  In Fabric v1.4.4 and v1.4.5, if there were not enough known eligible
  peers to meet the private data collection RequiredPeerCount dissemination
  requirement, endorsement was succeeding rather than returning an error.

  **FAB-17431: Decouple javaenv version from Fabric version**

  By default Fabric peer core.yaml was configured to use the following javaenv
  image for java chaincode:

  `runtime: $(DOCKER_NS)/fabric-javaenv:$(ARCH)-$(PROJECT_VERSION)`

  Since javaenv versioning may deviate from Fabric versioning,
  the javaenv reference is updated to use the latest two digit version:

  `runtime: $(DOCKER_NS)/fabric-javaenv:$(TWO_DIGIT_VERSION)`

  For example, Fabric v1.4.6 would utilize fabric-javaenv:1.4.


Changes, Known Issues, and Workarounds
--------------------------------------

- **FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
  Chaincode installed in different ways may result in "chaincode fingerprint
  mismatch data mismatch" error upon instantiation. This may happen when
  installing chaincode by using different SDKs. To workaround the problem,
  package the chaincode prior to installation and instantiation, by using
  the "peer chaincode package" command.


Known Vulnerabilities
---------------------

- **FAB-8664: Peer should detect and react when its org has been removed**
  This is a relatively low severity problem, because it requires a significant
  conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations
------------
The following functions are deprecated and are targeted for removal in a future release.

- **Support for automatically vendoring the chaincode shim into user chaincodes**

  The fabric-ccenv image which is used to build chaincode, currently includes
  the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
  This is convenient, as it provides the ability to package chaincode
  without the need to include the "shim". However, this may cause issues in future
  releases (and/or when trying to use packages which are included by the "shim").
  In order to avoid any issues, users are advised to manually vendor the "shim"
  package with their chaincode prior to using the peer CLI for packaging and/or
  for installing chaincode.
  For more details see FAB-5177.

- **Support for CAR chaincode package format**

  Support for packaging chaincode using the CAR format will be removed in
  a future release.
  For more details see FAB-14720.

- **Support for specifying orderer endpoints at the global level in channel configuration.**

  Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
  an organization instead.
  For more details see FAB-7559.

- **Support for invoking system chaincodes from user chaincodes.**

  System chaincodes, for example QSCC, are intended to be invoked by
  a client rather than by a user chaincode. Invoking from a user chaincode
  may cause deadlocks.
  For more details see FAB-15285.

- **Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

  Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
  logging mechanism.
  For more details see FAB-15366.

- **Support for peer's Admin service**

  The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
  Instead of using these services, utilize the HTTP operations service that was
  introduced in v1.4.0.
  For more details see FAB-15390.

- **Support for Solo ordering service**

  With the introduction of Raft-based ordering service in v1.4.1, it is possible
  to deploy a single-node (non-production) or multi-node
  Raft-based ordering service with no external dependencies.
  For single-node (non-production) ordering services, utilize Raft-based ordering
  service with a single node instead of Solo ordering service.
  For more details see FAB-15754.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v146
