v1.4.4 Release Notes - November 14, 2019
========================================

What's New in Hyperledger Fabric v1.4.4
---------------------------------------

The following enhancements are included in this release:

- **FAB-16715, FAB-16544: Orderer endpoint override**

  Ordering networks whose addresses or TLS root certificates change will cause problems for new
  peers joining channels because the channel genesis block will contain the outdated orderer
  information. A new configuration option for orderer endpoint overrides allows administrators
  to configure peers to translate old orderer addresses and certificates to the updated
  orderer addresses and certificate pools.

- **FAB-17000: Provide notification to users if certs are about to expire**

  Peers and orderers now log a warning to the log a week before the enrollment certificate or
  TLS certificate expire. Example log entries:

  `[certmonitor] trackCertExpiration -> WARN 011 The server TLS certificate expires within one week`

  `[certmonitor] trackCertExpiration -> WARN 011 The enrollment certificate expires within 2 days and 5 hours`

- **FAB-15814: Add operations endpoint to expose peer/orderer version**

  Adds a /version endpoint to the operations server that serves peer/orderer metadata
  including Version number and CommitSHA.

- **FAB-16852** Bump to Go v1.12.12 and baseimage 0.4.18

- **FABB-128** Bump node.js to 8.16.1 and npm to 6.11.3 in 0.4.18 baseimage

Fixes
-----

- **FAB-13552: Re-addition of a removed OSN in a channel** - Prior to the fix, if a Raft orderer was
  removed from the consenter set in the channel configuration, it would not check to see if was added
  back and a reboot was required.

- **FAB-15026: Segmentation violation in peer chaincode install** -  Prior to the fix, the tar processing
  during chaincode package install could trigger a panic while looking up user info when run with
  certain versions of libc. The calls to libc are no longer made.

- **FAB-15389: Endorsing peer is not honoring maxPeerCount for private data dissemination** - Prior
  to the fix, there was a chance that peers chosen for private data dissemination at endorsement time
  could potentially be counted twice towards maxPeerCount, leading to disseminating private data to
  fewer peers than expected.

- **FAB-15666: NetworkMode does not get passed to chaincode image build**
  Prior to the fix, the peer's configured docker NetworkMode was not getting passed
  upon chaincode image build.

- **FAB-16571: Fix panic in peer chaincode package command** - Prior to the fix, the peer
  chaincode package command could panic when traversing the chaincode location.

- **FAB-16610: Commit block to ledger hang when chaincode crash** - Prior to the fix, if a chaincode
  terminated abnormally during an invocation, a lock would prevent blocks from committing until the
  execution timeout (core.chaincode.executetimeout property) was triggered. The fix ensures that the
  lock is released immediately on exit.

- **FAB-16643: Nil pointer during reconciliation of deleted private data** - Prior to the fix,
  if a peer is trying to reconcile missing private data, and the private data key has since been
  deleted, the peer will panic with a nil pointer exception.

- **FAB-16651: Fix connection leak if certificates renewed** - Prior to the fix, peers that have changed
  their enrollment certificate without changing their endpoint caused connections to leak over time.

- **FAB-16695: Separate listeners causes panic** - Prior to the fix, configuring separate
  listeners for the peer admin service or for the orderer cluster service would cause a
  panic on startup if Prometheus metrics were enabled.

- **FAB-16948: Nil pointer exception in CID GetID() when using Idemix** - GetID now returns an error
  when invoked on a chaincode request from an Idemix identity.


Changes, Known Issues, and Workarounds
--------------------------------------

- **FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
  Chaincode installed in different ways may result in "chaincode fingerprint
  mismatch data mismatch" error upon instantiation. This may happen when
  installing chaincode by using different SDKs. To workaround the problem,
  package the chaincode prior to installation and instantiation, by using
  the "peer chaincode package" command.


Known Vulnerabilities
---------------------

- **FAB-8664: Peer should detect and react when its org has been removed**
  This is a relatively low severity problem, because it requires a significant
  conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations
------------
The following functions are deprecated and are targeted for removal in a future release.

- Support for automatically vendoring the chaincode shim into user chaincodes.
  The fabric-ccenv image which is used to build chaincode, currently includes
  the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
  This is convenient, as it provides the ability to package chaincode
  without the need to include the "shim". However, this may cause issues in future
  releases (and/or when trying to use packages which are included by the "shim").
  In order to avoid any issues, users are advised to manually vendor the "shim"
  package with their chaincode prior to using the peer CLI for packaging and/or
  for installing chaincode.
  For more details see FAB-5177.

- Support for CAR chaincode package format
  Support for packaging chaincode using the CAR format will be removed in
  a future release.
  For more details see FAB-14720.

- Support for specifying orderer endpoints at the global level in channel configuration.
  Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
  an organization instead.
  For more details see FAB-7559.

- Support for invoking system chaincodes from user chaincodes.
  System chaincodes, for example QSCC, are intended to be invoked by
  a client rather than by a user chaincode. Invoking from a user chaincode
  may cause deadlocks.
  For more details see FAB-15285.

- Support for user chaincodes to utilize the chaincode shim's logger via NewLogger().
  Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
  logging mechanism.
  For more details see FAB-15366.

- Support for peer's Admin service.
  The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
  Instead of using these services, utilize the HTTP operations service that was
  introduced in v1.4.0.
  For more details see FAB-15390.

- Support for Solo ordering service.
  With the introduction of Raft-based ordering service in v1.4.1, it is possible
  to deploy a single-node (non-production) or multi-node
  Raft-based ordering service with no external dependencies.
  For single-node (non-production) ordering services, utilize Raft-based ordering
  service with a single node instead of Solo ordering service.
  For more details see FAB-15754.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v144
