v1.4.11 Release Notes - March 2, 2021
=====================================

Fixes
-----

**FAB-18413: peer - Node.js chaincode image build may fail**

Node.js chaincode is built with fabric-ccenv image which extends fabric-baseimage.
Since fabric-baseimage uses Node.js v8, npm in fabric-ccenv must be pinned to npm v6.
If fabric-ccenv uses a later npm version, Node.js chaincode image build may fail
with error "Failed to generate platform-specific docker build".
This fix pins npm to v6 in fabric-ccenv image.

**peer and orderer - Fix s390x builds**

golang.org/x/crypto and golang.org/x/sys Go dependencies were out of sync,
causing build failure on s390x architecture.
This fix pins them to consistent versions of v1.14 so that s390x binaries can be built.

**FAB-18427 orderer - Orderer cluster stream termination reports incorrect reason**

The cluster communication infrastructure always reported an "aborted" reason
after a stream terminates, instead of reporting the correct reason.
This fix ensures that the correct reason is logged.


Dependencies
------------
Fabric v1.4.11 has been tested with the following dependencies:
* Go 1.14.12
* Fabric baseimage 0.4.22
* CouchDB v2.3.1


Changes, Known Issues, and Workarounds
--------------------------------------

**FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
Chaincode installed in different ways may result in "chaincode fingerprint
mismatch data mismatch" error upon instantiation. This may happen when
installing chaincode by using different SDKs. To workaround the problem,
package the chaincode prior to installation and instantiation, by using
the "peer chaincode package" command.


Known Vulnerabilities
---------------------

**FAB-8664: Peer should detect and react when its org has been removed**
This is a relatively low severity problem, because it requires a significant
conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations (existing)
-----------------------
The following functions are deprecated and are targeted for removal in a future release.

**Support for automatically vendoring the chaincode shim into user chaincodes**

The fabric-ccenv image which is used to build chaincode, currently includes
the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
This is convenient, as it provides the ability to package chaincode
without the need to include the "shim". However, this may cause issues in future
releases (and/or when trying to use packages which are included by the "shim").
In order to avoid any issues, users are advised to manually vendor the "shim"
package with their chaincode prior to using the peer CLI for packaging and/or
for installing chaincode.
Support removed in v2.0. For more details see FAB-5177.

**Support for CAR chaincode package format**

Support for packaging chaincode using the CAR format will be removed in
a future release.
Support removed in v2.0. For more details see FAB-14720.

**Support for invoking system chaincodes from user chaincodes.**

System chaincodes, for example QSCC, are intended to be invoked by
a client rather than by a user chaincode. Invoking from a user chaincode
may cause deadlocks.
Support removed in v2.0. For more details see FAB-15285.

**Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
logging mechanism.
Support removed in v2.0. For more details see FAB-15366.

**Support for peer's Admin service**

The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
Instead of using these services, utilize the HTTP operations service that was
introduced in v1.4.0.
Support removed in v2.0. For more details see FAB-15390.

**Support for specifying orderer endpoints at the global level in channel configuration.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
an organization instead.
For more details see FAB-7559.

**The 'Solo' consensus type is deprecated.**

With the introduction of Raft-based ordering service in v1.4.1, it is possible
to deploy a single-node (non-production) or multi-node
Raft-based ordering service with no external dependencies.
For single-node (non-production) ordering services, utilize Raft-based ordering
service with a single node instead of Solo ordering service.
For more details see FAB-15754.

**The 'Kafka' consensus type is deprecated**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type. There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**fabric-couchdb docker image no longer updated, maintained, or published**

The fabric-couchdb docker image will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v1411
