﻿namespace uzCyrl;

[UseCulture("uz-Cyrl-UZ")]
public class TimeSpanHumanizeTests
{
    [Theory]
    [Trait("Translation", "Google")]
    [InlineData(366, "1 йил")]
    [InlineData(731, "2 йил")]
    [InlineData(1096, "3 йил")]
    [InlineData(4018, "11 йил")]
    public void Years(int days, string expected) =>
        Assert.Equal(expected, TimeSpan.FromDays(days).Humanize(maxUnit: TimeUnit.Year));

    [Theory]
    [Trait("Translation", "Google")]
    [InlineData(31, "1 ой")]
    [InlineData(61, "2 ой")]
    [InlineData(92, "3 ой")]
    [InlineData(335, "11 ой")]
    public void Months(int days, string expected) =>
        Assert.Equal(expected, TimeSpan.FromDays(days).Humanize(maxUnit: TimeUnit.Year));

    [Theory]
    [InlineData(14, "2 ҳафта")]
    [InlineData(7, "1 ҳафта")]
    public void Weeks(int days, string expected)
    {
        var actual = TimeSpan.FromDays(days).Humanize();
        Assert.Equal(expected, actual);
    }

    [Theory]
    [InlineData(6, "6 кун")]
    [InlineData(2, "2 кун")]
    public void Days(int days, string expected)
    {
        var actual = TimeSpan.FromDays(days).Humanize();
        Assert.Equal(expected, actual);
    }

    [Theory]
    [InlineData(2, "2 соат")]
    [InlineData(1, "1 соат")]
    public void Hours(int hours, string expected)
    {
        var actual = TimeSpan.FromHours(hours).Humanize();
        Assert.Equal(expected, actual);
    }

    [Theory]
    [InlineData(2, "2 минут")]
    [InlineData(1, "1 минут")]
    public void Minutes(int minutes, string expected)
    {
        var actual = TimeSpan.FromMinutes(minutes).Humanize();
        Assert.Equal(expected, actual);
    }

    [Theory]
    [InlineData(2, "2 секунд")]
    [InlineData(1, "1 секунд")]
    public void Seconds(int seconds, string expected)
    {
        var actual = TimeSpan.FromSeconds(seconds).Humanize();
        Assert.Equal(expected, actual);
    }

    [Theory]
    [InlineData(2, "2 миллисекунд")]
    [InlineData(1, "1 миллисекунд")]
    public void Milliseconds(int ms, string expected)
    {
        var actual = TimeSpan.FromMilliseconds(ms).Humanize();
        Assert.Equal(expected, actual);
    }

    [Fact]
    public void NoTime()
    {
        var noTime = TimeSpan.Zero;
        var actual = noTime.Humanize();
        Assert.Equal("0 миллисекунд", actual);
    }

    [Fact]
    public void NoTimeToWords()
    {
        var noTime = TimeSpan.Zero;
        var actual = noTime.Humanize(toWords: true);
        Assert.Equal("вақт йўқ", actual);
    }
}