﻿namespace nl;

[UseCulture("nl-NL")]
public class TimeSpanHumanizeTests
{
    [Theory]
    [Trait("Translation", "Native speaker")]
    [InlineData(366, "1 jaar")]
    [InlineData(731, "2 jaar")]
    [InlineData(1096, "3 jaar")]
    [InlineData(4018, "11 jaar")]
    public void Years(int days, string expected) =>
        Assert.Equal(expected, TimeSpan.FromDays(days).Humanize(maxUnit: TimeUnit.Year));

    [Theory]
    [Trait("Translation", "Native speaker")]
    [InlineData(31, "1 maand")]
    [InlineData(61, "2 maanden")]
    [InlineData(92, "3 maanden")]
    [InlineData(335, "11 maanden")]
    public void Months(int days, string expected) =>
        Assert.Equal(expected, TimeSpan.FromDays(days).Humanize(maxUnit: TimeUnit.Year));

    [Fact]
    public void TwoWeeks() =>
        Assert.Equal("2 weken", TimeSpan.FromDays(14).Humanize());

    [Fact]
    public void OneWeek() =>
        Assert.Equal("1 week", TimeSpan.FromDays(7).Humanize());

    [Fact]
    public void SixDays() =>
        Assert.Equal("6 dagen", TimeSpan.FromDays(6).Humanize());

    [Fact]
    public void TwoDays() =>
        Assert.Equal("2 dagen", TimeSpan.FromDays(2).Humanize());

    [Fact]
    public void OneDay() =>
        Assert.Equal("1 dag", TimeSpan.FromDays(1).Humanize());

    [Fact]
    public void TwoHours() =>
        Assert.Equal("2 uur", TimeSpan.FromHours(2).Humanize());

    [Fact]
    public void OneHour() =>
        Assert.Equal("1 uur", TimeSpan.FromHours(1).Humanize());

    [Fact]
    public void TwoMinutes() =>
        Assert.Equal("2 minuten", TimeSpan.FromMinutes(2).Humanize());

    [Fact]
    public void OneMinute() =>
        Assert.Equal("1 minuut", TimeSpan.FromMinutes(1).Humanize());

    [Fact]
    public void TwoSeconds() =>
        Assert.Equal("2 seconden", TimeSpan.FromSeconds(2).Humanize());

    [Fact]
    public void OneSecond() =>
        Assert.Equal("1 seconde", TimeSpan.FromSeconds(1).Humanize());

    [Fact]
    public void TwoMilliseconds() =>
        Assert.Equal("2 milliseconden", TimeSpan.FromMilliseconds(2).Humanize());

    [Fact]
    public void OneMillisecond() =>
        Assert.Equal("1 milliseconde", TimeSpan.FromMilliseconds(1).Humanize());

    [Fact]
    public void NoTime() =>
        Assert.Equal("0 milliseconden", TimeSpan.Zero.Humanize());

    [Fact]
    public void NoTimeToWords() =>
        Assert.Equal("geen tijd", TimeSpan.Zero.Humanize(toWords: true));
}