﻿namespace mt;

[UseCulture("mt")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(0, "żero")]
    [InlineData(1, "wieħed")]
    [InlineData(-1, "wieħed inqas minn żero")]
    [InlineData(3, "tlieta")]
    [InlineData(10, "għaxra")]
    [InlineData(11, "ħdax")]
    [InlineData(20, "għoxrin")]
    [InlineData(-20, "għoxrin inqas minn żero")]
    [InlineData(21, "wieħed u għoxrin")]
    [InlineData(38, "tmienja u tletin")]
    [InlineData(43, "tlieta u erbgħin")]
    [InlineData(78, "tmienja u sebgħin")]
    [InlineData(99, "disgħa u disgħin")]
    [InlineData(100, "mija")]
    [InlineData(101, "mija u wieħed")]
    [InlineData(103, "mija u tlieta")]
    [InlineData(110, "mija u għaxra")]
    [InlineData(111, "mija u ħdax")]
    [InlineData(121, "mija u wieħed u għoxrin")]
    [InlineData(122, "mija u tnejn u għoxrin")]
    [InlineData(123, "mija u tlieta u għoxrin")]
    [InlineData(138, "mija u tmienja u tletin")]
    [InlineData(143, "mija u tlieta u erbgħin")]
    [InlineData(178, "mija u tmienja u sebgħin")]
    [InlineData(199, "mija u disgħa u disgħin")]
    [InlineData(200, "mitejn")]
    [InlineData(201, "mitejn u wieħed")]
    [InlineData(203, "mitejn u tlieta")]
    [InlineData(210, "mitejn u għaxra")]
    [InlineData(211, "mitejn u ħdax")]
    [InlineData(221, "mitejn u wieħed u għoxrin")]
    [InlineData(222, "mitejn u tnejn u għoxrin")]
    [InlineData(223, "mitejn u tlieta u għoxrin")]
    [InlineData(238, "mitejn u tmienja u tletin")]
    [InlineData(243, "mitejn u tlieta u erbgħin")]
    [InlineData(278, "mitejn u tmienja u sebgħin")]
    [InlineData(299, "mitejn u disgħa u disgħin")]
    [InlineData(300, "tlett mija")]
    [InlineData(401, "erbgħa mija u wieħed")]
    [InlineData(503, "ħames mija u tlieta")]
    [InlineData(610, "sitt mija u għaxra")]
    [InlineData(711, "sebgħa mija u ħdax")]
    [InlineData(821, "tminn mija u wieħed u għoxrin")]
    [InlineData(922, "disgħa mija u tnejn u għoxrin")]
    [InlineData(323, "tlett mija u tlieta u għoxrin")]
    [InlineData(438, "erbgħa mija u tmienja u tletin")]
    [InlineData(543, "ħames mija u tlieta u erbgħin")]
    [InlineData(678, "sitt mija u tmienja u sebgħin")]
    [InlineData(799, "sebgħa mija u disgħa u disgħin")]
    [InlineData(1000, "elf")]
    [InlineData(1001, "elf u wieħed")]
    [InlineData(1111, "elf u mija u ħdax")]
    [InlineData(1234, "elf u mitejn u erbgħa u tletin")]
    [InlineData(1999, "elf u disgħa mija u disgħa u disgħin")]
    [InlineData(2000, "elfejn")]
    [InlineData(2014, "elfejn u erbatax")]
    [InlineData(2048, "elfejn u tmienja u erbgħin")]
    [InlineData(3000, "tlett elef")]
    [InlineData(3501, "tlett elef u ħames mija u wieħed")]
    [InlineData(8100, "tmint elef u mija")]
    [InlineData(10000, "għaxart elef")]
    [InlineData(10001, "għaxart elef u wieħed")]
    [InlineData(12345, "tnax-il elf u tlett mija u ħamsa u erbgħin")]
    [InlineData(18000, "tmintax-il elf")]
    [InlineData(100000, "mitt elf")]
    [InlineData(100001, "mitt elf u wieħed")]
    [InlineData(111111, "mija u ħdax-il elf u mija u ħdax")]
    [InlineData(123456, "mija u tlieta u għoxrin elf u erbgħa mija u sitta u ħamsin")]
    [InlineData(1000000, "miljun")]
    [InlineData(1000001, "miljun u wieħed")]
    [InlineData(1111101, "miljun u mija u ħdax-il elf u mija u wieħed")]
    [InlineData(1111111, "miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(1234567, "miljun u mitejn u erbgħa u tletin elf u ħames mija u sebgħa u sittin")]
    [InlineData(5000000, "ħames miljuni")]
    [InlineData(10000000, "għaxar miljuni")]
    [InlineData(10000001, "għaxar miljuni u wieħed")]
    [InlineData(11111111, "ħdax-il miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(12345678, "tnax-il miljun u tlett mija u ħamsa u erbgħin elf u sitt mija u tmienja u sebgħin")]
    [InlineData(100000000, "mitt miljun")]
    [InlineData(100000001, "mitt miljun u wieħed")]
    [InlineData(111111111, "mija u ħdax-il miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(123456789, "mija u tlieta u għoxrin miljun u erbgħa mija u sitta u ħamsin elf u sebgħa mija u disgħa u tmenin")]
    [InlineData(1000000000, "biljun")]
    [InlineData(1000000001, "biljun u wieħed")]
    [InlineData(1101111101, "biljun u mija u miljun u mija u ħdax-il elf u mija u wieħed")]
    [InlineData(2000000000, "żewġ biljuni")]
    [InlineData(2147483647, "żewġ biljuni u mija u sebgħa u erbgħin miljun u erbgħa mija u tlieta u tmenin elf u sitt mija u sebgħa u erbgħin")]
    [InlineData(-2147483647, "żewġ biljuni u mija u sebgħa u erbgħin miljun u erbgħa mija u tlieta u tmenin elf u sitt mija u sebgħa u erbgħin inqas minn żero")]
    public void ToWords(int number, string expected) =>
        Assert.Equal(expected, number.ToWords());

    [Theory]
    [InlineData(1, "waħda")]
    [InlineData(1001, "elf u waħda")]
    [InlineData(100001, "mitt elf u waħda")]
    [InlineData(1000000001, "biljun u waħda")]
    public void ToFeminineWords(int number, string expected) =>
        Assert.Equal(expected, number.ToWords(GrammaticalGender.Feminine));

    [Theory]
    [InlineData(0, "żero")]
    [InlineData(1, "wieħed")]
    [InlineData(3, "tlieta")]
    [InlineData(10, "għaxra")]
    [InlineData(11, "ħdax")]
    [InlineData(20, "għoxrin")]
    [InlineData(21, "wieħed u għoxrin")]
    [InlineData(38, "tmienja u tletin")]
    [InlineData(43, "tlieta u erbgħin")]
    [InlineData(78, "tmienja u sebgħin")]
    [InlineData(99, "disgħa u disgħin")]
    [InlineData(100, "mija")]
    [InlineData(101, "mija u wieħed")]
    [InlineData(103, "mija u tlieta")]
    [InlineData(110, "mija u għaxra")]
    [InlineData(111, "mija u ħdax")]
    [InlineData(121, "mija u wieħed u għoxrin")]
    [InlineData(122, "mija u tnejn u għoxrin")]
    [InlineData(123, "mija u tlieta u għoxrin")]
    [InlineData(138, "mija u tmienja u tletin")]
    [InlineData(143, "mija u tlieta u erbgħin")]
    [InlineData(178, "mija u tmienja u sebgħin")]
    [InlineData(199, "mija u disgħa u disgħin")]
    [InlineData(200, "mitejn")]
    [InlineData(201, "mitejn u wieħed")]
    [InlineData(203, "mitejn u tlieta")]
    [InlineData(210, "mitejn u għaxra")]
    [InlineData(211, "mitejn u ħdax")]
    [InlineData(221, "mitejn u wieħed u għoxrin")]
    [InlineData(222, "mitejn u tnejn u għoxrin")]
    [InlineData(223, "mitejn u tlieta u għoxrin")]
    [InlineData(238, "mitejn u tmienja u tletin")]
    [InlineData(243, "mitejn u tlieta u erbgħin")]
    [InlineData(278, "mitejn u tmienja u sebgħin")]
    [InlineData(299, "mitejn u disgħa u disgħin")]
    [InlineData(300, "tlett mija")]
    [InlineData(401, "erbgħa mija u wieħed")]
    [InlineData(503, "ħames mija u tlieta")]
    [InlineData(610, "sitt mija u għaxra")]
    [InlineData(711, "sebgħa mija u ħdax")]
    [InlineData(821, "tminn mija u wieħed u għoxrin")]
    [InlineData(922, "disgħa mija u tnejn u għoxrin")]
    [InlineData(323, "tlett mija u tlieta u għoxrin")]
    [InlineData(438, "erbgħa mija u tmienja u tletin")]
    [InlineData(543, "ħames mija u tlieta u erbgħin")]
    [InlineData(678, "sitt mija u tmienja u sebgħin")]
    [InlineData(799, "sebgħa mija u disgħa u disgħin")]
    [InlineData(1000, "elf")]
    [InlineData(1001, "elf u wieħed")]
    [InlineData(1111, "elf u mija u ħdax")]
    [InlineData(1234, "elf u mitejn u erbgħa u tletin")]
    [InlineData(1999, "elf u disgħa mija u disgħa u disgħin")]
    [InlineData(2000, "elfejn")]
    [InlineData(2014, "elfejn u erbatax")]
    [InlineData(2048, "elfejn u tmienja u erbgħin")]
    [InlineData(3000, "tlett elef")]
    [InlineData(3501, "tlett elef u ħames mija u wieħed")]
    [InlineData(8100, "tmint elef u mija")]
    [InlineData(10000, "għaxart elef")]
    [InlineData(10001, "għaxart elef u wieħed")]
    [InlineData(12345, "tnax-il elf u tlett mija u ħamsa u erbgħin")]
    [InlineData(18000, "tmintax-il elf")]
    [InlineData(100000, "mitt elf")]
    [InlineData(100001, "mitt elf u wieħed")]
    [InlineData(111111, "mija u ħdax-il elf u mija u ħdax")]
    [InlineData(123456, "mija u tlieta u għoxrin elf u erbgħa mija u sitta u ħamsin")]
    [InlineData(1000000, "miljun")]
    [InlineData(1000001, "miljun u wieħed")]
    [InlineData(1111101, "miljun u mija u ħdax-il elf u mija u wieħed")]
    [InlineData(1111111, "miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(1234567, "miljun u mitejn u erbgħa u tletin elf u ħames mija u sebgħa u sittin")]
    [InlineData(5000000, "ħames miljuni")]
    [InlineData(10000000, "għaxar miljuni")]
    [InlineData(10000001, "għaxar miljuni u wieħed")]
    [InlineData(11111111, "ħdax-il miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(12345678, "tnax-il miljun u tlett mija u ħamsa u erbgħin elf u sitt mija u tmienja u sebgħin")]
    [InlineData(100000000, "mitt miljun")]
    [InlineData(100000001, "mitt miljun u wieħed")]
    [InlineData(111111111, "mija u ħdax-il miljun u mija u ħdax-il elf u mija u ħdax")]
    [InlineData(123456789, "mija u tlieta u għoxrin miljun u erbgħa mija u sitta u ħamsin elf u sebgħa mija u disgħa u tmenin")]
    [InlineData(1000000000, "biljun")]
    [InlineData(1000000001, "biljun u wieħed")]
    [InlineData(1101111101, "biljun u mija u miljun u mija u ħdax-il elf u mija u wieħed")]
    [InlineData(2000000000, "żewġ biljuni")]
    [InlineData(2147483647, "żewġ biljuni u mija u sebgħa u erbgħin miljun u erbgħa mija u tlieta u tmenin elf u sitt mija u sebgħa u erbgħin")]
    public void ToMasculineWords(int number, string expected) =>
        Assert.Equal(expected, number.ToWords(GrammaticalGender.Masculine));

    [Theory]
    [InlineData(0, "0")]
    [InlineData(1, "l-ewwel")]
    [InlineData(2, "it-tieni")]
    [InlineData(9, "id-disa'")]
    [InlineData(10, "l-għaxar")]
    [InlineData(11, "il-ħdax")]
    [InlineData(15, "il-ħmistax")]
    [InlineData(18, "it-tmintax")]
    [InlineData(20, "l-għoxrin")]
    [InlineData(21, "il-wieħed u għoxrin")]
    [InlineData(22, "it-tnejn u għoxrin")]
    [InlineData(28, "it-tmienja u għoxrin")]
    [InlineData(44, "l-erbgħa u erbgħin")]
    [InlineData(55, "il-ħamsa u ħamsin")]
    [InlineData(60, "is-sittin")]
    [InlineData(99, "id-disgħa u disgħin")]
    [InlineData(100, "il-mija")]
    [InlineData(101, "il-mija u wieħed")]
    [InlineData(1000, "l-elf")]
    [InlineData(1001, "l-elf u wieħed")]
    [InlineData(2000, "l-elfejn")]
    [InlineData(3000, "it-tlett elef")]
    public void ToOrdinalWords(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords());

    [Theory]
    [InlineData(0, "0")]
    [InlineData(1, "l-ewwel")]
    [InlineData(2, "it-tieni")]
    [InlineData(9, "id-disa'")]
    [InlineData(10, "l-għaxar")]
    [InlineData(11, "il-ħdax")]
    [InlineData(15, "il-ħmistax")]
    [InlineData(18, "it-tmintax")]
    [InlineData(20, "l-għoxrin")]
    [InlineData(21, "il-wieħed u għoxrin")]
    [InlineData(22, "it-tnejn u għoxrin")]
    [InlineData(28, "it-tmienja u għoxrin")]
    [InlineData(44, "l-erbgħa u erbgħin")]
    [InlineData(55, "il-ħamsa u ħamsin")]
    [InlineData(60, "is-sittin")]
    [InlineData(99, "id-disgħa u disgħin")]
    [InlineData(100, "il-mija")]
    [InlineData(101, "il-mija u waħda")]
    [InlineData(1000, "l-elf")]
    [InlineData(1001, "l-elf u waħda")]
    [InlineData(2000, "l-elfejn")]
    [InlineData(3000, "it-tlett elef")]
    public void ToFeminineOrdinalWords(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Feminine));

    [Theory]
    [InlineData(0, "0")]
    [InlineData(1, "l-ewwel")]
    [InlineData(2, "it-tieni")]
    [InlineData(9, "id-disa'")]
    [InlineData(10, "l-għaxar")]
    [InlineData(11, "il-ħdax")]
    [InlineData(15, "il-ħmistax")]
    [InlineData(18, "it-tmintax")]
    [InlineData(20, "l-għoxrin")]
    [InlineData(21, "il-wieħed u għoxrin")]
    [InlineData(22, "it-tnejn u għoxrin")]
    [InlineData(28, "it-tmienja u għoxrin")]
    [InlineData(44, "l-erbgħa u erbgħin")]
    [InlineData(55, "il-ħamsa u ħamsin")]
    [InlineData(60, "is-sittin")]
    [InlineData(99, "id-disgħa u disgħin")]
    [InlineData(100, "il-mija")]
    [InlineData(101, "il-mija u wieħed")]
    [InlineData(1000, "l-elf")]
    [InlineData(1001, "l-elf u wieħed")]
    [InlineData(2000, "l-elfejn")]
    [InlineData(3000, "it-tlett elef")]
    public void ToMasculineOrdinalWords(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Masculine));
}