﻿namespace lv;

[UseCulture("lv-LV")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(21, "divdesmit viens")]
    [InlineData(22, "divdesmit divi")]
    [InlineData(26, "divdesmit seši")]
    [InlineData(30, "trīsdesmit")]
    [InlineData(31, "trīsdesmit viens")]
    [InlineData(33, "trīsdesmit trīs")]
    [InlineData(37, "trīsdesmit septiņi")]
    [InlineData(40, "četrdesmit")]
    [InlineData(41, "četrdesmit viens")]
    [InlineData(44, "četrdesmit četri")]
    [InlineData(48, "četrdesmit astoņi")]
    [InlineData(50, "piecdesmit")]
    [InlineData(51, "piecdesmit viens")]
    [InlineData(55, "piecdesmit pieci")]
    [InlineData(59, "piecdesmit deviņi")]
    [InlineData(60, "sešdesmit")]
    [InlineData(61, "sešdesmit viens")]
    [InlineData(62, "sešdesmit divi")]
    [InlineData(66, "sešdesmit seši")]
    [InlineData(70, "septiņdesmit")]
    [InlineData(71, "septiņdesmit viens")]
    [InlineData(73, "septiņdesmit trīs")]
    [InlineData(77, "septiņdesmit septiņi")]
    [InlineData(80, "astoņdesmit")]
    [InlineData(81, "astoņdesmit viens")]
    [InlineData(84, "astoņdesmit četri")]
    [InlineData(88, "astoņdesmit astoņi")]
    [InlineData(90, "deviņdesmit")]
    [InlineData(91, "deviņdesmit viens")]
    [InlineData(95, "deviņdesmit pieci")]
    [InlineData(99, "deviņdesmit deviņi")]
    [InlineData(100, "simts")]
    [InlineData(101, "simtu viens")]
    [InlineData(105, "simtu pieci")]
    [InlineData(110, "simtu desmit")]
    [InlineData(151, "simtu piecdesmit viens")]
    [InlineData(200, "divi simti")]
    [InlineData(202, "divi simti divi")]
    [InlineData(206, "divi simti seši")]
    [InlineData(220, "divi simti divdesmit")]
    [InlineData(262, "divi simti sešdesmit divi")]
    [InlineData(300, "trīs simti")]
    [InlineData(303, "trīs simti trīs")]
    [InlineData(307, "trīs simti septiņi")]
    [InlineData(330, "trīs simti trīsdesmit")]
    [InlineData(373, "trīs simti septiņdesmit trīs")]
    [InlineData(400, "četri simti")]
    [InlineData(404, "četri simti četri")]
    [InlineData(408, "četri simti astoņi")]
    [InlineData(440, "četri simti četrdesmit")]
    [InlineData(484, "četri simti astoņdesmit četri")]
    [InlineData(500, "pieci simti")]
    [InlineData(505, "pieci simti pieci")]
    [InlineData(509, "pieci simti deviņi")]
    [InlineData(550, "pieci simti piecdesmit")]
    [InlineData(595, "pieci simti deviņdesmit pieci")]
    [InlineData(600, "seši simti")]
    [InlineData(601, "seši simti viens")]
    [InlineData(606, "seši simti seši")]
    [InlineData(616, "seši simti sešpadsmit")]
    [InlineData(660, "seši simti sešdesmit")]
    [InlineData(700, "septiņi simti")]
    [InlineData(702, "septiņi simti divi")]
    [InlineData(707, "septiņi simti septiņi")]
    [InlineData(727, "septiņi simti divdesmit septiņi")]
    [InlineData(770, "septiņi simti septiņdesmit")]
    [InlineData(800, "astoņi simti")]
    [InlineData(803, "astoņi simti trīs")]
    [InlineData(808, "astoņi simti astoņi")]
    [InlineData(838, "astoņi simti trīsdesmit astoņi")]
    [InlineData(880, "astoņi simti astoņdesmit")]
    [InlineData(900, "deviņi simti")]
    [InlineData(904, "deviņi simti četri")]
    [InlineData(909, "deviņi simti deviņi")]
    [InlineData(949, "deviņi simti četrdesmit deviņi")]
    [InlineData(990, "deviņi simti deviņdesmit")]
    [InlineData(1000, "tūkstotis")]
    [InlineData(1001, "tūkstoš viens")]
    [InlineData(1012, "tūkstoš divpadsmit")]
    [InlineData(1100, "tūkstoš viens simts")]
    [InlineData(1234, "tūkstoš divi simti trīsdesmit četri")]
    [InlineData(2000, "divi tūkstoši")]
    [InlineData(2002, "divi tūkstoši divi")]
    [InlineData(2023, "divi tūkstoši divdesmit trīs")]
    [InlineData(2345, "divi tūkstoši trīs simti četrdesmit pieci")]
    [InlineData(3000, "trīs tūkstoši")]
    [InlineData(3003, "trīs tūkstoši trīs")]
    [InlineData(3034, "trīs tūkstoši trīsdesmit četri")]
    [InlineData(3456, "trīs tūkstoši četri simti piecdesmit seši")]
    [InlineData(4000, "četri tūkstoši")]
    [InlineData(4004, "četri tūkstoši četri")]
    [InlineData(4045, "četri tūkstoši četrdesmit pieci")]
    [InlineData(4567, "četri tūkstoši pieci simti sešdesmit septiņi")]
    [InlineData(5000, "pieci tūkstoši")]
    [InlineData(5005, "pieci tūkstoši pieci")]
    [InlineData(5056, "pieci tūkstoši piecdesmit seši")]
    [InlineData(5678, "pieci tūkstoši seši simti septiņdesmit astoņi")]
    [InlineData(6000, "seši tūkstoši")]
    [InlineData(6006, "seši tūkstoši seši")]
    [InlineData(6067, "seši tūkstoši sešdesmit septiņi")]
    [InlineData(6789, "seši tūkstoši septiņi simti astoņdesmit deviņi")]
    [InlineData(7000, "septiņi tūkstoši")]
    [InlineData(7007, "septiņi tūkstoši septiņi")]
    [InlineData(7078, "septiņi tūkstoši septiņdesmit astoņi")]
    [InlineData(7890, "septiņi tūkstoši astoņi simti deviņdesmit")]
    [InlineData(8000, "astoņi tūkstoši")]
    [InlineData(8008, "astoņi tūkstoši astoņi")]
    [InlineData(8089, "astoņi tūkstoši astoņdesmit deviņi")]
    [InlineData(8901, "astoņi tūkstoši deviņi simti viens")]
    [InlineData(9000, "deviņi tūkstoši")]
    [InlineData(9009, "deviņi tūkstoši deviņi")]
    [InlineData(9012, "deviņi tūkstoši divpadsmit")]
    [InlineData(9090, "deviņi tūkstoši deviņdesmit")]
    [InlineData(10000, "desmit tūkstoši")]
    [InlineData(10001, "desmit tūkstoši viens")]
    [InlineData(20020, "divdesmit tūkstoši divdesmit")]
    [InlineData(30300, "trīsdesmit tūkstoši trīs simti")]
    [InlineData(44000, "četrdesmit četri tūkstoši")]
    [InlineData(44231, "četrdesmit četri tūkstoši divi simti trīsdesmit viens")]
    [InlineData(100000, "simts tūkstoši")]
    [InlineData(500000, "pieci simti tūkstoši")]
    [InlineData(1000000, "miljons")]
    [InlineData(6000000, "seši miljoni")]
    [InlineData(10000000, "desmit miljoni")]
    [InlineData(70000000, "septiņdesmit miljoni")]
    [InlineData(100000000, "simts miljoni")]
    [InlineData(800000000, "astoņi simti miljoni")]
    public void ToWords(int number, string expected) =>
        Assert.Equal(expected, number.ToWords());

    [Theory]
    [InlineData(21, "divdesmit pirmais")]
    [InlineData(22, "divdesmit otrais")]
    [InlineData(26, "divdesmit sestais")]
    [InlineData(30, "trīsdesmitais")]
    [InlineData(31, "trīsdesmit pirmais")]
    [InlineData(33, "trīsdesmit trešais")]
    [InlineData(37, "trīsdesmit septītais")]
    [InlineData(40, "četrdesmitais")]
    [InlineData(41, "četrdesmit pirmais")]
    [InlineData(44, "četrdesmit ceturtais")]
    [InlineData(48, "četrdesmit astotais")]
    [InlineData(50, "piecdesmitais")]
    [InlineData(51, "piecdesmit pirmais")]
    [InlineData(55, "piecdesmit piektais")]
    [InlineData(59, "piecdesmit devītais")]
    [InlineData(60, "sešdesmitais")]
    [InlineData(61, "sešdesmit pirmais")]
    [InlineData(62, "sešdesmit otrais")]
    [InlineData(66, "sešdesmit sestais")]
    [InlineData(70, "septiņdesmitais")]
    [InlineData(71, "septiņdesmit pirmais")]
    [InlineData(73, "septiņdesmit trešais")]
    [InlineData(77, "septiņdesmit septītais")]
    [InlineData(80, "astoņdesmitais")]
    [InlineData(81, "astoņdesmit pirmais")]
    [InlineData(84, "astoņdesmit ceturtais")]
    [InlineData(88, "astoņdesmit astotais")]
    [InlineData(90, "deviņdesmitais")]
    [InlineData(91, "deviņdesmit pirmais")]
    [InlineData(95, "deviņdesmit piektais")]
    [InlineData(99, "deviņdesmit devītais")]
    [InlineData(100, "simtais")]
    [InlineData(101, "simtu pirmais")]
    [InlineData(105, "simtu piektais")]
    [InlineData(110, "simtu desmitais")]
    [InlineData(151, "simtu piecdesmit pirmais")]
    [InlineData(200, "divsimtais")]
    [InlineData(202, "divi simti otrais")]
    [InlineData(206, "divi simti sestais")]
    [InlineData(220, "divi simti divdesmitais")]
    [InlineData(262, "divi simti sešdesmit otrais")]
    [InlineData(300, "trīssimtais")]
    [InlineData(303, "trīs simti trešais")]
    [InlineData(307, "trīs simti septītais")]
    [InlineData(330, "trīs simti trīsdesmitais")]
    [InlineData(373, "trīs simti septiņdesmit trešais")]
    [InlineData(400, "četrsimtais")]
    [InlineData(404, "četri simti ceturtais")]
    [InlineData(408, "četri simti astotais")]
    [InlineData(440, "četri simti četrdesmitais")]
    [InlineData(484, "četri simti astoņdesmit ceturtais")]
    [InlineData(500, "piecsimtais")]
    [InlineData(505, "pieci simti piektais")]
    [InlineData(509, "pieci simti devītais")]
    [InlineData(550, "pieci simti piecdesmitais")]
    [InlineData(595, "pieci simti deviņdesmit piektais")]
    [InlineData(600, "sešsimtais")]
    [InlineData(601, "seši simti pirmais")]
    [InlineData(606, "seši simti sestais")]
    [InlineData(616, "seši simti sešpadsmitais")]
    [InlineData(660, "seši simti sešdesmitais")]
    [InlineData(700, "septiņsimtais")]
    [InlineData(702, "septiņi simti otrais")]
    [InlineData(707, "septiņi simti septītais")]
    [InlineData(727, "septiņi simti divdesmit septītais")]
    [InlineData(770, "septiņi simti septiņdesmitais")]
    [InlineData(800, "astoņsimtais")]
    [InlineData(803, "astoņi simti trešais")]
    [InlineData(808, "astoņi simti astotais")]
    [InlineData(838, "astoņi simti trīsdesmit astotais")]
    [InlineData(880, "astoņi simti astoņdesmitais")]
    [InlineData(900, "deviņsimtais")]
    [InlineData(904, "deviņi simti ceturtais")]
    [InlineData(909, "deviņi simti devītais")]
    [InlineData(949, "deviņi simti četrdesmit devītais")]
    [InlineData(990, "deviņi simti deviņdesmitais")]
    [InlineData(1000, "tūkstošais")]
    [InlineData(1001, "tūkstoš pirmais")]
    [InlineData(1012, "tūkstoš divpadsmitais")]
    [InlineData(1100, "tūkstoš simtais")]
    [InlineData(1234, "tūkstoš divi simti trīsdesmit ceturtais")]
    [InlineData(2000, "divi tūkstošais")]
    [InlineData(2002, "divi tūkstoši otrais")]
    [InlineData(2023, "divi tūkstoši divdesmit trešais")]
    [InlineData(2345, "divi tūkstoši trīs simti četrdesmit piektais")]
    [InlineData(3000, "trīs tūkstošais")]
    [InlineData(3003, "trīs tūkstoši trešais")]
    [InlineData(3034, "trīs tūkstoši trīsdesmit ceturtais")]
    [InlineData(3456, "trīs tūkstoši četri simti piecdesmit sestais")]
    [InlineData(4000, "četri tūkstošais")]
    [InlineData(4004, "četri tūkstoši ceturtais")]
    [InlineData(4045, "četri tūkstoši četrdesmit piektais")]
    [InlineData(4567, "četri tūkstoši pieci simti sešdesmit septītais")]
    [InlineData(5000, "pieci tūkstošais")]
    [InlineData(5005, "pieci tūkstoši piektais")]
    [InlineData(5056, "pieci tūkstoši piecdesmit sestais")]
    [InlineData(5678, "pieci tūkstoši seši simti septiņdesmit astotais")]
    [InlineData(6000, "seši tūkstošais")]
    [InlineData(6006, "seši tūkstoši sestais")]
    [InlineData(6067, "seši tūkstoši sešdesmit septītais")]
    [InlineData(6789, "seši tūkstoši septiņi simti astoņdesmit devītais")]
    [InlineData(7000, "septiņi tūkstošais")]
    [InlineData(7007, "septiņi tūkstoši septītais")]
    [InlineData(7078, "septiņi tūkstoši septiņdesmit astotais")]
    [InlineData(7890, "septiņi tūkstoši astoņi simti deviņdesmitais")]
    [InlineData(8000, "astoņi tūkstošais")]
    [InlineData(8008, "astoņi tūkstoši astotais")]
    [InlineData(8089, "astoņi tūkstoši astoņdesmit devītais")]
    [InlineData(8901, "astoņi tūkstoši deviņi simti pirmais")]
    [InlineData(9000, "deviņi tūkstošais")]
    [InlineData(9009, "deviņi tūkstoši devītais")]
    [InlineData(9012, "deviņi tūkstoši divpadsmitais")]
    [InlineData(9090, "deviņi tūkstoši deviņdesmitais")]
    [InlineData(10000, "desmit tūkstošais")]
    [InlineData(10001, "desmit tūkstoši pirmais")]
    [InlineData(20020, "divdesmit tūkstoši divdesmitais")]
    [InlineData(30300, "trīsdesmit tūkstoši trīssimtais")]
    [InlineData(44000, "četrdesmit četri tūkstošais")]
    [InlineData(44231, "četrdesmit četri tūkstoši divi simti trīsdesmit pirmais")]
    [InlineData(100000, "simts tūkstošais")]
    [InlineData(500000, "pieci simti tūkstošais")]
    [InlineData(1000000, "miljonais")]
    [InlineData(6000000, "seši miljonais")]
    [InlineData(10000000, "desmit miljonais")]
    [InlineData(70000000, "septiņdesmit miljonais")]
    [InlineData(100000000, "simts miljonais")]
    [InlineData(800000000, "astoņi simti miljonais")]
    public void ToOrdinalWordsMasculine(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Masculine));

    [Theory]
    [InlineData(21, "divdesmit pirmā")]
    [InlineData(22, "divdesmit otrā")]
    [InlineData(26, "divdesmit sestā")]
    [InlineData(30, "trīsdesmitā")]
    [InlineData(31, "trīsdesmit pirmā")]
    [InlineData(33, "trīsdesmit trešā")]
    [InlineData(37, "trīsdesmit septītā")]
    [InlineData(40, "četrdesmitā")]
    [InlineData(41, "četrdesmit pirmā")]
    [InlineData(44, "četrdesmit ceturtā")]
    [InlineData(48, "četrdesmit astotā")]
    [InlineData(50, "piecdesmitā")]
    [InlineData(51, "piecdesmit pirmā")]
    [InlineData(55, "piecdesmit piektā")]
    [InlineData(59, "piecdesmit devītā")]
    [InlineData(60, "sešdesmitā")]
    [InlineData(61, "sešdesmit pirmā")]
    [InlineData(62, "sešdesmit otrā")]
    [InlineData(66, "sešdesmit sestā")]
    [InlineData(70, "septiņdesmitā")]
    [InlineData(71, "septiņdesmit pirmā")]
    [InlineData(73, "septiņdesmit trešā")]
    [InlineData(77, "septiņdesmit septītā")]
    [InlineData(80, "astoņdesmitā")]
    [InlineData(81, "astoņdesmit pirmā")]
    [InlineData(84, "astoņdesmit ceturtā")]
    [InlineData(88, "astoņdesmit astotā")]
    [InlineData(90, "deviņdesmitā")]
    [InlineData(91, "deviņdesmit pirmā")]
    [InlineData(95, "deviņdesmit piektā")]
    [InlineData(99, "deviņdesmit devītā")]
    [InlineData(100, "simtā")]
    [InlineData(101, "simtu pirmā")]
    [InlineData(105, "simtu piektā")]
    [InlineData(110, "simtu desmitā")]
    [InlineData(151, "simtu piecdesmit pirmā")]
    [InlineData(200, "divsimtā")]
    [InlineData(202, "divi simti otrā")]
    [InlineData(206, "divi simti sestā")]
    [InlineData(220, "divi simti divdesmitā")]
    [InlineData(262, "divi simti sešdesmit otrā")]
    [InlineData(300, "trīssimtā")]
    [InlineData(303, "trīs simti trešā")]
    [InlineData(307, "trīs simti septītā")]
    [InlineData(330, "trīs simti trīsdesmitā")]
    [InlineData(373, "trīs simti septiņdesmit trešā")]
    [InlineData(400, "četrsimtā")]
    [InlineData(404, "četri simti ceturtā")]
    [InlineData(408, "četri simti astotā")]
    [InlineData(440, "četri simti četrdesmitā")]
    [InlineData(484, "četri simti astoņdesmit ceturtā")]
    [InlineData(500, "piecsimtā")]
    [InlineData(505, "pieci simti piektā")]
    [InlineData(509, "pieci simti devītā")]
    [InlineData(550, "pieci simti piecdesmitā")]
    [InlineData(595, "pieci simti deviņdesmit piektā")]
    [InlineData(600, "sešsimtā")]
    [InlineData(601, "seši simti pirmā")]
    [InlineData(606, "seši simti sestā")]
    [InlineData(616, "seši simti sešpadsmitā")]
    [InlineData(660, "seši simti sešdesmitā")]
    [InlineData(700, "septiņsimtā")]
    [InlineData(702, "septiņi simti otrā")]
    [InlineData(707, "septiņi simti septītā")]
    [InlineData(727, "septiņi simti divdesmit septītā")]
    [InlineData(770, "septiņi simti septiņdesmitā")]
    [InlineData(800, "astoņsimtā")]
    [InlineData(803, "astoņi simti trešā")]
    [InlineData(808, "astoņi simti astotā")]
    [InlineData(838, "astoņi simti trīsdesmit astotā")]
    [InlineData(880, "astoņi simti astoņdesmitā")]
    [InlineData(900, "deviņsimtā")]
    [InlineData(904, "deviņi simti ceturtā")]
    [InlineData(909, "deviņi simti devītā")]
    [InlineData(949, "deviņi simti četrdesmit devītā")]
    [InlineData(990, "deviņi simti deviņdesmitā")]
    [InlineData(1000, "tūkstošā")]
    [InlineData(1001, "tūkstoš pirmā")]
    [InlineData(1012, "tūkstoš divpadsmitā")]
    [InlineData(1100, "tūkstoš simtā")]
    [InlineData(1234, "tūkstoš divi simti trīsdesmit ceturtā")]
    [InlineData(2000, "divi tūkstošā")]
    [InlineData(2002, "divi tūkstoši otrā")]
    [InlineData(2023, "divi tūkstoši divdesmit trešā")]
    [InlineData(2345, "divi tūkstoši trīs simti četrdesmit piektā")]
    [InlineData(3000, "trīs tūkstošā")]
    [InlineData(3003, "trīs tūkstoši trešā")]
    [InlineData(3034, "trīs tūkstoši trīsdesmit ceturtā")]
    [InlineData(3456, "trīs tūkstoši četri simti piecdesmit sestā")]
    [InlineData(4000, "četri tūkstošā")]
    [InlineData(4004, "četri tūkstoši ceturtā")]
    [InlineData(4045, "četri tūkstoši četrdesmit piektā")]
    [InlineData(4567, "četri tūkstoši pieci simti sešdesmit septītā")]
    [InlineData(5000, "pieci tūkstošā")]
    [InlineData(5005, "pieci tūkstoši piektā")]
    [InlineData(5056, "pieci tūkstoši piecdesmit sestā")]
    [InlineData(5678, "pieci tūkstoši seši simti septiņdesmit astotā")]
    [InlineData(6000, "seši tūkstošā")]
    [InlineData(6006, "seši tūkstoši sestā")]
    [InlineData(6067, "seši tūkstoši sešdesmit septītā")]
    [InlineData(6789, "seši tūkstoši septiņi simti astoņdesmit devītā")]
    [InlineData(7000, "septiņi tūkstošā")]
    [InlineData(7007, "septiņi tūkstoši septītā")]
    [InlineData(7078, "septiņi tūkstoši septiņdesmit astotā")]
    [InlineData(7890, "septiņi tūkstoši astoņi simti deviņdesmitā")]
    [InlineData(8000, "astoņi tūkstošā")]
    [InlineData(8008, "astoņi tūkstoši astotā")]
    [InlineData(8089, "astoņi tūkstoši astoņdesmit devītā")]
    [InlineData(8901, "astoņi tūkstoši deviņi simti pirmā")]
    [InlineData(9000, "deviņi tūkstošā")]
    [InlineData(9009, "deviņi tūkstoši devītā")]
    [InlineData(9012, "deviņi tūkstoši divpadsmitā")]
    [InlineData(9090, "deviņi tūkstoši deviņdesmitā")]
    [InlineData(10000, "desmit tūkstošā")]
    [InlineData(10001, "desmit tūkstoši pirmā")]
    [InlineData(20020, "divdesmit tūkstoši divdesmitā")]
    [InlineData(30300, "trīsdesmit tūkstoši trīssimtā")]
    [InlineData(44000, "četrdesmit četri tūkstošā")]
    [InlineData(44231, "četrdesmit četri tūkstoši divi simti trīsdesmit pirmā")]
    [InlineData(100000, "simts tūkstošā")]
    [InlineData(500000, "pieci simti tūkstošā")]
    [InlineData(1000000, "miljonā")]
    [InlineData(6000000, "seši miljonā")]
    [InlineData(10000000, "desmit miljonā")]
    [InlineData(70000000, "septiņdesmit miljonā")]
    [InlineData(100000000, "simts miljonā")]
    [InlineData(800000000, "astoņi simti miljonā")]
    public void ToOrdinalWordsFeminine(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Feminine));
}