﻿namespace lt;

[UseCulture("lt")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(-1, "minus vienas")]
    [InlineData(0, "nulis")]
    [InlineData(1, "vienas")]
    [InlineData(11, "vienuolika")]
    [InlineData(21, "dvidešimt vienas")]
    [InlineData(22, "dvidešimt du")]
    [InlineData(26, "dvidešimt šeši")]
    [InlineData(30, "trisdešimt")]
    [InlineData(31, "trisdešimt vienas")]
    [InlineData(33, "trisdešimt trys")]
    [InlineData(37, "trisdešimt septyni")]
    [InlineData(40, "keturiasdešimt")]
    [InlineData(41, "keturiasdešimt vienas")]
    [InlineData(44, "keturiasdešimt keturi")]
    [InlineData(48, "keturiasdešimt aštuoni")]
    [InlineData(50, "penkiasdešimt")]
    [InlineData(51, "penkiasdešimt vienas")]
    [InlineData(55, "penkiasdešimt penki")]
    [InlineData(59, "penkiasdešimt devyni")]
    [InlineData(60, "šešiasdešimt")]
    [InlineData(61, "šešiasdešimt vienas")]
    [InlineData(62, "šešiasdešimt du")]
    [InlineData(66, "šešiasdešimt šeši")]
    [InlineData(70, "septyniasdešimt")]
    [InlineData(71, "septyniasdešimt vienas")]
    [InlineData(73, "septyniasdešimt trys")]
    [InlineData(77, "septyniasdešimt septyni")]
    [InlineData(80, "aštuoniasdešimt")]
    [InlineData(81, "aštuoniasdešimt vienas")]
    [InlineData(84, "aštuoniasdešimt keturi")]
    [InlineData(88, "aštuoniasdešimt aštuoni")]
    [InlineData(90, "devyniasdešimt")]
    [InlineData(91, "devyniasdešimt vienas")]
    [InlineData(95, "devyniasdešimt penki")]
    [InlineData(99, "devyniasdešimt devyni")]
    [InlineData(100, "šimtas")]
    [InlineData(101, "šimtas vienas")]
    [InlineData(105, "šimtas penki")]
    [InlineData(110, "šimtas dešimt")]
    [InlineData(151, "šimtas penkiasdešimt vienas")]
    [InlineData(200, "du šimtai")]
    [InlineData(202, "du šimtai du")]
    [InlineData(206, "du šimtai šeši")]
    [InlineData(220, "du šimtai dvidešimt")]
    [InlineData(262, "du šimtai šešiasdešimt du")]
    [InlineData(300, "trys šimtai")]
    [InlineData(303, "trys šimtai trys")]
    [InlineData(307, "trys šimtai septyni")]
    [InlineData(330, "trys šimtai trisdešimt")]
    [InlineData(373, "trys šimtai septyniasdešimt trys")]
    [InlineData(400, "keturi šimtai")]
    [InlineData(404, "keturi šimtai keturi")]
    [InlineData(408, "keturi šimtai aštuoni")]
    [InlineData(440, "keturi šimtai keturiasdešimt")]
    [InlineData(484, "keturi šimtai aštuoniasdešimt keturi")]
    [InlineData(500, "penki šimtai")]
    [InlineData(505, "penki šimtai penki")]
    [InlineData(509, "penki šimtai devyni")]
    [InlineData(550, "penki šimtai penkiasdešimt")]
    [InlineData(595, "penki šimtai devyniasdešimt penki")]
    [InlineData(600, "šeši šimtai")]
    [InlineData(601, "šeši šimtai vienas")]
    [InlineData(606, "šeši šimtai šeši")]
    [InlineData(616, "šeši šimtai šešiolika")]
    [InlineData(660, "šeši šimtai šešiasdešimt")]
    [InlineData(700, "septyni šimtai")]
    [InlineData(702, "septyni šimtai du")]
    [InlineData(707, "septyni šimtai septyni")]
    [InlineData(727, "septyni šimtai dvidešimt septyni")]
    [InlineData(770, "septyni šimtai septyniasdešimt")]
    [InlineData(800, "aštuoni šimtai")]
    [InlineData(803, "aštuoni šimtai trys")]
    [InlineData(808, "aštuoni šimtai aštuoni")]
    [InlineData(838, "aštuoni šimtai trisdešimt aštuoni")]
    [InlineData(880, "aštuoni šimtai aštuoniasdešimt")]
    [InlineData(900, "devyni šimtai")]
    [InlineData(904, "devyni šimtai keturi")]
    [InlineData(909, "devyni šimtai devyni")]
    [InlineData(949, "devyni šimtai keturiasdešimt devyni")]
    [InlineData(990, "devyni šimtai devyniasdešimt")]
    [InlineData(1000, "tūkstantis")]
    [InlineData(1001, "tūkstantis vienas")]
    [InlineData(1012, "tūkstantis dvylika")]
    [InlineData(1100, "tūkstantis šimtas")]
    [InlineData(1234, "tūkstantis du šimtai trisdešimt keturi")]
    [InlineData(2000, "du tūkstančiai")]
    [InlineData(2002, "du tūkstančiai du")]
    [InlineData(2023, "du tūkstančiai dvidešimt trys")]
    [InlineData(2345, "du tūkstančiai trys šimtai keturiasdešimt penki")]
    [InlineData(3000, "trys tūkstančiai")]
    [InlineData(3003, "trys tūkstančiai trys")]
    [InlineData(3034, "trys tūkstančiai trisdešimt keturi")]
    [InlineData(3456, "trys tūkstančiai keturi šimtai penkiasdešimt šeši")]
    [InlineData(4000, "keturi tūkstančiai")]
    [InlineData(4004, "keturi tūkstančiai keturi")]
    [InlineData(4045, "keturi tūkstančiai keturiasdešimt penki")]
    [InlineData(4567, "keturi tūkstančiai penki šimtai šešiasdešimt septyni")]
    [InlineData(5000, "penki tūkstančiai")]
    [InlineData(5005, "penki tūkstančiai penki")]
    [InlineData(5056, "penki tūkstančiai penkiasdešimt šeši")]
    [InlineData(5678, "penki tūkstančiai šeši šimtai septyniasdešimt aštuoni")]
    [InlineData(6000, "šeši tūkstančiai")]
    [InlineData(6006, "šeši tūkstančiai šeši")]
    [InlineData(6067, "šeši tūkstančiai šešiasdešimt septyni")]
    [InlineData(6789, "šeši tūkstančiai septyni šimtai aštuoniasdešimt devyni")]
    [InlineData(7000, "septyni tūkstančiai")]
    [InlineData(7007, "septyni tūkstančiai septyni")]
    [InlineData(7078, "septyni tūkstančiai septyniasdešimt aštuoni")]
    [InlineData(7890, "septyni tūkstančiai aštuoni šimtai devyniasdešimt")]
    [InlineData(8000, "aštuoni tūkstančiai")]
    [InlineData(8008, "aštuoni tūkstančiai aštuoni")]
    [InlineData(8089, "aštuoni tūkstančiai aštuoniasdešimt devyni")]
    [InlineData(8901, "aštuoni tūkstančiai devyni šimtai vienas")]
    [InlineData(9000, "devyni tūkstančiai")]
    [InlineData(9009, "devyni tūkstančiai devyni")]
    [InlineData(9012, "devyni tūkstančiai dvylika")]
    [InlineData(9090, "devyni tūkstančiai devyniasdešimt")]
    [InlineData(10000, "dešimt tūkstančių")]
    [InlineData(10001, "dešimt tūkstančių vienas")]
    [InlineData(20020, "dvidešimt tūkstančių dvidešimt")]
    [InlineData(30300, "trisdešimt tūkstančių trys šimtai")]
    [InlineData(44000, "keturiasdešimt keturi tūkstančiai")]
    [InlineData(44231, "keturiasdešimt keturi tūkstančiai du šimtai trisdešimt vienas")]
    [InlineData(100000, "šimtas tūkstančių")]
    [InlineData(500000, "penki šimtai tūkstančių")]
    [InlineData(1000000, "milijonas")]
    [InlineData(6000000, "šeši milijonai")]
    [InlineData(10000000, "dešimt milijonų")]
    [InlineData(70000000, "septyniasdešimt milijonų")]
    [InlineData(100000000, "šimtas milijonų")]
    [InlineData(800000000, "aštuoni šimtai milijonų")]
    [InlineData(9223372036854775807, "devyni kvintilijonai du šimtai dvidešimt trys kvadrilijonai trys šimtai septyniasdešimt du trilijonai trisdešimt šeši milijardai aštuoni šimtai penkiasdešimt keturi milijonai septyni šimtai septyniasdešimt penki tūkstančiai aštuoni šimtai septyni")]
    public void ToWordsMasculine(long number, string expected) =>
        Assert.Equal(expected, number.ToWords(gender: GrammaticalGender.Masculine));

    [Theory]
    [InlineData(-1, "minus viena")]
    [InlineData(0, "nulis")]
    [InlineData(1, "viena")]
    [InlineData(11, "vienuolika")]
    [InlineData(21, "dvidešimt viena")]
    [InlineData(22, "dvidešimt dvi")]
    [InlineData(26, "dvidešimt šešios")]
    [InlineData(30, "trisdešimt")]
    [InlineData(31, "trisdešimt viena")]
    [InlineData(33, "trisdešimt trys")]
    [InlineData(37, "trisdešimt septynios")]
    [InlineData(40, "keturiasdešimt")]
    [InlineData(41, "keturiasdešimt viena")]
    [InlineData(44, "keturiasdešimt keturios")]
    [InlineData(48, "keturiasdešimt aštuonios")]
    [InlineData(50, "penkiasdešimt")]
    [InlineData(51, "penkiasdešimt viena")]
    [InlineData(55, "penkiasdešimt penkios")]
    [InlineData(59, "penkiasdešimt devynios")]
    [InlineData(60, "šešiasdešimt")]
    [InlineData(61, "šešiasdešimt viena")]
    [InlineData(62, "šešiasdešimt dvi")]
    [InlineData(66, "šešiasdešimt šešios")]
    [InlineData(70, "septyniasdešimt")]
    [InlineData(71, "septyniasdešimt viena")]
    [InlineData(73, "septyniasdešimt trys")]
    [InlineData(77, "septyniasdešimt septynios")]
    [InlineData(80, "aštuoniasdešimt")]
    [InlineData(81, "aštuoniasdešimt viena")]
    [InlineData(84, "aštuoniasdešimt keturios")]
    [InlineData(88, "aštuoniasdešimt aštuonios")]
    [InlineData(90, "devyniasdešimt")]
    [InlineData(91, "devyniasdešimt viena")]
    [InlineData(95, "devyniasdešimt penkios")]
    [InlineData(99, "devyniasdešimt devynios")]
    [InlineData(100, "šimtas")]
    [InlineData(101, "šimtas viena")]
    [InlineData(105, "šimtas penkios")]
    [InlineData(110, "šimtas dešimt")]
    [InlineData(151, "šimtas penkiasdešimt viena")]
    [InlineData(200, "du šimtai")]
    [InlineData(202, "du šimtai dvi")]
    [InlineData(206, "du šimtai šešios")]
    [InlineData(220, "du šimtai dvidešimt")]
    [InlineData(262, "du šimtai šešiasdešimt dvi")]
    [InlineData(300, "trys šimtai")]
    [InlineData(303, "trys šimtai trys")]
    [InlineData(307, "trys šimtai septynios")]
    [InlineData(330, "trys šimtai trisdešimt")]
    [InlineData(373, "trys šimtai septyniasdešimt trys")]
    [InlineData(400, "keturi šimtai")]
    [InlineData(404, "keturi šimtai keturios")]
    [InlineData(408, "keturi šimtai aštuonios")]
    [InlineData(440, "keturi šimtai keturiasdešimt")]
    [InlineData(484, "keturi šimtai aštuoniasdešimt keturios")]
    [InlineData(500, "penki šimtai")]
    [InlineData(505, "penki šimtai penkios")]
    [InlineData(509, "penki šimtai devynios")]
    [InlineData(550, "penki šimtai penkiasdešimt")]
    [InlineData(595, "penki šimtai devyniasdešimt penkios")]
    [InlineData(600, "šeši šimtai")]
    [InlineData(601, "šeši šimtai viena")]
    [InlineData(606, "šeši šimtai šešios")]
    [InlineData(616, "šeši šimtai šešiolika")]
    [InlineData(660, "šeši šimtai šešiasdešimt")]
    [InlineData(700, "septyni šimtai")]
    [InlineData(702, "septyni šimtai dvi")]
    [InlineData(707, "septyni šimtai septynios")]
    [InlineData(727, "septyni šimtai dvidešimt septynios")]
    [InlineData(770, "septyni šimtai septyniasdešimt")]
    [InlineData(800, "aštuoni šimtai")]
    [InlineData(803, "aštuoni šimtai trys")]
    [InlineData(808, "aštuoni šimtai aštuonios")]
    [InlineData(838, "aštuoni šimtai trisdešimt aštuonios")]
    [InlineData(880, "aštuoni šimtai aštuoniasdešimt")]
    [InlineData(900, "devyni šimtai")]
    [InlineData(904, "devyni šimtai keturios")]
    [InlineData(909, "devyni šimtai devynios")]
    [InlineData(949, "devyni šimtai keturiasdešimt devynios")]
    [InlineData(990, "devyni šimtai devyniasdešimt")]
    [InlineData(1000, "tūkstantis")]
    [InlineData(1001, "tūkstantis viena")]
    [InlineData(1012, "tūkstantis dvylika")]
    [InlineData(1100, "tūkstantis šimtas")]
    [InlineData(1234, "tūkstantis du šimtai trisdešimt keturios")]
    [InlineData(2000, "du tūkstančiai")]
    [InlineData(2002, "du tūkstančiai dvi")]
    [InlineData(2023, "du tūkstančiai dvidešimt trys")]
    [InlineData(2345, "du tūkstančiai trys šimtai keturiasdešimt penkios")]
    [InlineData(3000, "trys tūkstančiai")]
    [InlineData(3003, "trys tūkstančiai trys")]
    [InlineData(3034, "trys tūkstančiai trisdešimt keturios")]
    [InlineData(3456, "trys tūkstančiai keturi šimtai penkiasdešimt šešios")]
    [InlineData(4000, "keturi tūkstančiai")]
    [InlineData(4004, "keturi tūkstančiai keturios")]
    [InlineData(4045, "keturi tūkstančiai keturiasdešimt penkios")]
    [InlineData(4567, "keturi tūkstančiai penki šimtai šešiasdešimt septynios")]
    [InlineData(5000, "penki tūkstančiai")]
    [InlineData(5005, "penki tūkstančiai penkios")]
    [InlineData(5056, "penki tūkstančiai penkiasdešimt šešios")]
    [InlineData(5678, "penki tūkstančiai šeši šimtai septyniasdešimt aštuonios")]
    [InlineData(6000, "šeši tūkstančiai")]
    [InlineData(6006, "šeši tūkstančiai šešios")]
    [InlineData(6067, "šeši tūkstančiai šešiasdešimt septynios")]
    [InlineData(6789, "šeši tūkstančiai septyni šimtai aštuoniasdešimt devynios")]
    [InlineData(7000, "septyni tūkstančiai")]
    [InlineData(7007, "septyni tūkstančiai septynios")]
    [InlineData(7078, "septyni tūkstančiai septyniasdešimt aštuonios")]
    [InlineData(7890, "septyni tūkstančiai aštuoni šimtai devyniasdešimt")]
    [InlineData(8000, "aštuoni tūkstančiai")]
    [InlineData(8008, "aštuoni tūkstančiai aštuonios")]
    [InlineData(8089, "aštuoni tūkstančiai aštuoniasdešimt devynios")]
    [InlineData(8901, "aštuoni tūkstančiai devyni šimtai viena")]
    [InlineData(9000, "devyni tūkstančiai")]
    [InlineData(9009, "devyni tūkstančiai devynios")]
    [InlineData(9012, "devyni tūkstančiai dvylika")]
    [InlineData(9090, "devyni tūkstančiai devyniasdešimt")]
    [InlineData(10000, "dešimt tūkstančių")]
    [InlineData(10001, "dešimt tūkstančių viena")]
    [InlineData(20020, "dvidešimt tūkstančių dvidešimt")]
    [InlineData(30300, "trisdešimt tūkstančių trys šimtai")]
    [InlineData(44000, "keturiasdešimt keturi tūkstančiai")]
    [InlineData(44231, "keturiasdešimt keturi tūkstančiai du šimtai trisdešimt viena")]
    [InlineData(100000, "šimtas tūkstančių")]
    [InlineData(500000, "penki šimtai tūkstančių")]
    [InlineData(1000000, "milijonas")]
    [InlineData(6000000, "šeši milijonai")]
    [InlineData(10000000, "dešimt milijonų")]
    [InlineData(70000000, "septyniasdešimt milijonų")]
    [InlineData(100000000, "šimtas milijonų")]
    [InlineData(800000000, "aštuoni šimtai milijonų")]
    [InlineData(9223372036854775807, "devyni kvintilijonai du šimtai dvidešimt trys kvadrilijonai trys šimtai septyniasdešimt du trilijonai trisdešimt šeši milijardai aštuoni šimtai penkiasdešimt keturi milijonai septyni šimtai septyniasdešimt penki tūkstančiai aštuoni šimtai septynios")]
    public void ToWordsFeminine(long number, string expected) =>
        Assert.Equal(expected, number.ToWords(gender: GrammaticalGender.Feminine));

    [Theory]
    [InlineData(-1, "minus pirmas")]
    [InlineData(0, "nulinis")]
    [InlineData(1, "pirmas")]
    [InlineData(21, "dvidešimt pirmas")]
    [InlineData(22, "dvidešimt antras")]
    [InlineData(26, "dvidešimt šeštas")]
    [InlineData(30, "trisdešimtas")]
    [InlineData(31, "trisdešimt pirmas")]
    [InlineData(33, "trisdešimt trečias")]
    [InlineData(37, "trisdešimt septintas")]
    [InlineData(40, "keturiasdešimtas")]
    [InlineData(41, "keturiasdešimt pirmas")]
    [InlineData(44, "keturiasdešimt ketvirtas")]
    [InlineData(48, "keturiasdešimt aštuntas")]
    [InlineData(50, "penkiasdešimtas")]
    [InlineData(51, "penkiasdešimt pirmas")]
    [InlineData(55, "penkiasdešimt penktas")]
    [InlineData(59, "penkiasdešimt devintas")]
    [InlineData(60, "šešiasdešimtas")]
    [InlineData(61, "šešiasdešimt pirmas")]
    [InlineData(62, "šešiasdešimt antras")]
    [InlineData(66, "šešiasdešimt šeštas")]
    [InlineData(70, "septyniasdešimtas")]
    [InlineData(71, "septyniasdešimt pirmas")]
    [InlineData(73, "septyniasdešimt trečias")]
    [InlineData(77, "septyniasdešimt septintas")]
    [InlineData(80, "aštuoniasdešimtas")]
    [InlineData(81, "aštuoniasdešimt pirmas")]
    [InlineData(84, "aštuoniasdešimt ketvirtas")]
    [InlineData(88, "aštuoniasdešimt aštuntas")]
    [InlineData(90, "devyniasdešimtas")]
    [InlineData(91, "devyniasdešimt pirmas")]
    [InlineData(95, "devyniasdešimt penktas")]
    [InlineData(99, "devyniasdešimt devintas")]
    [InlineData(100, "šimtas")]
    [InlineData(101, "šimtas pirmas")]
    [InlineData(105, "šimtas penktas")]
    [InlineData(110, "šimtas dešimtas")]
    [InlineData(151, "šimtas penkiasdešimt pirmas")]
    [InlineData(200, "du šimtas")]
    [InlineData(202, "du šimtai antras")]
    [InlineData(206, "du šimtai šeštas")]
    [InlineData(220, "du šimtai dvidešimtas")]
    [InlineData(262, "du šimtai šešiasdešimt antras")]
    [InlineData(300, "trys šimtas")]
    [InlineData(303, "trys šimtai trečias")]
    [InlineData(307, "trys šimtai septintas")]
    [InlineData(330, "trys šimtai trisdešimtas")]
    [InlineData(373, "trys šimtai septyniasdešimt trečias")]
    [InlineData(400, "keturi šimtas")]
    [InlineData(404, "keturi šimtai ketvirtas")]
    [InlineData(408, "keturi šimtai aštuntas")]
    [InlineData(440, "keturi šimtai keturiasdešimtas")]
    [InlineData(484, "keturi šimtai aštuoniasdešimt ketvirtas")]
    [InlineData(500, "penki šimtas")]
    [InlineData(505, "penki šimtai penktas")]
    [InlineData(509, "penki šimtai devintas")]
    [InlineData(550, "penki šimtai penkiasdešimtas")]
    [InlineData(595, "penki šimtai devyniasdešimt penktas")]
    [InlineData(600, "šeši šimtas")]
    [InlineData(601, "šeši šimtai pirmas")]
    [InlineData(606, "šeši šimtai šeštas")]
    [InlineData(616, "šeši šimtai šešioliktas")]
    [InlineData(660, "šeši šimtai šešiasdešimtas")]
    [InlineData(700, "septyni šimtas")]
    [InlineData(702, "septyni šimtai antras")]
    [InlineData(707, "septyni šimtai septintas")]
    [InlineData(727, "septyni šimtai dvidešimt septintas")]
    [InlineData(770, "septyni šimtai septyniasdešimtas")]
    [InlineData(800, "aštuoni šimtas")]
    [InlineData(803, "aštuoni šimtai trečias")]
    [InlineData(808, "aštuoni šimtai aštuntas")]
    [InlineData(838, "aštuoni šimtai trisdešimt aštuntas")]
    [InlineData(880, "aštuoni šimtai aštuoniasdešimtas")]
    [InlineData(900, "devyni šimtas")]
    [InlineData(904, "devyni šimtai ketvirtas")]
    [InlineData(909, "devyni šimtai devintas")]
    [InlineData(949, "devyni šimtai keturiasdešimt devintas")]
    [InlineData(990, "devyni šimtai devyniasdešimtas")]
    [InlineData(1000, "tūkstantas")]
    [InlineData(1001, "tūkstantis pirmas")]
    [InlineData(1012, "tūkstantis dvyliktas")]
    [InlineData(1100, "tūkstantis šimtas")]
    [InlineData(1234, "tūkstantis du šimtai trisdešimt ketvirtas")]
    [InlineData(2000, "du tūkstantas")]
    [InlineData(2002, "du tūkstančiai antras")]
    [InlineData(2023, "du tūkstančiai dvidešimt trečias")]
    [InlineData(2345, "du tūkstančiai trys šimtai keturiasdešimt penktas")]
    [InlineData(3000, "trys tūkstantas")]
    [InlineData(3003, "trys tūkstančiai trečias")]
    [InlineData(3034, "trys tūkstančiai trisdešimt ketvirtas")]
    [InlineData(3456, "trys tūkstančiai keturi šimtai penkiasdešimt šeštas")]
    [InlineData(4000, "keturi tūkstantas")]
    [InlineData(4004, "keturi tūkstančiai ketvirtas")]
    [InlineData(4045, "keturi tūkstančiai keturiasdešimt penktas")]
    [InlineData(4567, "keturi tūkstančiai penki šimtai šešiasdešimt septintas")]
    [InlineData(5000, "penki tūkstantas")]
    [InlineData(5005, "penki tūkstančiai penktas")]
    [InlineData(5056, "penki tūkstančiai penkiasdešimt šeštas")]
    [InlineData(5678, "penki tūkstančiai šeši šimtai septyniasdešimt aštuntas")]
    [InlineData(6000, "šeši tūkstantas")]
    [InlineData(6006, "šeši tūkstančiai šeštas")]
    [InlineData(6067, "šeši tūkstančiai šešiasdešimt septintas")]
    [InlineData(6789, "šeši tūkstančiai septyni šimtai aštuoniasdešimt devintas")]
    [InlineData(7000, "septyni tūkstantas")]
    [InlineData(7007, "septyni tūkstančiai septintas")]
    [InlineData(7078, "septyni tūkstančiai septyniasdešimt aštuntas")]
    [InlineData(7890, "septyni tūkstančiai aštuoni šimtai devyniasdešimtas")]
    [InlineData(8000, "aštuoni tūkstantas")]
    [InlineData(8008, "aštuoni tūkstančiai aštuntas")]
    [InlineData(8089, "aštuoni tūkstančiai aštuoniasdešimt devintas")]
    [InlineData(8901, "aštuoni tūkstančiai devyni šimtai pirmas")]
    [InlineData(9000, "devyni tūkstantas")]
    [InlineData(9009, "devyni tūkstančiai devintas")]
    [InlineData(9012, "devyni tūkstančiai dvyliktas")]
    [InlineData(9090, "devyni tūkstančiai devyniasdešimtas")]
    [InlineData(10000, "dešimt tūkstantas")]
    [InlineData(10001, "dešimt tūkstančių pirmas")]
    [InlineData(20020, "dvidešimt tūkstančių dvidešimtas")]
    [InlineData(30300, "trisdešimt tūkstančių trys šimtas")]
    [InlineData(44000, "keturiasdešimt keturi tūkstantas")]
    [InlineData(44231, "keturiasdešimt keturi tūkstančiai du šimtai trisdešimt pirmas")]
    [InlineData(100000, "šimtas tūkstantas")]
    [InlineData(500000, "penki šimtai tūkstantas")]
    [InlineData(1000000, "milijonas")]
    [InlineData(6000000, "šeši milijonas")]
    [InlineData(10000000, "dešimt milijonas")]
    [InlineData(70000000, "septyniasdešimt milijonas")]
    [InlineData(100000000, "šimtas milijonas")]
    [InlineData(800000000, "aštuoni šimtai milijonas")]
    public void ToOrdinalWordsMasculine(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Masculine));

    [Theory]
    [InlineData(-1, "minus pirma")]
    [InlineData(0, "nulinė")]
    [InlineData(1, "pirma")]
    [InlineData(21, "dvidešimt pirma")]
    [InlineData(22, "dvidešimt antra")]
    [InlineData(26, "dvidešimt šešta")]
    [InlineData(30, "trisdešimta")]
    [InlineData(31, "trisdešimt pirma")]
    [InlineData(33, "trisdešimt trečia")]
    [InlineData(37, "trisdešimt septinta")]
    [InlineData(40, "keturiasdešimta")]
    [InlineData(41, "keturiasdešimt pirma")]
    [InlineData(44, "keturiasdešimt ketvirta")]
    [InlineData(48, "keturiasdešimt aštunta")]
    [InlineData(50, "penkiasdešimta")]
    [InlineData(51, "penkiasdešimt pirma")]
    [InlineData(55, "penkiasdešimt penkta")]
    [InlineData(59, "penkiasdešimt devinta")]
    [InlineData(60, "šešiasdešimta")]
    [InlineData(61, "šešiasdešimt pirma")]
    [InlineData(62, "šešiasdešimt antra")]
    [InlineData(66, "šešiasdešimt šešta")]
    [InlineData(70, "septyniasdešimta")]
    [InlineData(71, "septyniasdešimt pirma")]
    [InlineData(73, "septyniasdešimt trečia")]
    [InlineData(77, "septyniasdešimt septinta")]
    [InlineData(80, "aštuoniasdešimta")]
    [InlineData(81, "aštuoniasdešimt pirma")]
    [InlineData(84, "aštuoniasdešimt ketvirta")]
    [InlineData(88, "aštuoniasdešimt aštunta")]
    [InlineData(90, "devyniasdešimta")]
    [InlineData(91, "devyniasdešimt pirma")]
    [InlineData(95, "devyniasdešimt penkta")]
    [InlineData(99, "devyniasdešimt devinta")]
    [InlineData(100, "šimta")]
    [InlineData(101, "šimtas pirma")]
    [InlineData(105, "šimtas penkta")]
    [InlineData(110, "šimtas dešimta")]
    [InlineData(151, "šimtas penkiasdešimt pirma")]
    [InlineData(200, "du šimta")]
    [InlineData(202, "du šimtai antra")]
    [InlineData(206, "du šimtai šešta")]
    [InlineData(220, "du šimtai dvidešimta")]
    [InlineData(262, "du šimtai šešiasdešimt antra")]
    [InlineData(300, "trys šimta")]
    [InlineData(303, "trys šimtai trečia")]
    [InlineData(307, "trys šimtai septinta")]
    [InlineData(330, "trys šimtai trisdešimta")]
    [InlineData(373, "trys šimtai septyniasdešimt trečia")]
    [InlineData(400, "keturi šimta")]
    [InlineData(404, "keturi šimtai ketvirta")]
    [InlineData(408, "keturi šimtai aštunta")]
    [InlineData(440, "keturi šimtai keturiasdešimta")]
    [InlineData(484, "keturi šimtai aštuoniasdešimt ketvirta")]
    [InlineData(500, "penki šimta")]
    [InlineData(505, "penki šimtai penkta")]
    [InlineData(509, "penki šimtai devinta")]
    [InlineData(550, "penki šimtai penkiasdešimta")]
    [InlineData(595, "penki šimtai devyniasdešimt penkta")]
    [InlineData(600, "šeši šimta")]
    [InlineData(601, "šeši šimtai pirma")]
    [InlineData(606, "šeši šimtai šešta")]
    [InlineData(616, "šeši šimtai šešiolikta")]
    [InlineData(660, "šeši šimtai šešiasdešimta")]
    [InlineData(700, "septyni šimta")]
    [InlineData(702, "septyni šimtai antra")]
    [InlineData(707, "septyni šimtai septinta")]
    [InlineData(727, "septyni šimtai dvidešimt septinta")]
    [InlineData(770, "septyni šimtai septyniasdešimta")]
    [InlineData(800, "aštuoni šimta")]
    [InlineData(803, "aštuoni šimtai trečia")]
    [InlineData(808, "aštuoni šimtai aštunta")]
    [InlineData(838, "aštuoni šimtai trisdešimt aštunta")]
    [InlineData(880, "aštuoni šimtai aštuoniasdešimta")]
    [InlineData(900, "devyni šimta")]
    [InlineData(904, "devyni šimtai ketvirta")]
    [InlineData(909, "devyni šimtai devinta")]
    [InlineData(949, "devyni šimtai keturiasdešimt devinta")]
    [InlineData(990, "devyni šimtai devyniasdešimta")]
    [InlineData(1000, "tūkstanta")]
    [InlineData(1001, "tūkstantis pirma")]
    [InlineData(1012, "tūkstantis dvylikta")]
    [InlineData(1100, "tūkstantis šimta")]
    [InlineData(1234, "tūkstantis du šimtai trisdešimt ketvirta")]
    [InlineData(2000, "du tūkstanta")]
    [InlineData(2002, "du tūkstančiai antra")]
    [InlineData(2023, "du tūkstančiai dvidešimt trečia")]
    [InlineData(2345, "du tūkstančiai trys šimtai keturiasdešimt penkta")]
    [InlineData(3000, "trys tūkstanta")]
    [InlineData(3003, "trys tūkstančiai trečia")]
    [InlineData(3034, "trys tūkstančiai trisdešimt ketvirta")]
    [InlineData(3456, "trys tūkstančiai keturi šimtai penkiasdešimt šešta")]
    [InlineData(4000, "keturi tūkstanta")]
    [InlineData(4004, "keturi tūkstančiai ketvirta")]
    [InlineData(4045, "keturi tūkstančiai keturiasdešimt penkta")]
    [InlineData(4567, "keturi tūkstančiai penki šimtai šešiasdešimt septinta")]
    [InlineData(5000, "penki tūkstanta")]
    [InlineData(5005, "penki tūkstančiai penkta")]
    [InlineData(5056, "penki tūkstančiai penkiasdešimt šešta")]
    [InlineData(5678, "penki tūkstančiai šeši šimtai septyniasdešimt aštunta")]
    [InlineData(6000, "šeši tūkstanta")]
    [InlineData(6006, "šeši tūkstančiai šešta")]
    [InlineData(6067, "šeši tūkstančiai šešiasdešimt septinta")]
    [InlineData(6789, "šeši tūkstančiai septyni šimtai aštuoniasdešimt devinta")]
    [InlineData(7000, "septyni tūkstanta")]
    [InlineData(7007, "septyni tūkstančiai septinta")]
    [InlineData(7078, "septyni tūkstančiai septyniasdešimt aštunta")]
    [InlineData(7890, "septyni tūkstančiai aštuoni šimtai devyniasdešimta")]
    [InlineData(8000, "aštuoni tūkstanta")]
    [InlineData(8008, "aštuoni tūkstančiai aštunta")]
    [InlineData(8089, "aštuoni tūkstančiai aštuoniasdešimt devinta")]
    [InlineData(8901, "aštuoni tūkstančiai devyni šimtai pirma")]
    [InlineData(9000, "devyni tūkstanta")]
    [InlineData(9009, "devyni tūkstančiai devinta")]
    [InlineData(9012, "devyni tūkstančiai dvylikta")]
    [InlineData(9090, "devyni tūkstančiai devyniasdešimta")]
    [InlineData(10000, "dešimt tūkstanta")]
    [InlineData(10001, "dešimt tūkstančių pirma")]
    [InlineData(20020, "dvidešimt tūkstančių dvidešimta")]
    [InlineData(30300, "trisdešimt tūkstančių trys šimta")]
    [InlineData(44000, "keturiasdešimt keturi tūkstanta")]
    [InlineData(44231, "keturiasdešimt keturi tūkstančiai du šimtai trisdešimt pirma")]
    [InlineData(100000, "šimtas tūkstanta")]
    [InlineData(500000, "penki šimtai tūkstanta")]
    [InlineData(1000000, "milijona")]
    [InlineData(6000000, "šeši milijona")]
    [InlineData(10000000, "dešimt milijona")]
    [InlineData(70000000, "septyniasdešimt milijona")]
    [InlineData(100000000, "šimtas milijona")]
    [InlineData(800000000, "aštuoni šimtai milijona")]
    public void ToOrdinalWordsFeminine(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Feminine));
}