﻿namespace lb;

[UseCulture("lb-LU")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(0, "null")]
    [InlineData(1, "een")]
    [InlineData(2, "zwee")]
    [InlineData(3, "dräi")]
    [InlineData(4, "véier")]
    [InlineData(5, "fënnef")]
    [InlineData(6, "sechs")]
    [InlineData(7, "siwen")]
    [InlineData(8, "aacht")]
    [InlineData(9, "néng")]
    [InlineData(10, "zéng")]
    [InlineData(20, "zwanzeg")]
    [InlineData(30, "drësseg")]
    [InlineData(40, "véierzeg")]
    [InlineData(50, "fofzeg")]
    [InlineData(60, "sechzeg")]
    [InlineData(70, "siwwenzeg")]
    [InlineData(80, "achtzeg")]
    [InlineData(90, "nonzeg")]
    [InlineData(100, "eenhonnert")]
    [InlineData(200, "zweehonnert")]
    [InlineData(1000, "eendausend")]
    [InlineData(10000, "zéngdausend")]
    [InlineData(100000, "eenhonnertdausend")]
    [InlineData(1000000, "eng Millioun")]
    [InlineData(10000000, "zéng Milliounen")]
    [InlineData(100000000, "eenhonnert Milliounen")]
    [InlineData(1000000000, "eng Milliard")]
    [InlineData(2000000000, "zwou Milliarden")]
    [InlineData(122, "eenhonnertzweeanzwanzeg")]
    [InlineData(3501, "dräidausendfënnefhonnerteen")]
    [InlineData(111, "eenhonnerteelef")]
    [InlineData(1112, "eendausendeenhonnertzwielef")]
    [InlineData(11213, "eelefdausendzweehonnertdräizéng")]
    [InlineData(121314, "eenhonnerteenanzwanzegdausenddräihonnertvéierzéng")]
    [InlineData(2132415, "zwou Milliounen eenhonnertzweeandrëssegdausendvéierhonnertfofzéng")]
    [InlineData(12345516, "zwielef Milliounen dräihonnertfënnefavéierzegdausendfënnefhonnertsiechzéng")]
    [InlineData(751633617, "siwenhonnerteenafofzeg Milliounen sechshonnertdräiandrëssegdausendsechshonnertsiwwenzéng")]
    [InlineData(1111111118, "eng Milliard eenhonnerteelef Milliounen eenhonnerteelefdausendeenhonnertuechtzéng")]
    [InlineData(35484694489515, "fënnefandrësseg Billiounen véierhonnertvéieranachtzeg Milliarden sechshonnertvéierannonzeg Milliounen véierhonnertnénganachtzegdausendfënnefhonnertfofzéng")]
    [InlineData(8183162164626926, "aacht Billiarden eenhonnertdräianachtzeg Billiounen eenhonnertzweeasechzeg Milliarden eenhonnertvéierasechzeg Milliounen sechshonnertsechsanzwanzegdausendnénghonnertsechsanzwanzeg")]
    [InlineData(4564121926659524672, "véier Trilliounen fënnefhonnertvéierasechzeg Billiarden eenhonnerteenanzwanzeg Billiounen nénghonnertsechsanzwanzeg Milliarden sechshonnertnéngafofzeg Milliounen fënnefhonnertvéieranzwanzegdausendsechshonnertzweeasiwwenzeg")]
    [InlineData(-751633619, "minus siwenhonnerteenafofzeg Milliounen sechshonnertdräiandrëssegdausendsechshonnertnonzéng")]
    public void ToWords(long number, string expected) =>
        Assert.Equal(expected, number.ToWords());

    [Theory]
    [InlineData(1, "eng")]
    [InlineData(2, "zwou")]
    [InlineData(3501, "dräidausendfënnefhonnerteng")]
    [InlineData(3502, "dräidausendfënnefhonnertzwou")]
    public void ToWordsFeminine(long number, string expected) =>
        Assert.Equal(expected, number.ToWords(GrammaticalGender.Feminine));

    [Theory]
    [InlineData(0, "nullten")]
    [InlineData(1, "éischten")]
    [InlineData(2, "zweeten")]
    [InlineData(3, "drëtten")]
    [InlineData(4, "véierten")]
    [InlineData(5, "fënneften")]
    [InlineData(6, "sechsten")]
    [InlineData(7, "siwenten")]
    [InlineData(8, "aachten")]
    [InlineData(9, "néngten")]
    [InlineData(10, "zéngten")]
    [InlineData(20, "zwanzegsten")]
    [InlineData(30, "drëssegsten")]
    [InlineData(40, "véierzegsten")]
    [InlineData(50, "fofzegsten")]
    [InlineData(60, "sechzegsten")]
    [InlineData(70, "siwwenzegsten")]
    [InlineData(80, "achtzegsten")]
    [InlineData(90, "nonzegsten")]
    [InlineData(100, "eenhonnertsten")]
    [InlineData(200, "zweehonnertsten")]
    [InlineData(1000, "eendausendsten")]
    [InlineData(10000, "zéngdausendsten")]
    [InlineData(100000, "eenhonnertdausendsten")]
    [InlineData(1000000, "eemilliounsten")]
    [InlineData(10000000, "zéngmilliounsten")]
    [InlineData(100000000, "eenhonnertmilliounsten")]
    [InlineData(1000000000, "eemilliardsten")]
    [InlineData(2000000000, "zwoumilliardsten")]
    [InlineData(122, "eenhonnertzweeanzwanzegsten")]
    [InlineData(3501, "dräidausendfënnefhonnertéischten")]
    [InlineData(111, "eenhonnerteeleften")]
    [InlineData(1112, "eendausendeenhonnertzwieleften")]
    [InlineData(11213, "eelefdausendzweehonnertdräizéngten")]
    [InlineData(121314, "eenhonnerteenanzwanzegdausenddräihonnertvéierzéngten")]
    [InlineData(2132415, "zwoumilliouneneenhonnertzweeandrëssegdausendvéierhonnertfofzéngten")]
    [InlineData(12345516, "zwielefmilliounendräihonnertfënnefavéierzegdausendfënnefhonnertsiechzéngten")]
    [InlineData(751633617, "siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertsiwwenzéngten")]
    [InlineData(1111111118, "engmilliardeenhonnerteelefmilliouneneenhonnerteelefdausendeenhonnertuechtzéngten")]
    [InlineData(-751633619, "minus siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertnonzéngten")]
    public void ToOrdinalWords(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords());

    [Theory]
    [InlineData(0, "nullt")]
    [InlineData(1, "éischt")]
    [InlineData(2, "zweet")]
    [InlineData(3, "drëtt")]
    [InlineData(4, "véiert")]
    [InlineData(5, "fënneft")]
    [InlineData(6, "sechst")]
    [InlineData(7, "siwent")]
    [InlineData(8, "aacht")]
    [InlineData(9, "néngt")]
    [InlineData(10, "zéngt")]
    [InlineData(111, "eenhonnerteeleft")]
    [InlineData(1112, "eendausendeenhonnertzwieleft")]
    [InlineData(11213, "eelefdausendzweehonnertdräizéngt")]
    [InlineData(121314, "eenhonnerteenanzwanzegdausenddräihonnertvéierzéngt")]
    [InlineData(2132415, "zwoumilliouneneenhonnertzweeandrëssegdausendvéierhonnertfofzéngt")]
    [InlineData(12345516, "zwielefmilliounendräihonnertfënnefavéierzegdausendfënnefhonnertsiechzéngt")]
    [InlineData(751633617, "siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertsiwwenzéngt")]
    [InlineData(1111111118, "engmilliardeenhonnerteelefmilliouneneenhonnerteelefdausendeenhonnertuechtzéngt")]
    [InlineData(-751633619, "minus siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertnonzéngt")]
    public void ToOrdinalWordsFeminine(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Feminine));

    [Theory]
    [InlineData(0, "nullt")]
    [InlineData(1, "éischt")]
    [InlineData(2, "zweet")]
    [InlineData(3, "drëtt")]
    [InlineData(4, "véiert")]
    [InlineData(5, "fënneft")]
    [InlineData(6, "sechst")]
    [InlineData(7, "siwent")]
    [InlineData(8, "aacht")]
    [InlineData(9, "néngt")]
    [InlineData(10, "zéngt")]
    [InlineData(111, "eenhonnerteeleft")]
    [InlineData(1112, "eendausendeenhonnertzwieleft")]
    [InlineData(11213, "eelefdausendzweehonnertdräizéngt")]
    [InlineData(121314, "eenhonnerteenanzwanzegdausenddräihonnertvéierzéngt")]
    [InlineData(2132415, "zwoumilliouneneenhonnertzweeandrëssegdausendvéierhonnertfofzéngt")]
    [InlineData(12345516, "zwielefmilliounendräihonnertfënnefavéierzegdausendfënnefhonnertsiechzéngt")]
    [InlineData(751633617, "siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertsiwwenzéngt")]
    [InlineData(1111111118, "engmilliardeenhonnerteelefmilliouneneenhonnerteelefdausendeenhonnertuechtzéngt")]
    [InlineData(-751633619, "minus siwenhonnerteenafofzegmilliounensechshonnertdräiandrëssegdausendsechshonnertnonzéngt")]
    public void ToOrdinalWordsNeuter(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords(GrammaticalGender.Neuter));
}
