﻿namespace hy;

[UseCulture("hy")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(0, "զրո")]
    [InlineData(1, "մեկ")]
    [InlineData(10, "տաս")]
    [InlineData(11, "տասնմեկ")]
    [InlineData(12, "տասներկու")]
    [InlineData(13, "տասներեք")]
    [InlineData(14, "տասնչորս")]
    [InlineData(15, "տասնհինգ")]
    [InlineData(16, "տասնվեց")]
    [InlineData(17, "տասնյոթ")]
    [InlineData(18, "տասնութ")]
    [InlineData(19, "տասնինը")]
    [InlineData(20, "քսան")]
    [InlineData(30, "երեսուն")]
    [InlineData(40, "քառասուն")]
    [InlineData(50, "հիսուն")]
    [InlineData(60, "վաթսուն")]
    [InlineData(70, "յոթանասուն")]
    [InlineData(80, "ութսուն")]
    [InlineData(90, "իննսուն")]
    [InlineData(100, "հարյուր")]
    [InlineData(200, "երկու հարյուր")]
    [InlineData(300, "երեք հարյուր")]
    [InlineData(400, "չորս հարյուր")]
    [InlineData(500, "հինգ հարյուր")]
    [InlineData(600, "վեց հարյուր")]
    [InlineData(700, "յոթ հարյուր")]
    [InlineData(800, "ութ հարյուր")]
    [InlineData(900, "ինը հարյուր")]
    [InlineData(1000, "հազար")]
    [InlineData(2000, "երկու հազար")]
    [InlineData(3000, "երեք հազար")]
    [InlineData(4000, "չորս հազար")]
    [InlineData(5000, "հինգ հազար")]
    [InlineData(10000, "տաս հազար")]
    [InlineData(100000, "հարյուր հազար")]
    [InlineData(1000000, "մեկ միլիոն")]
    [InlineData(2000000, "երկու միլիոն")]
    [InlineData(10000000, "տաս միլիոն")]
    [InlineData(100000000, "հարյուր միլիոն")]
    [InlineData(1000000000, "մեկ միլիարդ")]
    [InlineData(2000000000, "երկու միլիարդ")]
    [InlineData(3000000000, "երեք միլիարդ")]
    [InlineData(4000000000, "չորս միլիարդ")]
    [InlineData(122, "հարյուր քսաներկու")]
    [InlineData(3501, "երեք հազար հինգ հարյուր մեկ")]
    [InlineData(111, "հարյուր տասնմեկ")]
    [InlineData(1112, "հազար հարյուր տասներկու")]
    [InlineData(11213, "տասնմեկ հազար երկու հարյուր տասներեք")]
    [InlineData(121314, "հարյուր քսանմեկ հազար երեք հարյուր տասնչորս")]
    [InlineData(2132415, "երկու միլիոն հարյուր երեսուներկու հազար չորս հարյուր տասնհինգ")]
    [InlineData(12345516, "տասներկու միլիոն երեք հարյուր քառասունհինգ հազար հինգ հարյուր տասնվեց")]
    [InlineData(751633617, "յոթ հարյուր հիսունմեկ միլիոն վեց հարյուր երեսուներեք հազար վեց հարյուր տասնյոթ")]
    [InlineData(1111111118, "մեկ միլիարդ հարյուր տասնմեկ միլիոն հարյուր տասնմեկ հազար հարյուր տասնութ")]
    [InlineData(4111111118, "չորս միլիարդ հարյուր տասնմեկ միլիոն հարյուր տասնմեկ հազար հարյուր տասնութ")]
    [InlineData(-751633617, "մինուս յոթ հարյուր հիսունմեկ միլիոն վեց հարյուր երեսուներեք հազար վեց հարյուր տասնյոթ")]
    [InlineData(999999999999, "ինը հարյուր իննսունինը միլիարդ ինը հարյուր իննսունինը միլիոն ինը հարյուր իննսունինը հազար ինը հարյուր իննսունինը")]
    [InlineData(1_000_000_000_000, "մեկ տրիլիոն")]
    [InlineData(3_000_000_000_000, "երեք տրիլիոն")]
    [InlineData(5_000_000_000_000, "հինգ տրիլիոն")]
    [InlineData(999_000_000_000_000, "ինը հարյուր իննսունինը տրիլիոն")]
    [InlineData(
        long.MaxValue,
        "ինը քվինտիլիոն " +
        "երկու հարյուր քսաներեք կվադրիլիոն " +
        "երեք հարյուր յոթանասուներկու տրիլիոն " +
        "երեսունվեց միլիարդ " +
        "ութ հարյուր հիսունչորս միլիոն " +
        "յոթ հարյուր յոթանասունհինգ հազար " +
        "ութ հարյուր յոթ")]
    [InlineData(
        long.MinValue,
        "մինուս ինը քվինտիլիոն " +
        "երկու հարյուր քսաներեք կվադրիլիոն " +
        "երեք հարյուր յոթանասուներկու տրիլիոն " +
        "երեսունվեց միլիարդ " +
        "ութ հարյուր հիսունչորս միլիոն " +
        "յոթ հարյուր յոթանասունհինգ հազար " +
        "ութ հարյուր ութ")]
    public void ToWords(long number, string expected) =>
        Assert.Equal(expected, number.ToWords());

    [Theory]
    [InlineData(0, "զրոյական")]
    [InlineData(1, "առաջին")]
    [InlineData(2, "երկրորդ")]
    [InlineData(3, "երրորդ")]
    [InlineData(10, "տասերորդ")]
    [InlineData(11, "տասնմեկերորդ")]
    [InlineData(12, "տասներկուերորդ")]
    [InlineData(13, "տասներեքերորդ")]
    [InlineData(14, "տասնչորսերորդ")]
    [InlineData(15, "տասնհինգերորդ")]
    [InlineData(16, "տասնվեցերորդ")]
    [InlineData(17, "տասնյոթերորդ")]
    [InlineData(18, "տասնութերորդ")]
    [InlineData(19, "տասնինըերորդ")]
    [InlineData(20, "քսաներորդ")]
    [InlineData(30, "երեսուներորդ")]
    [InlineData(40, "քառասուներորդ")]
    [InlineData(50, "հիսուներորդ")]
    [InlineData(60, "վաթսուներորդ")]
    [InlineData(70, "յոթանասուներորդ")]
    [InlineData(80, "ութսուներորդ")]
    [InlineData(90, "իննսուներորդ")]
    [InlineData(100, "հարյուրերորդ")]
    [InlineData(200, "երկու հարյուրերորդ")]
    [InlineData(300, "երեք հարյուրերորդ")]
    [InlineData(400, "չորս հարյուրերորդ")]
    [InlineData(500, "հինգ հարյուրերորդ")]
    [InlineData(600, "վեց հարյուրերորդ")]
    [InlineData(700, "յոթ հարյուրերորդ")]
    [InlineData(800, "ութ հարյուրերորդ")]
    [InlineData(900, "ինը հարյուրերորդ")]
    [InlineData(1000, "հազարերորդ")]
    [InlineData(2000, "երկու հազարերորդ")]
    [InlineData(3000, "երեք հազարերորդ")]
    [InlineData(4000, "չորս հազարերորդ")]
    [InlineData(5000, "հինգ հազարերորդ")]
    [InlineData(10000, "տաս հազարերորդ")]
    [InlineData(21000, "քսանմեկ հազարերորդ")]
    [InlineData(100000, "հարյուր հազարերորդ")]
    [InlineData(101000, "հարյուր մեկ հազարերորդ")]
    [InlineData(1000000, "մեկ միլիոներորդ")]
    [InlineData(121000, "հարյուր քսանմեկ հազարերորդ")]
    [InlineData(200000, "երկու հարյուր հազարերորդ")]
    [InlineData(2000000, "երկու միլիոներորդ")]
    [InlineData(10000000, "տաս միլիոներորդ")]
    [InlineData(21000000, "քսանմեկ միլիոներորդ")]
    [InlineData(100000000, "հարյուր միլիոներորդ")]
    [InlineData(230000000, "երկու հարյուր երեսուն միլիոներորդ")]
    [InlineData(1000000000, "մեկ միլիարդերորդ")]
    [InlineData(2000000000, "երկու միլիարդերորդ")]
    [InlineData(122, "հարյուր քսաներկուերորդ")]
    [InlineData(3501, "երեք հազար հինգ հարյուր մեկերորդ")]
    [InlineData(111, "հարյուր տասնմեկերորդ")]
    [InlineData(1112, "հազար հարյուր տասներկուերորդ")]
    [InlineData(11213, "տասնմեկ հազար երկու հարյուր տասներեքերորդ")]
    [InlineData(121314, "հարյուր քսանմեկ հազար երեք հարյուր տասնչորսերորդ")]
    [InlineData(2132415, "երկու միլիոն հարյուր երեսուներկու հազար չորս հարյուր տասնհինգերորդ")]
    [InlineData(12345516, "տասներկու միլիոն երեք հարյուր քառասունհինգ հազար հինգ հարյուր տասնվեցերորդ")]
    [InlineData(751633617, "յոթ հարյուր հիսունմեկ միլիոն վեց հարյուր երեսուներեք հազար վեց հարյուր տասնյոթերորդ")]
    [InlineData(1111111118, "մեկ միլիարդ հարյուր տասնմեկ միլիոն հարյուր տասնմեկ հազար հարյուր տասնութերորդ")]
    [InlineData(1111111000, "մեկ միլիարդ հարյուր տասնմեկ միլիոն հարյուր տասնմեկ հազարերորդ")]
    [InlineData(1234567000, "մեկ միլիարդ երկու հարյուր երեսունչորս միլիոն հինգ հարյուր վաթսունյոթ հազարերորդ")]
    [InlineData(-751633617, "մինուս յոթ հարյուր հիսունմեկ միլիոն վեց հարյուր երեսուներեք հազար վեց հարյուր տասնյոթերորդ")]
    public void ToOrdinalWords(int number, string expected) =>
        Assert.Equal(expected, number.ToOrdinalWords());
}