namespace hu;

[UseCulture("hu-HU")]
public class NumberToWordsTests
{
    private readonly HungarianNumberToWordsConverter converter = new();

    [Theory]
    [InlineData(0, "nulla")]
    [InlineData(1, "egy")]
    [InlineData(2, "kettő")]
    [InlineData(10, "tíz")]
    [InlineData(11, "tizenegy")]
    [InlineData(20, "húsz")]
    [InlineData(21, "huszonegy")]
    [InlineData(100, "száz")]
    [InlineData(101, "százegy")]
    [InlineData(111, "száztizenegy")]
    [InlineData(200, "kétszáz")]
    [InlineData(999, "kilencszázkilencvenkilenc")]
    [InlineData(1000, "ezer")]
    [InlineData(1001, "ezeregy")]
    [InlineData(1002, "ezerkettő")]
    [InlineData(1111, "ezerszáztizenegy")]
    [InlineData(2000, "kétezer")]
    [InlineData(2001, "kétezer-egy")]
    [InlineData(2002, "kétezer-kettő")]
    [InlineData(2111, "kétezer-száztizenegy")]
    [InlineData(3000, "háromezer")]
    [InlineData(3001, "háromezer-egy")]
    [InlineData(3002, "háromezer-kettő")]
    [InlineData(3122, "háromezer-százhuszonkettő")]
    [InlineData(12345, "tizenkétezer-háromszáznegyvenöt")]
    [InlineData(123456, "százhuszonháromezer-négyszázötvenhat")]
    [InlineData(1234567, "egymillió-kétszázharmincnégyezer-ötszázhatvanhét")]
    [InlineData(12345678, "tizenkétmillió-háromszáznegyvenötezer-hatszázhetvennyolc")]
    [InlineData(123456789, "százhuszonhárommillió-négyszázötvenhatezer-hétszáznyolcvankilenc")]
    [InlineData(1234567890, "egymilliárd-kétszázharmincnégymillió-ötszázhatvanhétezer-nyolcszázkilencven")]
    [InlineData(1000000, "egymillió")]
    [InlineData(2000000, "kétmillió")]
    [InlineData(12000000, "tizenkétmillió")]
    [InlineData(-1, "mínusz egy")]
    [InlineData(-18, "mínusz tizennyolc")]
    public void TestNumberConversion(long number, string expected) =>
        Assert.Equal(expected, converter.Convert(number));


    [Theory]
    [InlineData(0, "nulladik")]
    [InlineData(1, "első")]
    [InlineData(2, "második")]
    [InlineData(10, "tizedik")]
    [InlineData(11, "tizenegyedik")]
    [InlineData(20, "huszadik")]
    [InlineData(21, "huszonegyedik")]
    [InlineData(100, "századik")]
    [InlineData(101, "százegyedik")]
    [InlineData(111, "száztizenegyedik")]
    [InlineData(200, "kétszázadik")]
    [InlineData(999, "kilencszázkilencvenkilencedik")]
    [InlineData(1000, "ezredik")]
    [InlineData(1001, "ezeregyedik")]
    [InlineData(1002, "ezerkettedik")]
    [InlineData(1111, "ezerszáztizenegyedik")]
    [InlineData(2000, "kétezredik")]
    [InlineData(2001, "kétezer-egyedik")]
    [InlineData(2002, "kétezer-kettedik")]
    [InlineData(2111, "kétezer-száztizenegyedik")]
    [InlineData(3000, "háromezredik")]
    [InlineData(3001, "háromezer-egyedik")]
    [InlineData(3002, "háromezer-kettedik")]
    [InlineData(3122, "háromezer-százhuszonkettedik")]
    [InlineData(12345, "tizenkétezer-háromszáznegyvenötödik")]
    [InlineData(123456, "százhuszonháromezer-négyszázötvenhatodik")]
    [InlineData(1234567, "egymillió-kétszázharmincnégyezer-ötszázhatvanhetedik")]
    [InlineData(12345678, "tizenkétmillió-háromszáznegyvenötezer-hatszázhetvennyolcadik")]
    [InlineData(123456789, "százhuszonhárommillió-négyszázötvenhatezer-hétszáznyolcvankilencedik")]
    [InlineData(1234567890, "egymilliárd-kétszázharmincnégymillió-ötszázhatvanhétezer-nyolcszázkilencvenedik")]
    [InlineData(1000000, "egymilliomodik")]
    [InlineData(2000000, "kétmilliomodik")]
    [InlineData(12000000, "tizenkétmilliomodik")]
    [InlineData(-1, "mínusz első")]
    [InlineData(-18, "mínusz tizennyolcadik")]
    public void TestOrdinalConversion(int number, string expected) =>
        Assert.Equal(expected, converter.ConvertToOrdinal(number));

}