﻿namespace hr;

[UseCulture("hr-HR")]
public class NumberToWordsTests
{
    [Theory]
    [InlineData(0, "nula")]
    [InlineData(1, "jedan")]
    [InlineData(10, "deset")]
    [InlineData(11, "jedanaest")]
    [InlineData(20, "dvadeset")]
    [InlineData(122, "sto dvadeset dva")]
    [InlineData(3501, "tri tisuće petsto jedan")]
    [InlineData(100, "sto")]
    [InlineData(200, "dvjesto")]
    [InlineData(300, "tristo")]
    [InlineData(400, "četiristo")]
    [InlineData(500, "petsto")]
    [InlineData(1000, "tisuću")]
    [InlineData(1001, "tisuću jedan")]
    [InlineData(2000, "dvije tisuće")]
    [InlineData(3000, "tri tisuće")]
    [InlineData(4000, "četiri tisuće")]
    [InlineData(5000, "pet tisuća")]
    [InlineData(10000, "deset tisuća")]
    [InlineData(20000, "dvadeset tisuća")]
    [InlineData(21000, "dvadeset jedna tisuća")]
    [InlineData(22000, "dvadeset dvije tisuće")]
    [InlineData(23000, "dvadeset tri tisuće")]
    [InlineData(24000, "dvadeset četiri tisuće")]
    [InlineData(25000, "dvadeset pet tisuća")]
    [InlineData(100000, "sto tisuća")]
    [InlineData(200000, "dvjesto tisuća")]
    [InlineData(201000, "dvjesto jedna tisuća")]
    [InlineData(202000, "dvjesto dvije tisuće")]
    [InlineData(203000, "dvjesto tri tisuće")]
    [InlineData(204000, "dvjesto četiri tisuće")]
    [InlineData(205000, "dvjesto pet tisuća")]
    [InlineData(222222, "dvjesto dvadeset dvije tisuće dvjesto dvadeset dva")]
    [InlineData(1000000, "milijun")]
    [InlineData(2000000, "dva milijuna")]
    [InlineData(10000000, "deset milijuna")]
    [InlineData(11000000, "jedanaest milijuna")]
    [InlineData(20000000, "dvadeset milijuna")]
    [InlineData(21000000, "dvadeset jedan milijun")]
    [InlineData(22000000, "dvadeset dva milijuna")]
    [InlineData(30000000, "trideset milijuna")]
    [InlineData(31000000, "trideset jedan milijun")]
    [InlineData(32000000, "trideset dva milijuna")]
    [InlineData(100000000, "sto milijuna")]
    [InlineData(101000000, "sto jedan milijun")]
    [InlineData(102000000, "sto dva milijuna")]
    [InlineData(111000000, "sto jedanaest milijuna")]
    [InlineData(200000000, "dvjesto milijuna")]
    [InlineData(201000000, "dvjesto jedan milijun")]
    [InlineData(202000000, "dvjesto dva milijuna")]
    [InlineData(211000000, "dvjesto jedanaest milijuna")]
    [InlineData(1000000000, "milijarda")]
    [InlineData(2100000000, "dvije milijarde sto milijuna")]
    [InlineData(2200000000, "dvije milijarde dvjesto milijuna")]
    [InlineData(2300000000, "dvije milijarde tristo milijuna")]
    [InlineData(2500000000, "dvije milijarde petsto milijuna")]
    [InlineData(10000000000, "deset milijardi")]
    [InlineData(11000000000, "jedanaest milijardi")]
    [InlineData(20000000000, "dvadeset milijardi")]
    [InlineData(21000000000, "dvadeset jedna milijarda")]
    [InlineData(22000000000, "dvadeset dvije milijarde")]
    [InlineData(23000000000, "dvadeset tri milijarde")]
    [InlineData(24000000000, "dvadeset četiri milijarde")]
    [InlineData(25000000000, "dvadeset pet milijardi")]
    [InlineData(111, "sto jedanaest")]
    [InlineData(1111, "tisuću sto jedanaest")]
    [InlineData(111111, "sto jedanaest tisuća sto jedanaest")]
    [InlineData(1111111, "milijun sto jedanaest tisuća sto jedanaest")]
    [InlineData(11111111, "jedanaest milijuna sto jedanaest tisuća sto jedanaest")]
    [InlineData(111111111, "sto jedanaest milijuna sto jedanaest tisuća sto jedanaest")]
    [InlineData(1111111111, "milijarda sto jedanaest milijuna sto jedanaest tisuća sto jedanaest")]
    [InlineData(101, "sto jedan")]
    [InlineData(1011, "tisuću jedanaest")]
    [InlineData(100011, "sto tisuća jedanaest")]
    [InlineData(1100001, "milijun sto tisuća jedan")]
    [InlineData(11000011, "jedanaest milijuna jedanaest")]
    [InlineData(110000011, "sto deset milijuna jedanaest")]
    [InlineData(1100000111, "milijarda sto milijuna sto jedanaest")]
    [InlineData(123, "sto dvadeset tri")]
    [InlineData(1234, "tisuću dvjesto trideset četiri")]
    [InlineData(12345, "dvanaest tisuća tristo četrdeset pet")]
    [InlineData(123456, "sto dvadeset tri tisuće četiristo pedeset šest")]
    [InlineData(1234567, "milijun dvjesto trideset četiri tisuće petsto šezdeset sedam")]
    [InlineData(12345678, "dvanaest milijuna tristo četrdeset pet tisuća šeststo sedamdeset osam")]
    [InlineData(123456789, "sto dvadeset tri milijuna četiristo pedeset šest tisuća sedamsto osamdeset devet")]
    [InlineData(1234567890, "milijarda dvjesto trideset četiri milijuna petsto šezdeset sedam tisuća osamsto devedeset")]
    [InlineData(1000000000000, "bilijun")]
    [InlineData(2000000000000, "dva bilijuna")]
    [InlineData(10000000000000, "deset bilijuna")]
    [InlineData(11000000000000, "jedanaest bilijuna")]
    [InlineData(20000000000000, "dvadeset bilijuna")]
    [InlineData(21000000000000, "dvadeset jedan bilijun")]
    [InlineData(22000000000000, "dvadeset dva bilijuna")]
    [InlineData(45678912345678, "četrdeset pet bilijuna šeststo sedamdeset osam milijardi devetsto dvanaest milijuna tristo četrdeset pet tisuća šeststo sedamdeset osam")]
    [InlineData(1000000000000000, "bilijarda")]
    [InlineData(2000000000000000, "dvije bilijarde")]
    [InlineData(3000000000000000, "tri bilijarde")]
    [InlineData(4000000000000000, "četiri bilijarde")]
    [InlineData(5000000000000000, "pet bilijardi")]
    [InlineData(10000000000000000, "deset bilijardi")]
    [InlineData(11000000000000000, "jedanaest bilijardi")]
    [InlineData(20000000000000000, "dvadeset bilijardi")]
    [InlineData(21000000000000000, "dvadeset jedna bilijarda")]
    [InlineData(22000000000000000, "dvadeset dvije bilijarde")]
    [InlineData(23000000000000000, "dvadeset tri bilijarde")]
    [InlineData(24000000000000000, "dvadeset četiri bilijarde")]
    [InlineData(25000000000000000, "dvadeset pet bilijardi")]
    [InlineData(1000000000000000000, "trilijun")]
    [InlineData(2000000000000000000, "dva trilijuna")]
    [InlineData(9000000000000000000, "devet trilijuna")]
    [InlineData(-7516, "minus sedam tisuća petsto šesnaest")]
    [InlineData(long.MaxValue, "devet trilijuna dvjesto dvadeset tri bilijarde tristo sedamdeset dva bilijuna trideset šest milijardi osamsto pedeset četiri milijuna sedamsto sedamdeset pet tisuća osamsto sedam")]
    [InlineData(long.MinValue, "minus devet trilijuna dvjesto dvadeset tri bilijarde tristo sedamdeset dva bilijuna trideset šest milijardi osamsto pedeset četiri milijuna sedamsto sedamdeset pet tisuća osamsto osam")]
    public void NumberToWords(long stubNumber, string expectedWords)
    {
        var actualWords = stubNumber.ToWords();

        Assert.Equal(expectedWords, actualWords);
    }
}