# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [2.0.0-alpha.7](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.6...v2.0.0-alpha.7) (2020-11-07)

### CI

* **nodejs:** move from node v12 lts to v14 lts

## [2.0.0-alpha.6](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.5...v2.0.0-alpha.6) (2020-10-24)

### ⚠ BREAKING CHANGES

* **login:** removed login connected with CouchDB instance  ([737326d](https://github.com/HospitalRun/hospitalrun-frontend/commit/737326d5bf4be325c3159dce180fe9b3478da5aa))

### Features

* **patient:** add panel to display useful patient information ([0baf3af](https://github.com/HospitalRun/hospitalrun-frontend/commit/0baf3af504c1cc0b9512c1d1be4d0b1eeb268f49)), closes [#2259](https://github.com/HospitalRun/hospitalrun-frontend/issues/2259)
* **patient:** refactor add allergy button ([4b234a1](https://github.com/HospitalRun/hospitalrun-frontend/commit/4b234a1968802e45038197f1e765020e9ca15bff)), closes [#2259](https://github.com/HospitalRun/hospitalrun-frontend/issues/2259)
* **patient:** remove unused function ([eba6074](https://github.com/HospitalRun/hospitalrun-frontend/commit/eba6074adb0a52be03cc5e4b6c2945f4d7d24f9c)), closes [#2259](https://github.com/HospitalRun/hospitalrun-frontend/issues/2259)
* **patient:** resolve merge conflict ([981f59f](https://github.com/HospitalRun/hospitalrun-frontend/commit/981f59f48ded2c48b932180e45ff677b28d63f14)), closes [#2259](https://github.com/HospitalRun/hospitalrun-frontend/issues/2259)


### Bug Fixes

* **EditAppointment:** refactor editing appointment to use ([56e058f](https://github.com/HospitalRun/hospitalrun-frontend/commit/56e058f9c78f519be6c598b10d8eb48f3d7df97d))
* **lab request:** Update toast success message ([734ac30](https://github.com/HospitalRun/hospitalrun-frontend/commit/734ac3029da18ec0abf2e8d21dc7fb8f6b931eee))
* **scheduling:** added hook tests ([da046c7](https://github.com/HospitalRun/hospitalrun-frontend/commit/da046c7087626cc269c4a96ad97989deee2e207f))

## [2.0.0-alpha.5](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.4...v2.0.0-alpha.5) (2020-09-28)


### Features

* Added smooth scroll to index.css ([#2408](https://github.com/HospitalRun/hospitalrun-frontend/issues/2408)) ([a7f771f](https://github.com/HospitalRun/hospitalrun-frontend/commit/a7f771f693f124ecadc5f7f5eaf257ccf367563c))
* **added tests:** incidentsDownloadCSV ([dc3c93e](https://github.com/HospitalRun/hospitalrun-frontend/commit/dc3c93eeecac464ba0e3fdc9111d1ed32ac566b2)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **caregoal:** add care goals to patient ([#2360](https://github.com/HospitalRun/hospitalrun-frontend/issues/2360)) ([8eb8f6f](https://github.com/HospitalRun/hospitalrun-frontend/commit/8eb8f6f0910d8259f15c1878249e630ff3a8be18))
* **couchdb:** added Windows alternatives to the couchdb helper scripts ([f0a1cb8](https://github.com/HospitalRun/hospitalrun-frontend/commit/f0a1cb8a0749ba9255ee188c358bd097be804fff))
* **diagnosis:** adds new diagnosis fields ([#2276](https://github.com/HospitalRun/hospitalrun-frontend/issues/2276)) ([2532435](https://github.com/HospitalRun/hospitalrun-frontend/commit/2532435feea8066588694a965aa15fc942b2ef19))
* **diagnosis:** link diagnosis with visit ([#2321](https://github.com/HospitalRun/hospitalrun-frontend/issues/2321)) ([e558c27](https://github.com/HospitalRun/hospitalrun-frontend/commit/e558c2778effa743411f647b3ac5ab83074b9ad1))
* **download csv of incident table:** uses json2csv. filters data ([6575a74](https://github.com/HospitalRun/hospitalrun-frontend/commit/6575a7403bcc920b56ae6903232cf3ee8d09952b)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **imaging:** link image with visit ([#2309](https://github.com/HospitalRun/hospitalrun-frontend/issues/2309)) ([c0ee742](https://github.com/HospitalRun/hospitalrun-frontend/commit/c0ee7428bf582af8dfd763a9f7b6c264c9da9bcf))
* **incidentscsv:** fixes ([a5f60b2](https://github.com/HospitalRun/hospitalrun-frontend/commit/a5f60b228ceccc7030b36c4498ec1c227897092a)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **incidentscsv:** made functions more abstract ([1fb36c9](https://github.com/HospitalRun/hospitalrun-frontend/commit/1fb36c97f16760ba8867e61d3413f34b3611a7be)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **incidentscsvtest:** newline bug in tests ([d577970](https://github.com/HospitalRun/hospitalrun-frontend/commit/d577970aa13c5afb440ec3ae885efceee9c58739)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **labs:** support list of notes for lab requests ([#2325](https://github.com/HospitalRun/hospitalrun-frontend/issues/2325)) ([019a5f8](https://github.com/HospitalRun/hospitalrun-frontend/commit/019a5f8491c07f27218476e70652010a6f7e27ae))
* add new useTranslator ([#2197](https://github.com/HospitalRun/hospitalrun-frontend/issues/2197)) ([d756cb6](https://github.com/HospitalRun/hospitalrun-frontend/commit/d756cb68c34eb6aaff020edf69430d4fd3e8ad59))
* added an entry in pageMap for incident infographic ([e23c913](https://github.com/HospitalRun/hospitalrun-frontend/commit/e23c913ab0a6f68aaa86e74142a25c5448878694))
* Added blood type info to patient ([#2190](https://github.com/HospitalRun/hospitalrun-frontend/issues/2190)) ([01e8343](https://github.com/HospitalRun/hospitalrun-frontend/commit/01e834301e318553c3c49768c5af5f5c72a40d0b))
* added label for visualize and fixed title ([e06fbc3](https://github.com/HospitalRun/hospitalrun-frontend/commit/e06fbc3e1746ea36d6de1f3d4837cc92f2c40bdb))
* added ListItem component to incidents in Sidebar for visualize tab ([d73a3e7](https://github.com/HospitalRun/hospitalrun-frontend/commit/d73a3e7109a5923eccebc79f768fc09958e2746c))
* added permission for viewing widgets to Permissions model ([68d6297](https://github.com/HospitalRun/hospitalrun-frontend/commit/68d6297735b13783212a1c3787d8b3a00b8aa446))
* added route for visualize component and performed sanity check ([9dc7855](https://github.com/HospitalRun/hospitalrun-frontend/commit/9dc78558affd1419801a91e060d0b412b4c09072))
* added test cases for visualize route ([c6f17b3](https://github.com/HospitalRun/hospitalrun-frontend/commit/c6f17b3b1b98b80aae7eb805fb2f2571c2b850b9))
* implemented use of hook to retrieve reported incidents ([8d04353](https://github.com/HospitalRun/hospitalrun-frontend/commit/8d04353bfe0ef3a89d6d93e8dfedcbd928376a8e))
* imported LineGraph component and rendered it with dumby data ([7cc66eb](https://github.com/HospitalRun/hospitalrun-frontend/commit/7cc66ebe530e2449e6ae6e733a600d5b6881d2a7))
* incidents per month are now managed in state ([f2bc985](https://github.com/HospitalRun/hospitalrun-frontend/commit/f2bc985fd90878d9b084598693afd817e77f855c))
* linegraph component now renders dynamic data stored in state ([56ae1b8](https://github.com/HospitalRun/hospitalrun-frontend/commit/56ae1b844fb881bf1c29cc826cb2a80099cde545))
* partial implementation of useEffect hook ([29a603e](https://github.com/HospitalRun/hospitalrun-frontend/commit/29a603e0db5df1a94aece929a2314cc812bf6dca))
* use of Array.fill in monthlyIncidents useState ([bb4b9fb](https://github.com/HospitalRun/hospitalrun-frontend/commit/bb4b9fb682b0d1bac90094acbf32795708bcf97e))
* **allergies:** ability to click on allergy and view an allergy ([#2224](https://github.com/HospitalRun/hospitalrun-frontend/issues/2224)) ([071508c](https://github.com/HospitalRun/hospitalrun-frontend/commit/071508c358befcf16973af41fcfc4bceba3a8feb))
* **appointments:** provide more information on listed appointments ([a7b8441](https://github.com/HospitalRun/hospitalrun-frontend/commit/a7b844183b1db9d9e6daf1e144170dc5d3dd6921))
* **incidents:** add ability to resolve incidents ([#2222](https://github.com/HospitalRun/hospitalrun-frontend/issues/2222)) ([5e95a9c](https://github.com/HospitalRun/hospitalrun-frontend/commit/5e95a9ccf15d094174be817ce2d18f70cb13a485))
* **incidents, scheduling, other:** add russian locale ([7fa152b](https://github.com/HospitalRun/hospitalrun-frontend/commit/7fa152bd2367884941e615f02073c0e1f66a4f56))
* **labs:** labs tab should use Table component ([88a7c08](https://github.com/HospitalRun/hospitalrun-frontend/commit/88a7c0863c0a7752b99683e864d461209fe16b5d))
* **navbar:** add icons to 'quick add' icon in navbar ([#2220](https://github.com/HospitalRun/hospitalrun-frontend/issues/2220)) ([7e0aba7](https://github.com/HospitalRun/hospitalrun-frontend/commit/7e0aba7d1a3fe14db48f55e6250cfbca75ed7ad8))
* **navbar:** display currently logged in user name ([5a4bfa5](https://github.com/HospitalRun/hospitalrun-frontend/commit/5a4bfa54af9d30d9b6b26416f06a5e3325699551))
* **Navbar:** remove search from navbar ([#2237](https://github.com/HospitalRun/hospitalrun-frontend/issues/2237)) ([0c85e24](https://github.com/HospitalRun/hospitalrun-frontend/commit/0c85e2450acad2dbf7addb0b657a037e2cf397b7))
* **new:** warn about potential duplicate patient ([#2187](https://github.com/HospitalRun/hospitalrun-frontend/issues/2187)) ([#2240](https://github.com/HospitalRun/hospitalrun-frontend/issues/2240)) ([f49831c](https://github.com/HospitalRun/hospitalrun-frontend/commit/f49831cd11b67a8f28071a05dbc832891c5b4bf5))
* **new scripts and contributing.md:** added scripts to init and cleanup couchdb ([a331d62](https://github.com/HospitalRun/hospitalrun-frontend/commit/a331d621b274e795ae26f5471a669b076c7a8b06))
* triggers a re-render on useEffect when data loads ([699be8c](https://github.com/HospitalRun/hospitalrun-frontend/commit/699be8c436122de63972db3bd4d9e90ebbfc06aa))
* updated useEffect dependency and implemented map ([2b72f7e](https://github.com/HospitalRun/hospitalrun-frontend/commit/2b72f7ee5775256ebad5d1c72c72125b60f68498))
* **imaging:** create basic imaging module ([#2250](https://github.com/HospitalRun/hospitalrun-frontend/issues/2250)) ([f256129](https://github.com/HospitalRun/hospitalrun-frontend/commit/f25612928d4cf09d054c7605373c8be13e4f4fce))
* **loading:** add shared loading component ([24c45bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/24c45bc4919e4c0c088f38f744a0bd03014b7d3a))
* **medications:** implement basic medication module ([#2249](https://github.com/HospitalRun/hospitalrun-frontend/issues/2249)) ([ab1bd5c](https://github.com/HospitalRun/hospitalrun-frontend/commit/ab1bd5c4238fc118518f573af8bb418fce2a95af))
* **patient:** put "Unknow" next to date of brith field ([#2217](https://github.com/HospitalRun/hospitalrun-frontend/issues/2217)) ([ce16424](https://github.com/HospitalRun/hospitalrun-frontend/commit/ce1642406e0015ce7c51a182d9db6011ad4aefc3))
* **patient, actions:** add russian locale ([a03a63e](https://github.com/HospitalRun/hospitalrun-frontend/commit/a03a63eb30db7b3387a308934d14dfaab3b72fd2))
* **patients:** add no patients exist ([#2235](https://github.com/HospitalRun/hospitalrun-frontend/issues/2235)) ([886163a](https://github.com/HospitalRun/hospitalrun-frontend/commit/886163aafe30de2c66d41e0491600f00749ca682))
* **patients:** add visit functionality ([#2251](https://github.com/HospitalRun/hospitalrun-frontend/issues/2251)) ([f11e702](https://github.com/HospitalRun/hospitalrun-frontend/commit/f11e702d5440ef50d7e2dc635cf71a06cfc12d11))
* **viewlab.tsx:** added success toast for updated/completed labs ([5d08ccf](https://github.com/HospitalRun/hospitalrun-frontend/commit/5d08ccf84b48e503b8a907c829c80b2ad72349f3))


### Bug Fixes

* add successfullycompleted resolves [#2295](https://github.com/HospitalRun/hospitalrun-frontend/issues/2295) ([2fc4ca4](https://github.com/HospitalRun/hospitalrun-frontend/commit/2fc4ca4bd8f285f8dd60c1459040f051132e4ea8))
* fix typo successfully alphabet text ([40ab00f](https://github.com/HospitalRun/hospitalrun-frontend/commit/40ab00feb2b8584a090e607d98793de56a31fa47))
* update text for oncomplete lab ([8c60adb](https://github.com/HospitalRun/hospitalrun-frontend/commit/8c60adb08e5b3ff4f1fc7cd38ff73a74fff76417))
* **added translation keys #2258:** added missing translation keys PR [#2258](https://github.com/HospitalRun/hospitalrun-frontend/issues/2258) ([6339e78](https://github.com/HospitalRun/hospitalrun-frontend/commit/6339e78285b01fdf7c8481aaf98b55471e5111b2))
* **allergies:** fixes allergies tab not refreshing data after allergy has been added ([0e29639](https://github.com/HospitalRun/hospitalrun-frontend/commit/0e296398ec12ca0c74621a5f5b476cb5465e6583))
* **care plan:** fix view button label in list ([#2376](https://github.com/HospitalRun/hospitalrun-frontend/issues/2376)) ([6156f38](https://github.com/HospitalRun/hospitalrun-frontend/commit/6156f38f8ea3e8bbf8bb9496f210d8815ee4a78e))
* **care plans:** fix undefined care plans behavior ([e43c9c7](https://github.com/HospitalRun/hospitalrun-frontend/commit/e43c9c7aa13cf1a76986945323379fa909e55e80))
* **couchdb-init.sh and couchdb-cleanup.sh:** removed files which where commited by accident ([42c8cf7](https://github.com/HospitalRun/hospitalrun-frontend/commit/42c8cf76ee15d7e1c93200abfa8a585146d67a0e))
* **eslint rule and subsequent changes to the codebase:** eslint rule no-console added ([6d9ca06](https://github.com/HospitalRun/hospitalrun-frontend/commit/6d9ca06443de91b5137a2495941b83ecefbd0979)), closes [#2307](https://github.com/HospitalRun/hospitalrun-frontend/issues/2307)
* **incidents:** fix find all incidents ([aabd33e](https://github.com/HospitalRun/hospitalrun-frontend/commit/aabd33e2651246ac8eaadc1c6b260b1f3b6e7591))
* **incidents:** fix search incidents query not working ([0818c11](https://github.com/HospitalRun/hospitalrun-frontend/commit/0818c115d08c8edb58f0b10b0b4df7d4a1ab2626))
* **incidentscvstests:** fixed timezone test bug ([02294e6](https://github.com/HospitalRun/hospitalrun-frontend/commit/02294e6b7c0c21173dede054fb23fdf4d47a3c96)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* **issue-2306:** removed additional Report Incident nav link from quick create menu ([c971fb2](https://github.com/HospitalRun/hospitalrun-frontend/commit/c971fb2d1357d82f9e9cb5a0b2abe22dd945bf48))
* **labs:** fix successfully updated lab message ([7f65174](https://github.com/HospitalRun/hospitalrun-frontend/commit/7f651742be76050b46a3360864aec4f516a44694))
* **login:** fixes broken login ([d72c4e9](https://github.com/HospitalRun/hospitalrun-frontend/commit/d72c4e99cf032eb37e354cdb15abef0a694c38a9))
* **login:** improved login validation ([028daff](https://github.com/HospitalRun/hospitalrun-frontend/commit/028daff0648d7758984b04960f24e8bf20002ea4))
* **navigation:** align quick menu with sidebar and mobile version ([0187c34](https://github.com/HospitalRun/hospitalrun-frontend/commit/0187c3406306540b5da3f574a6abe984dcd84754))
* **patient:** add DOB to add related person search ([c1ffd82](https://github.com/HospitalRun/hospitalrun-frontend/commit/c1ffd82f64eb44400d82815102b2efdbca19b433))
* **patient:** successfully updated message should show actual text ([7ca79bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/7ca79bcda2d40ecd95fc8ed6ceffefac85249725))
* **patients:** fix infinite loop in patients search ([08fff6f](https://github.com/HospitalRun/hospitalrun-frontend/commit/08fff6f9e345368c166adb578b19e2a1b801f3b7))
* **patients:** fixes related person search crashing if no DoB ([babc7e3](https://github.com/HospitalRun/hospitalrun-frontend/commit/babc7e3e817ecb20b5a2cf7b3afde99182740b4b))
* **shared:** couchdb auth popup local.ini httpd section update ([937f78e](https://github.com/HospitalRun/hospitalrun-frontend/commit/937f78ef1d1a4e0ffb79582f27b3e60603f76249)), closes [#2256](https://github.com/HospitalRun/hospitalrun-frontend/issues/2256)
* **shared:** couchdb auth popup nginx.conf update ([eca339a](https://github.com/HospitalRun/hospitalrun-frontend/commit/eca339a72d089cafbc348ec431c2d36a327299c5))
* **shared:** couchdb auth popup pr lgtm merge issue ([6cf6739](https://github.com/HospitalRun/hospitalrun-frontend/commit/6cf6739e9c8fd44db3f293cc1b3e0145c68ef30a))
* **shared:** pouchdb auth - add skip_setup flag ([a8d34e1](https://github.com/HospitalRun/hospitalrun-frontend/commit/a8d34e14ab89447bd2753248038907c89801f327)), closes [#2256](https://github.com/HospitalRun/hospitalrun-frontend/issues/2256)
* **shared:** update couchdb auth local.ini httpd section ([d939bb2](https://github.com/HospitalRun/hospitalrun-frontend/commit/d939bb2a69adb58262696f62dcf2c0ee453c6815))
* **sidebar:** test improvements ([7b75fe0](https://github.com/HospitalRun/hospitalrun-frontend/commit/7b75fe01395ec44e3e95ea5866e78178313272e8))
* react-hooks/exhaustive-deps warnings do not appear when running ([6434fd0](https://github.com/HospitalRun/hospitalrun-frontend/commit/6434fd07784b4cddc886c5759b34dbbdab273006))
* **typo:** fixed typo and used locale ([fd2ec69](https://github.com/HospitalRun/hospitalrun-frontend/commit/fd2ec6961f51dc7259b2c8872e60461a4eb1ae38)), closes [#2292](https://github.com/HospitalRun/hospitalrun-frontend/issues/2292)
* correct incident icon ([#2252](https://github.com/HospitalRun/hospitalrun-frontend/issues/2252)) ([c156f25](https://github.com/HospitalRun/hospitalrun-frontend/commit/c156f25aa975c9ade32e814777f7f055612c6b3a))
* fix find all + sort request behavior ([922d767](https://github.com/HospitalRun/hospitalrun-frontend/commit/922d7675bc9c7f51cacd100be0becbd5ee6087e1))
* remove console.log from tests output ([fe3a71a](https://github.com/HospitalRun/hospitalrun-frontend/commit/fe3a71a0d1169071117adaf529aa5ff6a0a891ef))
* search should only pull back relevant document types ([ab6f3cc](https://github.com/HospitalRun/hospitalrun-frontend/commit/ab6f3cc9590e9399220890a939e6e569032d1185))
* **use effect line to newlabrequest.tsx:** added use effect ([9b34904](https://github.com/HospitalRun/hospitalrun-frontend/commit/9b34904252c8ccbc479abbdecd6f3f0ba40bcbd3))
* prevent app route always changes to root after refresh ([24b73bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/24b73bcad48ea1eed7d9ac7b30d81491f6d8a1d6))
* remove duplicate prop ([faea7ba](https://github.com/HospitalRun/hospitalrun-frontend/commit/faea7bae3e00d3c471802a875bcce7e719f9b277))
* reset lab state when navigation from lab form ([#2268](https://github.com/HospitalRun/hospitalrun-frontend/issues/2268)) ([aa8e2ed](https://github.com/HospitalRun/hospitalrun-frontend/commit/aa8e2ed5f1c49d37fff0e6e8f928814e23cd359d))
* undefined care plan behavior ([279d649](https://github.com/HospitalRun/hospitalrun-frontend/commit/279d64914ca0fab541ade4f64d9569f27000ddae))
* update hardcoded text with i18n locales ([#2203](https://github.com/HospitalRun/hospitalrun-frontend/issues/2203)) ([573df57](https://github.com/HospitalRun/hospitalrun-frontend/commit/573df570bc0c8effd45fe232002a47367dcb8076))
* weird spacing issue in quick add icon ([14ef415](https://github.com/HospitalRun/hospitalrun-frontend/commit/14ef415334354bd61475ead9469b8579dde8bf6c))

## [2.0.0-alpha.4](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.3...v2.0.0-alpha.4) (2020-06-26)


### Features

* **navbar:** add hamberger icon for mobile, and dividers ([1cf6575](https://github.com/HospitalRun/hospitalrun-frontend/commit/1cf657516e1249373c3e44247700d435473c7d59))
* apply select component changes ([c38004b](https://github.com/HospitalRun/hospitalrun-frontend/commit/c38004bf9285a6cc53c36150754bd659130e5998))
* **add new script for checking missing translations:** translations ([9ca5232](https://github.com/HospitalRun/hospitalrun-frontend/commit/9ca5232632503fbefb5ffae4e4d23a10d44fc62c)), closes [#1919](https://github.com/HospitalRun/hospitalrun-frontend/issues/1919)
* **care plan:** fix internationalization ([72a5bed](https://github.com/HospitalRun/hospitalrun-frontend/commit/72a5bede7862c72eecb068c0c20141ef619a8f27))
* **care-plan:** add care plan form and tests ([e96eb83](https://github.com/HospitalRun/hospitalrun-frontend/commit/e96eb835c37c0d4174ee8a8878286fbabda309c8))
* **careplan:** adds ability to add a new care plan ([0aa0cf9](https://github.com/HospitalRun/hospitalrun-frontend/commit/0aa0cf93b3f9e3153592684ce05babee2e0c5379))
* **checkmissingtranslations.ts:** add language in logs ([d20b9c7](https://github.com/HospitalRun/hospitalrun-frontend/commit/d20b9c718dcb3f72142cb3280d779d7ef74f973e))
* **checkmissingtranslations.ts:** change type of searchingPath ([7ab8195](https://github.com/HospitalRun/hospitalrun-frontend/commit/7ab81957277eec5368d6daea5e38f003a7f03255))
* **checkmissingtranslations.ts:** refactor ([75f9981](https://github.com/HospitalRun/hospitalrun-frontend/commit/75f998103cde809054d01b5d999dba557952bb09))
* **checkmissintranlations.ts:** add colors to log ([ede7b2e](https://github.com/HospitalRun/hospitalrun-frontend/commit/ede7b2eca4046bc93dc47c43a73ef9007f2f1594))
* **checkmissintranslations.ts:** run script before default ones ([5ef3f7e](https://github.com/HospitalRun/hospitalrun-frontend/commit/5ef3f7ec702331bb1bea14cd51a46e48a2a31ca2))
* **datepicker:** add year selector dropdown ([#2060](https://github.com/HospitalRun/hospitalrun-frontend/issues/2060)) ([b159d7a](https://github.com/HospitalRun/hospitalrun-frontend/commit/b159d7ada730976583d416b0f44d38a186abe4cd))
* **i18n:** add italian translation ([#2035](https://github.com/HospitalRun/hospitalrun-frontend/issues/2035)) ([44f15f3](https://github.com/HospitalRun/hospitalrun-frontend/commit/44f15f3a12b3a4252f70c745b37a1140c732d976))
* **incident:** Added Report Incident button ([43cafa6](https://github.com/HospitalRun/hospitalrun-frontend/commit/43cafa6da8334bf41440588ce71a27b42b73ef9d))
* **incidents:** add ability to view an incident ([5887859](https://github.com/HospitalRun/hospitalrun-frontend/commit/5887859542247573843fc5af980cd081f6cc6f25))
* **incidents:** add incident related routing ([2e9e985](https://github.com/HospitalRun/hospitalrun-frontend/commit/2e9e985c877db2f095ba11fb6900fc177283d5cc))
* **incidents:** adds ability to report incident ([4a4a682](https://github.com/HospitalRun/hospitalrun-frontend/commit/4a4a6821838982f51b94ff050ff5e614a95d8839))
* **incidents:** adds ability to view all incidents ([f11d8e9](https://github.com/HospitalRun/hospitalrun-frontend/commit/f11d8e90fe2752eba35fa2108e188053b89e6e8f))
* **incidents:** filter incidents ([#2087](https://github.com/HospitalRun/hospitalrun-frontend/issues/2087)) ([5309a85](https://github.com/HospitalRun/hospitalrun-frontend/commit/5309a859a4b19617f44183b1d70d0f36af6206d8))
* **labs:** ability to filter by status on labs screen ([#2033](https://github.com/HospitalRun/hospitalrun-frontend/issues/2033)) ([2b5c789](https://github.com/HospitalRun/hospitalrun-frontend/commit/2b5c789bb6247c3fe62fad8818d7fa1a16034a5b))
* **labs:** add lab code ([#2040](https://github.com/HospitalRun/hospitalrun-frontend/issues/2040)) ([b695ac8](https://github.com/HospitalRun/hospitalrun-frontend/commit/b695ac899ea73e7059a50ad633bea90932431ff8))
* **navbar:** add shortcut icon to the create pages ([b1a8cdf](https://github.com/HospitalRun/hospitalrun-frontend/commit/b1a8cdf3e3288f6084592f583407ea89cebd5134))
* **network-status:** Notify users when they're working offline ([#2109](https://github.com/HospitalRun/hospitalrun-frontend/issues/2109)) ([fa5bcb6](https://github.com/HospitalRun/hospitalrun-frontend/commit/fa5bcb6a86ae082de789aca84a938bc7f99a8ca7))
* **newlabrequest:** add requestBy to model ([c791de3](https://github.com/HospitalRun/hospitalrun-frontend/commit/c791de39fa8c67d875f8fb1aa99baf164691b5eb)), closes [#2082](https://github.com/HospitalRun/hospitalrun-frontend/issues/2082)
* **pagecomponent:** user can change page size ([7411ad0](https://github.com/HospitalRun/hospitalrun-frontend/commit/7411ad09ee680e5a691fdd34f1ca33c452398f1b)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* **patient:** add input validation ([#2032](https://github.com/HospitalRun/hospitalrun-frontend/issues/2032)) ([bb02fa2](https://github.com/HospitalRun/hospitalrun-frontend/commit/bb02fa20a23eab285c88cfe6ef16d28783d24ec6))
* **patient:** multiple contact info ([#2113](https://github.com/HospitalRun/hospitalrun-frontend/issues/2113)) ([ceb96a4](https://github.com/HospitalRun/hospitalrun-frontend/commit/ceb96a4af48d4108babb7ff4f5d3e75bf74ec1fb))
* **settings:** add navbar dropdown and settings page ([#2096](https://github.com/HospitalRun/hospitalrun-frontend/issues/2096)) ([e5677fe](https://github.com/HospitalRun/hospitalrun-frontend/commit/e5677fe459fe07637b0c9b3a2445296a89d16ee1))
* **viewpatient:** added labs tab to ViewPatient ([#1987](https://github.com/HospitalRun/hospitalrun-frontend/issues/1987)) ([4a1c7ed](https://github.com/HospitalRun/hospitalrun-frontend/commit/4a1c7ed4a80265e55020f8b86fbec1aedf366330))
* **viewpatients:** add a new field 'index', paging in next direction ([d1c55e7](https://github.com/HospitalRun/hospitalrun-frontend/commit/d1c55e7ab0bdcbe9a851751a747a6fe71714dc6a)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969) [#1967](https://github.com/HospitalRun/hospitalrun-frontend/issues/1967)
* **viewpatients:** add paging feature in ViewPatients component ([dff2b3e](https://github.com/HospitalRun/hospitalrun-frontend/commit/dff2b3e44ee076f8154290fe9183106d6fe3f231)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* **viewpatients:** add paging for search patients ([b96680f](https://github.com/HospitalRun/hospitalrun-frontend/commit/b96680fbe1329384ed6eefa9e414803c781897dd)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* **viewpatients:** add Tests, Fix bug ([671ad02](https://github.com/HospitalRun/hospitalrun-frontend/commit/671ad02d6992727f73c777f673a6c305fd57b1b2)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* **viewpatients:** enables to navigation to previous page ([52a59d3](https://github.com/HospitalRun/hospitalrun-frontend/commit/52a59d3865444d37a2c605d2799346172fec2904)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* **viewpatients:** refactor code as recommended ([5308f5f](https://github.com/HospitalRun/hospitalrun-frontend/commit/5308f5fc7fa358d13797dee5e6a78b724795f31b)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)
* add Sort request in ViewPatients ([c4109a4](https://github.com/HospitalRun/hospitalrun-frontend/commit/c4109a470290843b39023e656db68845930174d0)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)


### Bug Fixes

* **datetime:** datetime pickers are bigger now ([#2056](https://github.com/HospitalRun/hospitalrun-frontend/issues/2056)) ([52d30a3](https://github.com/HospitalRun/hospitalrun-frontend/commit/52d30a3ec1cc27c2ee2ec8827dce331180203461))
* **eslint:** fix pouchdb test error ([f19d276](https://github.com/HospitalRun/hospitalrun-frontend/commit/f19d276bff9fa8aaf906cf0b8f1f97dcfa362e4a))
* **i18n:** fix build ([30bb158](https://github.com/HospitalRun/hospitalrun-frontend/commit/30bb1587125e1d208ffb68e6f8ec9d4aab09a291))
* **incidents:** add loading during fetch phase ([#2085](https://github.com/HospitalRun/hospitalrun-frontend/issues/2085)) ([d1fb940](https://github.com/HospitalRun/hospitalrun-frontend/commit/d1fb94078494a048f9d8aae5ac1b803f429dc07e))
* **navbar:** Make Navbar mobile-friendly ([#2118](https://github.com/HospitalRun/hospitalrun-frontend/issues/2118)) ([391271a](https://github.com/HospitalRun/hospitalrun-frontend/commit/391271a23a3cdd66f27911aafb729c4add10c171))
* **patient:** make note not required in care plan ([#2158](https://github.com/HospitalRun/hospitalrun-frontend/issues/2158)) ([34e6041](https://github.com/HospitalRun/hospitalrun-frontend/commit/34e6041cd051aa8ce98bdf359cc6874da1244096))
* **sidebar:** sidebar should only show links user has access to see ([66feda1](https://github.com/HospitalRun/hospitalrun-frontend/commit/66feda1eefba9f663598f4f1d8f3f0484dfe38eb)), closes [#2110](https://github.com/HospitalRun/hospitalrun-frontend/issues/2110)
* **sidebar:** sidebar should only show links user has access to see ([2f22ebd](https://github.com/HospitalRun/hospitalrun-frontend/commit/2f22ebdab707028d17a1417a995aa57b40422ad3)), closes [#2110](https://github.com/HospitalRun/hospitalrun-frontend/issues/2110)
* **toolchain:** extends scripts tsconfig.json from base one ([6532028](https://github.com/HospitalRun/hospitalrun-frontend/commit/653202870b4eafad6f960136b63ef76639ca005c)), closes [#2113](https://github.com/HospitalRun/hospitalrun-frontend/issues/2113)
* **toolchain:** fix broken deps and updates translate-check script ([d0c35db](https://github.com/HospitalRun/hospitalrun-frontend/commit/d0c35db60aef95d0892fe7650960635eeda25df8))
* standardize mock store setup in tests ([#2075](https://github.com/HospitalRun/hospitalrun-frontend/issues/2075)) ([50f9e49](https://github.com/HospitalRun/hospitalrun-frontend/commit/50f9e49ec1edc3bfdb8c2bbaed98bb8ceeb27f92))
* standardized react router imports in tests and source code ([#2067](https://github.com/HospitalRun/hospitalrun-frontend/issues/2067)) ([cb3cea5](https://github.com/HospitalRun/hospitalrun-frontend/commit/cb3cea5d6e1c3c568ecd6536c55d8aa5e6d6e62d))
* styling the Navbar to make it Sticky ([#2057](https://github.com/HospitalRun/hospitalrun-frontend/issues/2057)) ([11e4de8](https://github.com/HospitalRun/hospitalrun-frontend/commit/11e4de80fc2d36d5fdeacdf24466db14de10eb30))
* **viewpatients:** call PatientRepository.findAll() only once ([#2044](https://github.com/HospitalRun/hospitalrun-frontend/issues/2044)) ([9084411](https://github.com/HospitalRun/hospitalrun-frontend/commit/9084411bc459abfd5e7003460ff2f1574cbbc243))
* **viewpatients.tsx:** add userPageRequest in dependency array ([11b6c8b](https://github.com/HospitalRun/hospitalrun-frontend/commit/11b6c8be0ee643bea6c33250c8adb36b8dafbf8f)), closes [#1969](https://github.com/HospitalRun/hospitalrun-frontend/issues/1969)

## [2.0.0-alpha.3](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.2...v2.0.0-alpha.3) (2020-05-02)


### ⚠ BREAKING CHANGES

* **patients:** Any patient saved with friendly id will no longer map friendly id to the patient
object, thus not displaying it in the UI or have it available for search

### Features

* **add french language:** add French language ot locales list ([2ce192b](https://github.com/HospitalRun/hospitalrun-frontend/commit/2ce192bb6989b9ba4c804c339f519be72ec26c04)), closes [#1888](https://github.com/HospitalRun/hospitalrun-frontend/issues/1888)
* **i18n:** add more missing translations ([697552d](https://github.com/HospitalRun/hospitalrun-frontend/commit/697552d6b0331d128fc16d2a7d4ec8262432b24b))
* **i18n:** fix tests ([0f0a7c3](https://github.com/HospitalRun/hospitalrun-frontend/commit/0f0a7c3edc5e2121624d4a1181963ddc7d45c65b))
* **i8ln:** accidently committed deleted file ([3f58dd5](https://github.com/HospitalRun/hospitalrun-frontend/commit/3f58dd5253c37c16cb1ea27d6f467ef2d7afb7ea))
* **i8ln:** add missing translations ([008cb5f](https://github.com/HospitalRun/hospitalrun-frontend/commit/008cb5fdf5b89cb9a911a7cfd88ae7086fd61130))
* making sidebar collapsible ([168a112](https://github.com/HospitalRun/hospitalrun-frontend/commit/168a112802cf07331331364f26e7e13afa881f88)), closes [#1858](https://github.com/HospitalRun/hospitalrun-frontend/issues/1858)
* **allergies:** adds ability to add allergy to appointment ([04a2160](https://github.com/HospitalRun/hospitalrun-frontend/commit/04a21604d449f18351d15ae5c3eafea2e47b7e62))
* **appointments:** add callbacks for appointment actions ([c077d75](https://github.com/HospitalRun/hospitalrun-frontend/commit/c077d75eb654747d5c6691369210942184325512))
* **breadcrumb:** add a breadcrumb underneath the page header ([65b40ae](https://github.com/HospitalRun/hospitalrun-frontend/commit/65b40aeba2c9f75d4d5944e046cdaa7da126f1d1)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** add a patient to the store in HispitalRun.tests.tsx ([63517e8](https://github.com/HospitalRun/hospitalrun-frontend/commit/63517e8a2a309788f9147107553d8bf1a26b601f)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** add Breadcrumbs unit tests (component/slice/hook) ([a44ac9f](https://github.com/HospitalRun/hospitalrun-frontend/commit/a44ac9f9dcc38ff98c1eb85476e25be4cc6598ac)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** add hook useAddBreadcrumbs / sort breadcrumbs ([5beda75](https://github.com/HospitalRun/hospitalrun-frontend/commit/5beda756d134439911cd4a412147a66e1b222176)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** add the dashboard breadcrumb item ([beffc1f](https://github.com/HospitalRun/hospitalrun-frontend/commit/beffc1f059c748e880b9f76766c955d8e5094f08))
* **breadcrumb:** display the breadcrumb in the appointment components ([a6eaf2a](https://github.com/HospitalRun/hospitalrun-frontend/commit/a6eaf2a9547875a4a0947f4e9a7e21e41add11c8)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** improve Breadcrumbs tests ([03174ad](https://github.com/HospitalRun/hospitalrun-frontend/commit/03174ad959bc8ef6c6e125d09c80cd97ff05aef9))
* **breadcrumb:** sort the breadcrumbs in addBreadcrumbs action ([bbb3ca0](https://github.com/HospitalRun/hospitalrun-frontend/commit/bbb3ca06ec2d3ed4622b79cea81558a87519a8a8)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **breadcrumb:** test the dispatch of addBreadcrumbs action ([b5e4c38](https://github.com/HospitalRun/hospitalrun-frontend/commit/b5e4c387ed43d1373c43bc5a2a66893c090bad27))
* **breadcrumb:** use reduxPatient instead of patient for breadcrumbs ([492cb37](https://github.com/HospitalRun/hospitalrun-frontend/commit/492cb37c593f94ad17cce4a26fa527990b1c9639))
* **edit appointment:** implement Edit Appointment functionality ([f32c573](https://github.com/HospitalRun/hospitalrun-frontend/commit/f32c5731afba24a3d5a81ab7d9f365d9d19dfbd9))
* **edit appointment:** use button toolbar, address other PR issues ([4744152](https://github.com/HospitalRun/hospitalrun-frontend/commit/4744152317b7a550d5eeda2ff6959b7fa2c160ee))
* **patients:** fixes notifactions for updating/creating patient ([73677e2](https://github.com/HospitalRun/hospitalrun-frontend/commit/73677e2df83ef0032b9c3f1fe4a9da94d87b1e5b))
* change to use standard naming and use iso dates ([8827df1](https://github.com/HospitalRun/hospitalrun-frontend/commit/8827df18d7141b9b6f94d00fc99b1bf00fae66dc)), closes [#1879](https://github.com/HospitalRun/hospitalrun-frontend/issues/1879)
* **breadcrumb:** customize breadcrumbs for patients and appointments ([a68ed7e](https://github.com/HospitalRun/hospitalrun-frontend/commit/a68ed7e282ec630049671f1f4a292cae6ed91379)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **delete appointment:** adds ability to delete appointment ([dcb46b8](https://github.com/HospitalRun/hospitalrun-frontend/commit/dcb46b89acb562e982a99531ca006e976f922d17))
* **diagnoses:** add diagnoses tab ([bdf7aa1](https://github.com/HospitalRun/hospitalrun-frontend/commit/bdf7aa1126ffcc453a7c5a5eab9d55a66186c9a0))
* **labs:** adding tests for labs module ([3518b77](https://github.com/HospitalRun/hospitalrun-frontend/commit/3518b77c1f351e15a4f7fe1ade184bdd19754ddc))
* **labs:** adds ability to request and view labs ([efba834](https://github.com/HospitalRun/hospitalrun-frontend/commit/efba8349df7c99f5e49ce46d03b26d29e73c2955))
* **labs:** adds labs route ([a9c4100](https://github.com/HospitalRun/hospitalrun-frontend/commit/a9c4100f4d70c71d41b890d1bad0fe761fea6ee2))
* **labs:** adds labs sidebar/navbar links ([691572b](https://github.com/HospitalRun/hospitalrun-frontend/commit/691572ba578fffb044c914ec84ca524fde066a59))
* **labs:** adds test for lab related routes ([f354c94](https://github.com/HospitalRun/hospitalrun-frontend/commit/f354c940ceac9e41b6b92d21fc37c91c7eb09121))
* **labs:** adds view lab tests ([1867543](https://github.com/HospitalRun/hospitalrun-frontend/commit/186754354bd8dacc30aa15c32619bd50e237c63f))
* **labs:** fix time related tests ([94fa61a](https://github.com/HospitalRun/hospitalrun-frontend/commit/94fa61aa2cff1f504cd415abde1e1c4483f2e3a4))
* **labs:** reduxify request, cancel, fetch, and update labs ([7ba2e8e](https://github.com/HospitalRun/hospitalrun-frontend/commit/7ba2e8ea6ffb20b71b9781e27c07e9f6a4d26ac7))
* **labs:** use different act import ([be799ac](https://github.com/HospitalRun/hospitalrun-frontend/commit/be799ac21453346ebed5c1b6dabb363cc22e13e5))
* **localization:** add portuguese language ([#2018](https://github.com/HospitalRun/hospitalrun-frontend/issues/2018)) ([4a7515a](https://github.com/HospitalRun/hospitalrun-frontend/commit/4a7515aa80312faa4a05fe5d74c8a74e50f8b6cf))
* **newrelatedpersonmodal:** update Error Feedback ([57f9d7a](https://github.com/HospitalRun/hospitalrun-frontend/commit/57f9d7ac34d5c366a6faeac324809599bf30a953)), closes [#1925](https://github.com/HospitalRun/hospitalrun-frontend/issues/1925)
* **notes:** add notes to pacient ([b43ae11](https://github.com/HospitalRun/hospitalrun-frontend/commit/b43ae1146d5ee9622e57626050fe7f471c29bdb6)), closes [#1771](https://github.com/HospitalRun/hospitalrun-frontend/issues/1771)
* **patient:** add appointment button ([ec5d655](https://github.com/HospitalRun/hospitalrun-frontend/commit/ec5d655650875024b0bba12d49bc0dfad4c670ab))
* **patient:** add email and phone number validation ([242e1a1](https://github.com/HospitalRun/hospitalrun-frontend/commit/242e1a13c14f83b4a945dcccf554e26ead5622ff))
* **patient:** add notes tab tests ([6edc0ad](https://github.com/HospitalRun/hospitalrun-frontend/commit/6edc0ad3ba352c92c8d85ec58148fedb9fc57a98))
* **patient:** change newAppointment button label and add tests ([1704ccb](https://github.com/HospitalRun/hospitalrun-frontend/commit/1704ccb0ecdf0678038aa7e6c06c222f60ed501f))
* **patient:** provide better feedback on patient form ([#1938](https://github.com/HospitalRun/hospitalrun-frontend/issues/1938)) ([37ac2b5](https://github.com/HospitalRun/hospitalrun-frontend/commit/37ac2b5aa0574c807e5b222ba5fd139f4f22cb88))
* **patients:** add tests ([53f93f6](https://github.com/HospitalRun/hospitalrun-frontend/commit/53f93f6d6193dc71bfc4d639b54d1556d645222a))
* **patients:** added an asterisk to the Allergy Name field ([#1944](https://github.com/HospitalRun/hospitalrun-frontend/issues/1944)) ([b7e7142](https://github.com/HospitalRun/hospitalrun-frontend/commit/b7e7142031b408b7bf8c41abe07d91b347cee0a2))
* **patients:** added live search to the patients search ([#1970](https://github.com/HospitalRun/hospitalrun-frontend/issues/1970)) ([3ba741c](https://github.com/HospitalRun/hospitalrun-frontend/commit/3ba741c0988165f8121c0025074e9eaaafadc577))
* **patients:** addRealtedPerson function ([bd22057](https://github.com/HospitalRun/hospitalrun-frontend/commit/bd22057c5b599005da20ba3cc757178ac3a1bb1d))
* **patients:** adds ability to remove related person ([#1968](https://github.com/HospitalRun/hospitalrun-frontend/issues/1968)) ([6e08bab](https://github.com/HospitalRun/hospitalrun-frontend/commit/6e08babcad9f25e830e53c9f301c60706562ab61))
* **patients:** adds tests for new notes modal ([b3ddd24](https://github.com/HospitalRun/hospitalrun-frontend/commit/b3ddd24b083a8cfda36bf7c207e3480a78948709))
* **patients:** better form feedback for add allergy ([#1945](https://github.com/HospitalRun/hospitalrun-frontend/issues/1945)) ([d6904e7](https://github.com/HospitalRun/hospitalrun-frontend/commit/d6904e74e4ec21da57529046243e1166c6287c8f))
* **patients:** escape string in appointments search ([#2031](https://github.com/HospitalRun/hospitalrun-frontend/issues/2031)) ([254273f](https://github.com/HospitalRun/hospitalrun-frontend/commit/254273f889fd0d24189c634226b6c07d8d043532)), closes [#1997](https://github.com/HospitalRun/hospitalrun-frontend/issues/1997) [#2003](https://github.com/HospitalRun/hospitalrun-frontend/issues/2003) [#1999](https://github.com/HospitalRun/hospitalrun-frontend/issues/1999) [#2029](https://github.com/HospitalRun/hospitalrun-frontend/issues/2029)
* **patients:** new related person to add related person ([#1955](https://github.com/HospitalRun/hospitalrun-frontend/issues/1955)) ([0afeee1](https://github.com/HospitalRun/hospitalrun-frontend/commit/0afeee19bc70ac17cd5898baa7f6a8813fa68218))
* **patients:** refactor patient list to use table ([#1965](https://github.com/HospitalRun/hospitalrun-frontend/issues/1965)) ([89430f7](https://github.com/HospitalRun/hospitalrun-frontend/commit/89430f79c25e793171d5eff73ced0338b6fbf1c4))
* **patients:** set max date in date of birth date picker ([#2002](https://github.com/HospitalRun/hospitalrun-frontend/issues/2002)) ([f292926](https://github.com/HospitalRun/hospitalrun-frontend/commit/f292926c46941159ba807bef3986f21a1ca34762))
* **viewlabs:** sort Labs by requestedOn field ([#2004](https://github.com/HospitalRun/hospitalrun-frontend/issues/2004)) ([88ec61c](https://github.com/HospitalRun/hospitalrun-frontend/commit/88ec61c3c9afa1f9a1c1a7e62d7b84ed1cd72015))
* add created date and last updated date ([16ab294](https://github.com/HospitalRun/hospitalrun-frontend/commit/16ab294a5391406e153532179c2b92fa26a64e57)), closes [#1879](https://github.com/HospitalRun/hospitalrun-frontend/issues/1879)
* Added new proposed links to the sidebar ([#1956](https://github.com/HospitalRun/hospitalrun-frontend/issues/1956)) ([c74dec0](https://github.com/HospitalRun/hospitalrun-frontend/commit/c74dec0d755ae5a4ac6ac997b6421dac70f336eb))
* added successful alert when adding new appointments ([4c0b8fe](https://github.com/HospitalRun/hospitalrun-frontend/commit/4c0b8fec526d8aa3730ca550db70dbdd01d593e3)), closes [#1894](https://github.com/HospitalRun/hospitalrun-frontend/issues/1894)
* fix tests for sorting ([3ce732a](https://github.com/HospitalRun/hospitalrun-frontend/commit/3ce732a99a9952e082febd811a1205260682f1e2))
* indicate required fields in new Related Person Modal ([#1950](https://github.com/HospitalRun/hospitalrun-frontend/issues/1950)) ([e17dd1d](https://github.com/HospitalRun/hospitalrun-frontend/commit/e17dd1db2f33795f7fa6e76b3b4f90d5bdee7e48))
* remove paging stuff ([a1569b1](https://github.com/HospitalRun/hospitalrun-frontend/commit/a1569b181845a8d0543d4147d65ce00cbb799fc7))
* remove unused variable ([060d68a](https://github.com/HospitalRun/hospitalrun-frontend/commit/060d68abbb05c553418eaf199c8738fa94a871d2))
* work in progress paging and sorting ([7f856c8](https://github.com/HospitalRun/hospitalrun-frontend/commit/7f856c84ca94808b4a85d6ae6abf6ecde1351d77))
* **breadcrumb:** use a single component for Breadcrumbs ([a4c1cfb](https://github.com/HospitalRun/hospitalrun-frontend/commit/a4c1cfbcd6ab52579b469e1df54d44c0769c25bd)), closes [#1770](https://github.com/HospitalRun/hospitalrun-frontend/issues/1770)
* **diagnoses:** adds ability to add a diagnosis ([e1ce6c9](https://github.com/HospitalRun/hospitalrun-frontend/commit/e1ce6c95451116e966bee58f7c240c4952a84a32))
* **edit appointment:** add tests for Edit Appointment route ([58117b4](https://github.com/HospitalRun/hospitalrun-frontend/commit/58117b4e245a5fe14bd4e18c44a95e925bcab46f))
* **edit appointment:** fix lint errors and typo ([c22d02b](https://github.com/HospitalRun/hospitalrun-frontend/commit/c22d02b15d596289ebd7e71ab7ca8b8cae0d8b26))
* **edit appointment:** resolve merge conflicts ([63165ab](https://github.com/HospitalRun/hospitalrun-frontend/commit/63165ab1f558d88447a7ff24a7c1699757f6542b))
* **i18n:** add translation resources ([03729e5](https://github.com/HospitalRun/hospitalrun-frontend/commit/03729e5edd919d1e8e392daac2581d7a4b2c8edb))
* **i18n:** reorganize public translation resources ([761deda](https://github.com/HospitalRun/hospitalrun-frontend/commit/761deda4a2ea4dd5dbf4bbdacad72fac55cd6f3c)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **i18n:** update and resolve testing and lint issues ([d9b7722](https://github.com/HospitalRun/hospitalrun-frontend/commit/d9b7722cce667796087724823ed67c460794b951)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **patients:** success alert on new related person ([c2c491d](https://github.com/HospitalRun/hospitalrun-frontend/commit/c2c491d2083a957c7469d700af79d2b6c94ebc8c))
* **patients:** use randomly generated code instead of sequence ([1d6047d](https://github.com/HospitalRun/hospitalrun-frontend/commit/1d6047d536e994618a5e6a18f03bf3c575adffe0)), closes [#1876](https://github.com/HospitalRun/hospitalrun-frontend/issues/1876)
* **textInput:** add new input type tel ([2128500](https://github.com/HospitalRun/hospitalrun-frontend/commit/21285004c478e07c590eed5ac2670b4eeec45e20))
* **toolbar:** add tests for button toolbar ([0e56e3c](https://github.com/HospitalRun/hospitalrun-frontend/commit/0e56e3c0398480235cecc226409e83a40ff4b3da))
* **toolbar:** basic button toolbar ([af22ce0](https://github.com/HospitalRun/hospitalrun-frontend/commit/af22ce043a3749db36deb52646cf2530a6662b10))
* **toolbar:** change edit patient to toolbar button ([450b8cd](https://github.com/HospitalRun/hospitalrun-frontend/commit/450b8cd2f864ce25068f97aef0f6b4616a8b0a2b))
* **view patient:** add 'edit' icon to Edit button ([0da4043](https://github.com/HospitalRun/hospitalrun-frontend/commit/0da4043afeb495281e04f4c5c2dcff512d285ea3))


### Bug Fixes

* **moment:** add resolutions key on package.json ([e972aae](https://github.com/HospitalRun/hospitalrun-frontend/commit/e972aaebce02badce360645b3e722135b19f3056))
* **patients:** fixes search when using special characters ([#2012](https://github.com/HospitalRun/hospitalrun-frontend/issues/2012)) ([1693e5f](https://github.com/HospitalRun/hospitalrun-frontend/commit/1693e5f542b7bead83dd0495b2fb2dc4398b3319))
* adds missing translations ([6f5f9f9](https://github.com/HospitalRun/hospitalrun-frontend/commit/6f5f9f97e8cf47a2f0d5ac3211d804f348ab561a))
* fixes warnings/errors appearing in console ([5cfbc32](https://github.com/HospitalRun/hospitalrun-frontend/commit/5cfbc3295d2142f6e6787890b2915cbfb6868aa1))
* ** #1906:** fixed button position ([89f0bcd](https://github.com/HospitalRun/hospitalrun-frontend/commit/89f0bcdeb858635eda4fae4585d95e64281ea49b))
* **./locales/enus/translations/scheduling/index.ts:** changed 'Walk Up' ([837987d](https://github.com/HospitalRun/hospitalrun-frontend/commit/837987d9a4e848c7d68fb2034954ea151977e28f))
* **#1899:** added warning messages ([58f9402](https://github.com/HospitalRun/hospitalrun-frontend/commit/58f94027db50bcfb4a04170c08b7e9facafaf68b)), closes [#1899](https://github.com/HospitalRun/hospitalrun-frontend/issues/1899)
* **#1915:**  ark required fields as required for new/edit Patient ([b43facf](https://github.com/HospitalRun/hospitalrun-frontend/commit/b43facf64e11e412fd1b4dfb2b872602e5ae0f75)), closes [#1915](https://github.com/HospitalRun/hospitalrun-frontend/issues/1915)
* **adddiagnosismodal and datepickerwithlabelformgroups:** required field ([b4100f5](https://github.com/HospitalRun/hospitalrun-frontend/commit/b4100f5c692d6a589c90c75246676aa9e4a28b04)), closes [#1926](https://github.com/HospitalRun/hospitalrun-frontend/issues/1926)
* **appointments:** changed appointment type 'Walk Up' to 'Walk In' ([0968c28](https://github.com/HospitalRun/hospitalrun-frontend/commit/0968c2840b2f02288e5ce79103cc227b610932ce))
* **breadcrumb:** add the breadcrumb for the edit appointment view ([3cee578](https://github.com/HospitalRun/hospitalrun-frontend/commit/3cee57808d00fc92057ab4cd5df0be4838ff166b)), closes [#1854](https://github.com/HospitalRun/hospitalrun-frontend/issues/1854)
* **breadcrumb:** set appointment date precision to minutes in breadcrumb ([33b4dc3](https://github.com/HospitalRun/hospitalrun-frontend/commit/33b4dc31f710af25266dbb786983cb68936ef2f3)), closes [#1853](https://github.com/HospitalRun/hospitalrun-frontend/issues/1853)
* **breadcrumb label:** edit Appointment label on breadcrumb ([224a63f](https://github.com/HospitalRun/hospitalrun-frontend/commit/224a63fdd8b8ec5b7125cc776f20215302b6f25a)), closes [#1996](https://github.com/HospitalRun/hospitalrun-frontend/issues/1996)
* **build:** fixes yarn install on github ci ([814e712](https://github.com/HospitalRun/hospitalrun-frontend/commit/814e712be03fa7ccbe587a9c7ef8b8cda4a12f7f))
* **button toolbar:** align buttons to the right in the toolbar ([9b2e721](https://github.com/HospitalRun/hospitalrun-frontend/commit/9b2e721a0d9e7b33cd91fe7da4e110dfc2130ee6)), closes [#1852](https://github.com/HospitalRun/hospitalrun-frontend/issues/1852)
* **ci:** removes storybook command ([38c4b40](https://github.com/HospitalRun/hospitalrun-frontend/commit/38c4b40e9ff7caaefa07df68920eea4c27669d47))
* **component:** changed Add Diagnoses button to Add Diagnosis for [#1929](https://github.com/HospitalRun/hospitalrun-frontend/issues/1929) ([735c8f3](https://github.com/HospitalRun/hospitalrun-frontend/commit/735c8f3172d50a5bd0af2405fd1784899ed58492))
* **conflict:** merge master ([97e01d9](https://github.com/HospitalRun/hospitalrun-frontend/commit/97e01d926ed04e47b93d7ea3e92e6efc262d1330))
* **i18n:** fix file type ([cf305bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/cf305bcad8175d2df9b5a3e1947b27a6fa45a9a7))
* **i18n:** fix file type and import ([98c25b9](https://github.com/HospitalRun/hospitalrun-frontend/commit/98c25b99c9bdc16078ee6552925a2c183a511c6f)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **i18n:** fix i18n translation keys and reorganize files ([dba5165](https://github.com/HospitalRun/hospitalrun-frontend/commit/dba51659f51ab8d36ed8a86bdf16d4b8fc60d76b)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **i18n:** fix search button properties ([59680a0](https://github.com/HospitalRun/hospitalrun-frontend/commit/59680a054baea29c1d99e9a5c9c4ab0d3e246b5b)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **i18n:** merge changes from upstream ([0726ac3](https://github.com/HospitalRun/hospitalrun-frontend/commit/0726ac39bf6e61f83bd72581d72e2d2bd59fcee0)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **i18n:** update translation resources for enUs and ptBr ([68bb92c](https://github.com/HospitalRun/hospitalrun-frontend/commit/68bb92c596b016364690cc2997d9cfe5bca4df6f)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **labs:** Cleanup small issues with lab section ([#2010](https://github.com/HospitalRun/hospitalrun-frontend/issues/2010)) ([e445a97](https://github.com/HospitalRun/hospitalrun-frontend/commit/e445a97df7961bfa3ef27e3c0823739d613e994f))
* **navbar:** add missing i18n t function ([c7fd937](https://github.com/HospitalRun/hospitalrun-frontend/commit/c7fd937050e95f8dbd20d5a81c3c274dfdd22c68)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)
* **newPatient:** correct input types of email and phone fields ([7b6b2cc](https://github.com/HospitalRun/hospitalrun-frontend/commit/7b6b2cc5f5135f4b68256985c3056a75c8cdb7d6))
* **patient:** appointments list tests ([af66ec6](https://github.com/HospitalRun/hospitalrun-frontend/commit/af66ec68c5c34d87755205c3dfab3debce7bd393))
* **patient:** Input validation and error feedback ([#1977](https://github.com/HospitalRun/hospitalrun-frontend/issues/1977)) ([992e58d](https://github.com/HospitalRun/hospitalrun-frontend/commit/992e58df8ebdaac2e2df2b0e50423608513a5176))
* **patient:** mark required fields in New Appointment/Edit Appointment ([47d14a0](https://github.com/HospitalRun/hospitalrun-frontend/commit/47d14a0d1643a77f6b2b21197918d6c6f541f638)), closes [#1916](https://github.com/HospitalRun/hospitalrun-frontend/issues/1916)
* **patients:** add translation for patient.Code ([#1994](https://github.com/HospitalRun/hospitalrun-frontend/issues/1994)) ([c703928](https://github.com/HospitalRun/hospitalrun-frontend/commit/c703928c3e2ded25207d7f2ecfbf7a0441743ef8))
* **patients:** current patient can no longer be related person ([#1959](https://github.com/HospitalRun/hospitalrun-frontend/issues/1959)) ([b816ebf](https://github.com/HospitalRun/hospitalrun-frontend/commit/b816ebf84661fe7290338451fe2737dfc1c0efa2))
* **search:** fixes search inputs being too small ([5c67b72](https://github.com/HospitalRun/hospitalrun-frontend/commit/5c67b72f46f32e177b10b6a30bc2039ca2874514))
* **translations:** missing translations values ([#1939](https://github.com/HospitalRun/hospitalrun-frontend/issues/1939)) ([79433a4](https://github.com/HospitalRun/hospitalrun-frontend/commit/79433a410090cb1f2a98d135bdcad4b688af00aa))
* add @types/uuid ([9c786cf](https://github.com/HospitalRun/hospitalrun-frontend/commit/9c786cf41d1c8b6eecd10c1bc6ce0ab3068ca0fc))
* fix time based test ([4b94d53](https://github.com/HospitalRun/hospitalrun-frontend/commit/4b94d53bf839ca6b99c71c9009a25edb94bb8522))
* typo in changelog.md ([b7465be](https://github.com/HospitalRun/hospitalrun-frontend/commit/b7465be520174327be6775753854fdbf65cca4a4))
* **schedual button:** fixed delete appointment button ([91baf9d](https://github.com/HospitalRun/hospitalrun-frontend/commit/91baf9d25dde7c61981ba1c20826d3d98f224f72)), closes [#1901](https://github.com/HospitalRun/hospitalrun-frontend/issues/1901)
* **translations:** ptBR alergies and diagnoses ([f2db2e3](https://github.com/HospitalRun/hospitalrun-frontend/commit/f2db2e3a62b9ec72b04463909333dbf472435801))
* fix multiple imports lint error ([e1e1f4c](https://github.com/HospitalRun/hospitalrun-frontend/commit/e1e1f4c33e984f87a81390cf3399632172cc8c4b))
* remove unused imports ([b9ee43a](https://github.com/HospitalRun/hospitalrun-frontend/commit/b9ee43a6ba7f97a5ccc231de7a70f87f0d63cbe1))
* use a different style import ([a6e97ea](https://github.com/HospitalRun/hospitalrun-frontend/commit/a6e97ea019ccb14cf459d7f265fee8bd469ac1f8))
* use uuidv4 instead of timestamps for autogenerated ids ([258cab8](https://github.com/HospitalRun/hospitalrun-frontend/commit/258cab8494ccce2830077fa4f8cfa2bf50ada0b8)), closes [#1877](https://github.com/HospitalRun/hospitalrun-frontend/issues/1877)
* **test:** cleaned up id and fixed test with sequential insert ([0f061d2](https://github.com/HospitalRun/hospitalrun-frontend/commit/0f061d2bec64883453c7ca283c541db846459f51))
* **test:** fix warning about missing key ([55b5fbd](https://github.com/HospitalRun/hospitalrun-frontend/commit/55b5fbd58e47f331731aa611d5c08f38438d8890))
* **test:** update patient slice test to match resource update ([0a23b8c](https://github.com/HospitalRun/hospitalrun-frontend/commit/0a23b8c675907d7df239652511005e2bf4242064)), closes [#1668](https://github.com/HospitalRun/hospitalrun-frontend/issues/1668)

## [2.0.0-alpha.2](https://github.com/HospitalRun/hospitalrun-frontend/compare/v2.0.0-alpha.1...v2.0.0-alpha.2) (2020-02-15)


### Features

* **appointmentslist:** add an appointments tab to the patient view ([deee00e](https://github.com/HospitalRun/hospitalrun-frontend/commit/deee00e52f2bab2fec8518d4e8cdfa6f67c2cf75)), closes [#1769](https://github.com/HospitalRun/hospitalrun-frontend/issues/1769)
* **edit patient:** implement Edit Patient functionality ([8e3355f](https://github.com/HospitalRun/hospitalrun-frontend/commit/8e3355f2124186b6ead1a710abb3010695e51abf))
* **edit patient:** moved buttons out of GeneralInformation ([403e49f](https://github.com/HospitalRun/hospitalrun-frontend/commit/403e49feb130d16718fb014e1a27ea218915bb7e))
* **env:** adds hospitalrun server information ([7f0fe7f](https://github.com/HospitalRun/hospitalrun-frontend/commit/7f0fe7fa47d0705d585f7ca15d4796e1c90c2f16))
* **env:** change env variable names ([cddc812](https://github.com/HospitalRun/hospitalrun-frontend/commit/cddc812ae5bd1f1b05e7310b5a504b51ecee1981))
* add documentation folder ([d22300e](https://github.com/HospitalRun/hospitalrun-frontend/commit/d22300e8a56be56c7edef6f914d7b9c5381aea7f))
* **navigation:** navigate to patients profile on related person click ([c6acecc](https://github.com/HospitalRun/hospitalrun-frontend/commit/c6acecc3c89b0aeb96fa6c6fea15b316ee0669a2)), closes [#1763](https://github.com/HospitalRun/hospitalrun-frontend/issues/1763)
* **relatedpersontab:** add cursor icon to related persons list ([ef7e19c](https://github.com/HospitalRun/hospitalrun-frontend/commit/ef7e19cabf596afd08d4e15449a96285541149d1)), closes [#1792](https://github.com/HospitalRun/hospitalrun-frontend/issues/1792)
* **test:** add navigate to related person profile onclick test ([29fbffe](https://github.com/HospitalRun/hospitalrun-frontend/commit/29fbffec0848f0e0fed54b133513cfb1471ddacb)), closes [#1792](https://github.com/HospitalRun/hospitalrun-frontend/issues/1792)


### Bug Fixes

* **patient-slice.ts:** conditionally render family name and suffix ([d20e294](https://github.com/HospitalRun/hospitalrun-frontend/commit/d20e294340a155cb90138ea9bf5210e6e697ea71)), closes [#1818](https://github.com/HospitalRun/hospitalrun-frontend/issues/1818)
* **patients:** add test for displaying No Related Persons warning ([da6bdb1](https://github.com/HospitalRun/hospitalrun-frontend/commit/da6bdb19e3609e1d8fca6d08349c71814162f536)), closes [#1789](https://github.com/HospitalRun/hospitalrun-frontend/issues/1789)
* **patients:** internationalize No Related Persons warning & loading ([099e50d](https://github.com/HospitalRun/hospitalrun-frontend/commit/099e50d846e1574dff2b28aafd77b7d01c4da955)), closes [#1789](https://github.com/HospitalRun/hospitalrun-frontend/issues/1789)
* **patients:** replace "Loading..." text with Spinner component ([e6ce4cb](https://github.com/HospitalRun/hospitalrun-frontend/commit/e6ce4cb979d3f3cd7c3704490ad4251955f4922f)), closes [#1789](https://github.com/HospitalRun/hospitalrun-frontend/issues/1789)
* **patients:** stop "Loading..." when patient has no related persons ([e513b17](https://github.com/HospitalRun/hospitalrun-frontend/commit/e513b172e25f24126969564a0e7d4f421758e626)), closes [#1789](https://github.com/HospitalRun/hospitalrun-frontend/issues/1789)
* **persons:** replace "No related persons" message with a warning ([c156b5b](https://github.com/HospitalRun/hospitalrun-frontend/commit/c156b5bba25b008be3bd7d11cd393e2f12fb49cb)), closes [#1789](https://github.com/HospitalRun/hospitalrun-frontend/issues/1789)
* **prettier:** changes endofline option ([1fbd965](https://github.com/HospitalRun/hospitalrun-frontend/commit/1fbd9658b4869d7f98b4ae918e731012e4b4b9a3))
* **test:** add related test, and revert test changes ([9bead70](https://github.com/HospitalRun/hospitalrun-frontend/commit/9bead7078f8ea94680f24d865f576ae786ce5178)), closes [#1792](https://github.com/HospitalRun/hospitalrun-frontend/issues/1792)
* **test:** remove extra whitespace ([155b4e9](https://github.com/HospitalRun/hospitalrun-frontend/commit/155b4e939151beb994808bae22dd2cd74845da39)), closes [#1792](https://github.com/HospitalRun/hospitalrun-frontend/issues/1792)
* **test:** remove unused import ([fc3a78d](https://github.com/HospitalRun/hospitalrun-frontend/commit/fc3a78d70f285a120a9d0f690320d6c6fa5e5696)), closes [#1792](https://github.com/HospitalRun/hospitalrun-frontend/issues/1792)

## 2.0.0-alpha.1 (2020-02-07)


### ⚠ BREAKING CHANGES

* **frontend:** update components package changing some interfaces
* This module no longer supports Node.js 0.10

### Features

* add analyze script ([3b60961](https://github.com/HospitalRun/hospitalrun-frontend/commit/3b60961f3875ca763893f1be2d63f304a83dd9d1))
* **appointments:** add ability to view appointment ([93bde54](https://github.com/HospitalRun/hospitalrun-frontend/commit/93bde5463653a0f0784170bc5ce7f0943d7cda76))
* **appointments:** add create appointment functionality ([723bec3](https://github.com/HospitalRun/hospitalrun-frontend/commit/723bec3b05184631fd611f0a9c65b495974f289f))
* **appointments:** adds ability to display appointments on calendar ([842b9ee](https://github.com/HospitalRun/hospitalrun-frontend/commit/842b9eed442ebf301da58fc81855c60905633b1b))
* **appointments:** adds new appointment route ([86c9a32](https://github.com/HospitalRun/hospitalrun-frontend/commit/86c9a325c57176e89b93aa43c888f5bcb0156ae8))
* **appointments:** adds screen to view appointment ([f31e852](https://github.com/HospitalRun/hospitalrun-frontend/commit/f31e852e83b130e024d212dd5d092c6c24c6d77e))
* **appointments:** display patient full name for appointments ([9bdb933](https://github.com/HospitalRun/hospitalrun-frontend/commit/9bdb933b066f45f3c7f594d0ebdf5415c2b6d88b))
* **appointments:** refactored appointment detail form to own component ([a0be28b](https://github.com/HospitalRun/hospitalrun-frontend/commit/a0be28b129ea67deb7d3934db08d68bd745bfdf1))
* **db:** adds remote couchdb ([d8e7a55](https://github.com/HospitalRun/hospitalrun-frontend/commit/d8e7a55b51170ca4484bcc252d7b5177c2a0172d))
* **i18n:** add internationalization ([0f69f84](https://github.com/HospitalRun/hospitalrun-frontend/commit/0f69f8466855ea5435ba31d24a93d7d44c39ea83))
* **init:** add basic routing ([c220b96](https://github.com/HospitalRun/hospitalrun-frontend/commit/c220b9667bf25569a73b9859c622d2cfd39fe5e2))
* **init:** add dashboard view, and useTitle hook ([d3835d6](https://github.com/HospitalRun/hospitalrun-frontend/commit/d3835d69e2753eaa539fc61c789b4969178edf23))
* **init:** add hospitalrun/components to package.json ([078dcf9](https://github.com/HospitalRun/hospitalrun-frontend/commit/078dcf9d7b2611fc4ea8546479194664a88c3276))
* **init:** add permissions for routes ([7a19200](https://github.com/HospitalRun/hospitalrun-frontend/commit/7a19200c2f6640d72737b156e3c994d1595cfdcd))
* **init:** add redux ([183d65c](https://github.com/HospitalRun/hospitalrun-frontend/commit/183d65cc837e2fb8539564dbf06c474b242cf611))
* **init:** cleans up interfaces for PatientForm ([2063b20](https://github.com/HospitalRun/hospitalrun-frontend/commit/2063b20b60b44f42ae9c92a1a17a69d4b94fac26))
* **init:** cleans up update patient code ([d6ab622](https://github.com/HospitalRun/hospitalrun-frontend/commit/d6ab6222395c93fa9cd5db2e483c81110f5d6295))
* **init:** creates a generic repository class and refactors patient db ([24940b4](https://github.com/HospitalRun/hospitalrun-frontend/commit/24940b4e80315f94cb92bfcbf34300cf8ddc30ec))
* **init:** creates a very simple pouchdb client ([c6d712b](https://github.com/HospitalRun/hospitalrun-frontend/commit/c6d712b6bd2fb74adc61d9de88e58673418bdcb4))
* **init:** fix warnings comming from manifest ([1dca924](https://github.com/HospitalRun/hospitalrun-frontend/commit/1dca9249c1d440cabb79784e8570d21ef106c70c))
* **init:** mock pouchdb ([7373e8d](https://github.com/HospitalRun/hospitalrun-frontend/commit/7373e8de447e79d6a8998736436a1c8396241f0b))
* **init:** remove warnings in tests ([3d7be47](https://github.com/HospitalRun/hospitalrun-frontend/commit/3d7be47d1d691b9ef547937a4391c8da1cc39894))
* **init:** rename store/store.ts to store/index.ts ([cd861e3](https://github.com/HospitalRun/hospitalrun-frontend/commit/cd861e3adb2c15ce53ce3c69676f7e5c0eeff6ec))
* **init:** update NewPatient to not use Patient slice ([c4ced2c](https://github.com/HospitalRun/hospitalrun-frontend/commit/c4ced2c157264089f69c6f53b3f89ced69b50f78))
* **init:** update to use models ([273b000](https://github.com/HospitalRun/hospitalrun-frontend/commit/273b000537ca45825f7c1c71236431a74c9ad7b6))
* **patientform:** added patient form error handling ([c17aa0a](https://github.com/HospitalRun/hospitalrun-frontend/commit/c17aa0aef887d76fd03ba3bfd7fcc8a4a464fdca))
* **patients:** add ability to add and display related persons ([4516e89](https://github.com/HospitalRun/hospitalrun-frontend/commit/4516e892ce7da97bf777f204ae3e1a826c8d0fa4))
* **patients:** add ability to store full name ([36ababf](https://github.com/HospitalRun/hospitalrun-frontend/commit/36ababf742141e5961807bd1809b34b593235165))
* **patients:** add ability to view a patient ([a73e7f0](https://github.com/HospitalRun/hospitalrun-frontend/commit/a73e7f086b4cd7bb22f7963ed3e3345494c590f4))
* **patients:** add error message for missing required fields ([148b220](https://github.com/HospitalRun/hospitalrun-frontend/commit/148b220cd7bbd43ffd71c15fde086b85c233c1ec))
* **patients:** add permission check to add button ([1a4e5af](https://github.com/HospitalRun/hospitalrun-frontend/commit/1a4e5afa527a01d19e76823c6df0948073d0d349))
* **patients:** add saveOrUpdate function in repositories ([c9a6913](https://github.com/HospitalRun/hospitalrun-frontend/commit/c9a6913800cf80bb88b8a39b2242d4b6080d79e0))
* **patients:** add success message when patient is created successfully ([3c2b2ae](https://github.com/HospitalRun/hospitalrun-frontend/commit/3c2b2ae978a856037d66e3d32fda4b3c3e0f5836)), closes [#1701](https://github.com/HospitalRun/hospitalrun-frontend/issues/1701)
* **patients:** add tabs in patient view ([3eea135](https://github.com/HospitalRun/hospitalrun-frontend/commit/3eea135c9b643a181c54da37a0fb70f55571f96d))
* **patients:** add tabs in patient view ([582770e](https://github.com/HospitalRun/hospitalrun-frontend/commit/582770ec573718bc065a02cc216c434487bb8953))
* **patients:** add tests for patients-slice and move files ([c2ef440](https://github.com/HospitalRun/hospitalrun-frontend/commit/c2ef440425b15baa64a262f64d0d81d355856294))
* **patients:** add update patient reducers/actions ([687d125](https://github.com/HospitalRun/hospitalrun-frontend/commit/687d125bb139d29dd2d6c281363ddc46130fb176))
* **patients:** add very simple create patient page ([bb94ef0](https://github.com/HospitalRun/hospitalrun-frontend/commit/bb94ef0cf5e4461a4d84515cc695db66fd229fc7))
* **patients:** add very simple way of displaying all patients ([927b5bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/927b5bc8ea606ad8a70c2603d2afbcae99744643))
* **patients:** adds a friendlyId ([ad9fb13](https://github.com/HospitalRun/hospitalrun-frontend/commit/ad9fb133b2f890b89ed507dcd81934a42aef0d30)), closes [#1709](https://github.com/HospitalRun/hospitalrun-frontend/issues/1709)
* **patients:** adds ability to approximate age when creating patient ([c8eba48](https://github.com/HospitalRun/hospitalrun-frontend/commit/c8eba48017f6dc27de32f3096a45037fa775c046))
* **patients:** adds ability to search by patient friendlyId ([a519550](https://github.com/HospitalRun/hospitalrun-frontend/commit/a51955046ae2f8841b5561fa01800698af2cfdf2)), closes [#1709](https://github.com/HospitalRun/hospitalrun-frontend/issues/1709)
* **patients:** adds abilty to search for patients by full name ([4468b59](https://github.com/HospitalRun/hospitalrun-frontend/commit/4468b59b5e1a3a6c13bacd56fa479cebf32f6954)), closes [#1707](https://github.com/HospitalRun/hospitalrun-frontend/issues/1707)
* **patients:** adds functionality to save patient ([c6159af](https://github.com/HospitalRun/hospitalrun-frontend/commit/c6159af39afb6aa325191e06229908d5e9479479))
* **patients:** adds tests for new patients form, inputs, and route" ([a7bf838](https://github.com/HospitalRun/hospitalrun-frontend/commit/a7bf8381a02c541496d2f30efbfafb15c4f145d5))
* **patients:** call findAll if search string is empty ([3ab5d13](https://github.com/HospitalRun/hospitalrun-frontend/commit/3ab5d1325a95983b566ed4e7f68e7c78ddad7836))
* **patients:** change search to be more of a fuzzy search ([7ebedd1](https://github.com/HospitalRun/hospitalrun-frontend/commit/7ebedd1ec37cb003ccef45995d1c8c6c49d43c66))
* **patients:** change the new patients route ([9072ac9](https://github.com/HospitalRun/hospitalrun-frontend/commit/9072ac910538c9d7425b4f1a96db8bfd6f17e740))
* **patients:** changes id to be a timestamp instead of random" ([bd54bb7](https://github.com/HospitalRun/hospitalrun-frontend/commit/bd54bb72348303e9ca8e9b1a2b8726688d77ef9a))
* **patients:** fix routing after successfully creating new patient ([d23f860](https://github.com/HospitalRun/hospitalrun-frontend/commit/d23f860ce7e71cf892e7584e2eef6de0d4c79a70))
* **patients:** flatten name object ([9bc4365](https://github.com/HospitalRun/hospitalrun-frontend/commit/9bc43653ac1526ff7e432bd3d5a99fd1a16107a6))
* **patients:** move date of birth information up a line ([bf45cce](https://github.com/HospitalRun/hospitalrun-frontend/commit/bf45cce152ec633efcc60bab12cdd46768ef3d99))
* **patients:** pass is approximate date of birth flag ([281674c](https://github.com/HospitalRun/hospitalrun-frontend/commit/281674cbb3d9caff84ce17f8992101b7d351ff46))
* **patients:** refactor name and contact information to  own interface ([26543af](https://github.com/HospitalRun/hospitalrun-frontend/commit/26543af294581974d02bf528c3acb69666c69bbf))
* **patients:** remove delete button that was there for testing ([3fbbfd4](https://github.com/HospitalRun/hospitalrun-frontend/commit/3fbbfd458175d06e8b98f941e91fcd744d990d92))
* **patients:** use button toolbar ([bf681cd](https://github.com/HospitalRun/hospitalrun-frontend/commit/bf681cd6e0eff9b4da6e301991f7eb1fee2e31c6))
* **patients:** use date-fns in favor of luxon ([97cf263](https://github.com/HospitalRun/hospitalrun-frontend/commit/97cf2636e987bf219f7a8836aaf04e63c98b59be))
* **patients:** use hospital run date picker ([9758986](https://github.com/HospitalRun/hospitalrun-frontend/commit/97589861aa4fc5e98052f7946befcff8b9c718fb))
* **patients:** use panels for grouping content in view patient ([452419c](https://github.com/HospitalRun/hospitalrun-frontend/commit/452419c8dccce23aa12df1518e2e641031b63d85))
* **patients:** use patient typeahead to find related person ([7565b5a](https://github.com/HospitalRun/hospitalrun-frontend/commit/7565b5ab071874eb6dae8a2c32b6b558698cacd3))
* **pwa:** adds pwa support ([e621489](https://github.com/HospitalRun/hospitalrun-frontend/commit/e6214893e5f7c869a8db388988b8bd255324b491)), closes [#1711](https://github.com/HospitalRun/hospitalrun-frontend/issues/1711)
* **scheduling:** add scheduling dropdown to navbar ([2375481](https://github.com/HospitalRun/hospitalrun-frontend/commit/2375481d2320338c9ba90e49a82f57ac4d6045e2))
* **scheduling:** add scheduling module and appointments ([02702bc](https://github.com/HospitalRun/hospitalrun-frontend/commit/02702bce291c03023e2b7a821cc970f89c5cd3a9))
* **toolchain:** adds commit script ([3fc9c2f](https://github.com/HospitalRun/hospitalrun-frontend/commit/3fc9c2fc661104f898d1533c057ea3f0388965ff))


### Bug Fixes

* **build:** add test after lint in precommit husky hook ([5e7c410](https://github.com/HospitalRun/hospitalrun-frontend/commit/5e7c41002a4e3afc160798264bf88498808f155f)), closes [#1775](https://github.com/HospitalRun/hospitalrun-frontend/issues/1775)
* **build:** fix prettier/eslint config ([e041e22](https://github.com/HospitalRun/hospitalrun-frontend/commit/e041e221bb09bcec280e17b14138d5d311ebd8c5)), closes [#1782](https://github.com/HospitalRun/hospitalrun-frontend/issues/1782)
* **build:** modify husky and lint-staged config to fix lint issue ([66076e6](https://github.com/HospitalRun/hospitalrun-frontend/commit/66076e63c39826f6099e439433f843a864ce255c)), closes [#1775](https://github.com/HospitalRun/hospitalrun-frontend/issues/1775)
* **build:** remove extra test ([9b5d70b](https://github.com/HospitalRun/hospitalrun-frontend/commit/9b5d70b2a0575fff2ee6afb40b0b42135b88f90e)), closes [#1780](https://github.com/HospitalRun/hospitalrun-frontend/issues/1780)
* **build:** test precommit config ([a293884](https://github.com/HospitalRun/hospitalrun-frontend/commit/a2938847b5196b6d9dee2864106aa983df1773b9)), closes [#1782](https://github.com/HospitalRun/hospitalrun-frontend/issues/1782)
* **dep:** fix missing react-bootstrap dependency ([500c680](https://github.com/HospitalRun/hospitalrun-frontend/commit/500c680795a3b98c7b3e99a3b35058848c8c3a5e))
* **docs:** fixes badge url on readme ([db127b6](https://github.com/HospitalRun/hospitalrun-frontend/commit/db127b6b3d4587fdb49fe568b74841fbdf3e74f3))
* **frontend:** make onclick undefined to avoid lint issue ([25ddab7](https://github.com/HospitalRun/hospitalrun-frontend/commit/25ddab75d0c5e1e56ff35a085f56f43d675dd10b)), closes [#1781](https://github.com/HospitalRun/hospitalrun-frontend/issues/1781)
* **frontend:** update navbar component to match new format ([ade4abf](https://github.com/HospitalRun/hospitalrun-frontend/commit/ade4abffd62411aa461f90eeddc85ab0df4b23b6)), closes [#1781](https://github.com/HospitalRun/hospitalrun-frontend/issues/1781)
* **hook:** improves eslint precommit hook ([639f122](https://github.com/HospitalRun/hospitalrun-frontend/commit/639f122b11e6eee2953d0ad40db6edbd22b82f61))
* **lint:** fixes eslint ([75e1756](https://github.com/HospitalRun/hospitalrun-frontend/commit/75e175665ef744cac1d6ea639e0a732a4c566d7b))
* **locales/de:** languageName ([1cfba70](https://github.com/HospitalRun/hospitalrun-frontend/commit/1cfba70a937ae0eced0baec836ac52cfb4373a76))
* **nav-sidebar:** current route highlighting ([357e4b5](https://github.com/HospitalRun/hospitalrun-frontend/commit/357e4b5679096ed53a628c8cc7b60e1b90196b78))
* **navbar:** fixes broken link to new patients in navbar ([e4cf64d](https://github.com/HospitalRun/hospitalrun-frontend/commit/e4cf64d44ce1c6b9baabff08cb86d557f7a5688c))
* **newpatientform.test.tsx:** fix to spacing according to lint rules ([55043fa](https://github.com/HospitalRun/hospitalrun-frontend/commit/55043fad76c5c0ab053941a866598a6d53619c4c))
* **package:** update electron-localshortcut to version 3.0.4 ([5e98e76](https://github.com/HospitalRun/hospitalrun-frontend/commit/5e98e760a0e3c39a74c238b7b1c7425b7efc7ec5))
* **patients:** fix 'Attempted to log TypeError: Cannot read property 'body' of null' warning ([2c439d6](https://github.com/HospitalRun/hospitalrun-frontend/commit/2c439d613af90ef1398d1bed7a4553a4b15ca6bf))
* **patients:** fix broken name display in view patient adn lsit patient ([8ff0ac9](https://github.com/HospitalRun/hospitalrun-frontend/commit/8ff0ac913f0cee0f8d738a7cfaee57b2722c350f))
* **patients:** fix issue with patient duplicating on update ([ae44b90](https://github.com/HospitalRun/hospitalrun-frontend/commit/ae44b903de2a1ecd7f4d8724f82f1a67ae38ca32))
* **patients:** fix typo in classnames ([c4f0c92](https://github.com/HospitalRun/hospitalrun-frontend/commit/c4f0c928509509db81513dd04b4e64034fbc7a9d))
* **patients:** makes patient search case insensitive ([4303b6c](https://github.com/HospitalRun/hospitalrun-frontend/commit/4303b6c3523576df8125980df98d81bb8512db20))
* **scss:** add node-sass ([0e7b0c7](https://github.com/HospitalRun/hospitalrun-frontend/commit/0e7b0c72c2efa7b00cf4b361065b2bd50e1e96a1))
* **test:** update navbar tests for component update ([7cd00d8](https://github.com/HospitalRun/hospitalrun-frontend/commit/7cd00d82a3693ec9984d9ef8b39f5e1a0807198f)), closes [#1782](https://github.com/HospitalRun/hospitalrun-frontend/issues/1782)
* add .idea/ default intellij folder to .gitignore ([67bcda3](https://github.com/HospitalRun/hospitalrun-frontend/commit/67bcda33f9730e933ff7264f76d19a89b431ec34))
* adjusted code as requests in pr and fixed linting errors ([59447dc](https://github.com/HospitalRun/hospitalrun-frontend/commit/59447dc391ed98b3a3c0ead3ede5e31448fc3c28))
* delete payments and line items when deleting invoices ([05527ae](https://github.com/HospitalRun/hospitalrun-frontend/commit/05527ae49db4c8a61fad38245e63b1f7a0fe2a6e))
* fixed edit operative plan title bug ([db469da](https://github.com/HospitalRun/hospitalrun-frontend/commit/db469da9a5eed20f74e7f139ab0b785a2af55abb))
* fixed edit operative plan title test ([51a6c3e](https://github.com/HospitalRun/hospitalrun-frontend/commit/51a6c3ecca1b80edecd5d5b887abc60885cf6c35))
* internationalization dubplicate fix & fix to translation json ([543cf74](https://github.com/HospitalRun/hospitalrun-frontend/commit/543cf741187b77cc1e92c4c956c14ddeeb59954e))
* internationalization dubplicate fix & fix to translation json ([6f54562](https://github.com/HospitalRun/hospitalrun-frontend/commit/6f545624835c254f5eedd728c643612571a2a283))
* lint build error fixes to newpatientform test file ([9bf8cef](https://github.com/HospitalRun/hospitalrun-frontend/commit/9bf8cefeb3051502e6314e250fe90ea42640c5ea))
* lint build error fixes to newpatientform test file{2} ([a5d625c](https://github.com/HospitalRun/hospitalrun-frontend/commit/a5d625c4f534cf6e7d340532bc98a76f6893bca4))
* small change to naming of json key in translation.json ([0edc07f](https://github.com/HospitalRun/hospitalrun-frontend/commit/0edc07fa5500d70ae9232f66f52eb701529cf612))
* **scss:** import scss from components library ([45cb83f](https://github.com/HospitalRun/hospitalrun-frontend/commit/45cb83f1712d2b7370388a7c9c269353a18914c4))
* **test:** adds coveralls like devdeps ([710c3c5](https://github.com/HospitalRun/hospitalrun-frontend/commit/710c3c5b0ddc500dfcd02df2c3ff58284177b8cb))
* **test:** fixes coveralls coverage ([9b321fa](https://github.com/HospitalRun/hospitalrun-frontend/commit/9b321fa0ba71e1eb2ad23cad8767a8358be411da))
* **test:** updates coveralls script ([324ca3b](https://github.com/HospitalRun/hospitalrun-frontend/commit/324ca3b5b2a965e6ad32fe1766716a6bcec640a2))
* **test:** updates coveralls script ([f8844ed](https://github.com/HospitalRun/hospitalrun-frontend/commit/f8844ed74345a6bf455bcfb28154ed03f21e6d51))
* **tests:** fix matchMediaMock issue when running tests ([2edfe1b](https://github.com/HospitalRun/hospitalrun-frontend/commit/2edfe1b247ec5d0e5d5e372e0facb82be535af3f))
* remove swap files inadverdently checked in ([9d2040d](https://github.com/HospitalRun/hospitalrun-frontend/commit/9d2040da45bf1e0a90d6468d4ab7d493e7a41e91))
* when deleting patient records, also delete appointments, payments, invoice line items and proc charges ([5939a73](https://github.com/HospitalRun/hospitalrun-frontend/commit/5939a738f3fce786dca84e32246236c4681767f4))


* drop support for Node.js 0.10 ([#782](https://github.com/HospitalRun/hospitalrun-frontend/issues/782)) ([c3e2dae](https://github.com/HospitalRun/hospitalrun-frontend/commit/c3e2dae5f3f16010a572a046697be9372169daa5))

# 1.0.0 (2019-10-15)


### Bug Fixes

* delete payments and line items when deleting invoices ([05527ae](https://github.com/HospitalRun/hospitalrun-frontend/commit/05527ae49db4c8a61fad38245e63b1f7a0fe2a6e))
* fixed edit operative plan title bug ([db469da](https://github.com/HospitalRun/hospitalrun-frontend/commit/db469da9a5eed20f74e7f139ab0b785a2af55abb))
* fixed edit operative plan title test ([51a6c3e](https://github.com/HospitalRun/hospitalrun-frontend/commit/51a6c3ecca1b80edecd5d5b887abc60885cf6c35))
* remove swap files inadverdently checked in ([9d2040d](https://github.com/HospitalRun/hospitalrun-frontend/commit/9d2040da45bf1e0a90d6468d4ab7d493e7a41e91))
* when deleting patient records, also delete appointsments, payments, invoice line items and proc charges ([5939a73](https://github.com/HospitalRun/hospitalrun-frontend/commit/5939a738f3fce786dca84e32246236c4681767f4))
* **docs:** fixes badge url on readme ([db127b6](https://github.com/HospitalRun/hospitalrun-frontend/commit/db127b6b3d4587fdb49fe568b74841fbdf3e74f3))
* **locales/de:** languageName ([1cfba70](https://github.com/HospitalRun/hospitalrun-frontend/commit/1cfba70a937ae0eced0baec836ac52cfb4373a76))
* **nav-sidebar:** current route highlighting ([357e4b5](https://github.com/HospitalRun/hospitalrun-frontend/commit/357e4b5679096ed53a628c8cc7b60e1b90196b78))
* **package:** update electron-localshortcut to version 3.0.4 ([5e98e76](https://github.com/HospitalRun/hospitalrun-frontend/commit/5e98e760a0e3c39a74c238b7b1c7425b7efc7ec5))


### chore

* drop support for Node.js 0.10 ([#782](https://github.com/HospitalRun/hospitalrun-frontend/issues/782)) ([c3e2dae](https://github.com/HospitalRun/hospitalrun-frontend/commit/c3e2dae5f3f16010a572a046697be9372169daa5))


### Features

* **toolchain:** adds commit script ([3fc9c2f](https://github.com/HospitalRun/hospitalrun-frontend/commit/3fc9c2fc661104f898d1533c057ea3f0388965ff))


### Performance Improvements

* **docker:** add `yarn` for faster dependency installs ([ae1ca43](https://github.com/HospitalRun/hospitalrun-frontend/commit/ae1ca43da091eb28bf62da92272cf204675ecbc7))


### BREAKING CHANGES

* This module no longer supports Node.js 0.10
