class Uv < Formula
  desc "Extremely fast Python package installer and resolver, written in Rust"
  homepage "https://github.com/astral-sh/uv"
  url "https://github.com/astral-sh/uv/archive/refs/tags/0.5.14.tar.gz"
  sha256 "356601e46d5daee7c1f999ca3f23550b2d3f015c8669934af8e425401ddbfd9c"
  license any_of: ["Apache-2.0", "MIT"]
  head "https://github.com/astral-sh/uv.git", branch: "main"

  bottle do
    sha256 cellar: :any_skip_relocation, arm64_sequoia: "59700a83de432e0da4ac978206746b4f1fe728d16b7f298ee0bcbb1c195fa3a1"
    sha256 cellar: :any_skip_relocation, arm64_sonoma:  "bdb873b0000702a5bd42e455479c100e3f6199ce4114084fa4ba26d211e7849d"
    sha256 cellar: :any_skip_relocation, arm64_ventura: "d6900f28c8d3bcbedfa656d77a5c46ba9dd2c1dcb3c16492e0f930073303b590"
    sha256 cellar: :any_skip_relocation, sonoma:        "e7f7d5857623f01a41711af6510800707daa22ef36d15e689bf99f24d9df469b"
    sha256 cellar: :any_skip_relocation, ventura:       "ded92bd8d2743b089ac3bcb0366c7fca97d45bb777835b0557cb92ac34b463ba"
    sha256 cellar: :any_skip_relocation, x86_64_linux:  "b2ee38fc6b27ad48a2e09ad1e0555c3a828d679d199d0c663b1ea79466fd7137"
  end

  depends_on "pkgconf" => :build
  depends_on "rust" => :build

  uses_from_macos "python" => :test
  uses_from_macos "bzip2"
  uses_from_macos "xz"

  def install
    ENV["UV_COMMIT_HASH"] = ENV["UV_COMMIT_SHORT_HASH"] = tap.user
    ENV["UV_COMMIT_DATE"] = time.strftime("%F")
    system "cargo", "install", "--no-default-features", *std_cargo_args(path: "crates/uv")
    generate_completions_from_executable(bin/"uv", "generate-shell-completion")
    generate_completions_from_executable(bin/"uvx", "--generate-shell-completion")
  end

  test do
    (testpath/"requirements.in").write <<~REQUIREMENTS
      requests
    REQUIREMENTS

    compiled = shell_output("#{bin}/uv pip compile -q requirements.in")
    assert_match "This file was autogenerated by uv", compiled
    assert_match "# via requests", compiled

    assert_match "ruff 0.5.1", shell_output("#{bin}/uvx -q ruff@0.5.1 --version")
  end
end
