class Typeshare < Formula
  desc "Synchronize type definitions between Rust and other languages for seamless FFI"
  homepage "https://github.com/1Password/typeshare"
  url "https://github.com/1Password/typeshare/archive/refs/tags/v1.13.2.tar.gz"
  sha256 "7640e70720190576aa82df57561841f33720281e55dc65fedcc0cd89ccc411e2"
  license any_of: ["Apache-2.0", "MIT"]
  head "https://github.com/1Password/typeshare.git", branch: "main"

  bottle do
    sha256 cellar: :any_skip_relocation, arm64_sequoia: "d04400d66c5bcbcd1babe6a500563294a0f6e5b79100be34d0b0465db7e43bae"
    sha256 cellar: :any_skip_relocation, arm64_sonoma:  "8a6691da6e2e6761fb371fda9b4a50e68c8e362673c7fd5d2664f23d40ec88cd"
    sha256 cellar: :any_skip_relocation, arm64_ventura: "90457cbc2f02a61fea512d6e96668a7c8a877703f0ebc28db6d5a214fa6502cc"
    sha256 cellar: :any_skip_relocation, sonoma:        "20df350c85f38fc2831d1a281abeefc30c776558382ea7c988b818083cf5d320"
    sha256 cellar: :any_skip_relocation, ventura:       "e7e101d9845a1d5c1f1d2f0c7f0cf077e595d4842c6732c3b1d2b2d3407da682"
    sha256 cellar: :any_skip_relocation, x86_64_linux:  "fefade27a0676ef950b1fb79c5a4b13929b637656a7c95c5b3eb70baa94bc080"
  end

  depends_on "rust" => :build

  def install
    system "cargo", "install", *std_cargo_args(path: "cli")

    generate_completions_from_executable(bin/"typeshare", "completions")
  end

  test do
    assert_match version.to_s, shell_output("#{bin}/typeshare --version")

    system bin/"typeshare", "--generate-config", testpath
    assert_path_exists testpath/"typeshare.toml"

    (testpath/"example.rs").write <<~RUST
      #[typeshare]
      struct MyStruct {
          my_name: String,
          my_age: u32,
      }
    RUST

    system bin/"typeshare", testpath/"example.rs", "--lang", "typescript", "--output-file", testpath/"TestType.ts"
    assert_match "Generated by typeshare", (testpath/"TestType.ts").read
  end
end
